/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDataImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDirectoryImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DummyFileSystem
extends DeprecatedVirtualFileSystem
implements NonPhysicalFileSystem {
    @NonNls
    public static final String PROTOCOL = "dummy";

    public static DummyFileSystem getInstance() {
        return (DummyFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DummyFileSystem() {
        this.startEventPropagation();
    }

    public VirtualFile createRoot(String name) {
        VirtualFileDirectoryImpl root = new VirtualFileDirectoryImpl(this, null, name);
        this.fireFileCreated(null, root);
        return root;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            DummyFileSystem.$$$reportNull$$$0(0);
        }
        return null;
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            DummyFileSystem.$$$reportNull$$$0(1);
        }
        String string = path;
        if (string == null) {
            DummyFileSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            DummyFileSystem.$$$reportNull$$$0(3);
        }
        return this.findFileByPath(path);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            DummyFileSystem.$$$reportNull$$$0(4);
        }
        this.fireBeforeFileDeletion(requestor, vFile);
        VirtualFileDirectoryImpl parent = (VirtualFileDirectoryImpl)vFile.getParent();
        if (parent == null) {
            throw new IOException(IdeBundle.message((String)"file.delete.root.error", (Object[])new Object[]{vFile.getPresentableUrl()}));
        }
        parent.removeChild((VirtualFileImpl)vFile);
        this.fireFileDeleted(requestor, vFile, vFile.getName(), parent);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        if (vFile == null) {
            DummyFileSystem.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            DummyFileSystem.$$$reportNull$$$0(6);
        }
        String oldName = vFile.getName();
        this.fireBeforePropertyChange(requestor, vFile, "name", oldName, newName);
        ((VirtualFileImpl)vFile).setName(newName);
        this.firePropertyChanged(requestor, vFile, "name", oldName, newName);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            DummyFileSystem.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            DummyFileSystem.$$$reportNull$$$0(8);
        }
        VirtualFileDirectoryImpl dir = (VirtualFileDirectoryImpl)vDir;
        VirtualFileDataImpl child2 = new VirtualFileDataImpl(this, dir, fileName);
        dir.addChild(child2);
        this.fireFileCreated(requestor, child2);
        VirtualFileDataImpl virtualFileDataImpl = child2;
        if (virtualFileDataImpl == null) {
            DummyFileSystem.$$$reportNull$$$0(9);
        }
        return virtualFileDataImpl;
    }

    public void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DummyFileSystem.$$$reportNull$$$0(10);
        }
        super.fireBeforeContentsChange(requestor, file2);
    }

    public void fireContentsChanged(Object requestor, @NotNull VirtualFile file2, long oldModificationStamp) {
        if (file2 == null) {
            DummyFileSystem.$$$reportNull$$$0(11);
        }
        super.fireContentsChanged(requestor, file2, oldModificationStamp);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) {
        if (vDir == null) {
            DummyFileSystem.$$$reportNull$$$0(12);
        }
        if (dirName == null) {
            DummyFileSystem.$$$reportNull$$$0(13);
        }
        VirtualFileDirectoryImpl dir = (VirtualFileDirectoryImpl)vDir;
        VirtualFileDirectoryImpl child2 = new VirtualFileDirectoryImpl(this, dir, dirName);
        dir.addChild(child2);
        this.fireFileCreated(requestor, child2);
        VirtualFileDirectoryImpl virtualFileDirectoryImpl = child2;
        if (virtualFileDirectoryImpl == null) {
            DummyFileSystem.$$$reportNull$$$0(14);
        }
        return virtualFileDirectoryImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ex/dummy/DummyFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeContentsChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fireContentsChanged";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

