/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class CredentialsManagerImpl
extends CredentialsManager {
    @Override
    public List<CredentialsType<?>> getAllTypes() {
        return Arrays.asList(CredentialsType.EP_NAME.getExtensions());
    }

    @Override
    public void loadCredentials(String interpreterPath, @Nullable Element element2, RemoteSdkAdditionalData data2) {
        for (CredentialsType<?> type : this.getAllTypes()) {
            if (!type.hasPrefix(interpreterPath)) continue;
            Object credentials = type.createCredentials();
            type.getHandler(credentials).load(element2);
            data2.setCredentials(type.getCredentialsKey(), credentials);
            return;
        }
        UnknownCredentialsHolder credentials = CredentialsType.UNKNOWN.createCredentials();
        credentials.setInterpreterPath(interpreterPath);
        credentials.load(element2);
        data2.setCredentials(CredentialsType.UNKNOWN_CREDENTIALS, credentials);
    }
}

