/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ID;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IndicesRegistrationResult {
    private final Map<ID<?, ?>, IndexState> updatedIndices = ContainerUtil.newConcurrentMap();

    @NotNull
    public String changedIndices() {
        return this.buildAffectedIndicesString(IndexState.VERSION_CHANGED);
    }

    @NotNull
    private String buildAffectedIndicesString(IndexState state) {
        String string = this.updatedIndices.keySet().stream().filter(id2 -> this.updatedIndices.get(id2) == state).map(id2 -> id2.getName()).collect(Collectors.joining(","));
        if (string == null) {
            IndicesRegistrationResult.$$$reportNull$$$0(0);
        }
        return string;
    }

    private String fullyBuiltIndices() {
        return this.buildAffectedIndicesString(IndexState.INITIAL_BUILD);
    }

    public void logChangedAndFullyBuiltIndices(@NotNull Logger log, @NotNull String changedIndicesLogMessage, @NotNull String fullyBuiltIndicesLogMessage) {
        String fullyBuiltIndices;
        String changedIndices;
        if (log == null) {
            IndicesRegistrationResult.$$$reportNull$$$0(1);
        }
        if (changedIndicesLogMessage == null) {
            IndicesRegistrationResult.$$$reportNull$$$0(2);
        }
        if (fullyBuiltIndicesLogMessage == null) {
            IndicesRegistrationResult.$$$reportNull$$$0(3);
        }
        if (!(changedIndices = this.changedIndices()).isEmpty()) {
            log.info(changedIndicesLogMessage + changedIndices);
        }
        if (!(fullyBuiltIndices = this.fullyBuiltIndices()).isEmpty()) {
            log.info(fullyBuiltIndicesLogMessage + fullyBuiltIndices);
        }
    }

    public void registerIndexAsUptoDate(@NotNull ID<?, ?> index) {
        if (index == null) {
            IndicesRegistrationResult.$$$reportNull$$$0(4);
        }
        this.updatedIndices.remove(index);
    }

    public void registerIndexAsInitiallyBuilt(@NotNull ID<?, ?> index) {
        if (index == null) {
            IndicesRegistrationResult.$$$reportNull$$$0(5);
        }
        this.updatedIndices.put(index, IndexState.INITIAL_BUILD);
    }

    public void registerIndexAsChanged(@NotNull ID<?, ?> index) {
        if (index == null) {
            IndicesRegistrationResult.$$$reportNull$$$0(6);
        }
        this.updatedIndices.put(index, IndexState.VERSION_CHANGED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndicesRegistrationResult";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedIndicesLogMessage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyBuiltIndicesLogMessage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAffectedIndicesString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndicesRegistrationResult";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logChangedAndFullyBuiltIndices";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexAsUptoDate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexAsInitiallyBuilt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexAsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum IndexState {
        VERSION_CHANGED,
        INITIAL_BUILD;

    }
}

