/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ProjectTopics;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.UnindexedFilesFinder;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class UnindexedFilesUpdater
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesUpdater.class);
    private final FileBasedIndexImpl myIndex;
    private final Project myProject;
    private final boolean myStartSuspended;
    private final PushedFilePropertiesUpdater myPusher;

    public UnindexedFilesUpdater(final @NotNull Project project, boolean startSuspended) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(0);
        }
        this.myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myProject = project;
        this.myStartSuspended = startSuspended;
        this.myPusher = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DumbService.getInstance((Project)project).cancelTask((DumbModeTask)UnindexedFilesUpdater.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/UnindexedFilesUpdater$1", "rootsChanged"));
            }
        });
    }

    public UnindexedFilesUpdater(@NotNull Project project) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(1);
        }
        this(project, false);
    }

    private void updateUnindexedFiles(ProgressIndicator indicator) {
        boolean trackResponsiveness;
        if (!IndexInfrastructure.hasIndices()) {
            return;
        }
        if (this.myStartSuspended) {
            ProgressSuspender suspender = ProgressSuspender.getSuspender(indicator);
            if (suspender == null) {
                throw new IllegalStateException("Indexing progress indicator must be suspendable!");
            }
            if (!suspender.isSuspended()) {
                suspender.suspendProcess(IdeBundle.message((String)"progress.indexing.started.as.suspended", (Object[])new Object[0]));
            }
        }
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        this.myPusher.pushAllPropertiesNow();
        boolean bl = trackResponsiveness = !ApplicationManager.getApplication().isUnitTestMode();
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Pushing properties");
        }
        indicator.setIndeterminate(true);
        indicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        this.myIndex.clearIndicesIfNecessary();
        FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.processIndexingProject(this.myProject, indicator));
        UnindexedFilesFinder finder = new UnindexedFilesFinder(this.myProject);
        snapshot = PerformanceWatcher.takeSnapshot();
        this.myIndex.iterateIndexableFilesConcurrently((ContentIterator)finder, this.myProject, indicator);
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Indexable file iteration");
        }
        List files2 = finder.getFiles();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleInitialVfsRefresh();
        }
        if (files2.isEmpty()) {
            return;
        }
        snapshot = PerformanceWatcher.takeSnapshot();
        if (trackResponsiveness) {
            LOG.info("Unindexed files update started: " + files2.size() + " files to update");
        }
        indicator.setIndeterminate(false);
        indicator.setText(IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        this.indexFiles(indicator, files2);
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Unindexed files update");
        }
    }

    private void scheduleInitialVfsRefresh() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).markRootsForRefresh();
        Application app = ApplicationManager.getApplication();
        if (!app.isCommandLine()) {
            final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
            final MessageBusConnection connection = app.getMessageBus().connect();
            connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (project == UnindexedFilesUpdater.this.myProject) {
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/UnindexedFilesUpdater$2", "projectClosed"));
                }
            });
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().syncRefresh());
        }
    }

    private void indexFiles(ProgressIndicator indicator, List<? extends VirtualFile> files2) {
        CacheUpdateRunner.processFiles(indicator, files2, this.myProject, (Consumer<? super FileContent>)((Consumer)content2 -> this.myIndex.indexFileContent(this.myProject, (FileContent)content2)));
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(2);
        }
        this.myIndex.filesUpdateStarted(this.myProject);
        try {
            this.updateUnindexedFiles(indicator);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Unindexed files update canceled");
            throw e;
        }
        finally {
            this.myIndex.filesUpdateFinished(this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performInDumbMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

