/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.jps;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.workspace.api.EntitySource;
import com.intellij.workspace.api.TypedEntity;
import com.intellij.workspace.api.TypedEntityStorage;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import com.intellij.workspace.api.VirtualFileUrl;
import com.intellij.workspace.api.VirtualFileUrlManager;
import com.intellij.workspace.ide.IdeUiEntitySource;
import com.intellij.workspace.ide.JpsFileEntitySource;
import com.intellij.workspace.ide.JpsProjectStoragePlace;
import com.intellij.workspace.jps.JpsConfigurationFilesChange;
import com.intellij.workspace.jps.JpsDirectoryEntitiesSerializerFactory;
import com.intellij.workspace.jps.JpsEntitiesSerializationData;
import com.intellij.workspace.jps.JpsFileContentReader;
import com.intellij.workspace.jps.JpsFileContentWriter;
import com.intellij.workspace.jps.JpsFileEntitiesSerializer;
import com.intellij.workspace.jps.JpsFileEntityTypeSerializer;
import com.intellij.workspace.jps.JpsFileSerializerFactory;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BK\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ4\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010'\u001a\u00020(2 \u0010)\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00030\u000fH\u0002J\u001e\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u00032\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u001d\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b2J^\u00103\u001a2\u0012.\u0012,\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00030\u000f040\u0003\"\b\b\u0000\u00105*\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H50\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0\u0003H\u0002J\u0017\u00106\u001a\u0004\u0018\u00010\u00102\u0006\u0010'\u001a\u000207H\u0000\u00a2\u0006\u0002\b8JD\u00109\u001a\u0004\u0018\u00010\u0010\"\b\b\u0000\u00105*\u00020+2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H50\u00042 \u0010)\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00030\u000fH\u0002JD\u0010;\u001a\u0004\u0018\u00010\u0010\"\b\b\u0000\u00105*\u00020+2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H50\u00062 \u0010)\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00030\u000fH\u0002J.\u0010=\u001a\b\u0012\u0004\u0012\u0002H50\u0003\"\b\b\u0000\u00105*\u00020+2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H50\n2\u0006\u0010?\u001a\u00020@H\u0002J\u0016\u0010A\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010C\u001a\u00020DJ(\u0010E\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020G0F\u0012\u0004\u0012\u00020D042\u0006\u0010H\u001a\u00020I2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010J\u001a\u00020B2\u0006\u0010?\u001a\u00020@2\u0006\u0010K\u001a\u00020LJ6\u0010M\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u000207040\u00032\u0006\u0010?\u001a\u00020@2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010K\u001a\u00020LJ\\\u0010O\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u000207040\u0003\"\b\b\u0000\u00105*\u00020+2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H50\u001c2 \u0010)\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020+0*\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00030\u000f2\u0006\u0010K\u001a\u00020LH\u0002J0\u0010P\u001a\u00020B\"\b\b\u0000\u00105*\u00020+2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002H50\u00062\u0006\u0010?\u001a\u00020@2\u0006\u0010K\u001a\u00020LH\u0002R$\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R=\u0010\u0019\u001a+\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00100\u0010\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u001b*\b\u0012\u0002\b\u0003\u0018\u00010\u001c0\u001c0\u001a\u00a2\u0006\u0002\b\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR(\u0010 \u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R(\u0010$\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/workspace/jps/JpsEntitiesSerializationData;", "", "directorySerializersFactories", "", "Lcom/intellij/workspace/jps/JpsDirectoryEntitiesSerializerFactory;", "fileSerializerFactories", "Lcom/intellij/workspace/jps/JpsFileSerializerFactory;", "reader", "Lcom/intellij/workspace/jps/JpsFileContentReader;", "entityTypeSerializers", "Lcom/intellij/workspace/jps/JpsFileEntityTypeSerializer;", "storagePlace", "Lcom/intellij/workspace/ide/JpsProjectStoragePlace;", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/workspace/jps/JpsFileContentReader;Ljava/util/List;Lcom/intellij/workspace/ide/JpsProjectStoragePlace;)V", "directorySerializerFactoriesByUrl", "", "", "getDirectorySerializerFactoriesByUrl$intellij_platform_workspaceModel_ide", "()Ljava/util/Map;", "fileIdToFileName", "Lgnu/trove/TIntObjectHashMap;", "getFileIdToFileName$intellij_platform_workspaceModel_ide", "()Lgnu/trove/TIntObjectHashMap;", "fileSerializerFactoriesByUrl", "getFileSerializerFactoriesByUrl$intellij_platform_workspaceModel_ide", "fileSerializersByUrl", "Lcom/intellij/util/containers/MultiMap;", "kotlin.jvm.PlatformType", "Lcom/intellij/workspace/jps/JpsFileEntitiesSerializer;", "Lorg/jetbrains/annotations/NotNull;", "getFileSerializersByUrl$intellij_platform_workspaceModel_ide", "()Lcom/intellij/util/containers/MultiMap;", "serializerToDirectoryFactory", "Lcom/intellij/util/containers/BidirectionalMap;", "getSerializerToDirectoryFactory$intellij_platform_workspaceModel_ide", "()Lcom/intellij/util/containers/BidirectionalMap;", "serializerToFileFactory", "getSerializerToFileFactory$intellij_platform_workspaceModel_ide", "calculateFileNameForEntity", "source", "Lcom/intellij/workspace/ide/JpsFileEntitySource$FileInDirectory;", "entities", "Ljava/lang/Class;", "Lcom/intellij/workspace/api/TypedEntity;", "createDirectorySerializers", "factory", "createFileInDirectorySource", "directoryUrl", "Lcom/intellij/workspace/api/VirtualFileUrl;", "fileName", "createFileInDirectorySource$intellij_platform_workspaceModel_ide", "createSerializersForDirectoryEntities", "Lkotlin/Pair;", "E", "getActualFileUrl", "Lcom/intellij/workspace/ide/JpsFileEntitySource;", "getActualFileUrl$intellij_platform_workspaceModel_ide", "getDefaultFileNameForEntity", "directoryFactory", "getFileNameForEntity", "fileFactory", "getFilteredEntitiesForSerializer", "serializer", "storage", "Lcom/intellij/workspace/api/TypedEntityStorage;", "loadAll", "", "builder", "Lcom/intellij/workspace/api/TypedEntityStorageBuilder;", "reloadFromChangedFiles", "", "Lcom/intellij/workspace/api/EntitySource;", "change", "Lcom/intellij/workspace/jps/JpsConfigurationFilesChange;", "saveAllEntities", "writer", "Lcom/intellij/workspace/jps/JpsFileContentWriter;", "saveEntities", "affectedSources", "saveEntitiesBySerializer", "saveEntitiesList", "it", "intellij.platform.workspaceModel.ide"})
public final class JpsEntitiesSerializationData {
    @NotNull
    private final BidirectionalMap<JpsFileEntitiesSerializer<?>, JpsFileSerializerFactory<?>> serializerToFileFactory;
    @NotNull
    private final BidirectionalMap<JpsFileEntitiesSerializer<?>, JpsDirectoryEntitiesSerializerFactory<?>> serializerToDirectoryFactory;
    @NotNull
    private final MultiMap<String, JpsFileEntitiesSerializer<?>> fileSerializersByUrl;
    @NotNull
    private final TIntObjectHashMap<String> fileIdToFileName;
    @NotNull
    private final Map<String, JpsDirectoryEntitiesSerializerFactory<?>> directorySerializerFactoriesByUrl;
    @NotNull
    private final Map<String, JpsFileSerializerFactory<?>> fileSerializerFactoriesByUrl;
    private final List<JpsFileEntityTypeSerializer<?>> entityTypeSerializers;
    private final JpsProjectStoragePlace storagePlace;

    @NotNull
    public final BidirectionalMap<JpsFileEntitiesSerializer<?>, JpsFileSerializerFactory<?>> getSerializerToFileFactory$intellij_platform_workspaceModel_ide() {
        return this.serializerToFileFactory;
    }

    @NotNull
    public final BidirectionalMap<JpsFileEntitiesSerializer<?>, JpsDirectoryEntitiesSerializerFactory<?>> getSerializerToDirectoryFactory$intellij_platform_workspaceModel_ide() {
        return this.serializerToDirectoryFactory;
    }

    @NotNull
    public final MultiMap<String, JpsFileEntitiesSerializer<?>> getFileSerializersByUrl$intellij_platform_workspaceModel_ide() {
        return this.fileSerializersByUrl;
    }

    @NotNull
    public final TIntObjectHashMap<String> getFileIdToFileName$intellij_platform_workspaceModel_ide() {
        return this.fileIdToFileName;
    }

    @NotNull
    public final Map<String, JpsDirectoryEntitiesSerializerFactory<?>> getDirectorySerializerFactoriesByUrl$intellij_platform_workspaceModel_ide() {
        return this.directorySerializerFactoriesByUrl;
    }

    @NotNull
    public final Map<String, JpsFileSerializerFactory<?>> getFileSerializerFactoriesByUrl$intellij_platform_workspaceModel_ide() {
        return this.fileSerializerFactoriesByUrl;
    }

    @NotNull
    public final JpsFileEntitySource.FileInDirectory createFileInDirectorySource$intellij_platform_workspaceModel_ide(@NotNull VirtualFileUrl directoryUrl, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)directoryUrl, (String)"directoryUrl");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        JpsFileEntitySource.FileInDirectory source = new JpsFileEntitySource.FileInDirectory(directoryUrl, this.storagePlace);
        this.fileIdToFileName.put(source.getFileNameId(), (Object)fileName);
        return source;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JpsFileEntitiesSerializer<?>> createDirectorySerializers(JpsDirectoryEntitiesSerializerFactory<?> factory) {
        void $this$mapTo$iv$iv;
        File[] files2;
        File[] fileArray = JpsPathUtil.urlToFile((String)factory.getDirectoryUrl()).listFiles(createDirectorySerializers.files.1.INSTANCE);
        if (fileArray == null) {
            return CollectionsKt.emptyList();
        }
        File[] $this$map$iv = files2 = fileArray;
        boolean $i$f$map = false;
        File[] fileArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_12 = item$iv$iv = var8_8[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(factory.getDirectoryUrl()).append('/');
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string = stringBuilder.append(v2.getName()).toString();
            VirtualFileUrl virtualFileUrl = VirtualFileUrlManager.INSTANCE.fromUrl(factory.getDirectoryUrl());
            String string2 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.name");
            JpsFileEntitiesSerializer<?> jpsFileEntitiesSerializer = factory.createSerializer(string, this.createFileInDirectorySource$intellij_platform_workspaceModel_ide(virtualFileUrl, string2));
            collection.add(jpsFileEntitiesSerializer);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Set<EntitySource>, TypedEntityStorageBuilder> reloadFromChangedFiles(@NotNull JpsConfigurationFilesChange change, @NotNull JpsFileContentReader reader) {
        Iterable $this$mapTo$iv;
        void $this$flatMapTo$iv$iv;
        JpsFileEntitiesSerializer<?> jpsFileEntitiesSerializer;
        Object object;
        Iterable<VirtualFileUrl> newFileUrls;
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        ArrayList obsoleteSerializers = new ArrayList();
        ArrayList newFileSerializers = new ArrayList();
        for (String string : change.getAddedFileUrls()) {
            JpsFileEntitiesSerializer<?> newFileSerializer;
            JpsFileEntitiesSerializer<?> jpsFileEntitiesSerializer2;
            JpsDirectoryEntitiesSerializerFactory<?> factory;
            JpsDirectoryEntitiesSerializerFactory<?> jpsDirectoryEntitiesSerializerFactory = factory = this.directorySerializerFactoriesByUrl.get(PathUtil.getParentPath((String)string));
            if (jpsDirectoryEntitiesSerializerFactory != null) {
                VirtualFileUrl virtualFileUrl = VirtualFileUrlManager.INSTANCE.fromUrl(factory.getDirectoryUrl());
                String string2 = PathUtil.getFileName((String)string);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtil.getFileName(addedFileUrl)");
                jpsFileEntitiesSerializer2 = jpsDirectoryEntitiesSerializerFactory.createSerializer(string, this.createFileInDirectorySource$intellij_platform_workspaceModel_ide(virtualFileUrl, string2));
            } else {
                jpsFileEntitiesSerializer2 = null;
            }
            if ((newFileSerializer = jpsFileEntitiesSerializer2) == null) continue;
            newFileSerializers.add(newFileSerializer);
            ((Map)this.serializerToDirectoryFactory).put(newFileSerializer, factory);
        }
        for (String string : change.getChangedFileUrls()) {
            void $this$associateWithTo$iv;
            void $this$mapTo$iv$iv;
            boolean bl;
            Iterable $this$filterTo$iv$iv;
            Object element$iv;
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv2;
            Object item$iv22;
            void $this$mapTo$iv2;
            JpsFileSerializerFactory<?> serializerFactory = this.fileSerializerFactoriesByUrl.get(string);
            if (serializerFactory == null) continue;
            newFileUrls = serializerFactory.loadFileList(reader);
            List list2 = this.serializerToFileFactory.getKeysByValue(serializerFactory);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List oldSerializers = list2;
            Iterable iterable = oldSerializers;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv22 : $this$mapTo$iv2) {
                void it;
                JpsFileEntitiesSerializer jpsFileEntitiesSerializer3 = (JpsFileEntitiesSerializer)item$iv22;
                object = destination$iv;
                boolean bl2 = false;
                jpsFileEntitiesSerializer = it.getFileUrl();
                object.add(jpsFileEntitiesSerializer);
            }
            HashSet oldFileUrls = (HashSet)destination$iv;
            Set newFileUrlsSet = CollectionsKt.toSet((Iterable)newFileUrls);
            Iterable $this$filter$iv = oldSerializers;
            boolean $i$f$filter = false;
            item$iv22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                JpsFileEntitiesSerializer it = (JpsFileEntitiesSerializer)element$iv$iv;
                boolean bl3 = false;
                if (!(!newFileUrlsSet.contains(it.getFileUrl()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List obsoleteSerializersForFactory = (List)destination$iv$iv;
            Iterable $this$forEach$iv = obsoleteSerializersForFactory;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                element$iv = $this$filterTo$iv$iv2.next();
                JpsFileEntitiesSerializer it = (JpsFileEntitiesSerializer)element$iv;
                boolean bl4 = false;
                this.serializerToFileFactory.remove((Object)it, serializerFactory);
            }
            Iterable $this$filter$iv2 = newFileUrls;
            boolean $i$f$filter2 = false;
            element$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                VirtualFileUrl it = (VirtualFileUrl)element$iv$iv2;
                bl = false;
                if (!(!oldFileUrls.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VirtualFileUrl it = (VirtualFileUrl)item$iv$iv;
                object = destination$iv$iv3;
                bl = false;
                VirtualFileUrl virtualFileUrl = it.getParent();
                if (virtualFileUrl == null) {
                    Intrinsics.throwNpe();
                }
                File file2 = it.getFile();
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.file!!.name");
                jpsFileEntitiesSerializer = serializerFactory.createSerializer(this.createFileInDirectorySource$intellij_platform_workspaceModel_ide(virtualFileUrl, string3), it);
                object.add(jpsFileEntitiesSerializer);
            }
            List newFileSerializersForFactory = (List)destination$iv$iv3;
            $this$map$iv = newFileSerializersForFactory;
            Map destination$iv2 = (Map)this.serializerToFileFactory;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv2 : $this$associateWithTo$iv) {
                element$iv$iv = (JpsFileEntitiesSerializer)element$iv2;
                jpsFileEntitiesSerializer = element$iv2;
                object = destination$iv2;
                boolean bl5 = false;
                JpsFileSerializerFactory<?> jpsFileSerializerFactory = serializerFactory;
                object.put(jpsFileEntitiesSerializer, jpsFileSerializerFactory);
            }
            obsoleteSerializers.addAll(obsoleteSerializersForFactory);
            newFileSerializers.addAll(newFileSerializersForFactory);
        }
        for (JpsFileEntitiesSerializer jpsFileEntitiesSerializer4 : newFileSerializers) {
            this.fileSerializersByUrl.putValue((Object)jpsFileEntitiesSerializer4.getFileUrl().getUrl(), (Object)jpsFileEntitiesSerializer4);
        }
        for (JpsFileEntitiesSerializer jpsFileEntitiesSerializer5 : obsoleteSerializers) {
            this.fileSerializersByUrl.remove((Object)jpsFileEntitiesSerializer5.getFileUrl().getUrl(), (Object)jpsFileEntitiesSerializer5);
        }
        Iterable $this$flatMap$iv = CollectionsKt.toCollection((Iterable)CollectionsKt.plus(change.getChangedFileUrls(), (Iterable)change.getAddedFileUrls()), (Collection)new HashSet());
        boolean $i$f$flatMap232 = false;
        newFileUrls = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.fileSerializersByUrl.get((Object)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        Iterable $i$f$flatMap232 = list3;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Iterator it;
            Object element$iv$iv;
            element$iv$iv = (JpsFileEntitiesSerializer)item$iv;
            object = destination$iv;
            boolean bl = false;
            jpsFileEntitiesSerializer = it.getEntitySource();
            object.add(jpsFileEntitiesSerializer);
        }
        HashSet changedSources = (HashSet)destination$iv;
        for (String fileUrl : change.getRemovedFileUrls()) {
            Collection obsolete = this.fileSerializersByUrl.remove((Object)fileUrl);
            if (obsolete == null) continue;
            obsoleteSerializers.addAll(obsolete);
            Iterable $this$forEach$iv = obsolete;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JpsFileEntitiesSerializer it = (JpsFileEntitiesSerializer)element$iv;
                boolean bl = false;
                this.serializerToDirectoryFactory.remove((Object)it);
            }
        }
        $this$mapTo$iv = obsoleteSerializers;
        boolean $i$f$mapTo3 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            JpsFileEntitiesSerializer $i$f$forEach = (JpsFileEntitiesSerializer)item$iv;
            object = changedSources;
            boolean bl = false;
            jpsFileEntitiesSerializer = it.getEntitySource();
            object.add(jpsFileEntitiesSerializer);
        }
        Sequence $this$forEach$iv = SequencesKt.filterIsInstance((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)obsoleteSerializers), (Function1)reloadFromChangedFiles.5.INSTANCE), JpsFileEntitySource.FileInDirectory.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsFileEntitySource.FileInDirectory it = (JpsFileEntitySource.FileInDirectory)element$iv;
            boolean bl = false;
            this.fileIdToFileName.remove(it.getFileNameId());
        }
        TypedEntityStorageBuilder builder2 = TypedEntityStorageBuilder.Companion.create();
        Iterable $this$forEach$iv2 = list3;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            JpsFileEntitiesSerializer it = (JpsFileEntitiesSerializer)element$iv;
            boolean bl = false;
            it.loadEntities(builder2, reader);
        }
        return new Pair((Object)changedSources, (Object)builder2);
    }

    public final void loadAll(@NotNull JpsFileContentReader reader, @NotNull TypedEntityStorageBuilder builder2) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        Collection collection = this.fileSerializersByUrl.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fileSerializersByUrl.values()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsFileEntitiesSerializer it = (JpsFileEntitiesSerializer)element$iv;
            boolean bl = false;
            it.loadEntities(builder2, reader);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveAllEntities(@NotNull TypedEntityStorage storage, @NotNull JpsFileContentWriter writer) {
        void $this$mapTo$iv;
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Iterable $this$forEach$iv = this.fileSerializerFactoriesByUrl.values();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsFileSerializerFactory it = (JpsFileSerializerFactory)element$iv;
            boolean bl = false;
            this.saveEntitiesList(it, storage, writer);
        }
        Collection collection = this.fileSerializersByUrl.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fileSerializersByUrl.values()");
        Iterable $i$f$forEach22 = collection;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            JpsFileEntitiesSerializer jpsFileEntitiesSerializer = (JpsFileEntitiesSerializer)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            JpsFileEntitySource jpsFileEntitySource = it.getEntitySource();
            collection2.add(jpsFileEntitySource);
        }
        HashSet allSources = (HashSet)destination$iv;
        Collection collection3 = allSources;
        IdeUiEntitySource ideUiEntitySource = IdeUiEntitySource.INSTANCE;
        boolean bl = false;
        collection3.add(ideUiEntitySource);
        this.saveEntities(storage, allSources, writer);
    }

    @Nullable
    public final String getActualFileUrl$intellij_platform_workspaceModel_ide(@NotNull JpsFileEntitySource source) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        JpsFileEntitySource jpsFileEntitySource = source;
        if (jpsFileEntitySource instanceof JpsFileEntitySource.ExactFile) {
            string = ((JpsFileEntitySource.ExactFile)source).getFile().getUrl();
        } else if (jpsFileEntitySource instanceof JpsFileEntitySource.FileInDirectory) {
            String fileName = (String)this.fileIdToFileName.get(((JpsFileEntitySource.FileInDirectory)source).getFileNameId());
            string = fileName != null ? ((JpsFileEntitySource.FileInDirectory)source).getDirectory().getUrl() + "/" + fileName : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<TypedEntity, JpsFileEntitySource>> saveEntities(@NotNull TypedEntityStorage storage, @NotNull Set<? extends EntitySource> affectedSources, @NotNull JpsFileContentWriter writer) {
        void $this$flatMapTo$iv$iv;
        Object entitiesMap;
        Object object;
        Object source;
        Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> $dstr$source$entities;
        Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> element$iv;
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull(affectedSources, (String)"affectedSources");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        HashSet<JpsFileSerializerFactory> affectedFileFactories = new HashSet<JpsFileSerializerFactory>();
        Function2<String, Boolean, Unit> $fun$processObsoleteSource$1 = new Function2<String, Boolean, Unit>(this, writer, affectedFileFactories){
            final /* synthetic */ JpsEntitiesSerializationData this$0;
            final /* synthetic */ JpsFileContentWriter $writer;
            final /* synthetic */ HashSet $affectedFileFactories;

            public final void invoke(@NotNull String fileUrl, boolean deleteObsoleteFilesFromFileFactories) {
                JpsFileEntitiesSerializer it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Collection obsoleteSerializers;
                Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
                Collection collection = obsoleteSerializers = this.this$0.getFileSerializersByUrl$intellij_platform_workspaceModel_ide().remove((Object)fileUrl);
                if (collection != null) {
                    $this$forEach$iv = collection;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (JpsFileEntitiesSerializer)element$iv;
                        boolean bl = false;
                        JpsFileSerializerFactory fileFactory = (JpsFileSerializerFactory)this.this$0.getSerializerToFileFactory$intellij_platform_workspaceModel_ide().remove((Object)it);
                        if (fileFactory == null) continue;
                        if (deleteObsoleteFilesFromFileFactories) {
                            fileFactory.deleteObsoleteFile(fileUrl, this.$writer);
                        }
                        this.$affectedFileFactories.add(fileFactory);
                    }
                }
                Collection collection2 = obsoleteSerializers;
                if (collection2 != null) {
                    $this$forEach$iv = collection2;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (JpsFileEntitiesSerializer)element$iv;
                        boolean bl = false;
                        JpsDirectoryEntitiesSerializerFactory directoryFactory = (JpsDirectoryEntitiesSerializerFactory)this.this$0.getSerializerToDirectoryFactory$intellij_platform_workspaceModel_ide().remove((Object)it);
                        if (directoryFactory == null) continue;
                        this.$writer.saveComponent(fileUrl, directoryFactory.getComponentName(), null);
                    }
                }
            }
            {
                this.this$0 = jpsEntitiesSerializationData;
                this.$writer = jpsFileContentWriter;
                this.$affectedFileFactories = hashSet;
                super(2);
            }
        };
        Map<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> entitiesToSave2 = storage.entitiesBySource((Function1<? super EntitySource, Boolean>)((Function1)new Function1<EntitySource, Boolean>(affectedSources){
            final /* synthetic */ Set $affectedSources;

            public final boolean invoke(@NotNull EntitySource it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$affectedSources.contains(it);
            }
            {
                this.$affectedSources = set;
                super(1);
            }
        }));
        Set obsoleteSources = SetsKt.minus(affectedSources, (Iterable)entitiesToSave2.keySet());
        for (EntitySource source2 : obsoleteSources) {
            String fileUrl;
            if (!(source2 instanceof JpsFileEntitySource) || (fileUrl = this.getActualFileUrl$intellij_platform_workspaceModel_ide((JpsFileEntitySource)source2)) == null) continue;
            $fun$processObsoleteSource$1.invoke(fileUrl, false);
            if (!(source2 instanceof JpsFileEntitySource.FileInDirectory)) continue;
            this.fileIdToFileName.remove(((JpsFileEntitySource.FileInDirectory)source2).getFileNameId());
        }
        ArrayList<Pair> serializersToRun = new ArrayList<Pair>();
        Function1<Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>>, Unit> $fun$processNewlyAddedDirectoryEntities$2 = new Function1<Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>>, Unit>(this, serializersToRun){
            final /* synthetic */ JpsEntitiesSerializationData this$0;
            final /* synthetic */ ArrayList $serializersToRun;

            public final void invoke(@NotNull Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>> entitiesMap) {
                Intrinsics.checkParameterIsNotNull(entitiesMap, (String)"entitiesMap");
                Iterable $this$forEach$iv = this.this$0.getDirectorySerializerFactoriesByUrl$intellij_platform_workspaceModel_ide().values();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JpsDirectoryEntitiesSerializerFactory factory = (JpsDirectoryEntitiesSerializerFactory)element$iv;
                    boolean bl = false;
                    List<? extends TypedEntity> added = entitiesMap.get(factory.getEntityClass());
                    if (added == null) continue;
                    List newSerializers = JpsEntitiesSerializationData.access$createSerializersForDirectoryEntities(this.this$0, factory, added);
                    Iterable $this$forEach$iv2 = newSerializers;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Pair it = (Pair)element$iv2;
                        boolean bl2 = false;
                        ((Map)this.this$0.getSerializerToDirectoryFactory$intellij_platform_workspaceModel_ide()).put(it.getFirst(), factory);
                        this.this$0.getFileSerializersByUrl$intellij_platform_workspaceModel_ide().putValue((Object)((JpsFileEntitiesSerializer)it.getFirst()).getFileUrl().getUrl(), it.getFirst());
                    }
                    this.$serializersToRun.addAll(newSerializers);
                }
            }
            {
                this.this$0 = jpsEntitiesSerializationData;
                this.$serializersToRun = arrayList;
                super(1);
            }
        };
        Map<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> $this$forEach$iv = entitiesToSave2;
        boolean $i$f$forEach = false;
        Map<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            String string;
            $dstr$source$entities = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> entry = $dstr$source$entities;
            boolean bl3 = false;
            EntitySource entitySource = entry.getKey();
            Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> entry2 = $dstr$source$entities;
            bl3 = false;
            Map<Class<? extends TypedEntity>, List<TypedEntity>> entities2 = entry2.getValue();
            if (!(source instanceof JpsFileEntitySource)) continue;
            if (source instanceof JpsFileEntitySource.FileInDirectory) {
                String string2 = this.calculateFileNameForEntity((JpsFileEntitySource.FileInDirectory)source, entities2);
                String oldFileName = (String)this.fileIdToFileName.get(((JpsFileEntitySource.FileInDirectory)source).getFileNameId());
                if (Intrinsics.areEqual((Object)oldFileName, (Object)string2) ^ true) {
                    this.fileIdToFileName.put(((JpsFileEntitySource.FileInDirectory)source).getFileNameId(), (Object)string2);
                    if (oldFileName != null) {
                        $fun$processObsoleteSource$1.invoke(((JpsFileEntitySource.FileInDirectory)source).getDirectory().getUrl() + '/' + oldFileName, true);
                    }
                    $fun$processNewlyAddedDirectoryEntities$2.invoke(entities2);
                }
            }
            if ((string = this.getActualFileUrl$intellij_platform_workspaceModel_ide((JpsFileEntitySource)source)) == null || this.fileSerializersByUrl.keySet().contains(string)) continue;
            Iterable $this$forEach$iv2 = this.fileSerializerFactoriesByUrl.values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JpsFileSerializerFactory factory = (JpsFileSerializerFactory)element$iv2;
                boolean bl4 = false;
                Map<Class<? extends TypedEntity>, List<TypedEntity>> map3 = entities2;
                Class clazz = factory.getEntityClass();
                boolean bl5 = false;
                object = map3;
                boolean bl6 = false;
                if (!object.containsKey(clazz)) continue;
                JpsFileEntitiesSerializer newSerializer = factory.createSerializer((JpsFileEntitySource)source, VirtualFileUrlManager.INSTANCE.fromUrl(string));
                this.fileSerializersByUrl.putValue((Object)string, newSerializer);
                ((Map)this.serializerToFileFactory).put(newSerializer, factory);
                affectedFileFactories.add(factory);
            }
        }
        $this$forEach$iv = entitiesToSave2;
        $i$f$forEach = false;
        map2 = $this$forEach$iv;
        bl = false;
        iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv;
            void $this$filterTo$iv$iv;
            Collection collection;
            $dstr$source$entities = element$iv = iterator2.next();
            boolean bl72 = false;
            Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> entry = $dstr$source$entities;
            boolean $this$forEach$iv2 = false;
            source = entry.getKey();
            Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> entry3 = $dstr$source$entities;
            $this$forEach$iv2 = false;
            Map<Class<? extends TypedEntity>, List<TypedEntity>> entities2 = entry3.getValue();
            if (!(source instanceof JpsFileEntitySource)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.fileSerializersByUrl.get((Object)this.getActualFileUrl$intellij_platform_workspaceModel_ide((JpsFileEntitySource)source)), (String)"fileSerializersByUrl[getActualFileUrl(source)]");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JpsFileEntitiesSerializer it2 = (JpsFileEntitiesSerializer)element$iv$iv;
                boolean bl8 = false;
                if (!(!(it2 instanceof JpsFileEntityTypeSerializer))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            Collection destination$iv = serializersToRun;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it3;
                JpsFileEntitiesSerializer bl4 = (JpsFileEntitiesSerializer)item$iv;
                object = destination$iv;
                boolean bl9 = false;
                Pair pair = new Pair((Object)it3, entities2);
                object.add(pair);
            }
        }
        Map map4 = entitiesToSave2.get(IdeUiEntitySource.INSTANCE);
        if (map4 == null) {
            map4 = MapsKt.emptyMap();
        }
        Map newEntities = map4;
        Iterable $this$forEach$iv3 = this.fileSerializerFactoriesByUrl.values();
        boolean $i$f$forEach3 = false;
        for (Object element$iv3 : $this$forEach$iv3) {
            JpsFileSerializerFactory it422 = (JpsFileSerializerFactory)element$iv3;
            boolean bl10 = false;
            if (!affectedFileFactories.contains(it422)) {
                Map bl72 = newEntities;
                Class clazz = it422.getEntityClass();
                boolean $this$mapTo$iv = false;
                source = bl72;
                boolean bl8 = false;
                if (!source.containsKey(clazz)) continue;
            }
            this.saveEntitiesList(it422, storage, writer);
        }
        $fun$processNewlyAddedDirectoryEntities$2.invoke((Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>>)newEntities);
        for (JpsFileEntityTypeSerializer<?> serializer : this.entityTypeSerializers) {
            Object element$iv3;
            Map map5 = newEntities;
            element$iv3 = serializer.getMainEntityClass();
            boolean it422 = false;
            Object object2 = map5;
            boolean bl72 = false;
            if (!object2.containsKey(element$iv3)) {
                boolean bl9;
                block19: {
                    Map<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> $this$any$iv = entitiesToSave2;
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl9 = false;
                    } else {
                        Map<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> it422 = $this$any$iv;
                        boolean bl13 = false;
                        Iterator<Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>>> bl72 = it422.entrySet().iterator();
                        while (bl72.hasNext()) {
                            Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> entry;
                            Map.Entry<EntitySource, Map<Class<? extends TypedEntity>, List<TypedEntity>>> it5 = entry = bl72.next();
                            boolean bl14 = false;
                            Map<Class<? extends TypedEntity>, List<TypedEntity>> map6 = it5.getValue();
                            Class clazz = serializer.getMainEntityClass();
                            boolean bl10 = false;
                            Map<Class<? extends TypedEntity>, List<TypedEntity>> map7 = map6;
                            boolean bl11 = false;
                            if (!map7.containsKey(clazz)) continue;
                            bl9 = true;
                            break block19;
                        }
                        bl9 = false;
                    }
                }
                if (!bl9) continue;
            }
            entitiesMap = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to(serializer.getMainEntityClass(), this.getFilteredEntitiesForSerializer(serializer, storage))});
            Iterable $this$associateWithTo$iv = serializer.getAdditionalEntityTypes();
            boolean $i$f$associateWithTo = false;
            for (Object element$iv5 : $this$associateWithTo$iv) {
                Class clazz = (Class)element$iv5;
                Object t = element$iv5;
                Object object3 = entitiesMap;
                boolean bl17 = false;
                List list2 = SequencesKt.toList(storage.entities(clazz));
                object3.put(t, list2);
            }
            serializersToRun.add(new Pair(serializer, entitiesMap));
        }
        Iterable $this$flatMap$iv = serializersToRun;
        boolean $i$f$flatMap = false;
        entitiesMap = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl18 = false;
            Iterable iterable = this.saveEntitiesBySerializer((JpsFileEntitiesSerializer)pair.getFirst(), (Map)pair.getSecond(), writer);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)iterable);
        }
        return (List)destination$iv$iv;
    }

    private final String calculateFileNameForEntity(JpsFileEntitySource.FileInDirectory source, Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>> entities2) {
        Object v0;
        block3: {
            JpsDirectoryEntitiesSerializerFactory<?> directoryFactory = this.directorySerializerFactoriesByUrl.get(source.getDirectory().getUrl());
            if (directoryFactory != null) {
                return this.getDefaultFileNameForEntity(directoryFactory, entities2);
            }
            Iterable iterable = this.fileSerializerFactoriesByUrl.values();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                JpsFileSerializerFactory it = (JpsFileSerializerFactory)t;
                boolean bl3 = false;
                Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>> map2 = entities2;
                Class clazz = it.getEntityClass();
                boolean bl4 = false;
                Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>> map3 = map2;
                boolean bl5 = false;
                if (!map3.containsKey(clazz)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        JpsFileSerializerFactory fileFactory = v0;
        if (fileFactory != null) {
            return this.getFileNameForEntity(fileFactory, entities2);
        }
        return null;
    }

    private final <E extends TypedEntity> String getDefaultFileNameForEntity(JpsDirectoryEntitiesSerializerFactory<E> directoryFactory, Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>> entities2) {
        List<? extends TypedEntity> list2 = entities2.get(directoryFactory.getEntityClass());
        TypedEntity typedEntity = list2 != null ? (TypedEntity)CollectionsKt.singleOrNull(list2) : null;
        if (!(typedEntity instanceof TypedEntity)) {
            typedEntity = null;
        }
        if (typedEntity == null) {
            return null;
        }
        TypedEntity entity = typedEntity;
        return FileUtil.sanitizeFileName((String)directoryFactory.getDefaultFileName(entity)) + ".xml";
    }

    private final <E extends TypedEntity> String getFileNameForEntity(JpsFileSerializerFactory<E> fileFactory, Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>> entities2) {
        List<? extends TypedEntity> list2 = entities2.get(fileFactory.getEntityClass());
        TypedEntity typedEntity = list2 != null ? (TypedEntity)CollectionsKt.singleOrNull(list2) : null;
        if (!(typedEntity instanceof TypedEntity)) {
            typedEntity = null;
        }
        if (typedEntity == null) {
            return null;
        }
        TypedEntity entity = typedEntity;
        return fileFactory.getFileName(entity);
    }

    private final <E extends TypedEntity> List<E> getFilteredEntitiesForSerializer(JpsFileEntityTypeSerializer<E> serializer, TypedEntityStorage storage) {
        return SequencesKt.toList((Sequence)SequencesKt.filter(storage.entities(serializer.getMainEntityClass()), serializer.getEntityFilter()));
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends TypedEntity> List<Pair<TypedEntity, JpsFileEntitySource>> saveEntitiesBySerializer(JpsFileEntitiesSerializer<E> serializer, Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>> entities2, JpsFileContentWriter writer) {
        void $this$mapTo$iv$iv;
        TypedEntity it;
        Iterable $this$filterTo$iv$iv;
        List<? extends TypedEntity> list2 = entities2.get(serializer.getMainEntityClass());
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<E>");
        }
        List<TypedEntity> savedEntities = serializer.saveEntities(list2, entities2, writer);
        Iterable $this$filter$iv = savedEntities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TypedEntity)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getEntitySource(), (Object)serializer.getEntitySource()) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TypedEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it, (Object)serializer.getEntitySource());
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends TypedEntity> List<Pair<JpsFileEntitiesSerializer<?>, Map<Class<? extends TypedEntity>, List<TypedEntity>>>> createSerializersForDirectoryEntities(JpsDirectoryEntitiesSerializerFactory<E> factory, List<? extends TypedEntity> entities2) {
        void $this$mapTo$iv$iv;
        TypedEntity it;
        Iterable $this$filterTo$iv$iv;
        List list2 = this.serializerToDirectoryFactory.getKeysByValue(factory);
        UniqueNameGenerator nameGenerator2 = new UniqueNameGenerator(list2 != null ? (Collection)list2 : (Collection)CollectionsKt.emptyList(), (Function)createSerializersForDirectoryEntities.nameGenerator.1.INSTANCE);
        Iterable $this$filter$iv = entities2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TypedEntity)element$iv$iv;
            boolean bl = false;
            TypedEntity typedEntity = it;
            if (typedEntity == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            if (!((Boolean)factory.getEntityFilter().invoke((Object)typedEntity)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String fileName;
            JpsFileEntitySource.FileInDirectory currentSource;
            it = (TypedEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypedEntity typedEntity = it;
            if (typedEntity == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)nameGenerator2.generateUniqueName(FileUtil.sanitizeFileName((String)factory.getDefaultFileName(typedEntity)), "", ".xml"), (String)"nameGenerator.generateUn\u2026me(it as E)), \"\", \".xml\")");
            Map entityMap = MapsKt.mapOf((Pair)TuplesKt.to(factory.getEntityClass(), (Object)CollectionsKt.listOf((Object)it)));
            EntitySource entitySource = it.getEntitySource();
            if (!(entitySource instanceof JpsFileEntitySource.FileInDirectory)) {
                entitySource = null;
            }
            JpsFileEntitySource.FileInDirectory source = (currentSource = (JpsFileEntitySource.FileInDirectory)entitySource) != null && Intrinsics.areEqual((Object)((String)this.fileIdToFileName.get(currentSource.getFileNameId())), (Object)fileName) ? currentSource : this.createFileInDirectorySource$intellij_platform_workspaceModel_ide(VirtualFileUrlManager.INSTANCE.fromUrl(factory.getDirectoryUrl()), fileName);
            Pair pair = new Pair(factory.createSerializer(factory.getDirectoryUrl() + '/' + fileName, source), (Object)entityMap);
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    private final <E extends TypedEntity> void saveEntitiesList(JpsFileSerializerFactory<E> it, TypedEntityStorage storage, JpsFileContentWriter writer) {
        it.saveEntitiesList(storage.entities(it.getEntityClass()), writer);
    }

    /*
     * WARNING - void declaration
     */
    public JpsEntitiesSerializationData(@NotNull List<? extends JpsDirectoryEntitiesSerializerFactory<?>> directorySerializersFactories, @NotNull List<? extends JpsFileSerializerFactory<?>> fileSerializerFactories, @NotNull JpsFileContentReader reader, @NotNull List<? extends JpsFileEntityTypeSerializer<?>> entityTypeSerializers, @NotNull JpsProjectStoragePlace storagePlace) {
        Iterable $this$associateByTo$iv$iv;
        Iterable $this$associateWithTo$iv;
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkParameterIsNotNull(directorySerializersFactories, (String)"directorySerializersFactories");
        Intrinsics.checkParameterIsNotNull(fileSerializerFactories, (String)"fileSerializerFactories");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(entityTypeSerializers, (String)"entityTypeSerializers");
        Intrinsics.checkParameterIsNotNull((Object)storagePlace, (String)"storagePlace");
        this.entityTypeSerializers = entityTypeSerializers;
        this.storagePlace = storagePlace;
        this.serializerToFileFactory = new BidirectionalMap();
        this.serializerToDirectoryFactory = new BidirectionalMap();
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.create<String, \u2026eEntitiesSerializer<*>>()");
        this.fileSerializersByUrl = multiMap;
        this.fileIdToFileName = new TIntObjectHashMap();
        for (JpsDirectoryEntitiesSerializerFactory<?> jpsDirectoryEntitiesSerializerFactory : directorySerializersFactories) {
            void $this$associateWithTo$iv2;
            Iterable iterable = this.createDirectorySerializers(jpsDirectoryEntitiesSerializerFactory);
            Map destination$iv = (Map)this.serializerToDirectoryFactory;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv2) {
                JpsFileEntitiesSerializer jpsFileEntitiesSerializer = (JpsFileEntitiesSerializer)element$iv;
                object3 = element$iv;
                object2 = destination$iv;
                boolean bl = false;
                object = jpsDirectoryEntitiesSerializerFactory;
                object2.put(object3, object);
            }
        }
        for (JpsFileSerializerFactory jpsFileSerializerFactory : fileSerializerFactories) {
            void $this$mapTo$iv$iv;
            List<VirtualFileUrl> fileList = jpsFileSerializerFactory.loadFileList(reader);
            Iterable $this$map$iv = fileList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFileUrl virtualFileUrl = (VirtualFileUrl)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                VirtualFileUrl virtualFileUrl2 = it.getParent();
                if (virtualFileUrl2 == null) {
                    Intrinsics.throwNpe();
                }
                File file2 = it.getFile();
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                String string = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.file!!.name");
                object3 = jpsFileSerializerFactory.createSerializer(this.createFileInDirectorySource$intellij_platform_workspaceModel_ide(virtualFileUrl2, string), (VirtualFileUrl)it);
                object2.add(object3);
            }
            $this$map$iv = (List)destination$iv$iv;
            Map destination$iv = (Map)this.serializerToFileFactory;
            boolean $i$f$associateWithTo = false;
            destination$iv$iv = $this$associateWithTo$iv.iterator();
            while (destination$iv$iv.hasNext()) {
                Object element$iv = destination$iv$iv.next();
                JpsFileEntitiesSerializer bl = (JpsFileEntitiesSerializer)element$iv;
                object3 = element$iv;
                object2 = destination$iv;
                boolean bl2 = false;
                object = jpsFileSerializerFactory;
                object2.put(object3, object);
            }
        }
        Collection collection = this.entityTypeSerializers;
        Set set = this.serializerToDirectoryFactory.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"serializerToDirectoryFactory.keys");
        Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)set);
        Set set2 = this.serializerToFileFactory.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"serializerToFileFactory.keys");
        List list2 = CollectionsKt.plus((Collection)collection2, (Iterable)set2);
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsFileEntitiesSerializer it = (JpsFileEntitiesSerializer)element$iv;
            boolean bl = false;
            this.fileSerializersByUrl.putValue((Object)it.getFileUrl().getUrl(), (Object)it);
        }
        Iterable iterable = directorySerializersFactories;
        object2 = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        $this$associateWithTo$iv = iterable;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            JpsDirectoryEntitiesSerializerFactory it = (JpsDirectoryEntitiesSerializerFactory)element$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object = it.getDirectoryUrl();
            object3.put((Object)object, element$iv$iv);
        }
        ((JpsEntitiesSerializationData)object2).directorySerializerFactoriesByUrl = object3 = destination$iv$iv;
        Iterable iterable2 = fileSerializerFactories;
        object2 = this;
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10)), (int)16);
        $this$associateByTo$iv$iv = iterable2;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            JpsFileSerializerFactory it = (JpsFileSerializerFactory)element$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object = it.getFileUrl();
            object3.put(object, element$iv$iv);
        }
        ((JpsEntitiesSerializationData)object2).fileSerializerFactoriesByUrl = object3 = destination$iv$iv;
    }

    public static final /* synthetic */ List access$createSerializersForDirectoryEntities(JpsEntitiesSerializationData $this, JpsDirectoryEntitiesSerializerFactory factory, List entities2) {
        return $this.createSerializersForDirectoryEntities(factory, entities2);
    }
}

