/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.ConfigurationState;
import com.intellij.xdebugger.impl.WatchState;
import com.intellij.xdebugger.impl.WatchesManagerState;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class XDebuggerWatchesManager {
    private final Map<String, List<XExpression>> watches = ContainerUtil.newConcurrentMap();

    @NotNull
    public List<XExpression> getWatches(String confName) {
        List list2 = ContainerUtil.notNullize(this.watches.get(confName));
        if (list2 == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public void setWatches(@NotNull String configurationName, @NotNull List<XExpression> expressions) {
        if (configurationName == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(1);
        }
        if (expressions == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(2);
        }
        if (expressions.isEmpty()) {
            this.watches.remove(configurationName);
        } else {
            this.watches.put(configurationName, expressions);
        }
    }

    @NotNull
    public WatchesManagerState saveState(@NotNull WatchesManagerState state) {
        if (state == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(3);
        }
        List<ConfigurationState> expressions = state.getExpressions();
        expressions.clear();
        this.watches.forEach((key, value2) -> expressions.add(new ConfigurationState((String)key, (List<? extends XExpression>)value2)));
        WatchesManagerState watchesManagerState = state;
        if (watchesManagerState == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(4);
        }
        return watchesManagerState;
    }

    public void clearContext() {
        this.watches.clear();
    }

    public void loadState(@NotNull WatchesManagerState state) {
        if (state == null) {
            XDebuggerWatchesManager.$$$reportNull$$$0(5);
        }
        this.clearContext();
        for (ConfigurationState expressionState : state.getExpressions()) {
            List<WatchState> expressionStates = expressionState.getExpressionStates();
            if (ContainerUtil.isEmpty(expressionStates)) continue;
            this.watches.put(expressionState.getName(), ContainerUtil.mapNotNull(expressionStates, XExpressionState::toXExpression));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerWatchesManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatches";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerWatchesManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setWatches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

