/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.parser.psi.impl;

import com.intellij.docker.dockerFile.parser.DockerParserUtil;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiVariableDeclaration;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiVariableReference;
import com.intellij.docker.dockerFile.parser.psi.impl.DockerPsiCompositeElementImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileArgCommand;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileArgDeclaration;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileEnvCommand;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerPsiVariableReferenceBase
extends DockerPsiCompositeElementImpl
implements DockerPsiVariableReference {
    private static final Object[] NO_VARIANTS = new Object[0];

    public DockerPsiVariableReferenceBase(ASTNode astNode) {
        super(astNode);
    }

    @NotNull
    public PsiElement getElement() {
        DockerPsiVariableReferenceBase dockerPsiVariableReferenceBase = this;
        if (dockerPsiVariableReferenceBase == null) {
            DockerPsiVariableReferenceBase.$$$reportNull$$$0(0);
        }
        return dockerPsiVariableReferenceBase;
    }

    public PsiReference getReference() {
        return this;
    }

    @Override
    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            DockerPsiVariableReferenceBase.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement referencingPart = Optional.ofNullable(this.getReferencedName()).orElse(this.getDollar());
        TextRange nameRange = referencingPart.getTextRange();
        TextRange textRange = nameRange.shiftRight(-this.getTextOffset());
        if (textRange == null) {
            DockerPsiVariableReferenceBase.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Nullable
    public DockerPsiVariableDeclaration resolve() {
        if (this.getReferencedName() == null) {
            return null;
        }
        String lookup = this.getReferencedName().getText();
        DockerPsiCommand curCommand = (DockerPsiCommand)PsiTreeUtil.getParentOfType((PsiElement)this, DockerPsiCommand.class);
        if (curCommand == null) {
            return null;
        }
        if (curCommand instanceof DockerFileEnvCommand || curCommand instanceof DockerFileArgCommand) {
            DockerPsiVariableDeclaration curDeclaration;
            DockerPsiVariableDeclaration cur = curDeclaration = (DockerPsiVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this, DockerPsiVariableDeclaration.class);
            while (cur != null) {
                if (cur.isDeclarationForName(lookup)) {
                    return cur;
                }
                cur = (DockerPsiVariableDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)cur, DockerPsiVariableDeclaration.class);
            }
        }
        DockerPsiCommand cur = curCommand;
        while (cur != null) {
            DockerFileArgCommand argCommand;
            DockerFileArgDeclaration argDeclaration;
            if (cur instanceof DockerFileEnvCommand) {
                Object unstructured;
                DockerFileEnvCommand envCommand = (DockerFileEnvCommand)cur;
                if (envCommand.getEnvUnstructuredDeclaration() != null && (unstructured = envCommand.getEnvUnstructuredDeclaration()).isDeclarationForName(lookup)) {
                    return unstructured;
                }
                unstructured = envCommand.getEnvRegularDeclarationList().iterator();
                while (unstructured.hasNext()) {
                    DockerPsiVariableDeclaration nextRegular = (DockerPsiVariableDeclaration)unstructured.next();
                    if (!nextRegular.isDeclarationForName(lookup)) continue;
                    return nextRegular;
                }
            } else if (cur instanceof DockerFileArgCommand && (argDeclaration = (argCommand = (DockerFileArgCommand)cur).getArgDeclaration()) != null && argDeclaration.isDeclarationForName(lookup)) {
                return argDeclaration;
            }
            cur = (DockerPsiCommand)PsiTreeUtil.getPrevSiblingOfType((PsiElement)cur, DockerPsiCommand.class);
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        PsiElement namePsi = this.getReferencedName();
        String string = "$" + (namePsi == null ? "" : namePsi.getText());
        if (string == null) {
            DockerPsiVariableReferenceBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            DockerPsiVariableReferenceBase.$$$reportNull$$$0(4);
        }
        if (this.getReferencedName() == null) {
            throw new IncorrectOperationException("Single $ is not a real ref and should not be renamed");
        }
        PsiElement newRef = DockerParserUtil.createNewIdentifier(newElementName);
        ASTNode curRefNode = this.getReferencedName().getNode();
        PostprocessReformattingAspect.getInstance((Project)this.getProject()).disablePostprocessFormattingInside(() -> curRefNode.getTreeParent().replaceChild(curRefNode, newRef.getNode()));
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            DockerPsiVariableReferenceBase.$$$reportNull$$$0(5);
        }
        return this;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            DockerPsiVariableReferenceBase.$$$reportNull$$$0(6);
        }
        if (!(element instanceof DockerPsiVariableDeclaration)) {
            return false;
        }
        if (this.getReferencedName() == null) {
            return false;
        }
        if (element.getContainingFile() != this.getContainingFile()) {
            return false;
        }
        String lookup = this.getReferencedName().getText();
        return ((DockerPsiVariableDeclaration)element).isDeclarationForName(lookup);
    }

    public Object @NotNull [] getVariants() {
        if (NO_VARIANTS == null) {
            DockerPsiVariableReferenceBase.$$$reportNull$$$0(7);
        }
        return NO_VARIANTS;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/dockerFile/parser/psi/impl/DockerPsiVariableReferenceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/dockerFile/parser/psi/impl/DockerPsiVariableReferenceBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

