/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.actions;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.source.Angular2SourceDeclaration;
import org.angular2.entities.source.Angular2SourceModule;
import org.angular2.inspections.actions.Angular2ActionFactory;
import org.angular2.inspections.actions.NgModuleImportAction;
import org.angular2.inspections.quickfixes.Angular2FixesPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportNgModuleDeclarationAction
implements QuestionAction {
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiElement myContext;
    @NotNull
    private final SmartPsiElementPointer<ES6Decorator> myDecorator;
    @NotNull
    private final String myName;
    private final boolean myCodeCompletion;
    private final NotNullLazyValue<NgModuleImportAction> myImportAction;

    ExportNgModuleDeclarationAction(@Nullable Editor editor, @NotNull PsiElement context, @NotNull SmartPsiElementPointer<ES6Decorator> decorator, @NotNull String actionName, boolean codeCompletion) {
        if (context == null) {
            ExportNgModuleDeclarationAction.$$$reportNull$$$0(0);
        }
        if (decorator == null) {
            ExportNgModuleDeclarationAction.$$$reportNull$$$0(1);
        }
        if (actionName == null) {
            ExportNgModuleDeclarationAction.$$$reportNull$$$0(2);
        }
        this.myEditor = editor;
        this.myContext = context;
        this.myDecorator = decorator;
        this.myName = actionName;
        this.myCodeCompletion = codeCompletion;
        this.myImportAction = NotNullLazyValue.createValue(() -> Angular2ActionFactory.createNgModuleImportAction(this.myEditor, this.myContext, this.myCodeCompletion));
    }

    public boolean execute() {
        if (this.addExport()) {
            ((NgModuleImportAction)((Object)this.myImportAction.getValue())).executeForAllVariants(null);
        }
        return true;
    }

    public List<JSElement> getCandidates() {
        return ((NgModuleImportAction)((Object)this.myImportAction.getValue())).getCandidates();
    }

    protected boolean addExport() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiElement element = this.myDecorator.getElement();
        Ref result = new Ref((Object)false);
        CommandProcessor.getInstance().executeCommand(this.myContext.getProject(), () -> {
            if (!this.myContext.isValid() || element == null || !element.isValid()) {
                return;
            }
            result.set((Object)this.executeFor(element));
        }, this.myName, (Object)this);
        return result.get() == Boolean.TRUE;
    }

    private boolean executeFor(@NotNull PsiElement element) {
        if (element == null) {
            ExportNgModuleDeclarationAction.$$$reportNull$$$0(3);
        }
        return WriteAction.compute(() -> {
            Angular2SourceDeclaration declaration = (Angular2SourceDeclaration)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getDeclaration(element), Angular2SourceDeclaration.class);
            if (declaration == null) {
                return null;
            }
            String className = declaration.getTypeScriptClass().getName();
            if (className == null) {
                return false;
            }
            Angular2SourceModule module = (Angular2SourceModule)ObjectUtils.tryCast((Object)declaration.getModule(), Angular2SourceModule.class);
            if (module == null) {
                return false;
            }
            ES6ImportPsiUtil.insertJSImport((PsiElement)module.getDecorator(), (String)className, (PsiElement)declaration.getTypeScriptClass(), (Editor)this.myEditor);
            return Angular2FixesPsiUtil.insertNgModuleMember(module, "exports", className);
        }) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/angular2/inspections/actions/ExportNgModuleDeclarationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

