/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.LogWrapper;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Component;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublishUtils {
    private static final Logger LOG = Logger.getInstance(PublishUtils.class);
    private static DefaultFileSystemManager ourFilesystemManager;
    public static boolean DISABLE_FILESYSTEM_CACHE;
    private static final long TEST_CONNECTION_POLL_TIMEOUT = 100L;

    @Nullable
    public static String testConnection(Deployable server, JComponent parentComponent, String title, boolean checkUrl) throws FileSystemException {
        Ref error = new Ref();
        Ref homePath = new Ref();
        Runnable runnable = () -> {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            LOG.assertTrue(server.validateFastInternal(false) == null);
            try {
                pi.setText(WDBundle.message("validating.server", new Object[0]));
                String e = server.validateInternalSlow(-1L, false);
                if (e != null) {
                    error.set((Object)new CustomFileSystemException(e));
                    return;
                }
            }
            catch (TimeoutException e) {
                LOG.error((Throwable)e);
            }
            Semaphore done = new Semaphore();
            done.down();
            EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    if (server.getAccessType().isProtocolBased()) {
                        pi.setText(WDBundle.message("connecting.by.0", server.getAccessType().getTitle()));
                        RemoteConnection connection = RemoteConnectionManager.getInstance().openConnection(ConnectionOwnerFactory.createConnectionOwner((Component)parentComponent), title, (Connectable)server, FileTransferConfig.Origin.Unchanged, (EventDispatcher<ForceDisconnectListener>)forceDisconnectDispatcher, pi);
                        try {
                            connection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> homePath.set((Object)connection.resolveRoot().getCurrentDir())), pi);
                        }
                        finally {
                            connection.release();
                        }
                    }
                    if (checkUrl) {
                        PublishUtils.doCheckUrl(server, pi);
                    }
                }
                catch (FileSystemException e) {
                    error.set((Object)e);
                }
                finally {
                    done.up();
                }
            });
            while (!done.waitFor(100L)) {
                if (!pi.isCanceled()) continue;
                ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                break;
            }
        };
        boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, title, true, null, parentComponent);
        if (!complete) {
            throw new ProcessCanceledException();
        }
        if (!error.isNull()) {
            throw (FileSystemException)((Object)error.get());
        }
        return (String)homePath.get();
    }

    private static void doCheckUrl(Deployable server, ProgressIndicator pi) throws FileSystemException {
        pi.setText(WDBundle.message("connecting.by.0", server.getUrl().startsWith("https:") ? "HTTPS" : "HTTP"));
        try {
            HttpRequests.request((String)DeploymentPathUtils.joinWebPath(server.getUrl(), "")).productNameAsUserAgent().tryConnect();
        }
        catch (IOException e) {
            throw new CustomFileSystemException(WDBundle.message("page.not.found", new Object[0]), e);
        }
    }

    @NotNull
    public static String getMessage(Throwable throwable, boolean full) {
        while (throwable.getCause() instanceof FileSystemException && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        if (throwable.getCause() instanceof FTPConnectionClosedException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof FileSystemException && "vfs.provider/set-permissions.error".equals(((FileSystemException)throwable).getCode()) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String string = SshConnectionUtil.getMessage((Throwable)throwable, (boolean)full);
        if (string == null) {
            PublishUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static boolean isFatal(Throwable t) {
        while (t instanceof FileSystemException) {
            String code = ((FileSystemException)t).getCode();
            if (code != null && code.contains("connect.error")) {
                return true;
            }
            if (t.getCause() == t) break;
            t = t.getCause();
        }
        return false;
    }

    public static synchronized FileSystemManager getManager() {
        if (ourFilesystemManager == null) {
            ourFilesystemManager = new StandardFileSystemManager(){

                public void init() throws FileSystemException {
                    this.setConfiguration(PublishUtils.class.getResource("commons-vfs-providers.xml"));
                    this.setCacheStrategy(DISABLE_FILESYSTEM_CACHE ? CacheStrategy.ON_RESOLVE : CacheStrategy.MANUAL);
                    this.setFilesCache((FilesCache)new SoftRefFilesCache(){

                        protected boolean shouldCloseFilesystemOnClear(Map files) {
                            return false;
                        }
                    });
                    super.init();
                }
            };
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)new Disposable(){

                public void dispose() {
                    ourFilesystemManager = null;
                }
            });
            try {
                ClassLoaderUtil.runWithClassLoader((ClassLoader)PublishUtils.class.getClassLoader(), () -> ourFilesystemManager.init());
            }
            catch (FileSystemException e) {
                LOG.error("Failed to initialize filesystem manager", (Throwable)e);
                return null;
            }
            ourFilesystemManager.setLogger((Log)new LogWrapper(LOG));
        }
        return ourFilesystemManager;
    }

    public static boolean isProcessCanceledException(FileSystemException e) {
        return e.getCause() instanceof ProcessCanceledException;
    }

    private static boolean isAuthFail(Throwable throwable) {
        while (throwable.getCause() instanceof FileSystemException && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        if (throwable.getCause() instanceof AuthFailSshTransportException) {
            return true;
        }
        if (throwable.getCause() instanceof SshTransportException && "Auth fail".equals(throwable.getCause().getMessage())) {
            return true;
        }
        return throwable instanceof FileSystemException && "vfs.provider.ftp/login.error".equals(((FileSystemException)throwable).getCode());
    }

    public static void showLoginDialogAfterAuthFail(@NotNull Throwable throwable, @NotNull Deployable deployable) {
        if (throwable == null) {
            PublishUtils.$$$reportNull$$$0(1);
        }
        if (deployable == null) {
            PublishUtils.$$$reportNull$$$0(2);
        }
        if (!deployable.getAccessType().isProtocolBased() || deployable.isAnonymous() || !PublishUtils.isAuthFail(throwable)) {
            return;
        }
        AuthHelper.setDeployableToReAuth(deployable);
    }

    @Deprecated
    public static FileObject findFile(@NotNull FileSystem fs, @NotNull WebServerConfig.RemotePath remotePath, @NotNull Connectable connectable) throws FileSystemException {
        if (fs == null) {
            PublishUtils.$$$reportNull$$$0(3);
        }
        if (remotePath == null) {
            PublishUtils.$$$reportNull$$$0(4);
        }
        if (connectable == null) {
            PublishUtils.$$$reportNull$$$0(5);
        }
        if (connectable.getAccessType().isProtocolBased()) {
            return fs.resolveFile(remotePath.path);
        }
        String path = remotePath.path;
        if (SystemInfo.isWindows) {
            String drive = remotePath.path.substring(0, 2);
            path = path.substring(3);
            String rootUri = fs.getRootURI();
            LOG.assertTrue(drive.equals(rootUri.substring(8, 10)));
        }
        return fs.resolveFile(path);
    }

    public static FileObject findFile(@NotNull RemoteConnection connection, @NotNull WebServerConfig.RemotePath remotePath, @NotNull Connectable connectable) throws FileSystemException {
        if (connection == null) {
            PublishUtils.$$$reportNull$$$0(6);
        }
        if (remotePath == null) {
            PublishUtils.$$$reportNull$$$0(7);
        }
        if (connectable == null) {
            PublishUtils.$$$reportNull$$$0(8);
        }
        if (connectable.getAccessType().isProtocolBased()) {
            return connection.resolveFile(remotePath.path);
        }
        String path = remotePath.path;
        if (SystemInfo.isWindows) {
            String drive = remotePath.path.substring(0, 2);
            path = path.substring(3);
            String rootUri = connection.getRootName().getRootURI();
            LOG.assertTrue(drive.equals(rootUri.substring(8, 10)));
        }
        return connection.resolveFile(path);
    }

    @NotNull
    public static Function<MergeResult, String> getMergeResolveCaptions() {
        Function function = result -> {
            switch (result) {
                case CANCEL: {
                    return null;
                }
                case LEFT: {
                    return WDBundle.message("merge.on.upload.left.button", new Object[0]);
                }
                case RIGHT: {
                    return WDBundle.message("merge.on.upload.right.button", new Object[0]);
                }
                case RESOLVED: {
                    return WDBundle.message("merge.on.upload.ok.button", new Object[0]);
                }
            }
            throw new IllegalStateException(result.name());
        };
        if (function == null) {
            PublishUtils.$$$reportNull$$$0(9);
        }
        return function;
    }

    public static boolean needsTransfer(@NotNull AccessType accessType) {
        if (accessType == null) {
            PublishUtils.$$$reportNull$$$0(10);
        }
        return accessType != AccessType.LOCAL;
    }

    public static String formatSize(float size, String bKey, String kbKey, String mbKey) {
        if (size < 1000.0f) {
            return WDBundle.message(bKey, Float.valueOf(size));
        }
        if (size < 1000000.0f) {
            return WDBundle.message(kbKey, Float.valueOf(size / 1000.0f));
        }
        return WDBundle.message(mbKey, Float.valueOf(size / 1000.0f / 1000.0f));
    }

    @Nullable
    public static String validateUrl(@NonNls String url) {
        if (StringUtil.isEmptyOrSpaces((String)url) || "http://".equalsIgnoreCase(url)) {
            return WDBundle.message("url.is.empty", new Object[0]);
        }
        if (!(url = StringUtil.toLowerCase((String)url)).startsWith("http://") && !url.startsWith("https://")) {
            return WDBundle.message("url.is.invalid", new Object[0]);
        }
        return null;
    }

    static {
        DISABLE_FILESYSTEM_CACHE = Boolean.getBoolean("com.jetbrains.plugins.webDeployment.noCache");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/PublishUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/PublishUtils";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeResolveCaptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showLoginDialogAfterAuthFail";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "needsTransfer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefreshingLocalFileProvider
    extends DefaultLocalFileProvider {
        protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) {
            LocalFileName rootName = (LocalFileName)name;
            return new LocalFileSystem((FileName)rootName, rootName.getRootFile(), fileSystemOptions){

                public synchronized FileObject resolveFile(FileName name) throws FileSystemException {
                    FileObject file = super.resolveFile(name);
                    if (!DISABLE_FILESYSTEM_CACHE && file != null) {
                        file.refresh();
                    }
                    return file;
                }
            };
        }
    }
}

