/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriter;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporterValues;
import com.intellij.diagnostic.startUpPerformanceReporter.ThreadNameManager;
import com.intellij.diagnostic.startUpPerformanceReporter.TraceEventFormatWriter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectLongHashMap;
import com.intellij.util.io.PathKt;
import gnu.trove.THashMap;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\n\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u001a\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter;", "Lcom/intellij/openapi/startup/StartupActivity;", "Lcom/intellij/diagnostic/StartUpPerformanceService;", "()V", "lastMetrics", "Lcom/intellij/util/containers/ObjectIntHashMap;", "", "lastReport", "Ljava/nio/ByteBuffer;", "pluginCostMap", "", "Lcom/intellij/util/containers/ObjectLongHashMap;", "startUpFinishedCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getLastReport", "getMetrics", "getPluginCostMap", "lastOptionTopHitProviderFinishedForProject", "", "project", "Lcom/intellij/openapi/project/Project;", "logStats", "projectName", "reportIfAnotherAlreadySet", "runActivity", "ActivityListener", "Companion", "intellij.platform.diagnostic"})
public final class StartUpPerformanceReporter
implements StartupActivity,
StartUpPerformanceService {
    private AtomicInteger startUpFinishedCounter = new AtomicInteger();
    private Map<String, ObjectLongHashMap<String>> pluginCostMap;
    private ByteBuffer lastReport;
    private ObjectIntHashMap<String> lastMetrics;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String VERSION = "19";
    public static final Companion Companion;

    @Nullable
    public ObjectIntHashMap<String> getMetrics() {
        return this.lastMetrics;
    }

    @NotNull
    public Map<String, ObjectLongHashMap<String>> getPluginCostMap() {
        Map<String, ObjectLongHashMap<String>> map = this.pluginCostMap;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        return map;
    }

    @Nullable
    public ByteBuffer getLastReport() {
        return this.lastReport;
    }

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (ActivityImpl.listener != null) {
            return;
        }
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String projectName = string;
        ActivityImpl.listener = new ActivityListener(projectName);
    }

    public void lastOptionTopHitProviderFinishedForProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        this.reportIfAnotherAlreadySet(string);
    }

    private final void reportIfAnotherAlreadySet(String projectName) {
        if (this.startUpFinishedCounter.incrementAndGet() == 2) {
            this.startUpFinishedCounter.set(0);
            StartUpMeasurer.stopPluginCostMeasurement();
            NonUrgentExecutor.getInstance().execute(new Runnable(this, projectName){
                final /* synthetic */ StartUpPerformanceReporter this$0;
                final /* synthetic */ String $projectName;

                public final void run() {
                    StartUpPerformanceReporter.access$logStats(this.this$0, this.$projectName);
                }
                {
                    this.this$0 = startUpPerformanceReporter;
                    this.$projectName = string;
                }
            });
        }
    }

    private final synchronized void logStats(String projectName) {
        StartUpPerformanceReporterValues startUpPerformanceReporterValues = StartUpPerformanceReporter.Companion.doLogStats(projectName);
        if (startUpPerformanceReporterValues == null) {
            return;
        }
        StartUpPerformanceReporterValues params = startUpPerformanceReporterValues;
        this.pluginCostMap = params.getPluginCostMap();
        this.lastReport = params.getLastReport();
        this.lastMetrics = params.getLastMetrics();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StartUpMeasurer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$logStats(StartUpPerformanceReporter $this, String projectName) {
        $this.logStats(projectName);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter$ActivityListener;", "Ljava/util/function/Consumer;", "Lcom/intellij/diagnostic/ActivityImpl;", "projectName", "", "(Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter;Ljava/lang/String;)V", "editorRestoringTillPaint", "", "projectOpenedActivitiesPassed", "accept", "", "activity", "completed", "intellij.platform.diagnostic"})
    public final class ActivityListener
    implements Consumer<ActivityImpl> {
        private volatile boolean projectOpenedActivitiesPassed;
        private volatile boolean editorRestoringTillPaint;
        private final String projectName;

        @Override
        public void accept(@NotNull ActivityImpl activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            if (activity.getCategory() != null && activity.getCategory() != ActivityCategory.APP_INIT) {
                return;
            }
            if (activity.getEnd() == 0L) {
                if (Intrinsics.areEqual((Object)activity.getName(), (Object)"editor restoring till paint")) {
                    this.editorRestoringTillPaint = false;
                }
            } else {
                switch (activity.getName()) {
                    case "project post-startup dumb-aware activities": {
                        this.projectOpenedActivitiesPassed = true;
                        if (!this.editorRestoringTillPaint) break;
                        this.completed();
                        break;
                    }
                    case "editor restoring till paint": {
                        this.editorRestoringTillPaint = true;
                        if (!this.projectOpenedActivitiesPassed) break;
                        this.completed();
                        break;
                    }
                }
            }
        }

        private final void completed() {
            ActivityImpl.listener = null;
            StartUpPerformanceReporter.this.reportIfAnotherAlreadySet(this.projectName);
        }

        public ActivityListener(String projectName) {
            Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
            this.projectName = projectName;
            this.editorRestoringTillPaint = true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tJ\u001b\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$intellij_platform_diagnostic", "()Lcom/intellij/openapi/diagnostic/Logger;", "VERSION", "", "doLogStats", "Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporterValues;", "projectName", "logStats", "", "sortItems", "items", "", "Lcom/intellij/diagnostic/ActivityImpl;", "sortItems$intellij_platform_diagnostic", "intellij.platform.diagnostic"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG$intellij_platform_diagnostic() {
            return LOG;
        }

        public final void sortItems$intellij_platform_diagnostic(@NotNull List<ActivityImpl> items) {
            Intrinsics.checkParameterIsNotNull(items, (String)"items");
            CollectionsKt.sortWith(items, (Comparator)sortItems.1.INSTANCE);
        }

        public final void logStats(@NotNull String projectName) {
            Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
            this.doLogStats(projectName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final StartUpPerformanceReporterValues doLogStats(String projectName) {
            var3_2 = false;
            items = new ArrayList<E>();
            var4_5 = false;
            instantEvents = new ArrayList<E>();
            activities = new THashMap();
            var6_7 = false;
            services = new ArrayList<E>();
            threadNameManager = new ThreadNameManager();
            var7_10 = new Ref.LongRef();
            var7_10.element = -1L;
            StartUpMeasurer.processAndClear((boolean)SystemProperties.getBooleanProperty((String)"idea.collect.perf.after.first.project", (boolean)false), (Consumer)new Consumer<ActivityImpl>(threadNameManager, instantEvents, items, (Ref.LongRef)end, services, activities){
                final /* synthetic */ ThreadNameManager $threadNameManager;
                final /* synthetic */ List $instantEvents;
                final /* synthetic */ List $items;
                final /* synthetic */ Ref.LongRef $end;
                final /* synthetic */ List $services;
                final /* synthetic */ THashMap $activities;

                /*
                 * WARNING - void declaration
                 */
                public final void accept(ActivityImpl item) {
                    ActivityImpl activityImpl = item;
                    Intrinsics.checkExpressionValueIsNotNull((Object)activityImpl, (String)"item");
                    this.$threadNameManager.getThreadName(activityImpl);
                    if (item.getEnd() == -1L) {
                        this.$instantEvents.add(item);
                    } else {
                        ActivityCategory category = item.getCategory();
                        if (category == null) {
                            this.$items.add(item);
                            if (Intrinsics.areEqual((Object)item.getName(), (Object)"project post-startup dumb-aware activities")) {
                                this.$end.element = item.getEnd();
                            }
                        } else if (category == ActivityCategory.APP_COMPONENT || category == ActivityCategory.PROJECT_COMPONENT || category == ActivityCategory.MODULE_COMPONENT || category == ActivityCategory.APP_SERVICE || category == ActivityCategory.PROJECT_SERVICE || category == ActivityCategory.MODULE_SERVICE || category == ActivityCategory.SERVICE_WAITING) {
                            this.$services.add(item);
                        } else {
                            Object object;
                            void $this$getOrPut$iv;
                            Map map = (Map)this.$activities;
                            String key$iv = category.getJsonName();
                            boolean $i$f$getOrPut = false;
                            V value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                boolean bl = false;
                                boolean bl2 = false;
                                List answer$iv = new ArrayList<E>();
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                object = answer$iv;
                            } else {
                                object = value$iv;
                            }
                            ((List)object).add(item);
                        }
                    }
                }
                {
                    this.$threadNameManager = threadNameManager;
                    this.$instantEvents = list;
                    this.$items = list2;
                    this.$end = longRef;
                    this.$services = list3;
                    this.$activities = tHashMap;
                }
            });
            if (items.isEmpty()) {
                return null;
            }
            this.sortItems$intellij_platform_diagnostic(items);
            pluginCostMap = StartUpPerformanceReporterKt.access$computePluginCostMap();
            w = new IdeaFormatWriter((Map)activities, pluginCostMap, threadNameManager);
            startTime = ((ActivityImpl)CollectionsKt.first((List)items)).getStart();
            for (ActivityImpl item : items) {
                if (item.getPluginId() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"item.pluginId ?: continue");
                v0 /* !! */  = item.getCategory();
                if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .name()) == null) {
                    v0 /* !! */  = "unknown";
                }
                StartUpMeasurer.doAddPluginCost((String)pluginId, (String)v0 /* !! */ , (long)(item.getEnd() - item.getStart()), (Map)pluginCostMap);
            }
            w.write(startTime, items, services, instantEvents, end.element, projectName);
            currentReport = w.toByteBuffer();
            perfFilePath = System.getProperty("idea.log.perf.stats.file");
            traceFilePath = System.getProperty("idea.log.perf.trace.file");
            v1 = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"ApplicationManager.getApplication()");
            if (v1.isInternal()) ** GOTO lbl-1000
            v2 = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"ApplicationInfoEx.getInstanceEx()");
            v3 = v2.getBuild();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"ApplicationInfoEx.getInstanceEx().build");
            if (v3.isSnapshot()) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = false;
            }
            mayLogReport = SystemProperties.getBooleanProperty((String)"idea.log.perf.stats", (boolean)v4);
            var16_18 = perfFilePath;
            var17_19 = false;
            var18_21 = false;
            if (!(var16_18 == null || StringsKt.isBlank((CharSequence)var16_18) != false)) {
                v5 = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"ApplicationManager.getApplication()");
                if (!v5.isUnitTestMode() && mayLogReport) {
                    w.writeToLog(this.getLOG$intellij_platform_diagnostic());
                }
            }
            var16_18 = perfFilePath;
            var17_19 = false;
            var18_21 = false;
            if (!(var16_18 == null || StringsKt.isBlank((CharSequence)var16_18) != false)) {
                this.getLOG$intellij_platform_diagnostic().info("StartUp Measurement report was written to: " + perfFilePath);
                v6 = Paths.get(perfFilePath, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"Paths.get(perfFilePath)");
                PathKt.write$default((Path)v6, (ByteBuffer)currentReport, (boolean)false, (int)2, null);
            }
            var16_18 = traceFilePath;
            var17_19 = false;
            var18_21 = false;
            if (!(var16_18 == null || StringsKt.isBlank((CharSequence)var16_18) != false)) {
                this.getLOG$intellij_platform_diagnostic().info("StartUp trace report was written to: " + traceFilePath);
                traceEventFormat = new TraceEventFormatWriter(startTime, instantEvents, threadNameManager);
                v7 = Paths.get(traceFilePath, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"Paths.get(traceFilePath)");
                var17_20 /* !! */  = PathKt.outputStream((Path)v7);
                var18_22 = Charsets.UTF_8;
                var19_24 = false;
                var17_20 /* !! */  = new OutputStreamWriter(var17_20 /* !! */ , var18_22);
                var18_23 = false;
                var19_25 = null;
                try {
                    it = (OutputStreamWriter)var17_20 /* !! */ ;
                    $i$a$-use-StartUpPerformanceReporter$Companion$doLogStats$2 = false;
                    traceEventFormat.write(items, (Map)activities, services, it);
                    var20_26 = Unit.INSTANCE;
                }
                catch (Throwable var20_27) {
                    var19_25 = var20_27;
                    throw var20_27;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var17_20 /* !! */ , (Throwable)var19_25);
                }
            }
            return new StartUpPerformanceReporterValues(pluginCostMap, currentReport, w.getPublicStatMetrics());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

