/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import javax.swing.JComponent;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.intellij.images.thumbnail.actions.FilterImagesAction;
import org.intellij.images.thumbnail.actions.ThemeFilter;
import org.jetbrains.annotations.NotNull;

public final class FilterByThemeComboBoxAction
extends ComboBoxAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FilterByThemeComboBoxAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        boolean hasApplicableExtension = Arrays.stream(ThemeFilter.EP_NAME.getExtensions()).allMatch(filter -> project != null && filter.isApplicableToProject(project));
        e.getPresentation().setVisible(view != null && hasApplicableExtension);
        ThemeFilter filter2 = view != null ? view.getFilter() : null;
        e.getPresentation().setText(filter2 == null ? CommonBundle.message((String)"action.text.all", (Object[])new Object[0]) : filter2.getDisplayName());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FilterImagesAction(new ThemeFilter(){

            @Override
            public String getDisplayName() {
                return "All";
            }

            @Override
            public boolean accepts(VirtualFile file) {
                return true;
            }

            @Override
            public boolean isApplicableToProject(Project project) {
                return true;
            }

            @Override
            public void setFilter(ThumbnailView view) {
                view.setFilter(this);
            }
        }));
        for (ThemeFilter filter : (ThemeFilter[])ThemeFilter.EP_NAME.getExtensions()) {
            group.add((AnAction)new FilterImagesAction(filter));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            FilterByThemeComboBoxAction.$$$reportNull$$$0(1);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/thumbnail/actions/FilterByThemeComboBoxAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/thumbnail/actions/FilterByThemeComboBoxAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

