/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.sorting;

import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.completion.sorting.LanguageRankingModel;
import com.intellij.completion.sorting.RankingModelWrapper;
import com.intellij.completion.sorting.RankingSupport;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.completion.RankingModelProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.stats.experiment.EmulatedExperiment;
import com.intellij.stats.experiment.WebServiceStatus;
import com.jetbrains.completion.ranker.WeakModelProvider;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0010H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/completion/sorting/RankingSupport;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "enabledInTests", "", "availableLanguages", "", "", "enableInTests", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "findProviderSafe", "Lcom/intellij/internal/ml/completion/RankingModelProvider;", "language", "Lcom/intellij/lang/Language;", "getRankingModel", "Lcom/intellij/completion/sorting/RankingModelWrapper;", "shouldSortByML", "provider", "tryGetModel", "intellij.statsCollector"})
public final class RankingSupport {
    private static final Logger LOG;
    private static boolean enabledInTests;
    public static final RankingSupport INSTANCE;

    @Nullable
    public final RankingModelWrapper getRankingModel(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        RankingModelProvider provider = this.findProviderSafe(language);
        return provider != null && this.shouldSortByML(language, provider) ? this.tryGetModel(provider) : null;
    }

    @NotNull
    public final List<String> availableLanguages() {
        Collection collection = Language.getRegisteredLanguages();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"Language.getRegisteredLanguages()");
        Collection registeredLanguages = collection;
        return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)WeakModelProvider.Companion.availableProviders(), (Function1)((Function1)new Function1<RankingModelProvider, Boolean>(registeredLanguages){
            final /* synthetic */ Collection $registeredLanguages;

            public final boolean invoke(@NotNull RankingModelProvider provider) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                    Iterable $this$any$iv = this.$registeredLanguages;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Language it = (Language)element$iv;
                            boolean bl2 = false;
                            if (!provider.isLanguageSupported(it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$registeredLanguages = collection;
                super(1);
            }
        })), (Function1)availableLanguages.2.INSTANCE))));
    }

    private final RankingModelProvider findProviderSafe(Language language) {
        try {
            return WeakModelProvider.Companion.findProvider(language);
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private final RankingModelWrapper tryGetModel(RankingModelProvider provider) {
        try {
            DecisionFunction decisionFunction = provider.getModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)decisionFunction, (String)"provider.model");
            return new LanguageRankingModel(decisionFunction);
        }
        catch (Exception e) {
            LOG.error("Could not create ranking model '" + provider.getDisplayNameInSettings() + '\'', (Throwable)e);
            return null;
        }
    }

    private final boolean shouldSortByML(Language language, RankingModelProvider provider) {
        Application application = ApplicationManager.getApplication();
        WebServiceStatus webServiceStatus = WebServiceStatus.Companion.getInstance();
        Application application2 = application;
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"application");
        if (application2.isUnitTestMode()) {
            return enabledInTests;
        }
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        CompletionMLRankingSettings settings = completionMLRankingSettings;
        if (application.isEAP() && webServiceStatus.isExperimentOnCurrentIDE() && settings.isCompletionLogsSendAllowed()) {
            return EmulatedExperiment.Companion.shouldRank(language, webServiceStatus.experimentVersion());
        }
        return settings.isRankingEnabled() && settings.isLanguageEnabled(provider.getDisplayNameInSettings());
    }

    public final void enableInTests(@NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        enabledInTests = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)enableInTests.1.INSTANCE);
    }

    private RankingSupport() {
    }

    static {
        RankingSupport rankingSupport;
        INSTANCE = rankingSupport = new RankingSupport();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RankingSupport.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$getEnabledInTests$p(RankingSupport $this) {
        RankingSupport rankingSupport = $this;
        return enabledInTests;
    }

    public static final /* synthetic */ void access$setEnabledInTests$p(RankingSupport $this, boolean bl) {
        RankingSupport rankingSupport = $this;
        enabledInTests = bl;
    }
}

