/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.reporting.PermissionsKt;
import com.intellij.stats.CompletionStatsPolicy;
import com.intellij.stats.completion.CompletionActionsListener;
import com.intellij.stats.completion.CompletionActionsTracker;
import com.intellij.stats.completion.CompletionLogger;
import com.intellij.stats.completion.CompletionLoggerProvider;
import com.intellij.stats.completion.CompletionPopupListener;
import com.intellij.stats.completion.CompletionTrackerInitializer;
import com.intellij.stats.completion.LoggerPerformanceTracker;
import com.intellij.stats.completion.LookupActionsListener;
import com.intellij.stats.completion.LookupTracker;
import com.intellij.stats.experiment.WebServiceStatus;
import com.intellij.stats.storage.factors.MutableLookupStorage;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/stats/completion/CompletionLoggerInitializer;", "Lcom/intellij/stats/completion/LookupTracker;", "actionListener", "Lcom/intellij/stats/completion/LookupActionsListener;", "(Lcom/intellij/stats/completion/LookupActionsListener;)V", "actionsTracker", "Lcom/intellij/stats/completion/CompletionActionsListener;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "storage", "Lcom/intellij/stats/storage/factors/MutableLookupStorage;", "experimentHelper", "Lcom/intellij/stats/experiment/WebServiceStatus;", "lookupClosed", "", "lookupCreated", "sessionShouldBeLogged", "", "language", "Lcom/intellij/lang/Language;", "Companion", "intellij.statsCollector"})
public final class CompletionLoggerInitializer
extends LookupTracker {
    private final LookupActionsListener actionListener;
    private static final Map<String, Double> LOGGED_SESSIONS_RATIO;
    public static final Companion Companion;

    @Override
    protected void lookupClosed() {
        this.actionListener.setListener(new CompletionPopupListener.Adapter());
    }

    @Override
    protected void lookupCreated(@NotNull LookupImpl lookup, @NotNull MutableLookupStorage storage) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        if (PermissionsKt.isUnitTestMode() && !CompletionTrackerInitializer.Companion.isEnabledInTests()) {
            return;
        }
        WebServiceStatus experimentHelper = WebServiceStatus.Companion.getInstance();
        if (this.sessionShouldBeLogged(experimentHelper, storage.getLanguage())) {
            CompletionActionsListener tracker = this.actionsTracker(lookup, storage, experimentHelper);
            this.actionListener.setListener(tracker);
            lookup.addLookupListener((LookupListener)tracker);
            lookup.setPrefixChangeListener((PrefixChangeListener)tracker);
            storage.markLoggingEnabled();
        } else {
            this.actionListener.setListener(new CompletionPopupListener.Adapter());
        }
    }

    private final CompletionActionsListener actionsTracker(LookupImpl lookup, MutableLookupStorage storage, WebServiceStatus experimentHelper) {
        CompletionLogger logger = CompletionLoggerProvider.Companion.getInstance().newCompletionLogger();
        CompletionActionsTracker actionsTracker = new CompletionActionsTracker(lookup, storage, logger, experimentHelper);
        return new LoggerPerformanceTracker(actionsTracker, storage.getPerformanceTracker());
    }

    private final boolean sessionShouldBeLogged(WebServiceStatus experimentHelper, Language language) {
        Application application;
        if (CompletionStatsPolicy.Companion.isStatsLogDisabled(language) || !PluginInfoDetectorKt.getPluginInfo(language.getClass()).isSafeToReport()) {
            return false;
        }
        Application application2 = application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"application");
        if (application2.isUnitTestMode() || experimentHelper.isExperimentOnCurrentIDE()) {
            return true;
        }
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        if (!completionMLRankingSettings.isCompletionLogsSendAllowed()) {
            return false;
        }
        String string = language.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"language.displayName");
        String string2 = string;
        Map<String, Double> map = LOGGED_SESSIONS_RATIO;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String string5 = string4;
        double logSessionChance = ((Number)map.getOrDefault(string5, 1.0)).doubleValue();
        return Random.Default.nextDouble() < logSessionChance;
    }

    public CompletionLoggerInitializer(@NotNull LookupActionsListener actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
        this.actionListener = actionListener;
    }

    static {
        Companion = new Companion(null);
        LOGGED_SESSIONS_RATIO = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"python", (Object)0.5), TuplesKt.to((Object)"scala", (Object)0.3), TuplesKt.to((Object)"php", (Object)0.2), TuplesKt.to((Object)"kotlin", (Object)0.2), TuplesKt.to((Object)"java", (Object)0.1), TuplesKt.to((Object)"ecmascript 6", (Object)0.2), TuplesKt.to((Object)"typescript", (Object)0.5), TuplesKt.to((Object)"c/c++", (Object)0.5), TuplesKt.to((Object)"c#", (Object)0.1)});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/stats/completion/CompletionLoggerInitializer$Companion;", "", "()V", "LOGGED_SESSIONS_RATIO", "", "", "", "shouldInitialize", "", "intellij.statsCollector"})
    public static final class Companion {
        public final boolean shouldInitialize() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            return application.isEAP() && StatisticsUploadAssistant.isSendAllowed() || PermissionsKt.isUnitTestMode();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

