/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.experiment;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LinkedTreeMap;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.stats.experiment.EmulatedExperiment;
import com.intellij.stats.experiment.ExperimentInfo;
import com.intellij.stats.experiment.WebServiceStatus;
import com.intellij.stats.experiment.WebServiceStatusProvider;
import com.intellij.stats.network.UtilsKt;
import com.intellij.stats.network.service.RequestService;
import com.intellij.stats.network.service.ResponseData;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u0015\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/stats/experiment/WebServiceStatusProvider;", "Lcom/intellij/stats/experiment/WebServiceStatus;", "()V", "dataServerUrl", "", "info", "Lcom/intellij/stats/experiment/ExperimentInfo;", "serverStatus", "experimentVersion", "", "getRequestService", "Lcom/intellij/stats/network/service/RequestService;", "isExperimentOnCurrentIDE", "", "isServerOk", "loadInfo", "loadInfoIfActual", "logCompletionExperimentStatus", "", "performExperiment", "prevInfo", "parseServerResponse", "Lcom/google/gson/internal/LinkedTreeMap;", "responseText", "saveInfo", "updateStatus", "Companion", "intellij.statsCollector"})
public class WebServiceStatusProvider
implements WebServiceStatus {
    private volatile ExperimentInfo info = this.loadInfoIfActual();
    private volatile String serverStatus = "";
    private volatile String dataServerUrl = "";
    @NotNull
    public static final String STATUS_URL = "https://www.jetbrains.com/config/features-service-status.json";
    private static final Lazy GSON$delegate;
    private static final Logger LOG;
    private static final String SALT = "completion.stats.experiment.salt";
    private static final String EXPERIMENT_VERSION_KEY = "completion.stats.experiment.version";
    private static final String PERFORM_EXPERIMENT_KEY = "completion.ml.perform.experiment";
    private static final String STATUS_UPDATED_TIMESTAMP_KEY = "completion.stats.status.updated.ts";
    private static final long INFO_TTL;
    private static final ExperimentInfo DEFAULT_INFO;
    private static final EmulatedExperiment EMULATED_EXPERIMENT;
    public static final Companion Companion;

    @Override
    public int experimentVersion() {
        return this.info.getExperimentVersion();
    }

    @Override
    @NotNull
    public String dataServerUrl() {
        return this.dataServerUrl;
    }

    @Override
    public boolean isServerOk() {
        return StringsKt.equals((String)this.serverStatus, (String)"ok", (boolean)true);
    }

    @Override
    public boolean isExperimentOnCurrentIDE() {
        int version = this.experimentVersion();
        return version == 7 || version == 8;
    }

    @Override
    public void updateStatus() {
        this.serverStatus = "";
        this.dataServerUrl = "";
        UtilsKt.assertNotEDT();
        ResponseData response = this.getRequestService().get(STATUS_URL);
        if (response != null && response.isOK()) {
            Object performExperiment;
            LinkedTreeMap<?, ?> linkedTreeMap = this.parseServerResponse(response.getText());
            if (linkedTreeMap == null) {
                return;
            }
            LinkedTreeMap<?, ?> map = linkedTreeMap;
            Map map2 = (Map)map;
            Object object = "salt";
            boolean bl = false;
            Object v = map2.get(object);
            String salt = v != null ? v.toString() : null;
            object = (Map)map;
            Object object2 = "experimentVersion";
            boolean bl2 = false;
            Object v2 = object.get(object2);
            String experimentVersion = v2 != null ? v2.toString() : null;
            object2 = (Map)map;
            String string = "performExperiment";
            boolean bl3 = false;
            Object v3 = object2.get(string);
            if (v3 == null || (v3 = v3.toString()) == null) {
                v3 = performExperiment = "false";
            }
            if (salt != null && experimentVersion != null) {
                string = experimentVersion;
                bl3 = false;
                int intVersion = (int)Float.parseFloat(string);
                Object v4 = performExperiment;
                boolean bl4 = false;
                boolean perform = Boolean.parseBoolean(v4);
                Integer emulatedVersion = EMULATED_EXPERIMENT.emulate(intVersion, perform, salt);
                ExperimentInfo prevInfo = this.info;
                this.info = emulatedVersion != null ? new ExperimentInfo(emulatedVersion, salt, true) : new ExperimentInfo(intVersion, salt, perform);
                this.logCompletionExperimentStatus(this.info.getExperimentVersion(), this.info.getPerformExperiment(), prevInfo);
                this.saveInfo(this.info);
            }
            Map map3 = (Map)map;
            String string2 = "status";
            WebServiceStatusProvider webServiceStatusProvider = this;
            bl3 = false;
            Object v5 = map3.get(string2);
            Object v6 = v5;
            if (v6 == null || (v6 = v6.toString()) == null) {
                v6 = "";
            }
            webServiceStatusProvider.serverStatus = v6;
            map3 = (Map)map;
            string2 = "urlForZipBase64Content";
            webServiceStatusProvider = this;
            bl3 = false;
            v5 = map3.get(string2);
            Object v7 = v5;
            if (v7 == null || (v7 = v7.toString()) == null) {
                v7 = "";
            }
            webServiceStatusProvider.dataServerUrl = v7;
        }
    }

    @NotNull
    protected RequestService getRequestService() {
        Object object = ApplicationManager.getApplication().getService(RequestService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026questService::class.java)");
        return (RequestService)object;
    }

    private final LinkedTreeMap<?, ?> parseServerResponse(String responseText) {
        try {
            return (LinkedTreeMap)WebServiceStatusProvider.Companion.getGSON().fromJson(responseText, LinkedTreeMap.class);
        }
        catch (JsonSyntaxException e) {
            LOG.warn("Could not parse server response");
            return null;
        }
    }

    private final ExperimentInfo loadInfoIfActual() {
        long updatedTimestamp = PropertiesComponent.getInstance().getLong(STATUS_UPDATED_TIMESTAMP_KEY, 0L);
        if (updatedTimestamp != 0L && System.currentTimeMillis() - updatedTimestamp < INFO_TTL) {
            ExperimentInfo experimentInfo = this.loadInfo();
            if (experimentInfo == null) {
                experimentInfo = DEFAULT_INFO;
            }
            return experimentInfo;
        }
        return DEFAULT_INFO;
    }

    private final ExperimentInfo loadInfo() {
        Boolean performExperiment;
        PropertiesComponent properties = PropertiesComponent.getInstance();
        String salt = properties.getValue(SALT);
        int experimentVersion = properties.getInt(EXPERIMENT_VERSION_KEY, -1);
        Boolean bl = performExperiment = properties.isValueSet(PERFORM_EXPERIMENT_KEY) ? Boolean.valueOf(properties.isTrueValue(PERFORM_EXPERIMENT_KEY)) : null;
        if (salt != null && experimentVersion != -1 && performExperiment != null) {
            this.logCompletionExperimentStatus(experimentVersion, performExperiment, null);
            return new ExperimentInfo(experimentVersion, salt, performExperiment);
        }
        return null;
    }

    private final void logCompletionExperimentStatus(int experimentVersion, boolean performExperiment, ExperimentInfo prevInfo) {
        if (prevInfo == null || prevInfo.getExperimentVersion() != experimentVersion || prevInfo.getPerformExperiment() != performExperiment) {
            LOG.info("Completion stats experiment: version=" + experimentVersion + ", enabled=" + performExperiment);
        }
    }

    private final void saveInfo(ExperimentInfo info) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        PropertiesComponent $this$with = propertiesComponent;
        boolean bl3 = false;
        $this$with.setValue(SALT, info.getSalt());
        $this$with.setValue(EXPERIMENT_VERSION_KEY, String.valueOf(info.getExperimentVersion()));
        $this$with.setValue(PERFORM_EXPERIMENT_KEY, info.getPerformExperiment());
        $this$with.setValue(STATUS_UPDATED_TIMESTAMP_KEY, String.valueOf(System.currentTimeMillis()));
    }

    static {
        Companion = new Companion(null);
        GSON$delegate = LazyKt.lazy((Function0)Companion.GSON.2.INSTANCE);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WebServiceStatusProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        INFO_TTL = TimeUnit.DAYS.toMillis(7L);
        DEFAULT_INFO = new ExperimentInfo(0, "", false);
        EMULATED_EXPERIMENT = new EmulatedExperiment();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/stats/experiment/WebServiceStatusProvider$Companion;", "", "()V", "DEFAULT_INFO", "Lcom/intellij/stats/experiment/ExperimentInfo;", "EMULATED_EXPERIMENT", "Lcom/intellij/stats/experiment/EmulatedExperiment;", "EXPERIMENT_VERSION_KEY", "", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "GSON$delegate", "Lkotlin/Lazy;", "INFO_TTL", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PERFORM_EXPERIMENT_KEY", "SALT", "STATUS_UPDATED_TIMESTAMP_KEY", "STATUS_URL", "intellij.statsCollector"})
    public static final class Companion {
        private final Gson getGSON() {
            Lazy lazy = GSON$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Gson)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

