/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserLauncherImpl;
import com.intellij.ide.browsers.BrowserSettings;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xml.XmlBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0014J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J@\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherImpl;", "Lcom/intellij/ide/browsers/BrowserLauncherAppless;", "()V", "getEffectiveBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "browser", "openWithExplicitBrowser", "", "url", "", "browserPath", "project", "Lcom/intellij/openapi/project/Project;", "showError", "error", "title", "fix", "Lkotlin/Function0;", "signUrl", "intellij.xml.impl"})
public final class BrowserLauncherImpl
extends BrowserLauncherAppless {
    @Nullable
    protected WebBrowser getEffectiveBrowser(@Nullable WebBrowser browser2) {
        WebBrowserManager browserManager;
        WebBrowser effectiveBrowser = browser2;
        if (browser2 == null && (browserManager = WebBrowserManager.getInstance()).getDefaultBrowserPolicy() == DefaultBrowserPolicy.FIRST) {
            WebBrowserManager webBrowserManager = browserManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)webBrowserManager), (String)"browserManager");
            effectiveBrowser = webBrowserManager.getFirstActiveBrowser();
        }
        return effectiveBrowser;
    }

    @NotNull
    protected String signUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String url2 = url;
        BuiltInServerManager serverManager = BuiltInServerManager.Companion.getInstance();
        Url parsedUrl = Urls.parse((String)url2, (boolean)false);
        if (parsedUrl != null && serverManager.isOnBuiltInWebServer(parsedUrl)) {
            if (Registry.is((String)"ide.built.in.web.server.activatable", (boolean)false)) {
                PropertiesComponent.getInstance().setValue("ide.built.in.web.server.active", true);
            }
            String string = serverManager.addAuthToken(parsedUrl).toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"serverManager.addAuthTok\u2026rsedUrl).toExternalForm()");
            url2 = string;
        }
        return url2;
    }

    protected void openWithExplicitBrowser(@NotNull String url, @Nullable String browserPath, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        if (browserManager.getDefaultBrowserPolicy() == DefaultBrowserPolicy.FIRST) {
            WebBrowserManager webBrowserManager = browserManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)webBrowserManager), (String)"browserManager");
            WebBrowser webBrowser = webBrowserManager.getFirstActiveBrowser();
            if (webBrowser != null) {
                WebBrowser webBrowser2 = webBrowser;
                boolean bl = false;
                boolean bl2 = false;
                WebBrowser it = webBrowser2;
                boolean bl3 = false;
                this.browse(url, it, project);
                return;
            }
        } else if (SystemInfo.isMac && Intrinsics.areEqual((Object)"open", (Object)browserPath)) {
            WebBrowserManager webBrowserManager = browserManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)webBrowserManager), (String)"browserManager");
            WebBrowser webBrowser = webBrowserManager.getFirstActiveBrowser();
            if (webBrowser != null) {
                WebBrowser webBrowser3 = webBrowser;
                boolean bl = false;
                boolean bl4 = false;
                WebBrowser it = webBrowser3;
                boolean bl5 = false;
                BrowserLauncher.browseUsingPath$default((BrowserLauncher)this, (String)url, null, (WebBrowser)it, (Project)project, (boolean)false, null, (int)48, null);
                return;
            }
        }
        super.openWithExplicitBrowser(url, browserPath, project);
    }

    protected void showError(@Nullable String error, @Nullable WebBrowser browser2, @Nullable Project project, @Nullable String title, @Nullable Function0<Unit> fix) {
        Project project2 = project;
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(project2 != null ? (Disposable)project2 : (Disposable)showError.1.INSTANCE)).submit(new Runnable(title, error, project, browser2, fix){
            final /* synthetic */ String $title;
            final /* synthetic */ String $error;
            final /* synthetic */ Project $project;
            final /* synthetic */ WebBrowser $browser;
            final /* synthetic */ Function0 $fix;

            public final void run() {
                block6: {
                    Runnable runnable;
                    String string;
                    String string2 = this.$title;
                    if (string2 == null) {
                        String string3 = XmlBundle.message((String)"browser.error", (Object[])new Object[0]);
                        string2 = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"XmlBundle.message(\"browser.error\")");
                    }
                    if ((string = this.$error) == null) {
                        String string4 = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
                        string = string4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"IdeBundle.message(\"unknown.error\")");
                    }
                    String string5 = IdeBundle.message((String)"button.fix", (Object[])new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"IdeBundle.message(\"button.fix\")");
                    String string6 = Messages.getOkButton();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"Messages.getOkButton()");
                    if (!MessageUtil.showOkNoDialog$default((String)string2, (String)string, (Project)this.$project, (String)string5, (String)string6, null, (int)32, null)) break block6;
                    BrowserSettings browserSettings = new BrowserSettings();
                    ShowSettingsUtil showSettingsUtil = ShowSettingsUtil.getInstance();
                    Project project = this.$project;
                    Configurable configurable = (Configurable)browserSettings;
                    WebBrowser webBrowser = this.$browser;
                    if (webBrowser != null) {
                        WebBrowser webBrowser2 = webBrowser;
                        Configurable configurable2 = configurable;
                        Project project2 = project;
                        ShowSettingsUtil showSettingsUtil2 = showSettingsUtil;
                        boolean bl = false;
                        boolean bl2 = false;
                        WebBrowser it = webBrowser2;
                        boolean bl3 = false;
                        Runnable runnable2 = new Runnable(it, browserSettings){
                            final /* synthetic */ WebBrowser $it;
                            final /* synthetic */ BrowserSettings $browserSettings$inlined;
                            {
                                this.$it = webBrowser;
                                this.$browserSettings$inlined = browserSettings;
                            }

                            public final void run() {
                                this.$browserSettings$inlined.selectBrowser(this.$it);
                            }
                        };
                        showSettingsUtil = showSettingsUtil2;
                        project = project2;
                        configurable = configurable2;
                        runnable = runnable2;
                    } else {
                        runnable = null;
                    }
                    if (showSettingsUtil.editConfigurable(project, configurable, runnable)) {
                        Function0 function0 = this.$fix;
                        if (function0 != null) {
                            Unit cfr_ignored_0 = (Unit)function0.invoke();
                        }
                    }
                }
            }
            {
                this.$title = string;
                this.$error = string2;
                this.$project = project;
                this.$browser = webBrowser;
                this.$fix = function0;
            }
        });
    }
}

