/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class GitOptionsTopHitProvider
implements OptionsSearchTopHitProvider.ProjectLevelProvider {
    GitOptionsTopHitProvider() {
    }

    @NotNull
    public String getId() {
        return "vcs";
    }

    @NotNull
    public Collection<OptionDescription> getOptions(@NotNull Project project) {
        if (project == null) {
            GitOptionsTopHitProvider.$$$reportNull$$$0(0);
        }
        for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)project).getAllVcss()) {
            if (!"Git".equals(descriptor.getDisplayName())) continue;
            final GitVcsSettings settings = GitVcsSettings.getInstance(project);
            ArrayList<BooleanOptionDescription> options = new ArrayList<BooleanOptionDescription>();
            options.add(GitOptionsTopHitProvider.applicationOption("Git: Commit automatically on cherry-pick", "isAutoCommitOnCherryPick", "setAutoCommitOnCherryPick"));
            options.add(GitOptionsTopHitProvider.option(project, "Git: Auto-update if push of the current branch was rejected", "autoUpdateIfPushRejected", "setAutoUpdateIfPushRejected"));
            GitRepositoryManager manager = GitRepositoryManager.getInstance(project);
            if (manager.moreThanOneRoot()) {
                options.add(new BooleanOptionDescription("Git: Control repositories synchronously", "vcs.Git"){

                    public boolean isOptionEnabled() {
                        return settings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
                    }

                    public void setOptionState(boolean enabled) {
                        settings.setSyncSetting(enabled ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
                    }
                });
            }
            options.add(GitOptionsTopHitProvider.option(project, "Git: Warn if CRLF line separators are about to be committed", "warnAboutCrlf", "setWarnAboutCrlf"));
            options.add(GitOptionsTopHitProvider.option(project, "Git: Warn when committing in detached HEAD or during rebase", "warnAboutDetachedHead", "setWarnAboutDetachedHead"));
            Collection<OptionDescription> collection = Collections.unmodifiableCollection(options);
            if (collection == null) {
                GitOptionsTopHitProvider.$$$reportNull$$$0(1);
            }
            return collection;
        }
        List<OptionDescription> list = Collections.emptyList();
        if (list == null) {
            GitOptionsTopHitProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static BooleanOptionDescription option(final Project project, String option, String getter, String setter) {
        return new PublicMethodBasedOptionDescription(option, "vcs.Git", getter, setter){

            public Object getInstance() {
                return GitVcsSettings.getInstance(project);
            }
        };
    }

    private static BooleanOptionDescription applicationOption(String option, String getter, String setter) {
        return new PublicMethodBasedOptionDescription(option, "vcs.Git", getter, setter){

            public Object getInstance() {
                return GitVcsApplicationSettings.getInstance();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitOptionsTopHitProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitOptionsTopHitProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

