/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import git4idea.repo.GitConflict;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lgit4idea/conflicts/ConflictChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lgit4idea/repo/GitConflict;", "conflict", "(Lgit4idea/repo/GitConflict;)V", "compareUserObjects", "", "o2", "getTextPresentation", "", "isDirectory", "", "isFile", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "expanded", "hasFocus", "toString", "intellij.vcs.git"})
final class ConflictChangesBrowserNode
extends ChangesBrowserNode<GitConflict> {
    protected boolean isFile() {
        return true;
    }

    protected boolean isDirectory() {
        return false;
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        String string;
        GitConflict conflict;
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        GitConflict gitConflict = conflict = (GitConflict)this.getUserObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)gitConflict, (String)"conflict");
        FilePath filePath = gitConflict.getFilePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"conflict.filePath");
        FilePath filePath2 = filePath;
        VirtualFile virtualFile = filePath2.getVirtualFile();
        String string2 = filePath2.getName();
        FileStatus fileStatus = FileStatus.MERGED_WITH_CONFLICTS;
        Intrinsics.checkExpressionValueIsNotNull((Object)fileStatus, (String)"FileStatus.MERGED_WITH_CONFLICTS");
        renderer.appendFileName(virtualFile, string2, fileStatus.getColor());
        if (renderer.isShowFlatten()) {
            this.appendParentPath(renderer, filePath2.getParentPath());
        }
        if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount((ColoredTreeCellRenderer)renderer);
        }
        GitConflict.Status status = conflict.getStatus(GitConflict.ConflictSide.OURS, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)status), (String)"conflict.getStatus(ConflictSide.OURS, true)");
        GitConflict.Status oursStatus = status;
        GitConflict.Status status2 = conflict.getStatus(GitConflict.ConflictSide.THEIRS, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)status2), (String)"conflict.getStatus(ConflictSide.THEIRS, true)");
        GitConflict.Status theirsStatus = status2;
        if (oursStatus == GitConflict.Status.DELETED && theirsStatus == GitConflict.Status.DELETED) {
            string = "both deleted";
        } else if (oursStatus == GitConflict.Status.ADDED && theirsStatus == GitConflict.Status.ADDED) {
            string = "both added";
        } else if (oursStatus == GitConflict.Status.MODIFIED && theirsStatus == GitConflict.Status.MODIFIED) {
            string = "both modified";
        } else if (oursStatus == GitConflict.Status.DELETED) {
            string = "deleted by you";
        } else if (theirsStatus == GitConflict.Status.DELETED) {
            string = "deleted by them";
        } else if (oursStatus == GitConflict.Status.ADDED) {
            string = "added by you";
        } else if (theirsStatus == GitConflict.Status.ADDED) {
            string = "added by them";
        } else {
            throw (Throwable)new IllegalStateException("ours: " + (Object)((Object)oursStatus) + "; theirs: " + (Object)((Object)theirsStatus));
        }
        String conflictType = string;
        renderer.append(FontUtil.spaceAndThinSpace() + conflictType, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        renderer.setIcon(filePath2, filePath2.isDirectory() || !this.isLeaf());
    }

    @NotNull
    public String getTextPresentation() {
        Object object = this.getUserObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getUserObject()");
        FilePath filePath = ((GitConflict)object).getFilePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"getUserObject().filePath");
        String string = filePath.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getUserObject().filePath.name");
        return string;
    }

    @NotNull
    public String toString() {
        Object object = this.getUserObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getUserObject()");
        FilePath filePath = ((GitConflict)object).getFilePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"getUserObject().filePath");
        String string = FileUtil.toSystemDependentName((String)filePath.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemDepende\u2026erObject().filePath.path)");
        return string;
    }

    public int compareUserObjects(@NotNull GitConflict o2) {
        Intrinsics.checkParameterIsNotNull((Object)o2, (String)"o2");
        Object object = this.getUserObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getUserObject()");
        return ChangesBrowserNode.compareFilePaths((FilePath)((GitConflict)object).getFilePath(), (FilePath)o2.getFilePath());
    }

    public ConflictChangesBrowserNode(@NotNull GitConflict conflict) {
        Intrinsics.checkParameterIsNotNull((Object)conflict, (String)"conflict");
        super((Object)conflict);
    }
}

