/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.facet.AppEngineFacetType;
import com.jetbrains.appengine.run.AppEngineServerRunConfigurationType;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PyRunConfigurationFactoryEx;
import com.jetbrains.python.templateLanguages.TemplatesService;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class AppEngineFacetConfigurator
implements DirectoryProjectConfigurator {
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean newProject) {
        Module module;
        Module[] modules;
        if (project == null) {
            AppEngineFacetConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            AppEngineFacetConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            AppEngineFacetConfigurator.$$$reportNull$$$0(2);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length > 0 && AppEngineFacet.getInstance((Module)(module = modules[0])) == null) {
            AppEngineFacetConfigurator.detectAppEngineFacet(module, baseDir);
        }
    }

    private static void detectAppEngineFacet(Module module, VirtualFile baseDir) {
        baseDir.refresh(false, true);
        if (baseDir.findChild("app.yaml") != null) {
            TemplatesService service;
            AppEngineFacetConfiguration configuration = AppEngineFacetConfiguration.fromProjectDirectory((VirtualFile)baseDir);
            if (StringUtil.isEmptyOrSpaces((String)configuration.getSdkFolder())) {
                Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Project Configuration", (String)AppEngineBundle.message((String)"python.app.engine.notification.group.project.configuration", (Object[])new Object[0])), AppEngineBundle.message((String)"python.app.engine.sdk.not.configured", (Object[])new Object[0]), AppEngineBundle.message((String)"python.app.engine.configure.sdk.path", (Object[])new Object[0]), NotificationType.WARNING, (NotificationListener)new MyNotificationListener(module.getProject())), (Project)module.getProject());
            }
            AppEngineFacetType.createAppEngineFacet((Module)module, (AppEngineFacetConfiguration)configuration);
            StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                if (configuration.getSdkFolder() != null) {
                    AppEngineUtil.initAppEngineModuleLibrary((Module)module, null, (String)configuration.getSdkFolder(), (String)configuration.getProjectRoot());
                }
            }));
            ((PyRunConfigurationFactoryEx)PyRunConfigurationFactory.getInstance()).createRunConfiguration(module, (ConfigurationFactory)AppEngineServerRunConfigurationType.getInstance().getConfigurationFactory());
            VirtualFile templatesFolder = baseDir.findChild("templates");
            if (templatesFolder != null && (service = TemplatesService.getInstance((Module)module)).getTemplateFolders().size() == 0) {
                service.setTemplateFolders(new VirtualFile[]{templatesFolder});
                service.setTemplateLanguage("Django");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleRef";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/appengine/AppEngineFacetConfigurator";
        objectArray[2] = "configureProject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyNotificationListener
    implements NotificationListener {
        public Project myProject;

        MyNotificationListener(Project project) {
            this.myProject = project;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyNotificationListener.$$$reportNull$$$0(1);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, AppEngineBundle.message((String)"configurable.AppEngineFacet.display.name", (Object[])new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/appengine/AppEngineFacetConfigurator$MyNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

