/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.model.DjangoProjectCreatorAndConfigurator;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.run.DjangoServerRunConfigurationType;
import com.jetbrains.django.templateFSLoader.DjangoTemplateFSLoaderPre8;
import com.jetbrains.django.testRunner.DjangoTestsConfigurationProducer;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.buildout.config.psi.BuildoutPsiUtil;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgFile;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgSection;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.blockEvaluator.PyBlockEvaluator;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PyRunConfigurationFactoryEx;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoFacetConfigurator
implements DirectoryProjectConfigurator {
    private static final String DJANGO_LIBRARY_NAME = "Django Lib";

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean newProject) {
        Module module;
        if (project == null) {
            DjangoFacetConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            DjangoFacetConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            DjangoFacetConfigurator.$$$reportNull$$$0(2);
        }
        Module moduleToConfigureDjangoFacet = null;
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length > 0) {
            module = modules[0];
            if (DjangoFacet.getInstance((Module)module) == null) {
                moduleToConfigureDjangoFacet = module;
            }
            DjangoFacetConfigurator.detectDjango(module, baseDir);
        }
        if (moduleToConfigureDjangoFacet != null) {
            module = moduleToConfigureDjangoFacet;
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> DjangoFacetConfigurator.detectDjangoFacet(module, baseDir));
        }
    }

    private static void detectDjango(Module module, @NotNull VirtualFile baseDir) {
        VirtualFile djangoRootPackage;
        if (baseDir == null) {
            DjangoFacetConfigurator.$$$reportNull$$$0(3);
        }
        if ((djangoRootPackage = DjangoUtil.findDjango((VirtualFile)baseDir)) != null && !baseDir.equals(djangoRootPackage.getParent())) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                LibraryOrderEntry entry = DjangoFacetConfigurator.findDjangoOrderEntry((ModuleRootModel)ModuleRootManager.getInstance((Module)module));
                if (entry != null) {
                    Library lib = entry.getLibrary();
                    if (lib != null) {
                        DjangoFacetConfigurator.fillLib(djangoRootPackage, lib);
                    }
                } else {
                    Library lib = LibraryTablesRegistrar.getInstance().getLibraryTable(module.getProject()).createLibrary(DJANGO_LIBRARY_NAME);
                    DjangoFacetConfigurator.fillLib(djangoRootPackage, lib);
                    ModuleRootModificationUtil.addDependency((Module)module, (Library)lib);
                }
            });
        }
    }

    private static void fillLib(@NotNull VirtualFile djangoRootPackage, @NotNull Library lib) {
        if (djangoRootPackage == null) {
            DjangoFacetConfigurator.$$$reportNull$$$0(4);
        }
        if (lib == null) {
            DjangoFacetConfigurator.$$$reportNull$$$0(5);
        }
        Library.ModifiableModel libModel = lib.getModifiableModel();
        String djangoUrl = djangoRootPackage.getParent().getUrl();
        boolean flag = false;
        for (String url : libModel.getUrls(OrderRootType.CLASSES)) {
            if (!djangoUrl.equals(url)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            libModel.addRoot(djangoUrl, OrderRootType.CLASSES);
            libModel.commit();
        }
    }

    @Nullable
    private static LibraryOrderEntry findDjangoOrderEntry(ModuleRootModel model) {
        return OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)model, (String)DJANGO_LIBRARY_NAME);
    }

    private static void detectDjangoFacet(@NotNull Module module, @NotNull VirtualFile baseDir) {
        VirtualFile managePy;
        BuildoutCfgSection section;
        BuildoutCfgFile configFile;
        if (module == null) {
            DjangoFacetConfigurator.$$$reportNull$$$0(6);
        }
        if (baseDir == null) {
            DjangoFacetConfigurator.$$$reportNull$$$0(7);
        }
        if (DjangoFacet.isPresent((Module)module)) {
            return;
        }
        baseDir.refresh(false, true);
        BuildoutFacet buildoutFacet = BuildoutFacet.getInstance((Module)module);
        if (buildoutFacet != null && (configFile = buildoutFacet.getConfigPsiFile()) != null && (section = BuildoutPsiUtil.getDjangoSection((BuildoutCfgFile)configFile)) != null) {
            DjangoFacetConfigurator.configureDjangoFromBuildout(module, buildoutFacet, section);
            return;
        }
        VirtualFile appFolder = DjangoFacetConfigurator.findDjangoApp(baseDir);
        if (appFolder != null) {
            DjangoProjectCreatorAndConfigurator.configureDjangoFacet((Module)module, (VirtualFile)baseDir);
            ((PyRunConfigurationFactoryEx)PyRunConfigurationFactory.getInstance()).createRunConfiguration(module, (ConfigurationFactory)DjangoServerRunConfigurationType.getInstance().getDjangoFactory());
        }
        if ((managePy = DjangoFacetConfigurator.findManagePy(baseDir)) != null) {
            DjangoProjectCreatorAndConfigurator.configureDjangoFacet((Module)module, (VirtualFile)baseDir);
        }
    }

    private static void setTemplatesFolder(Module module, VirtualFile appFolder, @Nullable VirtualFile settings) {
        TemplatesService service = TemplatesService.getInstance((Module)module);
        PyFile settingsPyFile = DjangoFacetConfigurator.getSettingsPyFile(module, settings);
        ArrayList<VirtualFile> templateFolders = new ArrayList<VirtualFile>();
        if (settingsPyFile != null) {
            PyBlockEvaluator evaluator = new PyBlockEvaluator();
            evaluator.evaluate((PyElement)settingsPyFile);
            List list = DjangoTemplateFSLoaderPre8.getFolders((PyFile)settingsPyFile);
            for (String s : list) {
                VirtualFile vf = DjangoTemplateManager.getInstance((Module)module).resolveVirtualFile(s, (PsiElement)DjangoSettingsPy.findSettingsFile((Module)module));
                if (vf == null) continue;
                templateFolders.add(vf);
            }
        } else {
            VirtualFile templates = appFolder.findChild("templates");
            if (templates != null) {
                templateFolders.add(templates);
            }
        }
        if (!templateFolders.isEmpty()) {
            service.setTemplateFolders(templateFolders.toArray(VirtualFile.EMPTY_ARRAY));
        }
        service.setTemplateLanguage("Django");
    }

    @Nullable
    public static PyFile getSettingsPyFile(Module module, @Nullable VirtualFile settingsFile) {
        if (settingsFile != null && settingsFile.exists()) {
            try {
                String text = VfsUtilCore.loadText((VirtualFile)settingsFile);
                PsiFile settingsPyFile = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText("settings.py", (Language)PythonLanguage.getInstance(), (CharSequence)text);
                if (settingsPyFile instanceof PyFile) {
                    return (PyFile)settingsPyFile;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void configureDjangoFromBuildout(Module module, BuildoutFacet buildoutFacet, BuildoutCfgSection section) {
        File scriptFile;
        String testApp;
        String settingsFileName;
        VirtualFile projectRoot;
        DjangoFacetConfiguration configuration = DjangoFacetType.createDefaultConfiguration((Project)module.getProject());
        String projectName = section.getOptionValue("project");
        if (projectName != null && (projectRoot = PyUtil.findInRoots((Module)module, (String)projectName)) != null) {
            configuration.setProjectRootPath(projectRoot.getPath());
            DjangoFacetConfigurator.setTemplatesFolder(module, projectRoot, null);
        }
        if ((settingsFileName = section.getOptionValue("settings")) != null) {
            configuration.setSettingsFilePath(DjangoPythonUtil.toFilePath((String)settingsFileName));
        }
        DjangoFacetType.createDjangoFacet((Module)module, (DjangoFacetConfiguration)configuration);
        if (projectName != null) {
            ((PyRunConfigurationFactoryEx)PyRunConfigurationFactory.getInstance()).createRunConfiguration(module, (ConfigurationFactory)DjangoServerRunConfigurationType.getInstance().getDjangoFactory());
        }
        if ((testApp = section.getOptionValue("test")) != null) {
            RunnerAndConfigurationSettings testConfiguration = DjangoTestsConfigurationProducer.createConfiguration((Module)module, (String)testApp, (Project)module.getProject());
            RunManager.getInstance((Project)module.getProject()).addConfiguration(testConfiguration);
        }
        if ((scriptFile = BuildoutFacet.findScript((BuildoutFacet)buildoutFacet, (String)section.getHeaderName(), (VirtualFile)module.getProject().getBaseDir())) != null) {
            ((BuildoutFacetConfiguration)buildoutFacet.getConfiguration()).setScriptName(scriptFile.getPath());
            buildoutFacet.updatePaths();
            BuildoutFacet.attachLibrary((Module)module);
        }
    }

    @Nullable
    private static VirtualFile findDjangoApp(VirtualFile baseDir) {
        if (DjangoFacetConfigurator.containsDjangoApp(baseDir)) {
            return baseDir;
        }
        for (VirtualFile file : baseDir.getChildren()) {
            if (!file.isDirectory() || !DjangoFacetConfigurator.containsDjangoApp(file)) continue;
            return file;
        }
        return null;
    }

    private static boolean containsDjangoApp(VirtualFile file) {
        return file.findChild("urls.py") != null && file.findChild("settings.py") != null;
    }

    @Nullable
    public static VirtualFile findManagePy(VirtualFile file) {
        return file.findChild("manage.py");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoRootPackage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/DjangoFacetConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detectDjango";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fillLib";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "detectDjangoFacet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

