/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rest.RestElementTypes;
import com.jetbrains.rest.RestTokenTypes;
import org.jetbrains.annotations.NotNull;

public class RestParser
implements PsiParser {
    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            RestParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            RestParser.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker rootMarker = builder.mark();
        while (!builder.eof()) {
            PsiBuilder.Marker marker;
            IElementType type = builder.getTokenType();
            if (type == RestTokenTypes.EXPLISIT_MARKUP_START) {
                RestParser.parseMarkup(builder);
                continue;
            }
            if (type == RestTokenTypes.REFERENCE_NAME || type == RestTokenTypes.SUBSTITUTION) {
                marker = builder.mark();
                builder.advanceLexer();
                marker.done((IElementType)RestTokenTypes.REFERENCE_NAME);
                continue;
            }
            if (type == RestTokenTypes.TITLE) {
                marker = builder.mark();
                builder.advanceLexer();
                marker.done((IElementType)RestTokenTypes.TITLE);
                continue;
            }
            if (type == RestTokenTypes.FIELD) {
                RestParser.parseFieldList(builder);
                continue;
            }
            if (type == RestTokenTypes.INLINE_LINE) {
                marker = builder.mark();
                builder.advanceLexer();
                marker.done((IElementType)RestElementTypes.INLINE_BLOCK);
                continue;
            }
            if (type == RestTokenTypes.ANONYMOUS_HYPERLINK) {
                marker = builder.mark();
                builder.advanceLexer();
                marker.done((IElementType)RestElementTypes.REFERENCE_TARGET);
                continue;
            }
            if (type == RestTokenTypes.LINE) {
                RestParser.parseLineText(builder, type);
                continue;
            }
            builder.advanceLexer();
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            RestParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    private static boolean parseLineText(PsiBuilder builder, IElementType type) {
        IElementType nextType;
        PsiBuilder.Marker marker = builder.mark();
        boolean gotLine = false;
        while (!(type != RestTokenTypes.LINE && type != RestTokenTypes.WHITESPACE || (nextType = builder.lookAhead(1)) != RestTokenTypes.LINE && type == RestTokenTypes.WHITESPACE)) {
            builder.advanceLexer();
            type = builder.getTokenType();
            gotLine = true;
        }
        if (gotLine) {
            marker.done((IElementType)RestElementTypes.LINE_TEXT);
        } else {
            marker.drop();
        }
        return gotLine;
    }

    private static void parseFieldList(PsiBuilder builder) {
        PsiBuilder.Marker listMarker = builder.mark();
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.done((IElementType)RestTokenTypes.FIELD);
        if (RestParser.parseLineText(builder, builder.getTokenType())) {
            listMarker.done((IElementType)RestElementTypes.FIELD_LIST);
        } else {
            listMarker.drop();
        }
    }

    private static void parseMarkup(PsiBuilder builder) {
        builder.advanceLexer();
        PsiBuilder.Marker marker = builder.mark();
        IElementType type = builder.getTokenType();
        if (type == RestTokenTypes.SUBSTITUTION) {
            builder.advanceLexer();
            marker.done((IElementType)RestElementTypes.REFERENCE_TARGET);
            builder.advanceLexer();
            marker = builder.mark();
            type = builder.getTokenType();
        }
        if (type == RestTokenTypes.DIRECTIVE || type == RestTokenTypes.CUSTOM_DIRECTIVE) {
            RestParser.gotoNextWhiteSpaces(builder);
            if (builder.getTokenType() != RestTokenTypes.WHITESPACE) {
                builder.advanceLexer();
                marker.done((IElementType)RestElementTypes.DIRECTIVE_BLOCK);
                return;
            }
            RestParser.skipBlankLines(builder);
            String tokenText = builder.getTokenText();
            if (builder.getTokenType() != RestTokenTypes.LINE || tokenText != null && StringUtil.getLineBreakCount((CharSequence)tokenText) == tokenText.length()) {
                marker.done((IElementType)RestElementTypes.DIRECTIVE_BLOCK);
                return;
            }
            String white = builder.getTokenText();
            RestParser.parseDirective(builder, white, marker);
        } else if (type == RestTokenTypes.FOOTNOTE || type == RestTokenTypes.CITATION || type == RestTokenTypes.HYPERLINK || type == RestTokenTypes.ANONYMOUS_HYPERLINK) {
            builder.advanceLexer();
            marker.done((IElementType)RestElementTypes.REFERENCE_TARGET);
        } else {
            builder.advanceLexer();
            marker.drop();
        }
    }

    private static void gotoNextWhiteSpaces(PsiBuilder builder) {
        while (!StringUtil.isEmptyOrSpaces((String)builder.getTokenText()) && !builder.eof() && builder.getTokenType() != null) {
            builder.advanceLexer();
        }
    }

    private static void skipBlankLines(PsiBuilder builder) {
        while ("\n".equals(builder.getTokenText()) && !builder.eof() && builder.getTokenType() != null) {
            builder.advanceLexer();
        }
    }

    private static void parseDirective(PsiBuilder builder, String indent, PsiBuilder.Marker marker) {
        while (builder.getTokenType() == RestTokenTypes.FIELD) {
            RestParser.parseFieldList(builder);
        }
        RestParser.gotoNextWhiteSpaces(builder);
        RestParser.skipBlankLines(builder);
        if (indent.equals(builder.getTokenText())) {
            builder.advanceLexer();
            RestParser.parseDirective(builder, indent, marker);
        } else {
            marker.done((IElementType)RestElementTypes.DIRECTIVE_BLOCK);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rest/parsing/RestParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rest/parsing/RestParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

