/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.script.generator.NamingService;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u000f\b&\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bJ\u001a\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u001f\u001a\u00020\u0012J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "Lcom/intellij/database/script/generator/NamingService;", "dbms", "Lcom/intellij/database/Dbms;", "namePattern", "Ljava/util/regex/Pattern;", "(Lcom/intellij/database/Dbms;Ljava/util/regex/Pattern;)V", "plainNamePattern", "(Lcom/intellij/database/Dbms;Ljava/util/regex/Pattern;Ljava/util/regex/Pattern;)V", "reservedWords", "", "", "getReservedWords", "()Ljava/util/Set;", "aptPattern", "plain", "", "closeQuote", "", "closeQuotes", "enquote", "name", "op", "cl", "enquoteName", "openQuotes", "isPlain", "isQuoted", "identifier", "isValidPlain", "nameToScript", "openQuote", "unquoteIdentifier", "intellij.database.dialects.base"})
public abstract class AbstractNamingService
implements NamingService {
    private final Dbms dbms;
    private final Pattern namePattern;
    private final Pattern plainNamePattern;

    private final Set<String> getReservedWords() {
        Set set;
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN)) {
            set = SetsKt.emptySet();
        } else {
            Object object = SqlLanguageDialect.EP.forDbms(this.dbms);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Set set2 = ((SqlLanguageDialect)object).getReservedKeywords();
            set = set2;
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"SqlLanguageDialect.EP.fo\u2026(dbms)!!.reservedKeywords");
        }
        return set;
    }

    public final char openQuote() {
        return this.openQuotes().charAt(0);
    }

    public final char closeQuote() {
        return this.closeQuotes().charAt(0);
    }

    @NotNull
    public String openQuotes() {
        return "\"";
    }

    @NotNull
    public String closeQuotes() {
        return "\"";
    }

    @NotNull
    public final String nameToScript(@NotNull String name2, boolean plain) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return this.nameToScript(name2, plain, null);
    }

    @NotNull
    public final String nameToScript(@NotNull String name2, boolean plain, @Nullable String openQuotes) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return this.isValidPlain(name2, plain) ? name2 : this.enquoteName(name2, openQuotes);
    }

    public boolean isQuoted(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        if (identifier.length() < 2) {
            return false;
        }
        int opIdx = StringsKt.indexOf$default((CharSequence)this.openQuotes(), (char)StringsKt.first((CharSequence)identifier), (int)0, (boolean)false, (int)6, null);
        if (opIdx == -1) {
            return false;
        }
        return StringsKt.last((CharSequence)identifier) == this.closeQuotes().charAt(opIdx);
    }

    @NotNull
    public String unquoteIdentifier(@NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        if (!this.isQuoted(identifier)) {
            return identifier;
        }
        char quote = StringsKt.last((CharSequence)identifier);
        String string = identifier;
        int n = 1;
        int n2 = identifier.length() - 1;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return StringsKt.replace$default((String)string2, (String)("" + quote + quote), (String)String.valueOf(quote), (boolean)false, (int)4, null);
    }

    @NotNull
    public final String enquoteName(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return this.enquoteName(name2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String enquoteName(@NotNull String name2, @Nullable String openQuotes) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        String oq = this.openQuotes();
        String cq = this.closeQuotes();
        int any = -1;
        String string = openQuotes;
        if (string != null) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = string;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            void var11_12 = $this$mapTo$iv$iv;
            for (int j = 0; j < var11_12.length(); ++j) {
                void it;
                char item$iv$iv;
                char c = item$iv$iv = var11_12.charAt(j);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer n = StringsKt.indexOf$default((CharSequence)oq, (char)it, (int)0, (boolean)false, (int)6, null);
                collection.add(n);
            }
            iterable = (List)destination$iv$iv;
        } else {
            int $this$map$iv = 0;
            iterable = (Iterable)new IntRange($this$map$iv, StringsKt.getLastIndex((CharSequence)oq));
        }
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int i2 = ((Number)element$iv).intValue();
            boolean bl = false;
            if (i2 == -1) continue;
            if (any == -1) {
                any = i2;
            }
            if (StringsKt.contains$default((CharSequence)name2, (char)cq.charAt(i2), (boolean)false, (int)2, null)) continue;
            return this.enquote(name2, oq.charAt(i2), cq.charAt(i2));
        }
        if (any == -1) {
            any = 0;
        }
        return this.enquote(name2, oq.charAt(any), cq.charAt(any));
    }

    private final String enquote(String name2, char op, char cl) {
        char c = op;
        String string = StringsKt.replace$default((String)name2, (String)String.valueOf(cl), (String)("" + cl + cl), (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append(cl).toString();
    }

    public boolean isPlain(@NotNull String name2, boolean plain) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        CharSequence charSequence = name2;
        Pattern pattern = this.aptPattern(plain);
        boolean bl = false;
        pattern = new Regex(pattern);
        bl = false;
        return pattern.matches(charSequence);
    }

    private final boolean isValidPlain(String name2, boolean plain) {
        return this.isPlain(name2, plain) && !this.getReservedWords().contains(name2);
    }

    private final Pattern aptPattern(boolean plain) {
        return plain ? this.plainNamePattern : this.namePattern;
    }

    public AbstractNamingService(@NotNull Dbms dbms, @NotNull Pattern namePattern, @NotNull Pattern plainNamePattern) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)namePattern, (String)"namePattern");
        Intrinsics.checkParameterIsNotNull((Object)plainNamePattern, (String)"plainNamePattern");
        this.dbms = dbms;
        this.namePattern = namePattern;
        this.plainNamePattern = plainNamePattern;
    }

    public AbstractNamingService(@NotNull Dbms dbms, @NotNull Pattern namePattern) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)namePattern, (String)"namePattern");
        this(dbms, namePattern, namePattern);
    }

    @Nullable
    public Character closeQuote(char openQuote) {
        return NamingService.DefaultImpls.closeQuote((NamingService)this, (char)openQuote);
    }
}

