/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.model;

import com.intellij.database.dialects.h2.model.H2Constant;
import com.intellij.database.dialects.h2.model.H2ObjectEditorFactory;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/h2/model/H2ModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "applyH2Column", "", "from", "Lcom/intellij/database/schemaEditor/model/DeColumn;", "col", "Lcom/intellij/database/dialects/h2/model/H2TableColumn;", "exportApplyColumn", "helper", "Lcom/intellij/database/schemaEditor/SchemaApplyHelper;", "to", "Lcom/intellij/database/model/basic/BasicModTableColumn;", "fillPropertiesWithExamples", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "", "vars", "", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "intellij.database.dialects.h2"})
public final class H2ModelHelper
extends ModelHelper {
    public void exportApplyColumn(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        if (to instanceof H2TableColumn) {
            this.applyH2Column(from, (H2TableColumn)to);
        } else {
            super.exportApplyColumn(helper, from, to);
        }
    }

    @NotNull
    public JBIterable<String> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
        if (meta.kind == ObjectKind.ROUTINE) {
            JBIterable jBIterable2 = JBIterable.of((Object)"Alias");
            jBIterable = jBIterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"JBIterable.of(\"Alias\")");
        } else {
            JBIterable jBIterable3 = super.generationVariants(meta);
            jBIterable = jBIterable3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"super.generationVariants(meta)");
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull String variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
        if (e instanceof H2Constant) {
            ((H2Constant)e).setValue("'val'");
            vars.put("value", "'val'");
        }
        super.fillPropertiesWithExamples(e, variant, vars);
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return H2ObjectEditorFactory.INSTANCE;
    }

    private final void applyH2Column(DeColumn from, H2TableColumn col) {
        BasicElement basicElement = from.unwrap();
        if (!(basicElement instanceof H2TableColumn)) {
            basicElement = null;
        }
        H2TableColumn prev = (H2TableColumn)basicElement;
        SequenceIdentity sequenceIdentity = SequenceIdentity.UNKNOWN;
        H2TableColumn h2TableColumn = col;
        boolean bl = false;
        boolean bl2 = false;
        SequenceIdentity it = sequenceIdentity;
        boolean bl3 = false;
        Object object = from.flags.contains(DeColumn.Flag.AUTO_INC) ? sequenceIdentity : null;
        h2TableColumn.setSequenceIdentity((SequenceIdentity)object);
        boolean notChangedSeq = prev != null && prev.isAutoInc() && !col.isAutoInc() && Intrinsics.areEqual((Object)from.defaultValue, (Object)prev.getDefaultExpression());
        String string = from.defaultValue;
        h2TableColumn = col;
        bl2 = false;
        boolean bl4 = false;
        String it2 = string;
        boolean bl5 = false;
        object = !notChangedSeq ? string : null;
        h2TableColumn.setDefaultExpression((String)object);
    }
}

