/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.model;

import com.intellij.database.dialects.hivebase.model.HiveBaseDescriptionService;
import com.intellij.database.dialects.hivebase.model.HiveBaseLikeTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseTableColumn;
import com.intellij.database.dialects.hivebase.model.HiveBaseView;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.model.properties.HiveTableColumnType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0004J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0004J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/hivebase/model/HiveBaseDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "appendProperties", "", "e", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseLikeTable;", "desc", "content", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeTable", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTable;", "describeTableColumn", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTableColumn;", "describeView", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseView;", "joinProperties", "properties", "", "Lcom/intellij/database/model/NameValue;", "intellij.database.dialects.hivebase"})
public class HiveBaseDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof HiveBaseTable ? this.describeTable((HiveBaseTable)e) : (basicElement instanceof HiveBaseTableColumn ? this.describeTableColumn((HiveBaseTableColumn)e) : (basicElement instanceof HiveBaseView ? this.describeView((HiveBaseView)e) : super.content(e, context)));
    }

    private final String describeView(HiveBaseView e) {
        String desc = super.describeView((BasicView)e);
        return this.appendProperties(e, desc);
    }

    @NotNull
    protected final String appendProperties(@NotNull HiveBaseLikeTable e, @NotNull String desc) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        List list = e.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"e.properties");
        List nonIgnoredProperties = list;
        Collection collection = nonIgnoredProperties;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return desc + " properties: " + this.joinProperties(nonIgnoredProperties);
        }
        return desc;
    }

    private final String joinProperties(List<NameValue> properties2) {
        return CollectionsKt.joinToString$default((Iterable)properties2, null, null, null, (int)0, null, (Function1)joinProperties.1.INSTANCE, (int)31, null);
    }

    private final String describeTableColumn(HiveBaseTableColumn e) {
        String desc = super.describeColumn((BasicLikeColumn)e);
        if (e.getType() != HiveTableColumnType.REGULAR) {
            desc = desc + ' ' + e.getType();
        }
        if (e.getSorting() != HiveTableColumnSortingOrder.NONE) {
            desc = desc + ' ' + e.getSorting();
        }
        return desc;
    }

    @NotNull
    protected final String describeTable(@NotNull HiveBaseTable e) {
        String desc;
        block6: {
            Object it;
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            desc = super.describeTable((BasicTable)e);
            if (e.getBucketsNum() != 0) {
                desc = desc + " buckets: " + e.getBucketsNum();
            }
            String string = e.getRowFormatSerde();
            if (string != null) {
                object = string;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                desc = desc + " serde: " + (String)it;
            }
            List<NameValue> list = e.getSerdeProperties();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"e.serdeProperties");
            object = list;
            bl2 = false;
            if (!object.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder().append(desc).append(" serdeproperties: ");
                List<NameValue> list2 = e.getSerdeProperties();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"e.serdeProperties");
                desc = stringBuilder.append(this.joinProperties(list2)).toString();
            }
            String string2 = e.getInputFormat();
            if (string2 != null) {
                object = string2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                desc = desc + " inputformat: " + (String)it;
            }
            String string3 = e.getOutputFormat();
            if (string3 != null) {
                object = string3;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl5 = false;
                desc = desc + " outputformat: " + (String)it;
            }
            String string4 = e.getInputDriver();
            if (string4 != null) {
                object = string4;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl6 = false;
                desc = desc + " inputdriver: " + (String)it;
            }
            String string5 = e.getOutputDriver();
            if (string5 == null) break block6;
            object = string5;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl7 = false;
            desc = desc + " outputdriver: " + (String)it;
        }
        return this.appendProperties(e, desc);
    }
}

