/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateSequence;
import com.intellij.database.dialects.mssql.generator.MsScriptGeneratorHelperKt;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u001a\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/mssql/generator/producers/MsCreateSequence;", "Lcom/intellij/database/dialects/base/generator/producers/CreateSequence;", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/mssql/model/MsSequence;)V", "gatherSequenceIdentityParameters", "", "sequence", "parameters", "", "", "getDefaultMax", "Ljava/math/BigInteger;", "getDefaultMin", "produceComment", "exists", "", "comment", "intellij.database.dialects.mssql"})
public final class MsCreateSequence
extends CreateSequence<MsSequence> {
    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        MsScriptGeneratorHelperKt.msAlterComment(this, exists, comment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BigInteger getDefaultMin(MsSequence sequence) {
        DataType dataType = sequence.getUnderlyingDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sequence.underlyingDataType");
        DataType dataType2 = dataType;
        String string = StringUtil.toLowerCase((String)dataType2.typeName);
        if (string == null) return null;
        switch (string) {
            case "tinyint": {
                BigInteger bigInteger2 = BigInteger.ZERO;
                return bigInteger2;
            }
            case "smallint": {
                int n = Short.MIN_VALUE;
                boolean bl = false;
                BigInteger bigInteger = BigInteger.valueOf(n);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(this.toLong())");
                return bigInteger2;
            }
            case "int": {
                int n = Integer.MIN_VALUE;
                boolean bl = false;
                BigInteger bigInteger = BigInteger.valueOf(n);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(this.toLong())");
                return bigInteger2;
            }
            case "bigint": {
                long l = Long.MIN_VALUE;
                boolean bl = false;
                BigInteger bigInteger = BigInteger.valueOf(l);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(this)");
                return bigInteger2;
            }
            case "numeric": 
            case "decimal": {
                String string2 = "-" + StringsKt.repeat((CharSequence)"9", (int)dataType2.getLength());
                boolean bl = false;
                BigInteger bigInteger2 = new BigInteger(string2);
                return bigInteger2;
            }
            case "unknown": {
                BigInteger bigInteger2 = BigInteger.ONE;
                return bigInteger2;
            }
            default: {
                return null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BigInteger getDefaultMax(MsSequence sequence) {
        DataType dataType = sequence.getUnderlyingDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sequence.underlyingDataType");
        DataType dataType2 = dataType;
        String string = StringUtil.toLowerCase((String)dataType2.typeName);
        if (string == null) return null;
        switch (string) {
            case "tinyint": {
                int n = 255;
                boolean bl = false;
                BigInteger bigInteger = BigInteger.valueOf(n);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(this.toLong())");
                return bigInteger2;
            }
            case "smallint": {
                int n = Short.MAX_VALUE;
                boolean bl = false;
                BigInteger bigInteger = BigInteger.valueOf(n);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(this.toLong())");
                return bigInteger2;
            }
            case "int": {
                int n = Integer.MAX_VALUE;
                boolean bl = false;
                BigInteger bigInteger = BigInteger.valueOf(n);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(this.toLong())");
                return bigInteger2;
            }
            case "bigint": {
                long l = Long.MAX_VALUE;
                boolean bl = false;
                BigInteger bigInteger = BigInteger.valueOf(l);
                BigInteger bigInteger2 = bigInteger;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(this)");
                return bigInteger2;
            }
            case "numeric": 
            case "decimal": {
                String string2 = StringsKt.repeat((CharSequence)"9", (int)dataType2.getLength());
                boolean bl = false;
                BigInteger bigInteger2 = new BigInteger(string2);
                return bigInteger2;
            }
            default: {
                return null;
            }
        }
    }

    @Override
    public void gatherSequenceIdentityParameters(@NotNull MsSequence sequence, @NotNull List<String> parameters2) {
        block11: {
            block10: {
                BigInteger defStart;
                BigInteger bigInteger;
                boolean bl;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
                Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
                if (Intrinsics.areEqual((Object)sequence.getDataType(), (Object)DataType.UNKNOWN) ^ true && !StringsKt.equals((String)sequence.getDataType().typeName, (String)"bigint", (boolean)true)) {
                    object = parameters2;
                    StringBuilder stringBuilder = new StringBuilder().append("as ");
                    DataType dataType = sequence.getDataType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sequence.dataType");
                    String string = stringBuilder.append(this.script(dataType)).toString();
                    bl = false;
                    object.add(string);
                }
                object = sequence.getSequenceIdentity();
                boolean bl2 = false;
                bl = false;
                SequenceIdentity identity = object;
                boolean bl3 = false;
                BigInteger defaultMin = this.getDefaultMin(sequence);
                BigInteger defaultMax = this.getDefaultMax(sequence);
                if (identity.increment.compareTo(BigInteger.ZERO) > 0) {
                    bigInteger = identity.min;
                    if (bigInteger == null) {
                        bigInteger = defaultMin;
                    }
                } else {
                    bigInteger = identity.max;
                    if (bigInteger == null) {
                        bigInteger = defStart = defaultMax;
                    }
                }
                if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)defStart) ^ true && ((Boolean)this.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE)).booleanValue()) {
                    parameters2.add("start with " + identity.next);
                }
                if (Intrinsics.areEqual((Object)identity.increment, (Object)BigInteger.ONE) ^ true) {
                    parameters2.add("increment by " + identity.increment);
                }
                if (identity.min != null && Intrinsics.areEqual((Object)identity.min, (Object)defaultMin) ^ true) {
                    parameters2.add("minvalue " + identity.min);
                }
                if (identity.max != null && Intrinsics.areEqual((Object)identity.max, (Object)defaultMax) ^ true) {
                    parameters2.add("maxvalue " + identity.max);
                }
                if (sequence.isCycled()) {
                    parameters2.add("cycle");
                }
                if (sequence.getCacheSize() >= 0L) break block10;
                parameters2.add("no cache");
                break block11;
            }
            if (sequence.getCacheSize() <= 0L) break block11;
            parameters2.add("cache " + sequence.getCacheSize());
        }
    }

    public MsCreateSequence(@NotNull ScriptingContext context, @NotNull MsSequence element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(context, (BasicSequence)element);
    }
}

