/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntroQueriesKt;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.mssql.introspector.ExtPropId;
import com.intellij.database.dialects.mssql.introspector.ForeignKeyInfo;
import com.intellij.database.dialects.mssql.introspector.MsIntroQueries;
import com.intellij.database.dialects.mssql.introspector.MsIntrospector;
import com.intellij.database.dialects.mssql.introspector.MsIntrospector$MsSchemaRetriever$retrieveRules$1$$special$;
import com.intellij.database.dialects.mssql.introspector.MsIntrospector$MsSchemaRetriever$retrieveSequences$1$$special$;
import com.intellij.database.dialects.mssql.introspector.MsIntrospector$MsSchemaRetriever$retrieveSources$;
import com.intellij.database.dialects.mssql.introspector.MsIntrospectorHelper;
import com.intellij.database.dialects.mssql.introspector.MsIntrospectorKt;
import com.intellij.database.dialects.mssql.introspector.MsMinorIdentity;
import com.intellij.database.dialects.mssql.introspector.MsRoutineTypes;
import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsArgument;
import com.intellij.database.dialects.mssql.model.MsCheck;
import com.intellij.database.dialects.mssql.model.MsCustomType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsForeignKey;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsIndexableTable;
import com.intellij.database.dialects.mssql.model.MsKey;
import com.intellij.database.dialects.mssql.model.MsLikeColumn;
import com.intellij.database.dialects.mssql.model.MsLikeTable;
import com.intellij.database.dialects.mssql.model.MsRoot;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsRule;
import com.intellij.database.dialects.mssql.model.MsSchema;
import com.intellij.database.dialects.mssql.model.MsSchemaObject;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.MsSourceAware;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsStoredTable;
import com.intellij.database.dialects.mssql.model.MsSynonym;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableOrView;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.MsView;
import com.intellij.database.introspection.CollectionAggregator;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.layoutedQueries.DBQueryRunner;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.MsRoutineType;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntHashSet;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003./0B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ&\u0010\u0015\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0016R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J\u001c\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J\u001c\u0010\u001c\u001a\u00060\u001dR\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0004H\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J)\u0010#\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%H\u0000\u00a2\u0006\u0002\b(J!\u0010#\u001a\u00020 2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%H\u0000\u00a2\u0006\u0002\b(J\"\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00140*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0-H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/Dbms;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "databasesToReResolveForeignKeys", "Ljava/util/HashSet;", "Lcom/intellij/database/model/basic/BasicDatabase;", "helper", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospectorHelper;", "myQueries", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries;", "myVer10", "", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever;", "schema", "initConnectionRelatedState", "", "postProcessDatabase", "tran", "prepareQueryParameters", "parameters", "", "", "", "prepareQueryParameters$intellij_database_dialects_mssql", "retrieveInvalid", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "", "Factory", "MsDatabaseRetriever", "MsSchemaRetriever", "intellij.database.dialects.mssql"})
public final class MsIntrospector
extends BaseMultiDatabaseIntrospector<MsRoot, MsDatabase, MsSchema> {
    private final MsIntroQueries myQueries;
    private boolean myVer10;
    private final HashSet<BasicDatabase> databasesToReResolveForeignKeys;
    private final MsIntrospectorHelper helper;

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        this.myVer10 = this.getServerVersion().isOrGreater(new int[]{10});
    }

    public final void prepareQueryParameters$intellij_database_dialects_mssql(@NotNull Map<String, Object> parameters2) {
        Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
        if (Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.AZURE)) {
            parameters2.put("AZURE", true);
        }
    }

    public final void prepareQueryParameters$intellij_database_dialects_mssql(@NotNull BasicDatabase database, @NotNull Map<String, Object> parameters2) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
        this.prepareQueryParameters$intellij_database_dialects_mssql(parameters2);
        parameters2.put("CAT", MsIntrospectorKt.access$catalogPrefix(database));
        parameters2.put("ISTABLETYPE", this.getServerVersion().isOrGreater(new int[]{10}) ? "is_table_type" : "0");
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 10, parameters2);
    }

    @NotNull
    protected MsDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull MsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new MsDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected MsSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull MsSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new MsSchemaRetriever(this, transaction, schema);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<MsIntroQueries.DbInfo, MsDatabase>(this){
            final /* synthetic */ MsIntrospector this$0;

            @NotNull
            protected List<MsIntroQueries.DbInfo> listDatabases(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                this.this$0.prepareQueryParameters$intellij_database_dialects_mssql(MsIntrospector.access$getQueryParameters$p(this.this$0));
                SqlQuery<List<MsIntroQueries.DbInfo>> sqlQuery = MsIntrospector.access$getMyQueries$p((MsIntrospector)this.this$0).listDatabases;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.listDatabases");
                Object object = MsIntrospector.access$performQuery(this.this$0, tran, sqlQuery);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"performQuery(tran, myQueries.listDatabases)");
                return (List)object;
            }

            @NotNull
            protected MsDatabase applyDatabase(@NotNull ModNamingFamily<?> databases, @NotNull MsIntroQueries.DbInfo db) {
                String string;
                Intrinsics.checkParameterIsNotNull(databases, (String)"databases");
                Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                MD MD = this.renew(databases, db.id, db.name);
                boolean bl = false;
                boolean bl2 = false;
                MsDatabase $this$apply = (MsDatabase)MD;
                boolean bl3 = false;
                MsDatabase msDatabase = $this$apply;
                String string2 = db.collation_name;
                if (string2 != null) {
                    String string3 = string2;
                    MsDatabase msDatabase2 = msDatabase;
                    boolean bl4 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string5 = ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
                    msDatabase = msDatabase2;
                    string = string5;
                } else {
                    string = null;
                }
                msDatabase.setCollation(string);
                return (MsDatabase)MD;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull MsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        if (this.databasesToReResolveForeignKeys.contains(database)) {
            Collection collection = this.databasesToReResolveForeignKeys;
            boolean bl = false;
            collection.remove(database);
            this.getModel().modify((BasicElement)database, MsDatabase.class, (ModelModifier)postProcessDatabase.1.INSTANCE);
        }
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
        boolean bl = false;
        LinkedHashMap res2 = new LinkedHashMap();
        for (BasicDatabase database : JBIterable.from(elements2).transform((Function)retrieveInvalid.1.INSTANCE).toSet()) {
            boolean bl2 = false;
            LinkedHashMap ids = new LinkedHashMap();
            Object $this$forEach$iv = elements2;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                BasicElement element$iv;
                BasicElement it = element$iv = object.next();
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getDatabase(), (Object)database) || !MsIntrospectorKt.access$canCheckOutdated(it)) continue;
                BasicElement basicElement = it;
                if (basicElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.mssql.model.MsSchemaObject");
                }
                MsSchemaObject cfr_ignored_0 = (MsSchemaObject)basicElement;
                ((Map)ids).put(((MsSchemaObject)it).getObjectId(), it);
            }
            if (ids.isEmpty()) continue;
            BasicDatabase basicDatabase = database;
            if (basicDatabase == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)basicDatabase, (String)"database!!");
            this.prepareQueryParameters$intellij_database_dialects_mssql(basicDatabase, this.queryParameters);
            Set set = ids.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"ids.keys");
            this.setQueryParameter("OBJECT_IDS", CollectionsKt.toLongArray((Collection)set));
            $this$forEach$iv = ids;
            $i$f$forEach = false;
            object = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$_u24__u24$v = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$_u24__u24$v;
                boolean bl6 = false;
                MsSchemaObject v2 = (MsSchemaObject)entry.getValue();
                ((Map)res2).put(v2, false);
            }
            SqlQuery<List<MsIntroQueries.OneState>> sqlQuery = MsIntroQueries.QUERIES.retrieveStates;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveStates");
            BaseIntrospector.performQueryByPack$default(this, sqlQuery, 0, (Function1)new Function1<MsIntroQueries.OneState, Unit>(ids, res2){
                final /* synthetic */ LinkedHashMap $ids;
                final /* synthetic */ LinkedHashMap $res;

                public final void invoke(@NotNull MsIntroQueries.OneState s) {
                    Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                    MsSchemaObject msSchemaObject = (MsSchemaObject)this.$ids.get(s.object_id);
                    if (msSchemaObject == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)msSchemaObject, (String)"ids[s.object_id] ?: return@performQueryByPack");
                    MsSchemaObject obj2 = msSchemaObject;
                    ((Map)this.$res).put(obj2, Intrinsics.areEqual((Object)obj2.getModifiedTimestamp(), (Object)s.modify_date));
                }
                {
                    this.$ids = linkedHashMap;
                    this.$res = linkedHashMap2;
                    super(1);
                }
            }, 2, null);
        }
        this.inModel((Function1)new Function1<MsRoot, Unit>(res2){
            final /* synthetic */ LinkedHashMap $res;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MsRoot it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Set<Map.Entry<K, V>> set = this.$res.entrySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"res.entries");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void obj2;
                    Map.Entry $dstr$obj$ok = (Map.Entry)element$iv;
                    boolean bl = false;
                    Map.Entry entry = $dstr$obj$ok;
                    boolean bl2 = false;
                    BasicElement basicElement = (BasicElement)entry.getKey();
                    entry = $dstr$obj$ok;
                    bl2 = false;
                    Boolean ok = (Boolean)entry.getValue();
                    void v1 = obj2;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
                    }
                    ((BasicModElement)v1).setOutdated(ok == false);
                }
            }
            {
                this.$res = linkedHashMap;
                super(1);
            }
        });
        return res2;
    }

    public MsIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        super(dbms, project, modelFactory);
        MsIntroQueries msIntroQueries = MsIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)msIntroQueries, (String)"QUERIES");
        this.myQueries = msIntroQueries;
        this.databasesToReResolveForeignKeys = new HashSet();
        this.helper = new MsIntrospectorHelper(project);
    }

    public static final /* synthetic */ void access$setMyVer10$p(MsIntrospector $this, boolean bl) {
        $this.myVer10 = bl;
    }

    public static final /* synthetic */ MsIntrospectorHelper access$getHelper$p(MsIntrospector $this) {
        return $this.helper;
    }

    public static final /* synthetic */ void access$writeSources(MsIntrospector $this, Function0 r) {
        $this.writeSources((Function0<Unit>)r);
    }

    public static final /* synthetic */ Map access$getQueryParameters$p(MsIntrospector $this) {
        return $this.queryParameters;
    }

    public static final /* synthetic */ Object access$performQuery(MsIntrospector $this, DBTransaction transaction, SqlQuery query) {
        return $this.performQuery(transaction, query);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.mssql"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @NotNull
        private final Dbms dbms;

        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return version.isOrGreater(new int[]{9});
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            return new MsIntrospector(dbms, project, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return MsIntrospectorKt.access$canCheckOutdated(e);
        }

        @NotNull
        public final Dbms getDbms() {
            return this.dbms;
        }

        public Factory(@NotNull Dbms dbms) {
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            this.dbms = dbms;
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.mssql"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mssql/model/MsDatabase;)V", "beforeSchemasRetrieval", "", "checkAzureDatabaseSelectedCorrectly", "checkFingerprint", "process", "retrieveExtProperties", "retrieveSchemas", "intellij.database.dialects.mssql"})
    protected final class MsDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<MsDatabase> {
        @Override
        public void process() {
            this.beforeSchemasRetrieval();
            this.retrieveExtProperties();
            this.checkFingerprint();
            super.process();
        }

        private final void retrieveExtProperties() {
            SqlQuery<List<MsIntroQueries.OneProperty>> sqlQuery = ((MsIntrospector)MsIntrospector.this).myQueries.retrieveDbExtendedProperties;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveDbExtendedProperties");
            List<MsIntroQueries.OneProperty> props = this.performQuery(sqlQuery);
            MsIntrospectorKt.access$setExtProps((MsExtendedPropertiesHolder)this.getDatabase(), props);
        }

        private final void checkFingerprint() {
            String string;
            String string2 = ((MsDatabase)this.getDatabase()).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"database.name");
            String databaseName = string2;
            SqlQuery<String> sqlQuery = ((MsIntrospector)MsIntrospector.this).myQueries.queryFingerprint;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.queryFingerprint");
            String calculatedFingerprint = this.performQuery(sqlQuery);
            if (calculatedFingerprint == null) {
                MsIntrospector.this.getLog().warn("Failed to calculate the fingerprint for the database " + databaseName);
            }
            if ((string = calculatedFingerprint) == null) {
                string = "failed-to-calculate";
            }
            String newFingerprint = string;
            String oldFingerprint = ((MsDatabase)this.getDatabase()).getFingerprint();
            if (oldFingerprint == null) {
                MsIntrospector.this.getLog().info("Setting the fingerprint for the database " + databaseName + ": " + newFingerprint);
                this.inDatabase((Function1)new Function1<MsDatabase, Unit>(newFingerprint){
                    final /* synthetic */ String $newFingerprint;

                    public final void invoke(@NotNull MsDatabase db) {
                        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                        db.setFingerprint(this.$newFingerprint);
                    }
                    {
                        this.$newFingerprint = string;
                        super(1);
                    }
                });
                return;
            }
            if (Intrinsics.areEqual((Object)newFingerprint, (Object)oldFingerprint) ^ true) {
                MsIntrospector.this.getLog().info("Database replacement for database " + databaseName + " detected: \n\told fingerprint: " + oldFingerprint + " \n\tnew fingerprint: " + newFingerprint + ' ');
                this.inDatabase((Function1)new Function1<MsDatabase, Unit>(newFingerprint){
                    final /* synthetic */ String $newFingerprint;

                    public final void invoke(@NotNull MsDatabase db) {
                        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                        Iterator iterator = db.getSchemas().iterator();
                        while (iterator.hasNext()) {
                            MsSchema schema;
                            MsSchema msSchema = schema = (MsSchema)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)msSchema, (String)"schema");
                            msSchema.setIntrospectionTimestamp(null);
                            schema.setComment(null);
                            schema.setExtendedProperties(CollectionsKt.emptyList());
                            schema.setAliasTypesCheckSum(0L);
                            schema.setDescriptionsCheckSum(0L);
                        }
                        db.setFingerprint(this.$newFingerprint);
                    }
                    {
                        this.$newFingerprint = string;
                        super(1);
                    }
                });
            }
        }

        @Override
        protected void beforeSchemasRetrieval() {
            if (Intrinsics.areEqual((Object)MsIntrospector.this.getDbms(), (Object)Dbms.AZURE)) {
                this.checkAzureDatabaseSelectedCorrectly();
            }
            MsIntrospector.this.prepareQueryParameters$intellij_database_dialects_mssql((BasicDatabase)this.getDatabase(), this.getQueryParameters());
        }

        private final void checkAzureDatabaseSelectedCorrectly() {
            String connectionDbName = ((MsIntrospector)MsIntrospector.this).getDbConnectionInfo().databaseName;
            String requestedDbName = ((MsDatabase)this.getDatabase()).getCatalogName();
            if (Intrinsics.areEqual((Object)connectionDbName, (Object)requestedDbName) ^ true) {
                MsIntrospector.this.getErrorSink().consume((Object)("Azure limitation: Attempted to introspect database [" + requestedDbName + "] with connection to database [" + connectionDbName + "] might ends with Azure error [40515]"), null);
            }
        }

        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            Ref.ObjectRef scs = new Ref.ObjectRef();
            try {
                SqlQuery<List<LongIdName>> sqlQuery = ((MsIntrospector)MsIntrospector.this).myQueries.listSchemas;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.listSchemas");
                List<LongIdName> list = this.performQuery(sqlQuery);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(myQueries.listSchemas)");
                scs.element = list;
            }
            catch (DBException e) {
                switch (e.vendorErrorCode) {
                    case 916: {
                        scs.element = CollectionsKt.emptyList();
                        break;
                    }
                    case 40515: {
                        scs.element = CollectionsKt.emptyList();
                        break;
                    }
                    default: {
                        throw (Throwable)e;
                    }
                }
                MsIntrospector.this.getErrorSink().consume(null, (Object)e);
            }
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(scs){
                final /* synthetic */ Ref.ObjectRef $scs;

                public final void invoke(@NotNull MsDatabase db) {
                    Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                    ModNamingIdentifyingFamily<? extends MsSchema> modNamingIdentifyingFamily = db.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"db.schemas");
                    ModelFun.applyNameIds(modNamingIdentifyingFamily, (List)((List)this.$scs.element));
                }
                {
                    this.$scs = objectRef;
                    super(1);
                }
            });
        }

        public MsDatabaseRetriever(@NotNull DBTransaction transaction, MsDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)MsIntrospector.this, transaction, (BasicModMateDatabase)database);
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0012H\u0014J:\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J2\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H 0\u0016\"\u0004\b\u0000\u0010 2\u0014\u0010!\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H 0#0\"2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0016H\u0002J\u0016\u0010,\u001a\u00020\u00122\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0016H\u0002J>\u0010/\u001a\u00020\u0012\"\f\b\u0000\u00100*\u000201*\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H0042\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0019H\u0002J$\u00105\u001a\u00020\u00122\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00162\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\u0016H\u0002J$\u0010:\u001a\u00020\u00122\f\u00106\u001a\b\u0012\u0004\u0012\u00020;0\u00162\f\u00108\u001a\b\u0012\u0004\u0012\u00020<0\u0016H\u0002J\u0016\u0010=\u001a\u00020\u00122\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0016H\u0002J\u0010\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020(H\u0002J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010C\u001a\u00020DH\u0002J \u0010E\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020GH\u0002J \u0010E\u001a\u00020\u00122\u0006\u0010I\u001a\u00020J2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020GH\u0002J\u0018\u0010K\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010L\u001a\u00020MH\u0002J\b\u0010N\u001a\u00020\u0012H\u0002J\b\u0010O\u001a\u00020\u0012H\u0002J\b\u0010P\u001a\u00020\u0012H\u0002J\b\u0010Q\u001a\u00020\u0012H\u0002J\b\u0010R\u001a\u00020\u0012H\u0002J\b\u0010S\u001a\u00020\u0012H\u0002J\b\u0010T\u001a\u00020\u0012H\u0002J\b\u0010U\u001a\u00020\u0012H\u0002J\b\u0010V\u001a\u00020\u0012H\u0002J\b\u0010W\u001a\u00020\u0012H\u0014J\b\u0010X\u001a\u00020\u0012H\u0014J\b\u0010Y\u001a\u00020\u0012H\u0002J\b\u0010Z\u001a\u00020\u0012H\u0002J\b\u0010[\u001a\u00020\u0012H\u0002J\b\u0010\\\u001a\u00020\u0012H\u0002J\b\u0010]\u001a\u00020\u0012H\u0002J\b\u0010^\u001a\u00020\u0012H\u0002J\b\u0010_\u001a\u00020\u0012H\u0002J\b\u0010`\u001a\u00020\u0012H\u0002J\b\u0010a\u001a\u00020\u0012H\u0002J\b\u0010b\u001a\u00020\u0012H\u0002J\u000e\u0010c\u001a\u0004\u0018\u00010d*\u00020eH\u0002J\u0014\u0010f\u001a\u00020g*\u00020h2\u0006\u0010i\u001a\u00020jH\u0002J\f\u0010k\u001a\u00020l*\u00020hH\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mssql/model/MsSchema;)V", "myTouchedRoutines", "Ljava/util/HashSet;", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "myTouchedTables", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/mssql/model/MsLikeTable;", "Lkotlin/collections/ArrayList;", "analyzeBriefInfo", "", "analyzeCurrentContent", "finishSchema", "getDescription", "", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneProperty;", "descriptions", "", "Lcom/intellij/database/dialects/mssql/introspector/ExtPropId;", "obj", "Lcom/intellij/database/model/basic/BasicIdentifiedElement;", "position", "", "performQueryForList", "X", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "packSize", "", "processAliasTypes", "aliasTypesCheckSum", "", "processCheckConstraints", "cs", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneCheckConstraints;", "processColumns", "cols", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneColumn;", "processDescriptions", "T", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "Lcom/intellij/database/dialects/mssql/model/MsExtendedPropertiesHolder;", "family", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "processFulltextIndices", "inds", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneFulltextIndex;", "ics", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneFulltextIndexColumn;", "processIndices", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneIndex;", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneIndexColumn;", "processKeys", "ks", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneKey;", "processTableTypes", "tableTypesCheckSum", "progress", "what", "", "removeUnexistentIndices", "existentIndicesCombies", "Lgnu/trove/TLongHashSet;", "tablesWithFulltextIndices", "table", "Lcom/intellij/database/dialects/mssql/model/MsStoredTable;", "removeUnexistentSchemaObjects", "existentObjectIds", "Lgnu/trove/TIntHashSet;", "retrieveArguments", "retrieveCheckConstraints", "retrieveColumns", "retrieveCustomTypes", "retrieveDescription", "retrieveForeignKeys", "retrieveFulltextIndices", "retrieveIndices", "retrieveKeys", "retrieveMainContent", "retrieveMajorNames", "retrieveMajorObjects", "retrieveRules", "retrieveSequences", "retrieveSources", "retrieveSynonyms", "retrieveTriggers", "retrieveTypeCheckConstraints", "retrieveTypeColumns", "retrieveTypeIndices", "retrieveTypeKeys", "asBigInteger", "Ljava/math/BigInteger;", "", "getDataType", "Lcom/intellij/database/model/DataType;", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneSequence;", "isUnderlying", "", "getSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "intellij.database.dialects.mssql"})
    protected final class MsSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<MsSchema> {
        private final ArrayList<MsLikeTable> myTouchedTables;
        private final HashSet<MsRoutine> myTouchedRoutines;
        final /* synthetic */ MsIntrospector this$0;

        @NotNull
        protected <X> List<X> performQueryForList(@NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            try {
                return super.performQueryForList(query, packSize);
            }
            catch (DBException e) {
                switch (e.vendorErrorCode) {
                    case 916: {
                        return CollectionsKt.emptyList();
                    }
                }
                this.this$0.getLog().error("Error occurred during introspection, query " + query.getDisplayName() + ":\n" + e.getMessage() + "\nSQL statement:\n" + e.statementText);
                return CollectionsKt.emptyList();
            }
        }

        @Override
        protected void analyzeBriefInfo() {
            DBQueryRunner dBQueryRunner = this.getTransaction().query("select current_timestamp", Layouts.singleOf(Timestamp.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)dBQueryRunner, (String)"transaction.query(\"selec\u2026f(Timestamp::class.java))");
            this.setIntrospectionBeginTimestamp((Timestamp)BaseIntroQueriesKt.runAndClose(dBQueryRunner));
        }

        @Override
        protected void analyzeCurrentContent() {
            this.progress("determining dropped objects");
            SqlQuery<int[]> sqlQuery = ((MsIntrospector)this.this$0).myQueries.listExistentObjects;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.listExistentObjects");
            int[] existentObjectsArray = this.performQuery(sqlQuery);
            TIntHashSet existentObjectIds = new TIntHashSet(existentObjectsArray);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, existentObjectIds){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ TIntHashSet $existentObjectIds;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    MsSchemaRetriever.access$removeUnexistentSchemaObjects(this.this$0, schema, this.$existentObjectIds);
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$existentObjectIds = tIntHashSet;
                    super(1);
                }
            });
            ModNamingIdentifyingFamily<? extends MsTableType> modNamingIdentifyingFamily = ((MsSchema)this.getSchema()).getTableTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.tableTypes");
            if (modNamingIdentifyingFamily.isEmpty()) {
                ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily2 = ((MsSchema)this.getSchema()).getTables();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.tables");
                if (modNamingIdentifyingFamily2.isEmpty()) {
                    return;
                }
            }
            SqlQuery<long[]> sqlQuery2 = ((MsIntrospector)this.this$0).myQueries.listExistentIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"myQueries.listExistentIndices");
            long[] existentIndicesArray = this.performQuery(sqlQuery2);
            SqlQuery<long[]> sqlQuery3 = ((MsIntrospector)this.this$0).myQueries.listExistentFulltextIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery3, (String)"myQueries.listExistentFulltextIndices");
            long[] tablesWithFulltextIndicesArray = this.performQuery(sqlQuery3);
            TLongHashSet existentIndicesCombies = new TLongHashSet(existentIndicesArray);
            TLongHashSet tablesWithFulltextIndices = new TLongHashSet(tablesWithFulltextIndicesArray);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, existentIndicesCombies, tablesWithFulltextIndices){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $existentIndicesCombies;
                final /* synthetic */ TLongHashSet $tablesWithFulltextIndices;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    MsSchemaRetriever.access$removeUnexistentIndices(this.this$0, schema, this.$existentIndicesCombies, this.$tablesWithFulltextIndices);
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$existentIndicesCombies = tLongHashSet;
                    this.$tablesWithFulltextIndices = tLongHashSet2;
                    super(1);
                }
            });
        }

        private final void removeUnexistentSchemaObjects(MsSchema schema, TIntHashSet existentObjectIds) {
            ModNamingIdentifyingFamily<? extends MsSynonym> modNamingIdentifyingFamily = schema.getSynonyms();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.synonyms");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily), existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsRoutine> modNamingIdentifyingFamily2 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.routines");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily2), existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsView> modNamingIdentifyingFamily3 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily3, (String)"schema.views");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily3), existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily4 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily4, (String)"schema.tables");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily4), existentObjectIds);
            Iterator iterator = schema.getTables().iterator();
            while (iterator.hasNext()) {
                MsTable table;
                MsTable msTable = table = (MsTable)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msTable, (String)"table");
                ModNamingIdentifyingFamily modNamingIdentifyingFamily5 = (ModNamingIdentifyingFamily)msTable.getKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily5, (String)"table.keys");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily5), existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsForeignKey> modNamingIdentifyingFamily6 = table.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily6, (String)"table.foreignKeys");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily6), existentObjectIds);
                ModNamingIdentifyingFamily modNamingIdentifyingFamily7 = (ModNamingIdentifyingFamily)table.getChecks();
                Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily7, (String)"table.checks");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily7), existentObjectIds);
                ModNamingIdentifyingFamily modNamingIdentifyingFamily8 = table.getDefaultConstraints();
                Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily8, (String)"table.defaultConstraints");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily8), existentObjectIds);
                ModNamingIdentifyingFamily modNamingIdentifyingFamily9 = table.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily9, (String)"table.triggers");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily9), existentObjectIds);
            }
            iterator = schema.getViews().iterator();
            while (iterator.hasNext()) {
                MsView view;
                MsView msView = view = (MsView)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msView, (String)"view");
                ModNamingIdentifyingFamily modNamingIdentifyingFamily10 = msView.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily10, (String)"view.triggers");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)modNamingIdentifyingFamily10), existentObjectIds);
            }
        }

        private final void removeUnexistentIndices(MsSchema schema, TLongHashSet existentIndicesCombies, TLongHashSet tablesWithFulltextIndices) {
            Iterator iterator = schema.getTableTypes().iterator();
            while (iterator.hasNext()) {
                MsTableType tableType;
                MsTableType msTableType = tableType = (MsTableType)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msTableType, (String)"tableType");
                this.removeUnexistentIndices(msTableType, existentIndicesCombies, tablesWithFulltextIndices);
            }
            iterator = schema.getTables().iterator();
            while (iterator.hasNext()) {
                MsTable table;
                MsTable msTable = table = (MsTable)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msTable, (String)"table");
                this.removeUnexistentIndices(msTable, existentIndicesCombies, tablesWithFulltextIndices);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void removeUnexistentIndices(MsStoredTable table, TLongHashSet existentIndicesCombies, TLongHashSet tablesWithFulltextIndices) {
            void $this$filterTo$iv$iv;
            ModPositioningNamingFamily<? extends MsIndex> modPositioningNamingFamily = table.getIndices();
            Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"table.indices");
            Iterable $this$filter$iv22 = (Iterable)modPositioningNamingFamily;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv22;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MsIndex it = (MsIndex)element$iv$iv;
                boolean bl = false;
                MsIndex msIndex = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)msIndex, (String)"it");
                boolean bl2 = msIndex.isFulltext() ? !tablesWithFulltextIndices.contains(table.getObjectId()) : !existentIndicesCombies.contains(table.getObjectId() * 100000L + (long)it.getPosition());
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List droppedIndices = (List)destination$iv$iv;
            int $this$filter$iv22 = droppedIndices.size() - 1;
            boolean bl = false;
            while ($this$filter$iv22 >= 0) {
                void i2;
                ((MsIndex)droppedIndices.get((int)i2)).drop();
                --i2;
            }
        }

        @Override
        protected void retrieveMajorNames() {
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveRules();
            this.retrieveCustomTypes();
            this.retrieveMajorObjects();
            this.retrieveColumns();
            this.retrieveIndices();
            this.retrieveFulltextIndices();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveArguments();
            this.retrieveTriggers();
            this.retrieveSynonyms();
            this.retrieveSequences();
            this.retrieveDescription();
            this.retrieveSources();
        }

        private final void retrieveRules() {
            if (this.this$0.getServerVersion().less(new int[]{13})) {
                return;
            }
            this.progress("retrieving rules");
            SqlQuery<List<MsIntroQueries.OneRule>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveRules;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveRules");
            List rules = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(rules){
                final /* synthetic */ List $rules;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    boolean $i$f$cleanupFamilies = false;
                    Function1 it = MsSchemaRetriever$retrieveRules$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                    boolean bl = false;
                    ModNamingIdentifyingFamily<? extends MsRule> modNamingIdentifyingFamily = schema.getRules();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.rules");
                    it.invoke(modNamingIdentifyingFamily);
                    boolean bl2 = false;
                    for (MsIntroQueries.OneRule r : this.$rules) {
                        BasicModNamedElement basicModNamedElement = schema.getRules().renew(r.object_id, r.name);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        MsRule it2 = (MsRule)basicModNamedElement;
                        boolean bl5 = false;
                        MsRule msRule = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)msRule, (String)"it");
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(msRule, r.create_date, r.modify_date);
                    }
                    it = MsSchemaRetriever$retrieveRules$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                    $i$a$-cleanupFamilies-MsIntrospector$MsSchemaRetriever$retrieveRules$1$1 = false;
                    ModNamingIdentifyingFamily<? extends MsRule> modNamingIdentifyingFamily2 = schema.getRules();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.rules");
                    it.invoke(modNamingIdentifyingFamily2);
                }
                {
                    this.$rules = list;
                    super(1);
                }
            });
        }

        private final void retrieveCustomTypes() {
            Object v2;
            List<MsIntroQueries.OneCustomTypesCheckSum> checkSums;
            block4: {
                if (Intrinsics.areEqual((Object)((MsSchema)this.getSchema()).getName(), (Object)"sys") && this.getMode().increment) {
                    return;
                }
                this.progress("retrieving user defined types");
                SqlQuery<List<MsIntroQueries.OneCustomTypesCheckSum>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.calculateCustomTypesCheckSums;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.calculateCustomTypesCheckSums");
                List<MsIntroQueries.OneCustomTypesCheckSum> list = checkSums = this.performQuery(sqlQuery);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"checkSums");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MsIntroQueries.OneCustomTypesCheckSum it = (MsIntroQueries.OneCustomTypesCheckSum)element$iv;
                    boolean bl = false;
                    if (!(it.type_kind == 1)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            MsIntroQueries.OneCustomTypesCheckSum oneCustomTypesCheckSum = v2;
            long aliasTypesCheckSum = oneCustomTypesCheckSum != null ? oneCustomTypesCheckSum.check_sum : 0L;
            this.processAliasTypes(aliasTypesCheckSum);
            if (this.this$0.myVer10) {
                Object v4;
                block5: {
                    Iterable $this$firstOrNull$iv = checkSums;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        MsIntroQueries.OneCustomTypesCheckSum it = (MsIntroQueries.OneCustomTypesCheckSum)element$iv;
                        boolean bl = false;
                        if (!(it.type_kind == 2)) continue;
                        v4 = element$iv;
                        break block5;
                    }
                    v4 = null;
                }
                MsIntroQueries.OneCustomTypesCheckSum oneCustomTypesCheckSum2 = v4;
                long tableTypesCheckSum = oneCustomTypesCheckSum2 != null ? oneCustomTypesCheckSum2.check_sum : 0L;
                this.processTableTypes(tableTypesCheckSum);
            }
        }

        private final void processAliasTypes(long aliasTypesCheckSum) {
            if (aliasTypesCheckSum == 0L) {
                this.inSchema(processAliasTypes.1.INSTANCE);
                return;
            }
            if (((MsSchema)this.getSchema()).getAliasTypesCheckSum() == aliasTypesCheckSum) {
                return;
            }
            SqlQuery<List<MsIntroQueries.OneAliasType>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveAliasTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveAliasTypes");
            List cas = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(cas){
                final /* synthetic */ List $cas;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.getAliasTypes().markChildrenAsSyncPending();
                    for (MsIntroQueries.OneAliasType at : this.$cas) {
                        MsAliasType aliasType;
                        ModNamingIdentifyingFamily<? extends MsAliasType> modNamingIdentifyingFamily = schema.getAliasTypes();
                        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.aliasTypes");
                        ModNamingFamily modNamingFamily = (ModNamingFamily)modNamingIdentifyingFamily;
                        int n = at.type_id;
                        String string = at.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"at.name");
                        MsAliasType msAliasType = aliasType = (MsAliasType)MsIntrospectorKt.access$renewType(modNamingFamily, n, string);
                        Intrinsics.checkExpressionValueIsNotNull((Object)msAliasType, (String)"aliasType");
                        msAliasType.setNotNull(!at.is_nullable);
                        if (at.base_name != null) {
                            DataType dt = MsIntrospectorKt.access$makeDataType(at.base_name, at.max_length, at.precision, at.scale);
                            aliasType.setDataType(dt);
                            continue;
                        }
                        aliasType.setDataType(DataType.UNKNOWN);
                    }
                    schema.getAliasTypes().removeSyncPendingChildren();
                    schema.getAliasTypes().sort();
                }
                {
                    this.$cas = list;
                    super(1);
                }
            });
        }

        private final void processTableTypes(long tableTypesCheckSum) {
            if (tableTypesCheckSum == 0L) {
                this.inSchema(processTableTypes.1.INSTANCE);
                return;
            }
            if (((MsSchema)this.getSchema()).getTableTypesCheckSum() == tableTypesCheckSum) {
                return;
            }
            SqlQuery<List<MsIntroQueries.OneTableType>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTableTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTableTypes");
            List tts = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(tts){
                final /* synthetic */ List $tts;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.getTableTypes().markChildrenAsSyncPending();
                    for (MsIntroQueries.OneTableType tt : this.$tts) {
                        MsTableType tableType;
                        ModNamingIdentifyingFamily<? extends MsTableType> modNamingIdentifyingFamily = schema.getTableTypes();
                        Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.tableTypes");
                        ModNamingFamily modNamingFamily = (ModNamingFamily)modNamingIdentifyingFamily;
                        int n = tt.type_id;
                        String string = tt.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tt.name");
                        MsTableType msTableType = tableType = (MsTableType)MsIntrospectorKt.access$renewType(modNamingFamily, n, string);
                        Intrinsics.checkExpressionValueIsNotNull((Object)msTableType, (String)"tableType");
                        msTableType.setObjectId(tt.object_id);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(tableType, tt.create_date, tt.modify_date);
                    }
                    schema.getTableTypes().removeSyncPendingChildren();
                    schema.getTableTypes().sort();
                }
                {
                    this.$tts = list;
                    super(1);
                }
            });
            this.retrieveTypeColumns();
            this.retrieveTypeIndices();
            this.retrieveTypeKeys();
            this.retrieveTypeCheckConstraints();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveMajorObjects() {
            void tableTypesWereTouched;
            void viewsWereTouched;
            void tablesWereTouched;
            this.progress("retrieving tables, views, procedures and functions");
            SqlQuery<List<MsIntroQueries.OneObject>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveObjects;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveObjects");
            List os = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (os.isEmpty()) {
                return;
            }
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
            booleanRef2.element = false;
            Ref.BooleanRef booleanRef3 = new Ref.BooleanRef();
            booleanRef3.element = false;
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, os, (Ref.BooleanRef)tablesWereTouched, (Ref.BooleanRef)viewsWereTouched, (Ref.BooleanRef)tableTypesWereTouched){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $os;
                final /* synthetic */ Ref.BooleanRef $tablesWereTouched;
                final /* synthetic */ Ref.BooleanRef $viewsWereTouched;
                final /* synthetic */ Ref.BooleanRef $tableTypesWereTouched;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (MsIntroQueries.OneObject o : this.$os) {
                        MsSchemaObject obj2 = null;
                        if (o.type == null) continue;
                        if (Intrinsics.areEqual((Object)o.type, (Object)"U") || Intrinsics.areEqual((Object)o.type, (Object)"S") || Intrinsics.areEqual((Object)o.type, (Object)"IT")) {
                            BasicModNamedElement basicModNamedElement = schema.getTables().renew((long)o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)basicModNamedElement, (String)"schema.tables.renew(o.object_id.toLong(), o.name)");
                            obj2 = (MsSchemaObject)basicModNamedElement;
                            this.$tablesWereTouched.element = true;
                        } else if (Intrinsics.areEqual((Object)o.type, (Object)"V")) {
                            BasicModNamedElement basicModNamedElement = schema.getViews().renew((long)o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)basicModNamedElement, (String)"schema.views.renew(o.object_id.toLong(), o.name)");
                            obj2 = (MsSchemaObject)basicModNamedElement;
                            this.$viewsWereTouched.element = true;
                        } else if (Intrinsics.areEqual((Object)o.type, (Object)"TT")) {
                            BasicModNamedElement basicModNamedElement = schema.getTableTypes().renew((long)o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)basicModNamedElement, (String)"schema.tableTypes.renew(\u2026ject_id.toLong(), o.name)");
                            obj2 = (MsSchemaObject)basicModNamedElement;
                            this.$tableTypesWereTouched.element = true;
                        } else {
                            if (!MsRoutineTypes.MS_ROUTINE_TYPES.keySet().contains(o.type)) continue;
                            MsRoutine routine = (MsRoutine)schema.getRoutines().renew((long)o.object_id, o.name);
                            MsRoutineType routineType = MsRoutineTypes.MS_ROUTINE_TYPES.get(o.type);
                            MsRoutine msRoutine = routine;
                            Intrinsics.checkExpressionValueIsNotNull((Object)msRoutine, (String)"routine");
                            msRoutine.setRoutineType(routineType);
                            Object object = routineType;
                            routine.setRoutineKind(CollectionsKt.contains((Iterable)MsRoutineTypes.MS_FUNCTION_TYPES.values(), (Object)object) ? DasRoutine.Kind.FUNCTION : (CollectionsKt.contains((Iterable)MsRoutineTypes.MS_PROCEDURE_TYPES.values(), (Object)object) ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.NONE));
                            obj2 = routine;
                            routine.getArguments().markChildrenAsSyncPending();
                            object = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0);
                            boolean bl = false;
                            object.add(routine);
                        }
                        boolean nameIsSurrogate = MsIntrospectorKt.access$detectSurrogateName(o.name);
                        obj2.setNameSurrogate(nameIsSurrogate);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(obj2, o.create_date, o.modify_date);
                        if (!(obj2 instanceof MsLikeTable)) continue;
                        MsSchemaRetriever.access$getMyTouchedTables$p(this.this$0).add(obj2);
                        ((MsLikeTable)((Object)obj2)).getColumns().markChildrenAsSyncPending();
                    }
                    if (this.$tablesWereTouched.element) {
                        schema.getTables().sort();
                    }
                    if (this.$viewsWereTouched.element) {
                        schema.getViews().sort();
                    }
                    if (this.$tableTypesWereTouched.element) {
                        schema.getTableTypes().sort();
                    }
                    Collection collection = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0);
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        schema.getRoutines().sort();
                    }
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$os = list;
                    this.$tablesWereTouched = booleanRef;
                    this.$viewsWereTouched = booleanRef2;
                    this.$tableTypesWereTouched = booleanRef3;
                    super(1);
                }
            });
        }

        private final void retrieveColumns() {
            if (this.myTouchedTables.isEmpty() && this.myTouchedRoutines.isEmpty()) {
                return;
            }
            this.progress("retrieving columns of tables and views");
            SqlQuery<List<MsIntroQueries.OneColumn>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveColumns");
            List cols2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.processColumns(cols2);
        }

        private final void retrieveTypeColumns() {
            this.progress("retrieving columns of custom table types");
            SqlQuery<List<MsIntroQueries.OneColumn>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTypeColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTypeColumns");
            List cols2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.processColumns(cols2);
        }

        private final void processColumns(List<MsIntroQueries.OneColumn> cols2) {
            HashSet affectedCursors = new HashSet(cols2.size() / 3);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, cols2, affectedCursors){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $cols;
                final /* synthetic */ HashSet $affectedCursors;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    cursor = null;
                    object_id = 0;
                    for (MsIntroQueries.OneColumn col : this.$cols) {
                        block11: {
                            if (object_id == col.object_id && cursor != null) break block11;
                            object_id = col.object_id;
                            var6_6 = (BasicSchema)schema;
                            objectId$iv = object_id;
                            $i$f$findById = false;
                            v0 = $this$findById$iv.getDatabase();
                            if (v0 == null) ** GOTO lbl-1000
                            $this$findById$iv$iv = v0;
                            $i$f$findById = false;
                            v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                            if (!(v1 instanceof MsLikeTable)) {
                                v1 = null;
                            }
                            if ((v0 = (BasicIdentifiedElement)((MsLikeTable)v1)) != null) {
                                $this$findById$iv$iv = v0;
                                var11_14 = false;
                                var12_15 = false;
                                it$iv = $this$findById$iv$iv;
                                $i$a$-takeIf-ModelFun$findById$1$iv = false;
                                v2 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? $this$findById$iv$iv : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 /* !! */  = null;
                            }
                            if ((cursor = (MsLikeTable)v2 /* !! */ ) == null) continue;
                            if (col.column_position == 1) {
                                cursor.getColumns().markChildrenAsSyncPending();
                                if (cursor instanceof MsStoredTable) {
                                    ((MsStoredTable)cursor).getDefaultConstraints().markChildrenAsSyncPending();
                                }
                            }
                            this.$affectedCursors.add(cursor);
                        }
                        v3 = column = (MsLikeColumn)cursor.getColumns().createOrGet(col.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"column");
                        v3.setPosition(col.column_position);
                        column.setNotNull(col.is_nullable == false);
                        dt = MsIntrospectorKt.access$makeDataType(col.type_name, col.max_length, col.precision, col.scale);
                        column.setDataType(dt);
                        isTimestamp = Intrinsics.areEqual((Object)col.type_name, (Object)"timestamp");
                        defaultExpression = MsIntrospector.access$getHelper$p(this.this$0.this$0).normalizeExpression(col.default_expression);
                        column.setDefaultExpression(defaultExpression);
                        if (column instanceof MsStoredColumn) {
                            ((MsStoredColumn)column).setComputed(col.is_computed != false || isTimestamp != false);
                            ((MsStoredColumn)column).setHidden(col.is_hidden);
                            ((MsStoredColumn)column).setSparse(col.is_sparse);
                            ((MsStoredColumn)column).setColumnSet(col.is_column_set);
                            if (col.identity_seed_value != null || col.identity_increment_value != null || col.identity_last_value != null) {
                                next = col.identity_last_value != null ? Long.valueOf(col.identity_last_value + 1L) : null;
                                ((MsStoredColumn)column).setSequenceIdentity(SequenceIdentity.of((Long)col.identity_seed_value, (Long)next, (Long)col.identity_increment_value, null));
                            } else {
                                ((MsStoredColumn)column).setSequenceIdentity(null);
                            }
                        }
                        defaultConstraintObjectId = col.default_constraint_object_id;
                        defaultConstraintName = col.default_constraint_name;
                        if (defaultConstraintName != null && defaultConstraintObjectId != 0L && cursor instanceof MsStoredTable) {
                            v4 = dc = (MsDefaultConstraint)((MsStoredTable)cursor).getDefaultConstraints().renew(defaultConstraintObjectId, defaultConstraintName);
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"dc");
                            v4.setModifiedTimestamp(col.default_constraint_modify_date);
                            dc.setNameSurrogate(col.default_constraint_name_is_surrogate);
                            dc.setDefaultExpression(defaultExpression);
                            dc.setColNames(Collections.singletonList(column.getName()));
                        }
                        if (!(column instanceof MsStoredColumn)) continue;
                        ((MsStoredColumn)column).setDefaultConstraintName(defaultConstraintName);
                    }
                    var5_4 = this.$affectedCursors.iterator();
                    while (var5_4.hasNext()) {
                        v5 = t = (MsLikeTable)var5_4.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"t");
                        v5.getColumns().removeSyncPendingChildren();
                        t.getColumns().sort();
                    }
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$cols = list;
                    this.$affectedCursors = hashSet;
                    super(1);
                }
            });
        }

        private final void retrieveIndices() {
            this.progress("retrieving indices");
            SqlQuery<List<MsIntroQueries.OneIndex>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveIndices");
            List inds = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            SqlQuery<List<MsIntroQueries.OneIndexColumn>> sqlQuery2 = ((MsIntrospector)this.this$0).myQueries.retrieveIndexColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"myQueries.retrieveIndexColumns");
            List ics = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery2, 0, 2, null);
            this.processIndices(inds, ics);
        }

        private final void retrieveFulltextIndices() {
            this.progress("retrieving fulltext indices");
            SqlQuery<List<MsIntroQueries.OneFulltextIndex>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveFulltextIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveFulltextIndices");
            List inds = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            SqlQuery<List<MsIntroQueries.OneFulltextIndexColumn>> sqlQuery2 = ((MsIntrospector)this.this$0).myQueries.retrieveFulltextIndexColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"myQueries.retrieveFulltextIndexColumns");
            List ics = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery2, 0, 2, null);
            this.processFulltextIndices(inds, ics);
        }

        private final void retrieveTypeIndices() {
            this.progress("retrieving indices of custom table types");
            SqlQuery<List<MsIntroQueries.OneIndex>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTypeIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTypeIndices");
            List inds = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            SqlQuery<List<MsIntroQueries.OneIndexColumn>> sqlQuery2 = ((MsIntrospector)this.this$0).myQueries.retrieveTypeIndexColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"myQueries.retrieveTypeIndexColumns");
            List ics = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery2, 0, 2, null);
            this.processIndices(inds, ics);
        }

        private final void processIndices(List<MsIntroQueries.OneIndex> inds, List<MsIntroQueries.OneIndexColumn> ics) {
            HashMap indices = new HashMap(inds.size());
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, inds, indices){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $inds;
                final /* synthetic */ HashMap $indices;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (MsIntroQueries.OneIndex ind : this.$inds) {
                        var5_5 = (BasicSchema)schema;
                        objectId$iv = ind.object_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findById$iv$iv = v0;
                        $i$f$findById = false;
                        v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                        if (!(v1 instanceof MsIndexableTable)) {
                            v1 = null;
                        }
                        if ((v0 = (BasicIdentifiedElement)((MsIndexableTable)v1)) != null) {
                            var9_8 = v0;
                            var10_9 = false;
                            var11_10 = false;
                            it$iv = var9_8;
                            $i$a$-takeIf-ModelFun$findById$1$iv = false;
                            v2 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? var9_8 : null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 /* !! */  = null;
                        }
                        if ((MsIndexableTable)v2 /* !! */  == null) {
                            continue;
                        }
                        v3 = index = (MsIndex)t.getIndices().createOrGetAt(ind.position);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"index");
                        v3.setName(ind.name);
                        index.setNameSurrogate(MsIntrospectorKt.access$detectSurrogateName(ind.name));
                        index.setUnique(ind.is_unique);
                        index.setClustering(ind.type == 1);
                        index.setCondition(MsIntrospector.access$getHelper$p(this.this$0.this$0).normalizeExpression(ind.filter_definition));
                        ((Map)this.$indices).put(new MsMinorIdentity(ind.object_id, ind.position), index);
                    }
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$inds = list;
                    this.$indices = hashMap;
                    super(1);
                }
            });
            CollectionAggregator colsA2 = new CollectionAggregator((Function0)processIndices.colsA.1.INSTANCE);
            CollectionAggregator colsI2 = new CollectionAggregator((Function0)processIndices.colsI.1.INSTANCE);
            CollectionAggregator colsR2 = new CollectionAggregator((Function0)processIndices.colsR.1.INSTANCE);
            for (MsIntroQueries.OneIndexColumn ic : ics) {
                MsMinorIdentity key2 = new MsMinorIdentity(ic.object_id, ic.index_position);
                if (!ic.is_included_column) {
                    String string = ic.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ic.name");
                    colsA2.add((Object)key2, (Object)string);
                    if (!ic.is_desc) continue;
                    String string2 = ic.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ic.name");
                    colsR2.add((Object)key2, (Object)string2);
                    continue;
                }
                String string = ic.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ic.name");
                colsI2.add((Object)key2, (Object)string);
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>(colsA2, indices, colsI2, colsR2){
                final /* synthetic */ CollectionAggregator $colsA;
                final /* synthetic */ HashMap $indices;
                final /* synthetic */ CollectionAggregator $colsI;
                final /* synthetic */ CollectionAggregator $colsR;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Object object = this.$colsA.getResult();
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                    while (iterator.hasNext()) {
                        MsIndex index2;
                        void key2;
                        Map.Entry<K, V> entry;
                        Map.Entry<K, V> entry2 = entry = iterator.next();
                        boolean bl2 = false;
                        object = (MsMinorIdentity)entry2.getKey();
                        entry2 = entry;
                        bl2 = false;
                        List names = (List)entry2.getValue();
                        if ((MsIndex)this.$indices.get(key2) == null) {
                            continue;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)index2, (String)"indices[key] ?: continue");
                        index2.setColNames(names);
                        List list = (List)this.$colsI.get((Object)key2);
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        index2.setIncludeColNames(list);
                        Set set = (Set)this.$colsR.get((Object)key2);
                        if (set == null) {
                            set = SetsKt.emptySet();
                        }
                        index2.setReverseColNames(set);
                    }
                }
                {
                    this.$colsA = collectionAggregator;
                    this.$indices = hashMap;
                    this.$colsI = collectionAggregator2;
                    this.$colsR = collectionAggregator3;
                    super(1);
                }
            });
        }

        private final void processFulltextIndices(List<MsIntroQueries.OneFulltextIndex> inds, List<MsIntroQueries.OneFulltextIndexColumn> ics) {
            HashMap indices = new HashMap(inds.size());
            this.inSchema((Function1)new Function1<MsSchema, Unit>(inds, indices){
                final /* synthetic */ List $inds;
                final /* synthetic */ HashMap $indices;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (MsIntroQueries.OneFulltextIndex ind : this.$inds) {
                        var5_5 = (BasicSchema)schema;
                        objectId$iv = ind.object_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findById$iv$iv = v0;
                        $i$f$findById = false;
                        v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                        if (!(v1 instanceof MsStoredTable)) {
                            v1 = null;
                        }
                        if ((v0 = (BasicIdentifiedElement)((MsStoredTable)v1)) != null) {
                            var9_8 = v0;
                            var10_9 = false;
                            var11_10 = false;
                            it$iv = var9_8;
                            $i$a$-takeIf-ModelFun$findById$1$iv = false;
                            v2 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? var9_8 : null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 /* !! */  = null;
                        }
                        if ((MsStoredTable)v2 /* !! */  == null) {
                            continue;
                        }
                        v3 = index = (MsIndex)t.getIndices().createOrGetAt((short)32767);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"index");
                        v3.setName("");
                        index.setFulltext(true);
                        index.setFulltextUniqueIndexId(ind.unique_index_id);
                        ((Map)this.$indices).put(ind.object_id, index);
                    }
                }
                {
                    this.$inds = list;
                    this.$indices = hashMap;
                    super(1);
                }
            });
            CollectionAggregator cols2 = new CollectionAggregator((Function0)processFulltextIndices.cols.1.INSTANCE);
            for (MsIntroQueries.OneFulltextIndexColumn ic : ics) {
                Integer n = ic.object_id;
                String string = ic.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ic.name");
                cols2.add((Object)n, (Object)string);
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>(cols2, indices){
                final /* synthetic */ CollectionAggregator $cols;
                final /* synthetic */ HashMap $indices;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsSchema it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Map map2 = this.$cols.getResult();
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        MsIndex index2;
                        void key2;
                        Map.Entry<K, V> entry;
                        Map.Entry<K, V> entry2 = entry = iterator.next();
                        boolean bl2 = false;
                        int n = ((Number)entry2.getKey()).intValue();
                        entry2 = entry;
                        bl2 = false;
                        List names = (List)entry2.getValue();
                        if ((MsIndex)this.$indices.get((int)key2) == null) {
                            continue;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)index2, (String)"indices[key] ?: continue");
                        index2.setColNames(names);
                    }
                }
                {
                    this.$cols = collectionAggregator;
                    this.$indices = hashMap;
                    super(1);
                }
            });
        }

        private final void retrieveKeys() {
            this.progress("retrieving candidate keys");
            SqlQuery<List<MsIntroQueries.OneKey>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveKeys");
            List ks = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.processKeys(ks);
            Collection collection = ks;
            boolean bl = false;
            if (!collection.isEmpty()) {
                collection = this.this$0.databasesToReResolveForeignKeys;
                MsDatabase msDatabase = ((MsSchema)this.getSchema()).getDatabase();
                if (msDatabase == null) {
                    Intrinsics.throwNpe();
                }
                MsDatabase msDatabase2 = msDatabase;
                boolean bl2 = false;
                collection.add(msDatabase2);
            }
        }

        private final void retrieveTypeKeys() {
            this.progress("retrieving keys of custom table types");
            SqlQuery<List<MsIntroQueries.OneKey>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTypeKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTypeKeys");
            List ks = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.processKeys(ks);
        }

        private final void processKeys(List<MsIntroQueries.OneKey> ks) {
            this.inSchema((Function1)new Function1<MsSchema, Unit>(ks){
                final /* synthetic */ List $ks;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    tables = new HashSet<MsStoredTable>(this.$ks.size());
                    for (MsIntroQueries.OneKey k : this.$ks) {
                        block9: {
                            var6_6 = (BasicSchema)schema;
                            objectId$iv = k.table_id;
                            $i$f$findById = false;
                            v0 = $this$findById$iv.getDatabase();
                            if (v0 == null) ** GOTO lbl-1000
                            $this$findById$iv$iv = v0;
                            $i$f$findById = false;
                            v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                            if (!(v1 instanceof MsStoredTable)) {
                                v1 = null;
                            }
                            if ((v0 = (BasicIdentifiedElement)((MsStoredTable)v1)) != null) {
                                var10_11 = v0;
                                $i$f$findById = false;
                                var12_14 = false;
                                it$iv = var10_11;
                                $i$a$-takeIf-ModelFun$findById$1$iv = false;
                                v2 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? var10_11 : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 /* !! */  = null;
                            }
                            if ((MsStoredTable)v2 /* !! */  == null) {
                                continue;
                            }
                            v3 = key = (MsKey)table.getKeys().renew((long)k.key_id, k.name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"key");
                            v3.setNameSurrogate(k.is_system_named);
                            key.setPrimary(k.is_primary);
                            MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(key, k.create_date, k.modify_date);
                            v4 = table.getIndices();
                            Intrinsics.checkExpressionValueIsNotNull(v4, (String)"table.indices");
                            $this$firstOrNull$iv = (Iterable)v4;
                            $i$f$firstOrNull = false;
                            for (E element$iv : $this$firstOrNull$iv) {
                                ind = (MsIndex)element$iv;
                                $i$a$-firstOrNull-MsIntrospector$MsSchemaRetriever$processKeys$1$index$1 = false;
                                v5 = ind;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"ind");
                                if (!(v5.getPosition() == k.index_position)) continue;
                                v6 = element$iv;
                                break block9;
                            }
                            v6 = null;
                        }
                        index = v6;
                        if (index != null) {
                            key.setUnderlyingIndexName(index.getRealName());
                            key.setColNames(index.getColNames());
                            index.setNameSurrogate(k.is_system_named);
                        } else {
                            key.setUnderlyingIndexName(null);
                            key.setColNames(CollectionsKt.emptyList());
                        }
                        tables.add(table);
                    }
                    var4_3 = tables.iterator();
                    while (var4_3.hasNext()) {
                        v7 = table = (MsStoredTable)var4_3.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"table");
                        v7.getKeys().sort();
                    }
                }
                {
                    this.$ks = list;
                    super(1);
                }
            });
        }

        private final void retrieveForeignKeys() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving foreign keys");
            SqlQuery<List<MsIntroQueries.OneForeignKey>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveForeignKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveForeignKeys");
            List fks = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (fks.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, fks){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $fks;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    affectedTables = new HashSet<MsTable>(this.$fks.size());
                    infos = new TLongObjectHashMap(this.$fks.size());
                    for (MsIntroQueries.OneForeignKey fk : this.$fks) {
                        if ((MsTable)schema.getTables().getByObjectId(fk.table_id) == null) {
                            continue;
                        }
                        fkey = (MsForeignKey)table.getForeignKeys().renew(fk.constraint_id, fk.name);
                        v0 = schema.getParentFamily();
                        if (v0 == null) {
                            Intrinsics.throwNpe();
                        }
                        refSchema = (MsSchema)v0.getByObjectId(fk.referenced_schema_id);
                        v1 = fkey;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"fkey");
                        v1.setNameSurrogate(fk.is_system_named);
                        fkey.setRefTableId(fk.referenced_object_id);
                        fkey.setRefTableName(fk.referenced_object_name);
                        v2 = fkey;
                        v3 = refSchema;
                        if (v3 == null) ** GOTO lbl-1000
                        var9_12 = v3;
                        var15_21 = v2;
                        var10_13 = false;
                        var11_15 = false;
                        it = var9_12;
                        $i$a$-takeIf-MsIntrospector$MsSchemaRetriever$retrieveForeignKeys$1$1 = false;
                        var16_22 = (Intrinsics.areEqual((Object)it, (Object)schema) ^ true) != false ? var9_12 : null;
                        v2 = var15_21;
                        v3 = var16_22;
                        if (v3 != null) {
                            v4 = v3.getRealName();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = null;
                        }
                        v2.setRefSchemaName(v4);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(fkey, fk.create_date, fk.modify_date);
                        fkey.setOnUpdate(MsIntrospectorKt.access$makeCascadeRule(fk.update_referential_action));
                        fkey.setOnDelete(MsIntrospectorKt.access$makeCascadeRule(fk.delete_referential_action));
                        fki = new ForeignKeyInfo(fkey, refSchema);
                        fki.setDomTableId(fk.table_id);
                        fki.setRefTableId(fk.referenced_object_id);
                        infos.put(fk.constraint_id, (Object)fki);
                        affectedTables.add(table);
                    }
                    v5 = MsIntrospector.access$getMyQueries$p((MsIntrospector)this.this$0.this$0).retrieveForeignKeyColumns;
                    Intrinsics.checkExpressionValueIsNotNull(v5, (String)"myQueries.retrieveForeignKeyColumns");
                    fcs = BaseIntrospector.AbstractRetriever.performQueryForList$default(this.this$0, v5, 0, 2, null);
                    for (MsIntroQueries.OneForeignKeyColumn fc : fcs) {
                        fki = (ForeignKeyInfo)infos.get(fc.constraint_id);
                        if (fc.domestic_column_name == null) {
                            continue;
                        }
                        if (fc.reference_column_name == null) {
                            continue;
                        }
                        if (fki == null) continue;
                        fki.getDomColumnNames().add((Object)domesticColumnName);
                        fki.getRefColumnNames().add((Object)referenceColumnName);
                    }
                    var7_9 = infos.getValues();
                    var8_11 = var7_9.length;
                    for (var6_7 = 0; var6_7 < var8_11; ++var6_7) {
                        v6 = o = var7_9[var6_7];
                        if (v6 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.mssql.introspector.ForeignKeyInfo");
                        }
                        fki = (ForeignKeyInfo)v6;
                        fki.getFkey().setColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getDomColumnNames())));
                        fki.getFkey().setRefColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getRefColumnNames())));
                        v7 = fki.getRefSchema();
                        v8 = v7 != null && (v7 = v7.getTables()) != null ? (MsTable)v7.getByObjectId(fki.getRefTableId()) : (refTable = null);
                        if (refTable != null) {
                            refKey = MsIntrospectorKt.access$findKeyByColumns(refTable, (List)fki.getRefColumnNames());
                            v9 = refKey;
                            fki.getFkey().setRefKeyName(v9 != null ? v9.getRealName() : null);
                            if (refKey != null) continue;
                            var12_17 = MsIntrospector.access$getDatabasesToReResolveForeignKeys$p(this.this$0.this$0);
                            if (schema.getDatabase() == null) {
                                Intrinsics.throwNpe();
                            }
                            var14_23 = false;
                            var12_17.add(var13_19);
                            continue;
                        }
                        var11_16 = MsIntrospector.access$getDatabasesToReResolveForeignKeys$p(this.this$0.this$0);
                        if (schema.getDatabase() == null) {
                            Intrinsics.throwNpe();
                        }
                        var13_20 = false;
                        var11_16.add(var12_17);
                    }
                    var6_8 = affectedTables.iterator();
                    while (var6_8.hasNext()) {
                        v10 = table = (MsTable)var6_8.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"table");
                        v10.getForeignKeys().sort();
                    }
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$fks = list;
                    super(1);
                }
            });
        }

        private final void retrieveCheckConstraints() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving check constraints");
            SqlQuery<List<MsIntroQueries.OneCheckConstraints>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveCheckConstraints;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveCheckConstraints");
            List cs = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.processCheckConstraints(cs);
        }

        private final void retrieveTypeCheckConstraints() {
            this.progress("retrieving check constraints of custom table types");
            SqlQuery<List<MsIntroQueries.OneCheckConstraints>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTypeCheckConstraints;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTypeCheckConstraints");
            List cs = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.processCheckConstraints(cs);
        }

        private final void processCheckConstraints(List<MsIntroQueries.OneCheckConstraints> cs) {
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, cs){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $cs;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    affectedTables = new HashSet<MsStoredTable>(this.$cs.size());
                    for (MsIntroQueries.OneCheckConstraints c : this.$cs) {
                        var6_6 = (BasicSchema)schema;
                        objectId$iv = c.table_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findById$iv$iv = v0;
                        $i$f$findById = false;
                        v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                        if (!(v1 instanceof MsStoredTable)) {
                            v1 = null;
                        }
                        if ((v0 = (BasicIdentifiedElement)((MsStoredTable)v1)) != null) {
                            var10_9 = v0;
                            var11_10 = false;
                            var12_11 = false;
                            it$iv = var10_9;
                            $i$a$-takeIf-ModelFun$findById$1$iv = false;
                            v2 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? var10_9 : null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 /* !! */  = null;
                        }
                        if ((MsStoredTable)v2 /* !! */  == null) {
                            continue;
                        }
                        v3 = check = (MsCheck)table.getChecks().renew((long)c.constraint_id, c.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"check");
                        v3.setNameSurrogate(c.is_system_named);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(check, c.create_date, c.modify_date);
                        if (c.column_name != null) {
                            check.setColNames(Collections.singletonList(c.column_name));
                        } else {
                            check.setColNames(CollectionsKt.emptyList());
                        }
                        check.setPredicate(MsIntrospector.access$getHelper$p(this.this$0.this$0).normalizeExpression(c.definition));
                        affectedTables.add(table);
                    }
                    var4_3 = affectedTables.iterator();
                    while (var4_3.hasNext()) {
                        v4 = table = (MsStoredTable)var4_3.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"table");
                        v4.getChecks().sort();
                    }
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$cs = list;
                    super(1);
                }
            });
        }

        private final void retrieveSynonyms() {
            this.progress("retrieving synonyms");
            SqlQuery<List<MsIntroQueries.OneSynonym>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveSynonyms");
            List ss = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (ss.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>(ss){
                final /* synthetic */ List $ss;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (MsIntroQueries.OneSynonym s : this.$ss) {
                        MsSynonym synonym2;
                        MsSynonym msSynonym = synonym2 = (MsSynonym)schema.getSynonyms().renew(s.object_id, s.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)msSynonym, (String)"synonym");
                        msSynonym.setTargetSchemaName(s.origin_schema_name);
                        synonym2.setTargetObjectName(s.origin_object_name);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(synonym2, s.create_date, s.modify_date);
                    }
                    schema.getSynonyms().sort();
                }
                {
                    this.$ss = list;
                    super(1);
                }
            });
        }

        private final void retrieveSequences() {
            if (this.this$0.getServerVersion().less(new int[]{11})) {
                return;
            }
            this.progress("retrieving sequences");
            SqlQuery<List<MsIntroQueries.OneSequence>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveSequences;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveSequences");
            List sequences = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, sequences){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $sequences;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    boolean $i$f$cleanupFamilies = false;
                    Function1 it = MsSchemaRetriever$retrieveSequences$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                    boolean bl = false;
                    ModNamingIdentifyingFamily<? extends MsSequence> modNamingIdentifyingFamily = schema.getSequences();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.sequences");
                    it.invoke(modNamingIdentifyingFamily);
                    boolean bl2 = false;
                    for (MsIntroQueries.OneSequence s : this.$sequences) {
                        long l;
                        MsSequence sequence;
                        MsSequence msSequence = sequence = (MsSequence)schema.getSequences().renew(s.object_id, s.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)msSequence, (String)"sequence");
                        msSequence.setCycled(s.is_cycling);
                        if (s.is_cached) {
                            Long l2 = s.cache_size;
                            l = l2 != null ? l2 : 0L;
                        } else {
                            l = -1L;
                        }
                        sequence.setCacheSize(l);
                        MsIntroQueries.OneSequence oneSequence = s;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oneSequence, (String)"s");
                        sequence.setSequenceIdentity(MsSchemaRetriever.access$getSequenceIdentity(this.this$0, oneSequence));
                        sequence.setDataType(MsSchemaRetriever.access$getDataType(this.this$0, s, false));
                        sequence.setUnderlyingDataType(MsSchemaRetriever.access$getDataType(this.this$0, s, true));
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(sequence, s.create_date, s.modify_date);
                    }
                    it = MsSchemaRetriever$retrieveSequences$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                    $i$a$-cleanupFamilies-MsIntrospector$MsSchemaRetriever$retrieveSequences$1$1 = false;
                    ModNamingIdentifyingFamily<? extends MsSequence> modNamingIdentifyingFamily2 = schema.getSequences();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.sequences");
                    it.invoke(modNamingIdentifyingFamily2);
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$sequences = list;
                    super(1);
                }
            });
        }

        private final BigInteger asBigInteger(@NotNull Object $this$asBigInteger) {
            BigInteger bigInteger;
            Object object = $this$asBigInteger;
            if (object instanceof Number) {
                long l = ((Number)$this$asBigInteger).longValue();
                boolean bl = false;
                BigInteger bigInteger2 = BigInteger.valueOf(l);
                bigInteger = bigInteger2;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"BigInteger.valueOf(this)");
            } else {
                bigInteger = object instanceof BigInteger ? (BigInteger)$this$asBigInteger : (object instanceof BigDecimal ? ((BigDecimal)$this$asBigInteger).toBigInteger() : null);
            }
            return bigInteger;
        }

        private final SequenceIdentity getSequenceIdentity(@NotNull MsIntroQueries.OneSequence $this$getSequenceIdentity) {
            BigInteger bigInteger;
            BigInteger max;
            Object object = $this$getSequenceIdentity.current_value;
            BigInteger currentValue = object != null ? this.asBigInteger(object) : null;
            Object object2 = $this$getSequenceIdentity.start_value;
            BigInteger startValue = object2 != null ? this.asBigInteger(object2) : null;
            Object object3 = $this$getSequenceIdentity.increment;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"increment");
            BigInteger increment = this.asBigInteger(object3);
            Object object4 = $this$getSequenceIdentity.minimum_value;
            BigInteger min = object4 != null ? this.asBigInteger(object4) : null;
            Object object5 = $this$getSequenceIdentity.maximum_value;
            BigInteger bigInteger2 = max = object5 != null ? this.asBigInteger(object5) : null;
            if (currentValue != null && increment != null) {
                BigInteger bigInteger3 = currentValue;
                boolean bl = false;
                BigInteger bigInteger4 = bigInteger3.add(increment);
                bigInteger = bigInteger4;
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger4, (String)"this.add(other)");
            } else {
                bigInteger = startValue;
            }
            BigInteger nextValue = bigInteger;
            SequenceIdentity sequenceIdentity = SequenceIdentity.of((BigInteger)min, (BigInteger)nextValue, (BigInteger)increment, (BigInteger)max);
            Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity, (String)"SequenceIdentity.of(min,\u2026extValue, increment, max)");
            return sequenceIdentity;
        }

        private final DataType getDataType(@NotNull MsIntroQueries.OneSequence $this$getDataType, boolean isUnderlying) {
            String string;
            String schemaName;
            String string2;
            if (isUnderlying) {
                String string3 = $this$getDataType.type_schema_name;
                if (string3 != null) {
                    String string4 = string3;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string4;
                    boolean bl3 = false;
                    string2 = !StringsKt.equals((String)it, (String)"sys", (boolean)true) ? string4 : null;
                } else {
                    string2 = null;
                }
            } else {
                string2 = schemaName = null;
            }
            if ((string = isUnderlying ? $this$getDataType.system_type_name : $this$getDataType.type_name) == null) {
                string = "bigint";
            }
            String typeName = string;
            int length = StringsKt.equals((String)typeName, (String)"numeric", (boolean)true) || StringsKt.equals((String)typeName, (String)"decimal", (boolean)true) ? $this$getDataType.precision : -1;
            DataType dataType = DataTypeFactory.of((String)schemaName, (String)typeName, (int)length, (int)0, null, null, (boolean)false, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(schem\u2026null, null, false, false)");
            return dataType;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveArguments() {
            void wasDefaults;
            if (this.myTouchedRoutines.isEmpty()) {
                return;
            }
            this.progress("retrieving procedures' and functions' parameters");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            SqlQuery<List<MsIntroQueries.OneArguments>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveArguments");
            List args2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, args2, (Ref.BooleanRef)wasDefaults){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $args;
                final /* synthetic */ Ref.BooleanRef $wasDefaults;

                public final void invoke(@NotNull MsSchema schema) {
                    MsRoutine routine;
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Iterator<E> iterator = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        MsRoutine msRoutine = routine = (MsRoutine)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)msRoutine, (String)"routine");
                        msRoutine.getArguments().markChildrenAsSyncPending();
                    }
                    for (MsIntroQueries.OneArguments a : this.$args) {
                        ArgumentDirection d;
                        MsRoutine routine2;
                        MsArgument argument;
                        block7: {
                            block8: {
                                if ((MsRoutine)schema.getRoutines().getByObjectId((long)a.object_id) == null) {
                                    continue;
                                }
                                MsArgument msArgument = argument = (MsArgument)routine2.getArguments().createOrGet(a.name);
                                Intrinsics.checkExpressionValueIsNotNull((Object)msArgument, (String)"argument");
                                msArgument.setPosition(a.position);
                                ArgumentDirection argumentDirection = a.is_cursor_ref ? ArgumentDirection.RESULT : (d = a.is_output ? ArgumentDirection.OUT : ArgumentDirection.IN);
                                if (d != ArgumentDirection.OUT) break block7;
                                if (a.name == null) break block8;
                                String string = a.name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.name");
                                CharSequence charSequence = string;
                                boolean bl = false;
                                if (!(charSequence.length() == 0)) break block7;
                            }
                            d = ArgumentDirection.RETURN;
                        }
                        argument.setArgumentDirection(d);
                        DataType dt = MsIntrospectorKt.access$makeDataType(a.type_name, a.max_length, a.precision, a.scale);
                        argument.setDataType(dt);
                        argument.resetSyncPending();
                        this.$wasDefaults.element |= a.has_default_value;
                        Collection collection = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0);
                        boolean bl = false;
                        collection.add(routine2);
                    }
                    iterator = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        MsRoutine msRoutine = routine = (MsRoutine)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)msRoutine, (String)"routine");
                        msRoutine.getArguments().removeSyncPendingChildren();
                    }
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$args = list;
                    this.$wasDefaults = booleanRef;
                    super(1);
                }
            });
        }

        private final void retrieveTriggers() {
            ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily = ((MsSchema)this.getSchema()).getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.tables");
            boolean bl = modNamingIdentifyingFamily.isEmpty();
            ModNamingIdentifyingFamily<? extends MsView> modNamingIdentifyingFamily2 = ((MsSchema)this.getSchema()).getViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.views");
            if (bl & modNamingIdentifyingFamily2.isEmpty()) {
                return;
            }
            this.progress("retrieving triggers");
            SqlQuery<List<MsIntroQueries.OneTrigger>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTriggers;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTriggers");
            List ts2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (ts2.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>(ts2){
                final /* synthetic */ List $ts;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    affectedTables = new HashSet<MsTableOrView>(this.$ts.size());
                    for (MsIntroQueries.OneTrigger t : this.$ts) {
                        var6_6 = (BasicSchema)schema;
                        objectId$iv = t.table_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findById$iv$iv = v0;
                        $i$f$findById = false;
                        v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                        if (!(v1 instanceof MsTableOrView)) {
                            v1 = null;
                        }
                        if ((v0 = (BasicIdentifiedElement)((MsTableOrView)v1)) != null) {
                            var10_9 = v0;
                            var11_10 = false;
                            var12_11 = false;
                            it$iv = var10_9;
                            $i$a$-takeIf-ModelFun$findById$1$iv = false;
                            v2 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? var10_9 : null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 /* !! */  = null;
                        }
                        if ((MsTableOrView)v2 /* !! */  == null) {
                            continue;
                        }
                        v3 = trigger = (MsTrigger)table.getTriggers().renew(t.trigger_id, t.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"trigger");
                        v3.setEvents(MsIntrospectorKt.access$unpackEvents(t.events));
                        trigger.setFirstEvents(MsIntrospectorKt.access$unpackEvents(t.first_events));
                        trigger.setLastEvents(MsIntrospectorKt.access$unpackEvents(t.last_events));
                        trigger.setTurn(t.is_instead_of_trigger != false ? TrigTurn.INSTEAD_OF : TrigTurn.AFTER_STMT);
                        trigger.setNotForReplication(t.is_not_for_replication);
                        trigger.setDisabled(t.is_disabled);
                        trigger.setEncrypted(t.encrypted);
                        trigger.setCreatedTimestamp(t.create_date);
                        trigger.setModifiedTimestamp(t.modify_date);
                        affectedTables.add(table);
                    }
                    var4_3 = affectedTables.iterator();
                    while (var4_3.hasNext()) {
                        v4 = table = (MsTableOrView)var4_3.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"table");
                        v4.getTriggers().sort();
                    }
                }
                {
                    this.$ts = list;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDescription() {
            void $this$groupByTo$iv$iv;
            this.progress("retrieving tables' descriptions");
            long checksum = 0L;
            try {
                Long checksumOrNull;
                SqlQuery<Long> sqlQuery = ((MsIntrospector)this.this$0).myQueries.calculateExtendedPropertiesChecksum;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.calculateExtendedPropertiesChecksum");
                Long l = checksumOrNull = this.performQuery(sqlQuery);
                checksum = l != null ? l : 0L;
            }
            catch (Exception e) {
                String message = "Failed to calculate checksum of descriptions in schema " + ((MsSchema)this.getSchema()).getName() + ": exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
                if (this.this$0.getLog().isDebugEnabled()) {
                    this.this$0.getLog().warn(message, (Throwable)e);
                } else {
                    this.this$0.getLog().warn(message);
                }
                return;
            }
            if (checksum == ((MsSchema)this.getSchema()).getDescriptionsCheckSum()) {
                return;
            }
            SqlQuery<List<MsIntroQueries.OneProperty>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveExtendedProperties;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveExtendedProperties");
            List ds = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            Iterable $this$groupBy$iv = ds;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                MsIntroQueries.OneProperty d = (MsIntroQueries.OneProperty)element$iv$iv;
                boolean bl = false;
                ExtPropId key$iv$iv = new ExtPropId(d.object_id, d.position);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map descriptions = destination$iv$iv;
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, descriptions, checksum){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ Map $descriptions;
                final /* synthetic */ long $checksum;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    ModNamingIdentifyingFamily<? extends MsSequence> modNamingIdentifyingFamily = schema.getSequences();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.sequences");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)modNamingIdentifyingFamily, this.$descriptions);
                    ModNamingIdentifyingFamily<? extends MsAliasType> modNamingIdentifyingFamily2 = schema.getAliasTypes();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.aliasTypes");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)modNamingIdentifyingFamily2, this.$descriptions);
                    ModNamingIdentifyingFamily<? extends MsTableType> modNamingIdentifyingFamily3 = schema.getTableTypes();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily3, (String)"schema.tableTypes");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)modNamingIdentifyingFamily3, this.$descriptions);
                    ModNamingIdentifyingFamily<? extends MsRoutine> modNamingIdentifyingFamily4 = schema.getRoutines();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily4, (String)"schema.routines");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)modNamingIdentifyingFamily4, this.$descriptions);
                    ModNamingIdentifyingFamily<? extends MsSynonym> modNamingIdentifyingFamily5 = schema.getSynonyms();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily5, (String)"schema.synonyms");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)modNamingIdentifyingFamily5, this.$descriptions);
                    ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily6 = schema.getTables();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily6, (String)"schema.tables");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)modNamingIdentifyingFamily6, this.$descriptions);
                    ModNamingIdentifyingFamily<? extends MsView> modNamingIdentifyingFamily7 = schema.getViews();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily7, (String)"schema.views");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)modNamingIdentifyingFamily7, this.$descriptions);
                    MsIntrospectorKt.access$setExtProps(schema, (List)this.$descriptions.get(new ExtPropId(schema.getObjectId(), 0)));
                    schema.setDescriptionsCheckSum(this.$checksum);
                }
                {
                    this.this$0 = msSchemaRetriever;
                    this.$descriptions = map2;
                    this.$checksum = l;
                    super(1);
                }
            });
        }

        private final <T extends BasicModIdentifiedElement & MsExtendedPropertiesHolder> void processDescriptions(ModIdentifyingFamily<T> family, Map<ExtPropId, ? extends List<MsIntroQueries.OneProperty>> descriptions) {
            for (BasicModIdentifiedElement obj2 : family) {
                Iterator iterator;
                long l;
                if (obj2 instanceof MsCustomType) {
                    l = ((MsCustomType)obj2).getTypeId();
                } else {
                    BasicModIdentifiedElement basicModIdentifiedElement = obj2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicModIdentifiedElement, (String)"obj");
                    l = basicModIdentifiedElement.getObjectId();
                }
                long objectId = l;
                MsIntrospectorKt.access$setExtProps((MsExtendedPropertiesHolder)obj2, descriptions.get(new ExtPropId(objectId, 0)));
                if (obj2 instanceof MsLikeTable) {
                    iterator = ((MsLikeTable)obj2).getColumns().iterator();
                    while (iterator.hasNext()) {
                        MsLikeColumn column2;
                        MsLikeColumn msLikeColumn = column2 = (MsLikeColumn)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)msLikeColumn, (String)"column");
                        MsIntrospectorKt.access$setExtProps(msLikeColumn, this.getDescription(descriptions, (BasicIdentifiedElement)obj2, column2.getPosition()));
                    }
                }
                if (obj2 instanceof MsTable) {
                    iterator = ((ModPositioningNamingFamily)((MsTable)obj2).getIndices()).iterator();
                    while (iterator.hasNext()) {
                        MsIndex index2;
                        MsIndex msIndex = index2 = (MsIndex)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)msIndex, (String)"index");
                        MsIntrospectorKt.access$setExtProps(msIndex, this.getDescription(descriptions, (BasicIdentifiedElement)obj2, -index2.getPosition()));
                    }
                    ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((MsTable)obj2).getChecks();
                    Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily, (String)"obj.checks");
                    this.processDescriptions((ModIdentifyingFamily)modNamingIdentifyingFamily, descriptions);
                    ModNamingIdentifyingFamily modNamingIdentifyingFamily2 = (ModNamingIdentifyingFamily)((MsTable)obj2).getKeys();
                    Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily2, (String)"obj.keys");
                    this.processDescriptions((ModIdentifyingFamily)modNamingIdentifyingFamily2, descriptions);
                    ModNamingIdentifyingFamily<? extends MsForeignKey> modNamingIdentifyingFamily3 = ((MsTable)obj2).getForeignKeys();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily3, (String)"obj.foreignKeys");
                    this.processDescriptions((ModIdentifyingFamily)modNamingIdentifyingFamily3, descriptions);
                    ModNamingIdentifyingFamily modNamingIdentifyingFamily4 = ((MsTable)obj2).getTriggers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)modNamingIdentifyingFamily4, (String)"obj.triggers");
                    this.processDescriptions((ModIdentifyingFamily)modNamingIdentifyingFamily4, descriptions);
                }
                if (!(obj2 instanceof MsRoutine)) continue;
                iterator = ((MsRoutine)obj2).getArguments().iterator();
                while (iterator.hasNext()) {
                    MsArgument argument;
                    MsArgument msArgument = argument = (MsArgument)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)msArgument, (String)"argument");
                    MsIntrospectorKt.access$setExtProps(msArgument, this.getDescription(descriptions, (BasicIdentifiedElement)obj2, argument.getPosition()));
                }
            }
        }

        private final List<MsIntroQueries.OneProperty> getDescription(Map<ExtPropId, ? extends List<MsIntroQueries.OneProperty>> descriptions, BasicIdentifiedElement obj2, short position) {
            return position == 0 ? null : descriptions.get(new ExtPropId(obj2.getObjectId(), position));
        }

        private final void retrieveSources() {
            SqlQuery<List<MsIntroQueries.OneSource>> query;
            boolean withSysSources;
            if (!this.getWithSources()) {
                return;
            }
            boolean bl = withSysSources = this.this$0.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES;
            if (Intrinsics.areEqual((Object)((MsSchema)this.getSchema()).getName(), (Object)"sys") && !withSysSources) {
                return;
            }
            this.progress("retrieving source texts");
            SqlQuery<List<MsIntroQueries.OneSource>> sqlQuery = query = withSysSources ? ((MsIntrospector)this.this$0).myQueries.retrieveSourcesWithSys : ((MsIntrospector)this.this$0).myQueries.retrieveSources;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List ss = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (ss.isEmpty()) {
                return;
            }
            BaseIntrospector this_$iv = this.this$0;
            boolean $i$f$writeSources = false;
            this_$iv.getModel().writeSources(new Runnable(this, ss){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $ss$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$ss$inlined = list;
                }

                public final void run() {
                    boolean bl = false;
                    MsSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<MsSchema, Unit>(this){
                        final /* synthetic */ MsSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        /*
                         * Unable to fully structure code
                         * Could not resolve type clashes
                         */
                        public final void invoke(@NotNull MsSchema schema) {
                            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                            for (MsIntroQueries.OneSource s : this.this$0.$ss$inlined) {
                                block9: {
                                    if (s.object_id == 0L || s.text == null) continue;
                                    if (s.is_trigger) break block9;
                                    var4_4 = (BasicSchema)schema;
                                    objectId$iv = s.object_id;
                                    $i$f$findById = false;
                                    v0 = $this$findById$iv.getDatabase();
                                    if (v0 == null) ** GOTO lbl-1000
                                    $this$findById$iv$iv = v0;
                                    $i$f$findById = false;
                                    v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                                    if (!(v1 instanceof BasicModIdentifiedElement)) {
                                        v1 = null;
                                    }
                                    if ((v0 = (BasicIdentifiedElement)((BasicModIdentifiedElement)v1)) != null) {
                                        $this$findById$iv$iv = v0;
                                        $i$f$findById = false;
                                        var10_9 = false;
                                        it$iv = $this$findById$iv$iv;
                                        $i$a$-takeIf-ModelFun$findById$1$iv = false;
                                        v2 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? $this$findById$iv$iv : null;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v2 /* !! */  = null;
                                    }
                                    if (!((element = (BasicModIdentifiedElement)v2 /* !! */ ) instanceof MsSourceAware)) continue;
                                    v3 = s.text;
                                    ((MsSourceAware)element).setSourceText((CompositeText)(v3 != null ? BaseIntrospectionFunctions.toCompositeText(v3, CompositeText.Kind.ORIGINAL_TEXT) : null));
                                    continue;
                                }
                                $this$findById$iv = (BasicSchema)schema;
                                objectId$iv = s.parent_id;
                                $i$f$findById = false;
                                v4 = $this$findById$iv.getDatabase();
                                if (v4 == null) ** GOTO lbl-1000
                                $this$findById$iv$iv = v4;
                                $i$f$findById = false;
                                v5 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                                if (!(v5 instanceof MsTableOrView)) {
                                    v5 = null;
                                }
                                if ((v4 = (BasicIdentifiedElement)((MsTableOrView)v5)) != null) {
                                    var8_7 = v4;
                                    var9_8 = false;
                                    var10_9 = false;
                                    it$iv = var8_7;
                                    $i$a$-takeIf-ModelFun$findById$1$iv = false;
                                    v6 /* !! */  = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? var8_7 : null;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v6 /* !! */  = null;
                                }
                                if ((MsTableOrView)v6 /* !! */  == null) {
                                    continue;
                                }
                                if ((MsTrigger)table.getTriggers().getByObjectId(s.object_id) == null) {
                                    continue;
                                }
                                v7 = s.text;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"s.text");
                                trigger.setSourceText((CompositeText)BaseIntrospectionFunctions.toCompositeText(v7, CompositeText.Kind.ORIGINAL_TEXT));
                            }
                        }
                    });
                }
            });
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this){
                final /* synthetic */ MsSchemaRetriever this$0;

                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.setIntrospectionTimestamp(this.this$0.getIntrospectionBeginTimestamp());
                }
                {
                    this.this$0 = msSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void progress(String what) {
            String mode = this.getMode().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((MsSchema)this.getSchema()).getName(), mode);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026(%s)\", schema.name, mode)");
            this.this$0.updateStatus(string, what);
        }

        /*
         * Unable to fully structure code
         */
        public MsSchemaRetriever(@NotNull MsIntrospector $outer, @NotNull DBTransaction transaction, MsSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)$outer, transaction, (BasicModSchema)schema);
            this.this$0 = $outer;
            this.myTouchedTables = new ArrayList<E>();
            this.myTouchedRoutines = new HashSet<E>();
            v0 = schema.getDatabase();
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"schema.database!!");
            $outer.prepareQueryParameters$intellij_database_dialects_mssql((BasicDatabase)v0, this.getQueryParameters());
            existentSourcesVersion = this.getModel().getSchemaSourcesVersion((BasicSchema)schema);
            if (!this.getMode().increment) ** GOTO lbl-1000
            v1 = existentSourcesVersion;
            if ((v1 != null ? v1 : 0L) > 0L) {
                v2 = existentSourcesVersion;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                v3 = new Timestamp(v2);
            } else lbl-1000:
            // 2 sources

            {
                v3 = BaseIntrospectionFunctions.AGES_AGO;
            }
            sourcesSince = v3;
            this.setQueryParameter("schema_id", (int)schema.getObjectId());
            this.setQueryParameter("schema_name", schema.getRealName());
            this.setQueryParameter("since", this.getFromTimestamp());
            this.setQueryParameter("src_since", sourcesSince);
        }

        public static final /* synthetic */ void access$removeUnexistentSchemaObjects(MsSchemaRetriever $this, MsSchema schema, TIntHashSet existentObjectIds) {
            $this.removeUnexistentSchemaObjects(schema, existentObjectIds);
        }

        public static final /* synthetic */ void access$removeUnexistentIndices(MsSchemaRetriever $this, MsSchema schema, TLongHashSet existentIndicesCombies, TLongHashSet tablesWithFulltextIndices) {
            $this.removeUnexistentIndices(schema, existentIndicesCombies, tablesWithFulltextIndices);
        }

        public static final /* synthetic */ HashSet access$getMyTouchedRoutines$p(MsSchemaRetriever $this) {
            return $this.myTouchedRoutines;
        }

        public static final /* synthetic */ ArrayList access$getMyTouchedTables$p(MsSchemaRetriever $this) {
            return $this.myTouchedTables;
        }

        public static final /* synthetic */ SequenceIdentity access$getSequenceIdentity(MsSchemaRetriever $this, MsIntroQueries.OneSequence $this$access_u24getSequenceIdentity) {
            return $this.getSequenceIdentity($this$access_u24getSequenceIdentity);
        }

        public static final /* synthetic */ DataType access$getDataType(MsSchemaRetriever $this, MsIntroQueries.OneSequence $this$access_u24getDataType, boolean isUnderlying) {
            return $this.getDataType($this$access_u24getDataType, isUnderlying);
        }

        public static final /* synthetic */ void access$processDescriptions(MsSchemaRetriever $this, ModIdentifyingFamily family, Map descriptions) {
            $this.processDescriptions(family, descriptions);
        }

        public static final /* synthetic */ void access$inSchema(MsSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }
    }
}

