/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgresbase.PgDialectBase;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgDialect
extends PgDialectBase
implements DatabaseDialect {
    private final Dbms myDbms;

    public PgDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            PgDialect.$$$reportNull$$$0(0);
        }
        super(new TypeHelper.PgTypeHelper(), Casing.create((Case)Case.LOWER, (Case)Case.EXACT));
        this.myDbms = dbms;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            PgDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDbms.getDisplayName();
        if (string == null) {
            PgDialect.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean supportsEmptyTables() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            PgDialect.$$$reportNull$$$0(3);
        }
        if (sequence == null) {
            PgDialect.$$$reportNull$$$0(4);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL((DdlBuilder)builder, (DasObject)sequence, (Boolean)cascade);
        if (ddlBuilder == null) {
            PgDialect.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            PgDialect.$$$reportNull$$$0(6);
        }
        DdlBuilder builder = new DdlBuilder().withDialect((DatabaseDialectEx)this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("select\n  'CREATE SEQUENCE ' || '" + DasUtil.getSchema((DasObject)element) + "' || '.'   || sequence_name\n  || ' INCREMENT BY ' || increment_by\n  || ' MINVALUE ' || min_value\n  || ' MAXVALUE ' || max_value\n  || ' START ' || start_value\n  || ' CACHE ' || cache_value\n  || case when is_cycled then ' CYCLE' else '' end\n  || ';'\nfrom " + builder.qualifiedRef(element).getStatement()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            PgDialect.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @Override
    public boolean canUnquoteAlias(@NotNull String alias, boolean afterAS) {
        if (alias == null) {
            PgDialect.$$$reportNull$$$0(8);
        }
        if (!this.isValidPlainIdentifier(alias)) {
            return false;
        }
        if (afterAS) {
            return true;
        }
        return !DbSqlUtil.getSqlDialect((Dbms)this.getDbms()).getKeywords().contains(alias);
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            PgDialect.$$$reportNull$$$0(9);
        }
        if (qualifier == null) {
            PgDialect.$$$reportNull$$$0(10);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            PgDialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    @Nullable
    public DataType convertUDTToDataType(@NotNull DasUserDefinedType type) {
        Object delegate;
        if (type == null) {
            PgDialect.$$$reportNull$$$0(12);
        }
        if (!((delegate = DbImplUtil.unwrap((DasObject)type)) instanceof PgDefType)) {
            return null;
        }
        List<String> labels = ((PgDefType)delegate).getLabels();
        if (labels.isEmpty()) {
            return null;
        }
        return DataTypeFactory.ofValues(null, null, (String)type.getName(), labels, (boolean)false);
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/PgDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/PgDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canUnquoteAlias";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertUDTToDataType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

