/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.model;

import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.snowflake.model.SFlakeObjectEditorFactory;
import com.intellij.database.dialects.snowflake.model.SFlakeTask;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/snowflake/model/SFlakeModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "", "vars", "", "getName", "kind", "Lcom/intellij/database/model/ObjectKind;", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "intellij.database.dialects.snowflake"})
public final class SFlakeModelHelper
extends ModelHelper {
    public static final SFlakeModelHelper INSTANCE;

    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEDULED_EVENT)) {
            string = "task";
        } else {
            String string2 = super.getName(kind);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.getName(kind)");
        }
        return string;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull String variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars);
        if (e instanceof SFlakeTask) {
            ((SFlakeTask)e).setSchedule("1 minute");
            StringBuilder stringBuilder = new StringBuilder().append("schedule = ");
            String string = ((SFlakeTask)e).getSchedule();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.schedule!!");
            vars.put("schedule", stringBuilder.append(ScriptGeneratorHelperKt.getSqlString(string)).toString());
        }
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return SFlakeObjectEditorFactory.INSTANCE;
    }

    private SFlakeModelHelper() {
    }

    static {
        SFlakeModelHelper sFlakeModelHelper;
        INSTANCE = sFlakeModelHelper = new SFlakeModelHelper();
    }
}

