/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.base.psi.SqlFunctionBodyInjector;
import com.intellij.sql.dialects.cassandra.CassTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassFunctionBodyInjector
extends SqlFunctionBodyInjector {
    @Override
    protected boolean canApply(PsiElement context) {
        return context instanceof SqlStringLiteralExpression && SqlImplUtil.getSqlDialectSafe((PsiElement)context).getDbms().isCassandra();
    }

    @Override
    @Nullable
    protected Pair<Language, String> calcBodyLanguage(@NotNull PsiElement context) {
        SqlStringLiteralExpression stringLiteral;
        SqlCreateFunctionStatementImpl statement;
        if (context == null) {
            CassFunctionBodyInjector.$$$reportNull$$$0(0);
        }
        if ((statement = (SqlCreateFunctionStatementImpl)PsiTreeUtil.getParentOfType((PsiElement)(stringLiteral = (SqlStringLiteralExpression)context), SqlCreateFunctionStatementImpl.class)) == null) {
            return null;
        }
        List clauses = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement, SqlClause.class);
        for (SqlClause clause : clauses) {
            PsiElement child = clause.getFirstChild();
            if (child == null || child.getNode().getElementType() != CassTypes.CASS_LANGUAGE) continue;
            PsiElement languageIdent = PsiTreeUtil.findSiblingForward((PsiElement)child, (IElementType)SqlTokens.SQL_IDENT, null);
            if (languageIdent == null) {
                return null;
            }
            return this.getLangBySpec(languageIdent.getText(), context);
        }
        return null;
    }

    @Override
    @Nullable
    protected Pair<String, String> getPrefixSuffix(@NotNull Language language) {
        if (language == null) {
            CassFunctionBodyInjector.$$$reportNull$$$0(1);
        }
        String prefix = "";
        String suffix2 = "";
        if (language.getID().equals("JAVA")) {
            prefix = "public class MyClass { public static Object main() { ";
            suffix2 = "} }";
        }
        return new Pair((Object)prefix, (Object)suffix2);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<SqlStringLiteralExpressionImpl>> list = Collections.singletonList(SqlStringLiteralExpressionImpl.class);
        if (list == null) {
            CassFunctionBodyInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/psi/CassFunctionBodyInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/psi/CassFunctionBodyInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcBodyLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixSuffix";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

