/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.MsTokens;
import com.intellij.sql.dialects.mssql.MsTypeSystem;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql.dataFlow.MsDFABuildingVisitor;
import com.intellij.sql.dialects.mssql.refactoring.MsExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDialect
extends SqlLanguageDialectEx {
    public static final MsDialect INSTANCE = new MsDialect();

    public MsDialect() {
        super("TSQL");
    }

    @NotNull
    public SqlTypeSystem getTypeSystem() {
        MsTypeSystem msTypeSystem = MsTypeSystem.INSTANCE;
        if (msTypeSystem == null) {
            MsDialect.$$$reportNull$$$0(0);
        }
        return msTypeSystem;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"hierarchyid", (String)"hierarchyid", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"xml", (String)"xml", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MSSQL;
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            MsDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            MsDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            MsDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MsDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MsDialect.$$$reportNull$$$0(6);
        }
        if ((type == ObjectKind.ALIAS_TYPE || type == ObjectKind.TABLE_TYPE) && expectedTypes.contains(ObjectKind.OBJECT_TYPE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes, place, strict, isCompletion);
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            MsDialect.$$$reportNull$$$0(8);
        }
        SqlTypeSystem typeSystem = this.getTypeSystem();
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_ACTION.name, (boolean)resolve2) && !processor.executeTarget((DasObject)LazyData.RE_ACTION, element, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_IDENTITY.name, (boolean)resolve2) && !processor.executeTarget((DasObject)LazyData.RE_IDENTITY, element, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_ROWGUID.name, (boolean)resolve2) && !processor.executeTarget((DasObject)LazyData.RE_ROWGUID, element, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_XML.name, (boolean)resolve2) && !processor.executeTarget((DasObject)LazyData.RE_XML, element, null, Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_ROWVERSION.name, (boolean)resolve2) && !processor.executeTarget((DasObject)LazyData.RE_ROWVERSION, element, null, Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, element, resolve2, processor);
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            MsDialect.$$$reportNull$$$0(9);
        }
        return 128;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        ObjectKind type;
        PsiElement parent;
        if (identifier == null) {
            MsDialect.$$$reportNull$$$0(10);
        }
        if (newElementName == null) {
            MsDialect.$$$reportNull$$$0(11);
        }
        Object object = (parent = identifier.getParent()) instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : (type = parent instanceof SqlDefinition ? ((SqlDefinition)parent).getKind() : null);
        if (type == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName);
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        if (type == SqlDbElementType.ANY && MsDialect.isExecArg(o)) {
            return false;
        }
        return MsElementTypes.Kinds.FILEGROUP != type && MsElementTypes.Kinds.FILE != type && super.shallResolve(o, type);
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.INDEX) {
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            MsDialect.$$$reportNull$$$0(12);
        }
        return !this.getKeywords().contains(ref);
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            MsDialect.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        List<ObjectName> schemas2 = MsDialect.getSchemaNames(dataSource);
        ObjectName dbname = MsDialect.getDatabaseName(dataSource);
        DasNamespace namespace = MsDialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[]{namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(schemas2, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                MsDialect.$$$reportNull$$$0(14);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)SqlImportUtil.createPositiveDatabase((dataSource == null ? 1 : 0) != 0, (ObjectName)dbname, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create(schemas2, (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}))));
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        TreePatternNode.Group[] schemas2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MsDialect.getSchemaNames(dataSource), (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)MsDialect.getDatabaseName(dataSource), (ObjectKind)ObjectKind.DATABASE, (TreePatternNode.Group[])schemas2)});
        TreePattern treePattern = SqlDialectImplUtil.forcedContextExpandedToSchemas((DbDataSource)dataSource, (Dbms)this.getDbms(), (SearchPath)searchPath, (TreePatternNode.Group[])schemas2, (TreePatternNode.Group[])databases);
        if (treePattern == null) {
            MsDialect.$$$reportNull$$$0(15);
        }
        return treePattern;
    }

    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        if (prev == null) {
            MsDialect.$$$reportNull$$$0(16);
        }
        if (ref == null) {
            MsDialect.$$$reportNull$$$0(17);
        }
        return SqlDialectImplUtil.refPatternExpandedToSchema((TreePattern)prev, (SqlReferenceExpression)ref, (SqlLanguageDialectEx)this);
    }

    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath searchPath) {
        if (searchPath == null) {
            MsDialect.$$$reportNull$$$0(18);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, searchPath);
        if (treePattern == null) {
            MsDialect.$$$reportNull$$$0(19);
        }
        return treePattern;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new MsDFABuildingVisitor(this);
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(20);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlMergeStatement.class}) != null;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return MsExtractFunctionHelper.INSTANCE;
    }

    public static boolean isExecArg(@Nullable SqlReferenceExpression o) {
        if (o == null) {
            return false;
        }
        PsiElement top = (PsiElement)SqlImplUtil.sqlParents((PsiElement)o).skipWhile(x -> x == o || x instanceof SqlNamedParameterValueExpression || x instanceof SqlExpressionList || x instanceof SqlFunctionCallExpression).first();
        return top instanceof SqlStatement;
    }

    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName((RawConnectionConfig)SqlImportUtil.getConnectionConfig((DbDataSource)dataSource)), (Object)"master")));
    }

    @NotNull
    private static List<ObjectName> getSchemaNames(@Nullable DbDataSource dataSource) {
        SmartList schemas2 = new SmartList((Object)ObjectName.quoted((String)"dbo"));
        String username = SqlDialectImplUtil.getUserName((RawConnectionConfig)SqlImportUtil.getConnectionConfig((DbDataSource)dataSource));
        if (username != null) {
            schemas2.add(ObjectName.plain((String)username));
        }
        SmartList smartList = schemas2;
        if (smartList == null) {
            MsDialect.$$$reportNull$$$0(21);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mssql/MsDialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mssql/MsDialect";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(MsTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final TokenSet ourClosingTokens;
        static final Set<IElementType> ourSupportedOperators;
        static final ReservedEntity RE_ACTION;
        static final ReservedEntity RE_IDENTITY;
        static final ReservedEntity RE_ROWGUID;
        static final ReservedEntity RE_XML;
        static final ReservedEntity RE_ROWVERSION;
        private static final EnterHandlerDelegate ENTER_HANDLER;
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{MsTypes.MSSQL_GO})});
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ});
            RE_ACTION = new ReservedEntity("$action", ObjectKind.COLUMN);
            RE_IDENTITY = new ReservedEntity("$IDENTITY", ObjectKind.COLUMN);
            RE_ROWGUID = new ReservedEntity("$ROWGUID", ObjectKind.COLUMN);
            RE_XML = new ReservedEntity("XML", ObjectKind.OBJECT_TYPE);
            RE_ROWVERSION = new ReservedEntity("rowversion", ObjectKind.OBJECT_TYPE);
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessor[]{new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, false})}), new SubstitutionDescriptorImpl(new IElementType[]{MsTypes.MSSQL_TRY, MsElementTypes.Misc.MSSQL_TRY_CATCH_STATEMENT}, "", "end try\nbegin catch\nend catch", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{MsTypes.MSSQL_TRY}).opt(new IElementType[]{MsElementTypes.Misc.MSSQL_CATCH_CLAUSE, SqlElementTypes.SQL_SEMICOLON}).build()}), new SubstitutionDescriptorImpl(new IElementType[]{MsTypes.MSSQL_CATCH, MsElementTypes.Misc.MSSQL_CATCH_CLAUSE}, "", "end catch", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlElementTypes.SQL_END, MsTypes.MSSQL_CATCH, SqlElementTypes.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})})})});
            MAJOR_CHILD_KINDS = Collections.singletonList(ObjectKind.TRIGGER);
        }
    }
}

