/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.dateTime.SqlDtToken;
import com.intellij.sql.dialects.dateTime.psi.ParseContext;
import com.intellij.sql.dialects.dateTime.psi.ParseUtilsKt;
import com.intellij.sql.dialects.dateTime.psi.SqlDtCompositeElementType;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValue;
import com.intellij.sql.dialects.dateTime.psi.values.SqlTemporalValueKt;
import com.intellij.sql.dialects.mysql.MysqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.mysql._MysqlDtLexer;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlTimeAndDateLiteralExpressionImpl;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/dialects/mysql/MysqlDateTimeLanguageHelper;", "Lcom/intellij/sql/dialects/dateTime/SqlDateTimeLanguageHelper;", "()V", "DATE_DELIMITERS_STRICT", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "DATE_TIME_DELIMITERS", "DELIMITERS_NON_STRICT", "MAX_DURATION_HOURS", "", "ODBC_TIME_DELIMITERS", "TIME_DELIMITERS_STRICT", "createLexer", "Lcom/intellij/lexer/FlexLexer;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "createParser", "Lcom/intellij/lang/PsiParser;", "getRootElementType", "Lcom/intellij/sql/dialects/dateTime/psi/SqlDtCompositeElementType;", "inspectTemporalValue", "Lcom/intellij/codeInspection/ProblemDescriptor;", "temporal", "Lcom/intellij/sql/dialects/dateTime/psi/values/SqlTemporalValue;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "validateTemporalValue", "", "intellij.database.dialects.mysqlbase"})
public final class MysqlDateTimeLanguageHelper
extends SqlDateTimeLanguageHelper {
    private static final TokenSet DATE_TIME_DELIMITERS;
    private static final TokenSet DELIMITERS_NON_STRICT;
    private static final TokenSet DATE_DELIMITERS_STRICT;
    private static final TokenSet TIME_DELIMITERS_STRICT;
    private static final TokenSet ODBC_TIME_DELIMITERS;
    private static final int MAX_DURATION_HOURS = 838;
    public static final MysqlDateTimeLanguageHelper INSTANCE;

    @Nullable
    public SqlDtCompositeElementType getRootElementType(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        PsiElement psiElement = host.getParent();
        if (!(psiElement instanceof SqlTimeAndDateLiteralExpressionImpl)) {
            psiElement = null;
        }
        SqlTimeAndDateLiteralExpressionImpl sqlTimeAndDateLiteralExpressionImpl = (SqlTimeAndDateLiteralExpressionImpl)psiElement;
        IElementType iElementType = sqlTimeAndDateLiteralExpressionImpl != null ? sqlTimeAndDateLiteralExpressionImpl.getElementType() : null;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TIME_LITERAL) ? SqlDtCompositeElementType.Companion.getDURATION() : super.getRootElementType(host);
    }

    @NotNull
    public FlexLexer createLexer(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        PsiElement psiElement = host.getParent();
        IElementType hostType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
        return new _MysqlDtLexer(Intrinsics.areEqual((Object)hostType, (Object)SqlCompositeElementTypes.ODBC_DATE) || Intrinsics.areEqual((Object)hostType, (Object)SqlCompositeElementTypes.ODBC_TIME) ? SqlDtToken.WHITE_SPACE : (IElementType)SqlDtToken.SIGNIFICANT_WHITE_SPACE);
    }

    @NotNull
    public PsiParser createParser(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        return ParseUtilsKt.parser((Function2)((Function2)new Function2<ParseContext, IElementType, Boolean>(host){
            final /* synthetic */ PsiLanguageInjectionHost $host;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull ParseContext $this$parser, @NotNull IElementType root2) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)$this$parser, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                PsiElement psiElement = this.$host.getParent();
                IElementType hostType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
                boolean isOdbc = SqlCompositeElementTypes.ODBC_DATE_TIME_TYPES.contains(hostType);
                Function1<Function2<? super ParseContext, ? super String, ? extends SqlDtCompositeElementType>, Boolean> $fun$parseConcatenatedValue$1 = new Function1<Function2<? super ParseContext, ? super String, ? extends SqlDtCompositeElementType>, Boolean>($this$parser){
                    final /* synthetic */ ParseContext $this_parser;

                    public final boolean invoke(@NotNull Function2<? super ParseContext, ? super String, SqlDtCompositeElementType> calcType) {
                        Intrinsics.checkParameterIsNotNull(calcType, (String)"calcType");
                        if (Intrinsics.areEqual((Object)this.$this_parser.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) ^ true) {
                            return false;
                        }
                        if (this.$this_parser.getBuilder().rawLookup(1) == null || Intrinsics.areEqual((Object)this.$this_parser.getBuilder().rawLookup(1), (Object)SqlDtToken.DOT) || Intrinsics.areEqual((Object)this.$this_parser.getBuilder().rawLookup(1), (Object)SqlDtToken.SIGNIFICANT_WHITE_SPACE) && this.$this_parser.getBuilder().rawLookup(2) == null) {
                            String string = this.$this_parser.getBuilder().getTokenText();
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.tokenText!!");
                            SqlDtCompositeElementType elementType = (SqlDtCompositeElementType)calcType.invoke((Object)this.$this_parser, (Object)string);
                            PsiBuilder.Marker marker = this.$this_parser.getBuilder().mark();
                            Intrinsics.checkExpressionValueIsNotNull((Object)marker, (String)"builder.mark()");
                            PsiBuilder.Marker marker2 = marker;
                            this.$this_parser.getBuilder().advanceLexer();
                            marker2.done((IElementType)elementType);
                            return true;
                        }
                        return false;
                    }
                    {
                        this.$this_parser = parseContext;
                        super(1);
                    }
                };
                Function0<Boolean> $fun$parseDate$2 = new Function0<Boolean>($this$parser, isOdbc, hostType){
                    final /* synthetic */ ParseContext $this_parser;
                    final /* synthetic */ boolean $isOdbc;
                    final /* synthetic */ IElementType $hostType;

                    public final boolean invoke() {
                        TokenSet dateDelimiters = this.$isOdbc ? MysqlDateTimeLanguageHelper.access$getDATE_DELIMITERS_STRICT$p(MysqlDateTimeLanguageHelper.INSTANCE) : MysqlDateTimeLanguageHelper.access$getDELIMITERS_NON_STRICT$p(MysqlDateTimeLanguageHelper.INSTANCE);
                        String delimiterMessage = this.$isOdbc ? "'-'" : "punctuation character";
                        return this.$this_parser.elem((IElementType)SqlDtCompositeElementType.Companion.getYEAR(), "positive number", (Function1)new Function1<ParseContext, Boolean>(this){
                            final /* synthetic */ createParser.2 this$0;

                            public final boolean invoke(@NotNull ParseContext $this$elem) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$elem, (String)"$receiver");
                                return (Intrinsics.areEqual((Object)this.this$0.$hostType, (Object)SqlCompositeElementTypes.ODBC_DATE) ^ true || $this$elem.maybe((IElementType)SqlDtToken.MINUS)) && ParseContext.tok$default((ParseContext)$this$elem, (IElementType)((IElementType)SqlDtToken.NUMBER), null, (int)2, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }) && (this.$this_parser.some(dateDelimiters) || this.$isOdbc && Intrinsics.areEqual((Object)this.$this_parser.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) || this.$this_parser.recoverUpTo((IElementType)SqlDtToken.NUMBER, delimiterMessage)) && this.$this_parser.elem((IElementType)SqlDtCompositeElementType.Companion.getMONTH(), "positive number", (Function1)createParser.2.INSTANCE) && (this.$this_parser.some(dateDelimiters) || this.$isOdbc && Intrinsics.areEqual((Object)this.$this_parser.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) || this.$this_parser.recoverUpTo((IElementType)SqlDtToken.NUMBER, delimiterMessage)) && this.$this_parser.elem((IElementType)SqlDtCompositeElementType.Companion.getDAY_OF_MONTH(), "positive number", (Function1)createParser.3.INSTANCE);
                    }
                    {
                        this.$this_parser = parseContext;
                        this.$isOdbc = bl;
                        this.$hostType = iElementType;
                        super(0);
                    }
                };
                Function0<Boolean> $fun$parseFractionalPart$3 = new Function0<Boolean>($this$parser, hostType){
                    final /* synthetic */ ParseContext $this_parser;
                    final /* synthetic */ IElementType $hostType;

                    public final boolean invoke() {
                        return ParseContext.maybe$default((ParseContext)this.$this_parser, (boolean)false, (Function1)((Function1)new Function1<ParseContext, Boolean>(this){
                            final /* synthetic */ createParser.3 this$0;

                            public final boolean invoke(@NotNull ParseContext $this$maybe) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$maybe, (String)"$receiver");
                                return (ParseContext.tok$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtToken.DOT), null, (int)2, null) || $this$maybe.tok((IElementType)SqlDtToken.GENERIC_DELIMITER, (Function2)createParser.1.INSTANCE)) && $this$maybe.maybe(Intrinsics.areEqual((Object)this.this$0.$hostType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP) ^ true, (Function1)createParser.2.INSTANCE);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)1, null);
                    }
                    {
                        this.$this_parser = parseContext;
                        this.$hostType = iElementType;
                        super(0);
                    }
                };
                Function1<Boolean, Boolean> $fun$parseTimeBase$4 = new Function1<Boolean, Boolean>($this$parser, hostType, isOdbc, root2, $fun$parseFractionalPart$3){
                    final /* synthetic */ ParseContext $this_parser;
                    final /* synthetic */ IElementType $hostType;
                    final /* synthetic */ boolean $isOdbc;
                    final /* synthetic */ IElementType $root;
                    final /* synthetic */ createParser.3 $parseFractionalPart$3;

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean invoke(boolean isOptionalHour) {
                        void timeDelimiters;
                        IElementType iElementType = this.$hostType;
                        Pair pair = Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP) ? TuplesKt.to((Object)MysqlDateTimeLanguageHelper.access$getTIME_DELIMITERS_STRICT$p(MysqlDateTimeLanguageHelper.INSTANCE), (Object)"':'") : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.ODBC_TIME) ? TuplesKt.to((Object)MysqlDateTimeLanguageHelper.access$getODBC_TIME_DELIMITERS$p(MysqlDateTimeLanguageHelper.INSTANCE), (Object)"':' or '.'") : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_TIME_LITERAL) ? TuplesKt.to((Object)MysqlDateTimeLanguageHelper.access$getTIME_DELIMITERS_STRICT$p(MysqlDateTimeLanguageHelper.INSTANCE), (Object)"':'") : TuplesKt.to((Object)MysqlDateTimeLanguageHelper.access$getDELIMITERS_NON_STRICT$p(MysqlDateTimeLanguageHelper.INSTANCE), (Object)"punctuation character")));
                        TokenSet tokenSet = (TokenSet)pair.component1();
                        String delimiterMessage = (String)pair.component2();
                        LighterASTNode lighterASTNode = this.$this_parser.getBuilder().getLatestDoneMarker();
                        return (Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)SqlDtCompositeElementType.Companion.getDAY_OF_TIME()) || this.$this_parser.maybe((IElementType)SqlDtToken.MINUS)) && this.$this_parser.maybe(isOptionalHour, (Function1)new Function1<ParseContext, Boolean>((TokenSet)timeDelimiters){
                            final /* synthetic */ TokenSet $timeDelimiters;

                            public final boolean invoke(@NotNull ParseContext $this$maybe) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$maybe, (String)"$receiver");
                                return $this$maybe.elem((IElementType)SqlDtCompositeElementType.Companion.getHOUR(), this.$timeDelimiters.contains($this$maybe.getBuilder().getTokenType()) ? null : "positive number", (Function1)createParser.1.INSTANCE);
                            }
                            {
                                this.$timeDelimiters = tokenSet;
                                super(1);
                            }
                        }) && this.$this_parser.maybe(!this.$isOdbc, (Function1)new Function1<ParseContext, Boolean>(this, (TokenSet)timeDelimiters, delimiterMessage){
                            final /* synthetic */ createParser.4 this$0;
                            final /* synthetic */ TokenSet $timeDelimiters;
                            final /* synthetic */ String $delimiterMessage;

                            public final boolean invoke(@NotNull ParseContext $this$maybe) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$maybe, (String)"$receiver");
                                return ($this$maybe.some(this.$timeDelimiters) || this.this$0.$isOdbc && Intrinsics.areEqual((Object)$this$maybe.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) || $this$maybe.recoverUpTo((IElementType)SqlDtToken.NUMBER, this.$delimiterMessage)) && $this$maybe.maybe(!this.this$0.$isOdbc && Intrinsics.areEqual((Object)this.this$0.$root, (Object)SqlDtCompositeElementType.Companion.getTIMESTAMP()), (Function1)new Function1<ParseContext, Boolean>(this){
                                    final /* synthetic */ createParser.2 this$0;

                                    public final boolean invoke(@NotNull ParseContext $this$maybe) {
                                        Intrinsics.checkParameterIsNotNull((Object)$this$maybe, (String)"$receiver");
                                        return (ParseContext.elem$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtCompositeElementType.Companion.getMINUTE()), null, (Function1)createParser.1.INSTANCE, (int)2, null) || $this$maybe.recoverUpTo((IElementType)SqlDtToken.NUMBER, "positive number")) && $this$maybe.maybe(!this.this$0.this$0.$isOdbc, (Function1)new Function1<ParseContext, Boolean>(this){
                                            final /* synthetic */ createParser.1 this$0;

                                            public final boolean invoke(@NotNull ParseContext $this$maybe) {
                                                Intrinsics.checkParameterIsNotNull((Object)$this$maybe, (String)"$receiver");
                                                return ($this$maybe.some(this.this$0.this$0.$timeDelimiters) || this.this$0.this$0.this$0.$isOdbc && Intrinsics.areEqual((Object)$this$maybe.getBuilder().getTokenType(), (Object)SqlDtToken.NUMBER) || $this$maybe.recoverUpTo((IElementType)SqlDtToken.NUMBER, this.this$0.this$0.$delimiterMessage)) && $this$maybe.maybe(!this.this$0.this$0.this$0.$isOdbc && Intrinsics.areEqual((Object)this.this$0.this$0.this$0.$root, (Object)SqlDtCompositeElementType.Companion.getTIMESTAMP()), (Function1)new Function1<ParseContext, Boolean>(this){
                                                    final /* synthetic */ createParser.2 this$0;

                                                    public final boolean invoke(@NotNull ParseContext $this$maybe) {
                                                        Intrinsics.checkParameterIsNotNull((Object)$this$maybe, (String)"$receiver");
                                                        return (ParseContext.elem$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtCompositeElementType.Companion.getSECOND()), null, (Function1)createParser.1.INSTANCE, (int)2, null) || $this$maybe.recoverUpTo((IElementType)SqlDtToken.NUMBER, "positive number")) && this.this$0.this$0.this$0.this$0.$parseFractionalPart$3.invoke();
                                                    }
                                                    {
                                                        this.this$0 = var1_1;
                                                        super(1);
                                                    }
                                                });
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                super(1);
                                            }
                                        });
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                            }
                            {
                                this.this$0 = var1_1;
                                this.$timeDelimiters = tokenSet;
                                this.$delimiterMessage = string;
                                super(1);
                            }
                        });
                    }
                    {
                        this.$this_parser = parseContext;
                        this.$hostType = iElementType;
                        this.$isOdbc = bl;
                        this.$root = iElementType2;
                        this.$parseFractionalPart$3 = var5_5;
                        super(1);
                    }
                };
                Function0<Boolean> $fun$parseTime$5 = new Function0<Boolean>($this$parser, root2, $fun$parseTimeBase$4){
                    final /* synthetic */ ParseContext $this_parser;
                    final /* synthetic */ IElementType $root;
                    final /* synthetic */ createParser.4 $parseTimeBase$4;

                    public final boolean invoke() {
                        return ParseContext.maybe$default((ParseContext)this.$this_parser, (boolean)false, (Function1)((Function1)new Function1<ParseContext, Boolean>(this){
                            final /* synthetic */ createParser.5 this$0;

                            public final boolean invoke(@NotNull ParseContext $this$maybe) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$maybe, (String)"$receiver");
                                return Intrinsics.areEqual((Object)this.this$0.$root, (Object)SqlDtCompositeElementType.Companion.getDURATION()) && $this$maybe.maybe((IElementType)SqlDtToken.MINUS) && ParseContext.elem$default((ParseContext)$this$maybe, (IElementType)((IElementType)SqlDtCompositeElementType.Companion.getDAY_OF_TIME()), null, (Function1)createParser.1.INSTANCE, (int)2, null) && $this$maybe.consumeSpaces();
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)1, null) && this.$parseTimeBase$4.invoke(true);
                    }
                    {
                        this.$this_parser = parseContext;
                        this.$root = iElementType;
                        this.$parseTimeBase$4 = var3_3;
                        super(0);
                    }
                };
                Function0<Boolean> $fun$parseDateTimeDelimiter$6 = new Function0<Boolean>($this$parser, hostType){
                    final /* synthetic */ ParseContext $this_parser;
                    final /* synthetic */ IElementType $hostType;

                    public final boolean invoke() {
                        if (Intrinsics.areEqual((Object)this.$hostType, (Object)SqlCompositeElementTypes.ODBC_TIMESTAMP)) {
                            return this.$this_parser.singleSpace();
                        }
                        int tokenCount = 0;
                        boolean isError = false;
                        PsiBuilder.Marker marker = this.$this_parser.getBuilder().mark();
                        Intrinsics.checkExpressionValueIsNotNull((Object)marker, (String)"builder.mark()");
                        PsiBuilder.Marker marker2 = marker;
                        while (MysqlDateTimeLanguageHelper.access$getDATE_TIME_DELIMITERS$p(MysqlDateTimeLanguageHelper.INSTANCE).contains(this.$this_parser.getBuilder().getTokenType())) {
                            if (Intrinsics.areEqual((Object)this.$this_parser.getBuilder().getTokenType(), (Object)SqlDtToken.IDENTIFIER)) {
                                isError = Intrinsics.areEqual((Object)this.$this_parser.getBuilder().getTokenText(), (Object)"T") ^ true;
                            }
                            ++tokenCount;
                            this.$this_parser.getBuilder().advanceLexer();
                        }
                        boolean bl = isError = isError || tokenCount != 1;
                        if (isError) {
                            marker2.error("'T' or space expected");
                        } else {
                            marker2.drop();
                        }
                        return true;
                    }
                    {
                        this.$this_parser = parseContext;
                        this.$hostType = iElementType;
                        super(0);
                    }
                };
                Function0<Boolean> $fun$parseTimestamp$7 = new Function0<Boolean>($fun$parseDate$2, $fun$parseDateTimeDelimiter$6, $fun$parseTimeBase$4){
                    final /* synthetic */ createParser.2 $parseDate$2;
                    final /* synthetic */ createParser.6 $parseDateTimeDelimiter$6;
                    final /* synthetic */ createParser.4 $parseTimeBase$4;

                    public final boolean invoke() {
                        return this.$parseDate$2.invoke() && this.$parseDateTimeDelimiter$6.invoke() && this.$parseTimeBase$4.invoke(false);
                    }
                    {
                        this.$parseDate$2 = var1_1;
                        this.$parseDateTimeDelimiter$6 = var2_2;
                        this.$parseTimeBase$4 = var3_3;
                        super(0);
                    }
                };
                if (!$this$parser.consumeSpaces()) return false;
                IElementType iElementType = root2;
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getDATE())) {
                    if (isOdbc || !$fun$parseConcatenatedValue$1.invoke((Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)createParser.8.INSTANCE))) {
                        if (!$fun$parseDate$2.invoke()) return false;
                    }
                    bl = true;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getTIME()) || Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getDURATION())) {
                    if (isOdbc || !$this$parser.maybe((IElementType)SqlDtToken.MINUS) || !$fun$parseConcatenatedValue$1.invoke((Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)createParser.9.INSTANCE)) || !$fun$parseFractionalPart$3.invoke()) {
                        if (!$fun$parseTime$5.invoke()) return false;
                    }
                    bl = true;
                } else {
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getTIMESTAMP())) return false;
                    if (isOdbc || !$fun$parseConcatenatedValue$1.invoke((Function2<? super ParseContext, ? super String, SqlDtCompositeElementType>)((Function2)createParser.10.INSTANCE)) || !$fun$parseFractionalPart$3.invoke()) {
                        if (!$fun$parseTimestamp$7.invoke()) return false;
                    }
                    bl = true;
                }
                if (!bl) return false;
                if (!$this$parser.consumeSpaces()) return false;
                return true;
            }
            {
                this.$host = psiLanguageInjectionHost;
                super(2);
            }
        }));
    }

    @Nullable
    public ProblemDescriptor inspectTemporalValue(@NotNull SqlTemporalValue<?> temporal, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor problemDescriptor;
        Intrinsics.checkParameterIsNotNull(temporal, (String)"temporal");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        SqlTemporalValue<?> sqlTemporalValue = temporal;
        if (sqlTemporalValue instanceof SqlTemporalValue.TimeDuration) {
            SqlTemporalValue.Hour hour = ((SqlTemporalValue.TimeDuration)temporal).getHour();
            if (hour == null) {
                return null;
            }
            SqlTemporalValue.Hour hour2 = hour;
            Object object = ((SqlTemporalValue.TimeDuration)temporal).getDayOfTime();
            int n = object != null && (object = object.getValue()) != null ? (Integer)object : 0;
            boolean bl = false;
            int dayOfTime = Math.abs(n);
            int maxHours = 838 - dayOfTime * 24;
            if (maxHours < 0) {
                return null;
            }
            int minHours = ((SqlTemporalValue.TimeDuration)temporal).getDayOfTime() != null ? 0 : -maxHours;
            String string = this.validateInterval((SqlTemporalValue)hour2, minHours, maxHours);
            if (string == null) {
                return null;
            }
            String message = string;
            problemDescriptor = manager.createProblemDescriptor((PsiElement)hour2.getPsi(), SqlTemporalValueKt.getRangeInElement((SqlTemporalValue)((SqlTemporalValue)hour2)), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
        } else {
            problemDescriptor = super.inspectTemporalValue(temporal, manager, isOnTheFly);
        }
        return problemDescriptor;
    }

    @Nullable
    public String validateTemporalValue(@NotNull SqlTemporalValue<?> temporal) {
        String string;
        Intrinsics.checkParameterIsNotNull(temporal, (String)"temporal");
        SqlTemporalValue<?> sqlTemporalValue = temporal;
        if (sqlTemporalValue instanceof SqlTemporalValue.Date) {
            int textLength = temporal.getPsi().getTextLength();
            string = SqlTemporalValueKt.isConcatenated(temporal) && textLength != 6 && textLength != 8 ? "Concatenated date must take the form of either YYMMDD, or YYYYMMDD" : null;
        } else if (sqlTemporalValue instanceof SqlTemporalValue.Year) {
            string = this.validateInterval(temporal, -9999, 9999);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.DayOfTime) {
            string = this.validateInterval(temporal, 0, 34);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.Hour) {
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)temporal.getPsi().getParent());
            string = Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getTIMESTAMP()) ? this.validateInterval(temporal, 0, 23) : (Intrinsics.areEqual((Object)iElementType, (Object)SqlDtCompositeElementType.Companion.getTIME()) ? this.validateInterval(temporal, -838, 838) : null);
        } else if (sqlTemporalValue instanceof SqlTemporalValue.SecondFraction) {
            int n = 0;
            IntRange intRange = new IntRange(n, 999999);
            Integer n2 = ((SqlTemporalValue.SecondFraction)temporal).getValue();
            boolean bl = false;
            string = !(n2 != null && intRange.contains(n2.intValue())) ? "Fractions longer than 6 digits are rounded off" : null;
        } else {
            string = super.validateTemporalValue(temporal);
        }
        return string;
    }

    private MysqlDateTimeLanguageHelper() {
    }

    static {
        MysqlDateTimeLanguageHelper mysqlDateTimeLanguageHelper;
        INSTANCE = mysqlDateTimeLanguageHelper = new MysqlDateTimeLanguageHelper();
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlDtToken.SIGNIFICANT_WHITE_SPACE, (IElementType)SqlDtToken.IDENTIFIER});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(SIGNIFIC\u2026_WHITE_SPACE, IDENTIFIER)");
        DATE_TIME_DELIMITERS = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlDtToken.PLUS, (IElementType)SqlDtToken.MINUS, (IElementType)SqlDtToken.COLON, (IElementType)SqlDtToken.DOT, (IElementType)SqlDtToken.GENERIC_DELIMITER});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"TokenSet.create(PLUS, MI\u2026, DOT, GENERIC_DELIMITER)");
        DELIMITERS_NON_STRICT = tokenSet2;
        TokenSet tokenSet3 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlDtToken.MINUS});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet3, (String)"TokenSet.create(MINUS)");
        DATE_DELIMITERS_STRICT = tokenSet3;
        TokenSet tokenSet4 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlDtToken.COLON});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet4, (String)"TokenSet.create(COLON)");
        TIME_DELIMITERS_STRICT = tokenSet4;
        TokenSet tokenSet5 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)SqlDtToken.COLON, (IElementType)SqlDtToken.DOT});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet5, (String)"TokenSet.create(COLON, DOT)");
        ODBC_TIME_DELIMITERS = tokenSet5;
    }

    public static final /* synthetic */ TokenSet access$getDATE_DELIMITERS_STRICT$p(MysqlDateTimeLanguageHelper $this) {
        MysqlDateTimeLanguageHelper mysqlDateTimeLanguageHelper = $this;
        return DATE_DELIMITERS_STRICT;
    }

    public static final /* synthetic */ TokenSet access$getDELIMITERS_NON_STRICT$p(MysqlDateTimeLanguageHelper $this) {
        MysqlDateTimeLanguageHelper mysqlDateTimeLanguageHelper = $this;
        return DELIMITERS_NON_STRICT;
    }

    public static final /* synthetic */ TokenSet access$getTIME_DELIMITERS_STRICT$p(MysqlDateTimeLanguageHelper $this) {
        MysqlDateTimeLanguageHelper mysqlDateTimeLanguageHelper = $this;
        return TIME_DELIMITERS_STRICT;
    }

    public static final /* synthetic */ TokenSet access$getODBC_TIME_DELIMITERS$p(MysqlDateTimeLanguageHelper $this) {
        MysqlDateTimeLanguageHelper mysqlDateTimeLanguageHelper = $this;
        return ODBC_TIME_DELIMITERS;
    }

    public static final /* synthetic */ TokenSet access$getDATE_TIME_DELIMITERS$p(MysqlDateTimeLanguageHelper $this) {
        MysqlDateTimeLanguageHelper mysqlDateTimeLanguageHelper = $this;
        return DATE_TIME_DELIMITERS;
    }
}

