/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraTypeSystem
extends SqlTypeSystem {
    public static final OraTypeSystem INSTANCE = new OraTypeSystem();

    private OraTypeSystem() {
        super((SqlLanguageDialectEx)OraDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            OraTypeSystem.$$$reportNull$$$0(0);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).equals("LONG VARCHAR")) {
            return "LONG";
        }
        if (name2.equals("NUMERIC")) {
            return "NUMBER";
        }
        if (name2.equals("DECIMAL")) {
            return "NUMBER";
        }
        if (name2.equals("DEC")) {
            return "NUMBER";
        }
        if (name2.equals("INTEGER")) {
            return "NUMBER";
        }
        if (name2.equals("INT")) {
            return "NUMBER";
        }
        if (name2.equals("SMALLINT")) {
            return "NUMBER";
        }
        if (name2.equals("DOUBLE PRECISION")) {
            return "FLOAT";
        }
        if (name2.equals("REAL")) {
            return "FLOAT";
        }
        String string = name2;
        if (string == null) {
            OraTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            OraTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "number";
            }
            case REAL: {
                return "float";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "timestamp";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "timestamp";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "varray";
            }
            case COLLECTION: {
                return "varray";
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            OraTypeSystem.$$$reportNull$$$0(3);
        }
        if ("BINARY_FLOAT".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if ("BINARY_DOUBLE".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if ("LONG".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        if ("LONG RAW".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(7);
            }
            return category;
        }
        if ("BFILE".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(8);
            }
            return category;
        }
        if ("ROWID".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(9);
            }
            return category;
        }
        if ("UROWID".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(10);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            OraTypeSystem.$$$reportNull$$$0(11);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/OraTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/OraTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

