/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.dataFlow.PgDFABuildingVisitor;
import com.intellij.sql.dialects.postgres.dataFlow.PgErrorSpecHelper;
import com.intellij.sql.dialects.postgres.psi.PgCreatePreparedStatement;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractFunctionHelper;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Pg83Dialect
extends PgDialectBase {
    public Pg83Dialect(@NotNull String id) {
        if (id == null) {
            Pg83Dialect.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        Object preparedStatement;
        String nameUC;
        if (element == null) {
            Pg83Dialect.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            Pg83Dialect.$$$reportNull$$$0(2);
        }
        if (!super.processReservedEntitiesWithType(name2, element, resolve2, processor)) {
            return false;
        }
        SqlTypeSystem typeSystem = this.getTypeSystem();
        String string = nameUC = name2 == null ? null : StringUtil.toUpperCase((String)name2);
        if (resolve2 && name2 != null && LazyData.ARG_PATTERN.matcher(name2).matches() && (preparedStatement = (PgCreatePreparedStatement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{PgCreatePreparedStatement.class})) != null && !processor.executeTarget(((PgCreatePreparedStatement)((Object)preparedStatement)).getArgument(name2), element, (SqlType)SqlType.UNKNOWN, null, ResolveState.initial())) {
            return false;
        }
        if (Pg83Dialect.inPl(element) && this.getQualifier(element) == null) {
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)LazyData.RE_FOUND.name, (String)name2, (boolean)resolve2) && !processor.executeTarget((DasObject)LazyData.RE_FOUND, element, typeSystem.booleanType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)LazyData.SQLSTATE.name, (String)name2, (boolean)resolve2) && Pg83Dialect.raiseStatement(element) && !processor.executeTarget((DasObject)LazyData.SQLSTATE, element, typeSystem.integerType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue((String)LazyData.SQLERRM.name, (String)name2, (boolean)resolve2) && Pg83Dialect.raiseStatement(element) && !processor.executeTarget((DasObject)LazyData.SQLERRM, element, typeSystem.stringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(PgElementTypes.Kinds.OPERATOR_CLASS)) {
            if (!resolve2) {
                for (DasObject target2 : LazyData.RE_OPS.values()) {
                    if (processor.executeTarget(target2, element, SqlTypeFactory.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) continue;
                    return false;
                }
            } else if (LazyData.RE_OPS.containsKey(nameUC) && !processor.executeTarget(LazyData.RE_OPS.get(nameUC), element, SqlTypeFactory.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        if (processor.isExpected(SqlDbElementType.ACCESS_METHOD)) {
            for (ReservedEntity am : LazyData.RE_PG_AMS) {
                if (Pg83Dialect.processReservedEntitiesWithTypeSimple((DasObject)am, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)element, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)false, null)) continue;
                return false;
            }
        }
        if (processor.isExpected(SqlDbElementType.COLUMN)) {
            SqlExpression expression;
            boolean process2 = true;
            if (!resolve2 && (expression = this.getQualifier(element)) != null && expression.getSqlType() == SqlType.UNKNOWN) {
                process2 = false;
            }
            if (process2) {
                for (DasObject entity : LazyData.RESERVED_INTEGER_ENTITIES.values()) {
                    if (Pg83Dialect.processReservedEntitiesWithTypeSimple((DasObject)entity, (SqlType)this.getTypeSystem().integerType(), (String)name2, (PsiElement)element, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)true, (Boolean)false)) continue;
                    return false;
                }
            }
        }
        if (element instanceof SqlReferenceExpression) {
            SqlReferenceElementType type = ((SqlReferenceExpression)element).getReferenceElementType();
            if (type == SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE) {
                if (!Pg83Dialect.processReservedEntitiesWithTypeSimple((DasObject)LazyData.RE_PG_DEFAULT, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)element, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                    return false;
                }
                if (!Pg83Dialect.processReservedEntitiesWithTypeSimple((DasObject)LazyData.RE_PG_GLOBAL, (SqlType)SqlTypeFactory.REFERENCE, (String)name2, (PsiElement)element, (boolean)resolve2, (SqlScopeProcessor)processor, (boolean)false, (Boolean)false)) {
                    return false;
                }
            }
            if (((SqlReferenceExpression)element).getQualifierExpression() == null) {
                for (ReservedEntity object : this.getReservedObjects()) {
                    if (processor.executeTarget((DasObject)object, element, null, Boolean.valueOf(false), ResolveState.initial())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            Pg83Dialect.$$$reportNull$$$0(3);
        }
        return 63;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new PgExtractVariableHelper((SqlLanguageDialect)this);
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return PgExtractFunctionHelper.INSTANCE;
    }

    @NotNull
    protected abstract List<ReservedEntity> getReservedObjects();

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == PgElementTypes.Kinds.OPERATOR_CLASS || type == PgElementTypes.Kinds.OPERATOR_FAMILY || type == PgElementTypes.Kinds.TEXT_SEARCH_PARSER || type == PgElementTypes.Kinds.TEXT_SEARCH_DICTIONARY || type == PgElementTypes.Kinds.TEXT_SEARCH_CONFIGURATION || type == PgElementTypes.Kinds.TEXT_SEARCH_TEMPLATE || type == ObjectKind.LANGUAGE) {
            result2.add((ObjectKind)SqlDbElementType.SCHEMA);
        }
        return super.getParentDbTypes(result2, type);
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        ObjectName dbName = Pg83Dialect.getDbName(dataSource);
        DasNamespace namespace = Pg83Dialect.getDefaultNamespace((DbDataSource)dataSource, (ObjectName)dbName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[]{namespace.getKind() == SqlDbElementType.SCHEMA ? null : TreePatternUtils.create((ObjectName)PgDialect.LazyData.PUBLIC_NAME, (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])});
            if (treePattern == null) {
                Pg83Dialect.$$$reportNull$$$0(4);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])SqlImportUtil.optAr((TreePatternNode.Group)SqlImportUtil.createPositiveDatabase((dataSource == null ? 1 : 0) != 0, (ObjectName)dbName, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)PgDialect.LazyData.PUBLIC_NAME, (ObjectKind)SqlDbElementType.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}))));
    }

    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            Pg83Dialect.$$$reportNull$$$0(5);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath((TreePattern)pattern, (ObjectName[])dsNames, Collections.singletonList(ObjectName.quoted((String)"pg_catalog")), (boolean)true, (ObjectKind[])new ObjectKind[]{SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA});
        if (treePattern == null) {
            Pg83Dialect.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Pg83Dialect.$$$reportNull$$$0(7);
        }
        if (type == SqlDbElementType.OBJECT_ATTRIBUTE && expectedTypes.contains(SqlDbElementType.COLUMN)) {
            return true;
        }
        if (strict) {
            return false;
        }
        if (SqlDialectImplUtil.isLabelOrRoutineQualification((PsiElement)element, (ObjectKind)type, (PsiElement)place, (boolean)isCompletion)) {
            return true;
        }
        if (expectedTypes.contains(SqlDbElementType.COLUMN) || expectedTypes.contains(SqlDbElementType.ANY)) {
            boolean isTable;
            boolean bl = isTable = type == SqlDbElementType.TABLE;
            if (type == SqlDbElementType.LOCAL_ALIAS) {
                if (element == null) {
                    isTable = true;
                } else {
                    PsiElement parent = element.getParent();
                    boolean bl2 = isTable = parent instanceof SqlFromClause || parent instanceof SqlJoinExpression;
                }
            }
            if (isTable) {
                SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
                return ref == null || ref.getQualifierExpression() == null;
            }
        }
        if (type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes, place, false, isCompletion);
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        if (column2 == null) {
            Pg83Dialect.$$$reportNull$$$0(8);
        }
        if (super.isAutoIncrementColumn(column2)) {
            return true;
        }
        String type = column2.getDataType().getSpecification();
        return LazyData.SERIAL_PATTERN.matcher(type).matches();
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            Pg83Dialect.$$$reportNull$$$0(9);
        }
        return collection;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != SqlDbElementType.CURSOR && super.shallResolve(o, type);
    }

    @Nullable
    protected SqlExpression getQualifier(@NotNull PsiElement element) {
        SqlReferenceExpression ref;
        if (element == null) {
            Pg83Dialect.$$$reportNull$$$0(10);
        }
        return (ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element, SqlReferenceExpression.class)) == null ? null : ref.getQualifierExpression();
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new PgDFABuildingVisitor(this);
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        PgErrorSpecHelper pgErrorSpecHelper = PgErrorSpecHelper.INSTANCE;
        if (pgErrorSpecHelper == null) {
            Pg83Dialect.$$$reportNull$$$0(11);
        }
        return pgErrorSpecHelper;
    }

    private static boolean raiseStatement(@NotNull PsiElement element) {
        SqlStatement statement;
        if (element == null) {
            Pg83Dialect.$$$reportNull$$$0(12);
        }
        return (statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) != null && statement.getNode().getElementType() == PgElementTypes.Misc.PG_RAISE_STATEMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/Pg83Dialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/Pg83Dialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "raiseStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final Pattern ARG_PATTERN = Pattern.compile("\\$\\d+");
        static final Pattern SERIAL_PATTERN = Pattern.compile("(?i)(?:big|small)?serial|serial[248]");
        static final List<ReservedEntity> RE_PG_AMS = Arrays.asList(new ReservedEntity("btree", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("hash", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("gist", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("spgist", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("gin", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("brin", SqlDbElementType.ACCESS_METHOD), new ReservedEntity("bloom", SqlDbElementType.ACCESS_METHOD));
        static final Map<String, DasObject> RESERVED_INTEGER_ENTITIES = SqlDialectImplUtil.buildEntities((ObjectKind)SqlDbElementType.COLUMN, (String[])new String[]{"OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID"});
        static final ReservedEntity RE_PG_DEFAULT = new ReservedEntity("pg_default", SqlDbElementType.TABLESPACE);
        static final ReservedEntity RE_PG_GLOBAL = new ReservedEntity("pg_global", SqlDbElementType.TABLESPACE);
        static final ReservedEntity RE_FOUND = new ReservedEntity("FOUND", SqlDbElementType.COLUMN);
        static final ReservedEntity SQLSTATE = new ReservedEntity("SQLSTATE", SqlDbElementType.COLUMN);
        static final ReservedEntity SQLERRM = new ReservedEntity("SQLERRM", SqlDbElementType.COLUMN);
        static final Map<String, DasObject> RE_OPS = SqlDialectImplUtil.buildEntities((ObjectKind)PgElementTypes.Kinds.OPERATOR_CLASS, (String[])new String[]{"INTEGER_OPS", "TEXT_PATTERN_OPS", "INT8_OPS", "INT4_OPS", "INT2_OPS", "VARCHAR_PATTERN_OPS", "BPCHAR_PATTERN_OPS", "JSONB_PATH_OPS", "JSONB_OPS"});
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessor[]{new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false, false})}), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_IF, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, true, false})})})});
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX, SqlDbElementType.TRIGGER, SqlDbElementType.RULE, SqlDbElementType.POLICY);

        private LazyData() {
        }
    }
}

