/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgSelectFromProcedureInspection
extends SqlInspectionBase {
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isPostgres()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, (SqlLanguageDialect)dialect, result2){

            public void visitSqlAsExpression(SqlAsExpression o) {
                this.processExpression(o.getExpression(), o.getColumnAliasList());
            }

            public void visitSqlFromClause(SqlFromClause o) {
                super.visitSqlFromClause(o);
                SqlExpression expression = o.getFromExpression();
                this.processExpression(expression, Collections.emptyList());
            }

            private void processExpression(SqlExpression expression, List<SqlDefinition> aliases) {
                SqlFunctionCallExpression function;
                if (expression instanceof SqlFunctionCallExpression) {
                    this.processFunctionCall((SqlFunctionCallExpression)expression, aliases);
                } else if (expression instanceof SqlExplicitTableExpression && (function = (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlFunctionCallExpression.class)) != null) {
                    this.processFunctionCall(function, aliases);
                }
            }

            private void processFunctionCall(SqlFunctionCallExpression functionCall, List<SqlDefinition> aliases) {
                boolean needTypedAliasDefinition = PgSelectFromProcedureInspection.needTypedAliasDefinition(functionCall);
                if (needTypedAliasDefinition && aliases.isEmpty()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)functionCall, "The function call must have a typed alias definition", (LocalQuickFix)((LocalQuickFixBase)null), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    return;
                }
                for (SqlDefinition alias : aliases) {
                    if (alias.getKind() != ObjectKind.COLUMN) continue;
                    SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)alias, SqlTypeElement.class);
                    if (needTypedAliasDefinition && type == null) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)alias, "The alias must have a type", (LocalQuickFix)new MyAddTypeQuickFix(alias), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                    if (needTypedAliasDefinition || type == null) continue;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)alias, "The alias can not have a type", (LocalQuickFix)new MyRemoveTypeQuickFix("Remove type element", "SQL"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }

    private static boolean needTypedAliasDefinition(@NotNull String functionName, @Nullable DataType returnType) {
        if (functionName == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(3);
        }
        if (returnType == null) {
            return false;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)returnType.getSpecification(), (CharSequence)"record")) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)returnType.typeName, (CharSequence)"table")) {
            String arg = returnType.vagueArg;
            return arg != null && StringUtil.endsWithIgnoreCase((String)arg, (String)" record");
        }
        return false;
    }

    private static boolean needTypedAliasDefinition(@NotNull SqlFunctionCallExpression functionCall) {
        SqlReferenceExpression nameElement;
        if (functionCall == null) {
            PgSelectFromProcedureInspection.$$$reportNull$$$0(4);
        }
        if ((nameElement = functionCall.getNameElement()) == null) {
            return false;
        }
        String functionName = nameElement.getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)functionName, (CharSequence)"dblink")) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)functionName, (CharSequence)"pg_stat_file")) {
            return false;
        }
        PsiElement resolve2 = nameElement.resolve();
        if (resolve2 instanceof DasRoutine) {
            DataType type;
            DasRoutine routine = (DasRoutine)resolve2;
            for (DasArgument info : DasUtil.getParameters((DasRoutine)routine)) {
                ArgumentDirection type2 = info.getArgumentDirection();
                if (type2 != ArgumentDirection.OUT && type2 != ArgumentDirection.INOUT) continue;
                return false;
            }
            DasArgument retArg = routine.getReturnArgument();
            DataType dataType = type = retArg == null ? null : retArg.getDataType();
            if (PgSelectFromProcedureInspection.needTypedAliasDefinition(functionName, type)) {
                return true;
            }
        }
        if (resolve2 instanceof PomTargetPsiElement) {
            PomTarget target2 = ((PomTargetPsiElement)resolve2).getTarget();
            if (!(target2 instanceof SqlFunctionDefinition)) {
                return false;
            }
            for (SqlFunctionDefinition.Prototype prototype : ((SqlFunctionDefinition)target2).getPrototypes()) {
                DataType returnType = prototype.getReturnType().getDataType();
                if (!PgSelectFromProcedureInspection.needTypedAliasDefinition(functionName, returnType)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnnotationVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "needTypedAliasDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyAddTypeQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private MyAddTypeQuickFix(SqlDefinition alias) {
            super((PsiElement)alias);
        }

        @NotNull
        public String getText() {
            return "Add type element";
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return "SQL";
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement alias, @NotNull PsiElement endElement) {
            if (project == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (alias == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                MyAddTypeQuickFix.$$$reportNull$$$0(3);
            }
            if (alias instanceof SqlDefinition) {
                SqlNameElement name2 = ((SqlDefinition)alias).getNameElement();
                PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
                Document document = instance.getDocument(file);
                if (name2 != null && document != null) {
                    int offset = name2.getTextRange().getEndOffset();
                    String defaultType = "int";
                    document.insertString(offset, (CharSequence)(" " + defaultType));
                    instance.commitDocument(document);
                    if (editor != null) {
                        int startOffset = offset + 1;
                        editor.getCaretModel().moveToOffset(startOffset);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().setSelection(startOffset, startOffset + defaultType.length());
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "alias";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyAddTypeQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRemoveTypeQuickFix
    extends LocalQuickFixBase {
        protected MyRemoveTypeQuickFix(@NotNull String name2, @NotNull String familyName) {
            if (name2 == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(0);
            }
            if (familyName == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(1);
            }
            super(name2, familyName);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            SqlTypeElement type;
            PsiElement alias;
            if (project == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyRemoveTypeQuickFix.$$$reportNull$$$0(3);
            }
            if ((alias = descriptor.getPsiElement()) instanceof SqlDefinition && (type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)alias, SqlTypeElement.class)) != null) {
                type.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/postgres/inspections/PgSelectFromProcedureInspection$MyRemoveTypeQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

