/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.toolwindow;

import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.toolwindow.StatisticsEventLogMessageBuilder;
import com.intellij.internal.statistic.toolwindow.StatisticsEventLogToolWindow;
import com.intellij.util.text.DateFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogMessageBuilder;", "", "()V", "buildLogMessage", "", "logEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "eventDataToString", "eventData", "", "shortenProjectId", "projectId", "valueToString", "value", "key", "Companion", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogMessageBuilder {
    private static final Set<String> systemFields;
    private static final int projectIdPrefixSize = 8;
    private static final int projectIdSuffixSize = 2;
    private static final int maxProjectIdSize = 10;
    public static final Companion Companion;

    @NotNull
    public final String buildLogMessage(@NotNull LogEvent logEvent) {
        Intrinsics.checkParameterIsNotNull((Object)logEvent, (String)"logEvent");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append(DateFormatUtil.formatTimeWithSeconds((long)logEvent.getTime()));
        LogEventAction event = logEvent.getEvent();
        $this$buildString.append(" - [\"" + logEvent.getGroup().getId() + "\", v" + logEvent.getGroup().getVersion() + "]: \"" + event.getId() + "\" ");
        int count = event.getCount();
        if (!event.getState() && count > 1) {
            $this$buildString.append("(count=" + count + ") ");
        }
        $this$buildString.append("{");
        $this$buildString.append(this.eventDataToString(event.getData()));
        $this$buildString.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String eventDataToString(Map<String, ? extends Object> eventData) {
        void $this$mapTo$iv$iv;
        String key;
        boolean bl;
        Map.Entry entry;
        Map.Entry $dstr$key$_u24__u24;
        Map $this$filterTo$iv$iv;
        Map<String, ? extends Object> $this$filter$iv = eventData;
        boolean $i$f$filter = false;
        Map<String, ? extends Object> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            $dstr$key$_u24__u24 = element$iv$iv = iterator.next();
            boolean bl3 = false;
            entry = $dstr$key$_u24__u24;
            bl = false;
            key = (String)entry.getKey();
            if (!(!systemFields.contains(key))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var7_7 = $this$mapTo$iv$iv;
        bl2 = false;
        for (Map.Entry item$iv$iv : var7_7.entrySet()) {
            void $dstr$key$value;
            $dstr$key$_u24__u24 = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl4 = false;
            entry = $dstr$key$value;
            bl = false;
            key = (String)entry.getKey();
            entry = $dstr$key$value;
            bl = false;
            Object value = entry.getValue();
            String string = '\"' + key + "\":" + this.valueToString(value, key);
            object.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String valueToString(Object value, String key) {
        String string;
        if (value instanceof Collection) {
            String values2 = CollectionsKt.joinToString$default((Iterable)((Iterable)value), null, null, null, (int)0, null, (Function1)valueToString.values.1.INSTANCE, (int)31, null);
            string = '[' + values2 + ']';
        } else {
            String valueAsString = value.toString();
            if (Intrinsics.areEqual((Object)key, (Object)"project")) {
                valueAsString = this.shortenProjectId(valueAsString);
            }
            string = '\"' + valueAsString + '\"';
        }
        return string;
    }

    private final String shortenProjectId(String projectId) {
        boolean isRejected;
        int length;
        block7: {
            boolean bl;
            length = projectId.length();
            Iterable $this$any$iv = StatisticsEventLogToolWindow.Companion.getRejectedValidationTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValidationResultType it = (ValidationResultType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)projectId)) continue;
                    bl = true;
                    break block7;
                }
                bl = isRejected = false;
            }
        }
        if (!isRejected) {
            CharSequence charSequence = projectId;
            int n = 0;
            if (!StringsKt.isBlank((CharSequence)charSequence) && length > 10) {
                charSequence = projectId;
                n = 0;
                int n2 = 8;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)charSequence2).substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string2 = string;
                charSequence = projectId;
                n = length - 2;
                stringBuilder = stringBuilder.append(string2).append("...");
                n2 = 0;
                CharSequence charSequence3 = charSequence;
                if (charSequence3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)charSequence3).substring(n, length);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string2 = string3;
                return stringBuilder.append(string2).toString();
            }
        }
        return projectId;
    }

    static {
        Companion = new Companion(null);
        systemFields = SetsKt.setOf((Object[])new String[]{"last", "created"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogMessageBuilder$Companion;", "", "()V", "maxProjectIdSize", "", "projectIdPrefixSize", "projectIdSuffixSize", "systemFields", "", "", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

