/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.codeInsight.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.HamlBundle;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLTagImpl;

public class HamlNestedTagContentInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            HamlNestedTagContentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            HamlNestedTagContentInspection.$$$reportNull$$$0(1);
        }
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (!(tag instanceof HAMLTagImpl) || ((HAMLTagImpl)tag).isTagNameEmpty()) {
                    return;
                }
                boolean firstLine = true;
                boolean textOnFirstLine = false;
                for (PsiElement element : tag.getChildren()) {
                    if (element.getNode().getElementType() == HAMLTokenTypes.TEXT && firstLine) {
                        textOnFirstLine = true;
                        continue;
                    }
                    if (element.getNode().getElementType() == HAMLTokenTypes.EOL) {
                        firstLine = false;
                        continue;
                    }
                    if (firstLine || !textOnFirstLine || element instanceof PsiComment || element.getText().trim().length() <= 0) continue;
                    holder.registerProblem((PsiElement)tag, HamlBundle.message("inspection.illegal.nesting.message", tag.getName()), new LocalQuickFix[0]);
                    return;
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/haml/codeInsight/inspections/HamlNestedTagContentInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

