/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.Dbms;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DbmsExtension<T>
extends KeyedExtensionCollector<T, Dbms> {
    public DbmsExtension(@NonNls @NotNull String epName) {
        if (epName == null) {
            DbmsExtension.$$$reportNull$$$0(0);
        }
        super(epName);
    }

    @NotNull
    protected String keyToString(@NotNull Dbms key) {
        if (key == null) {
            DbmsExtension.$$$reportNull$$$0(1);
        }
        String string = key.getName();
        if (string == null) {
            DbmsExtension.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<T> allForDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbmsExtension.$$$reportNull$$$0(3);
        }
        List list = this.forKey(dbms);
        if (list == null) {
            DbmsExtension.$$$reportNull$$$0(4);
        }
        return list;
    }

    public T forDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbmsExtension.$$$reportNull$$$0(5);
        }
        return (T)this.findSingle(dbms);
    }

    @NotNull
    public List<Bean<T>> allExtensions() {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPointIfRegistered(this.getName());
        List list = point == null ? Collections.emptyList() : point.getExtensionList();
        if (list == null) {
            DbmsExtension.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull Dbms key) {
        ExtensionPoint point;
        ArrayList result;
        if (stringKey == null) {
            DbmsExtension.$$$reportNull$$$0(7);
        }
        if (key == null) {
            DbmsExtension.$$$reportNull$$$0(8);
        }
        if ((result = super.buildExtensions(stringKey, (Object)key)).isEmpty() && key != Dbms.UNKNOWN && !this.forKey(Dbms.UNKNOWN).isEmpty() && (point = Extensions.getRootArea().getExtensionPointIfRegistered(this.getName())) != null) {
            result = new ArrayList();
            for (Bean bean : (Bean[])point.getExtensions()) {
                if (!StringUtil.equals((CharSequence)bean.dbmsStr, (CharSequence)Dbms.UNKNOWN.getName())) continue;
                try {
                    result.add(bean.doGetInstance(bean.findExtensionClass(bean.implementationClass), key));
                }
                catch (ReflectiveOperationException e) {
                    throw new PluginException((Throwable)e, bean.getPluginId());
                }
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            DbmsExtension.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/DbmsExtension";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/DbmsExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allForDbms";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "allExtensions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allForDbms";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forDbms";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InstanceBean<T>
    extends Bean<T> {
        @Override
        @NotNull
        T doGetInstance(@NotNull Class<T> aClass, @NotNull Dbms dbms) throws ReflectiveOperationException {
            if (aClass == null) {
                InstanceBean.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                InstanceBean.$$$reportNull$$$0(1);
            }
            Object object = aClass.getField("INSTANCE").get(null);
            if (object == null) {
                InstanceBean.$$$reportNull$$$0(2);
            }
            return (T)object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/DbmsExtension$InstanceBean";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/DbmsExtension$InstanceBean";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doGetInstance";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Bean<T>
    extends AbstractExtensionPointBean
    implements KeyedLazyInstance<T> {
        @Attribute(value="dbms")
        public String dbmsStr;
        @Attribute(value="implementationClass")
        public String implementationClass;
        private final NotNullLazyValue<T> myHandler = NotNullLazyValue.createValue(() -> {
            try {
                return this.doGetInstance(this.findExtensionClass(this.implementationClass), this.getDbms());
            }
            catch (ReflectiveOperationException e) {
                throw new PluginException((Throwable)e, this.getPluginId());
            }
        });

        @NotNull
        T doGetInstance(@NotNull Class<T> tClass, @NotNull Dbms dbms) throws ReflectiveOperationException {
            T t;
            if (tClass == null) {
                Bean.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                Bean.$$$reportNull$$$0(1);
            }
            try {
                t = this.instantiateByDbms(tClass, dbms);
            }
            catch (NoSuchMethodException ignored) {
                Object object = ReflectionUtil.newInstance(tClass);
                if (object == null) {
                    Bean.$$$reportNull$$$0(3);
                }
                return (T)object;
            }
            if (t == null) {
                Bean.$$$reportNull$$$0(2);
            }
            return t;
        }

        @NotNull
        T instantiateByDbms(@NotNull Class<T> tClass, @NotNull Dbms dbms) throws ReflectiveOperationException {
            if (tClass == null) {
                Bean.$$$reportNull$$$0(4);
            }
            if (dbms == null) {
                Bean.$$$reportNull$$$0(5);
            }
            Constructor<T> constructor = tClass.getConstructor(Dbms.class);
            constructor.setAccessible(true);
            T t = constructor.newInstance(dbms);
            if (t == null) {
                Bean.$$$reportNull$$$0(6);
            }
            return t;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.byName(this.dbmsStr);
            if (dbms == null) {
                throw new IllegalArgumentException("Dbms not found: " + this.dbmsStr);
            }
            Dbms dbms2 = dbms;
            if (dbms2 == null) {
                Bean.$$$reportNull$$$0(7);
            }
            return dbms2;
        }

        @NotNull
        public T getInstance() {
            Object object = this.myHandler.getValue();
            if (object == null) {
                Bean.$$$reportNull$$$0(8);
            }
            return (T)object;
        }

        public String getKey() {
            return this.dbmsStr;
        }

        public String toString() {
            return this.dbmsStr;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tClass";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/DbmsExtension$Bean";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/DbmsExtension$Bean";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetInstance";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiateByDbms";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doGetInstance";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "instantiateByDbms";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

