//
// Copyright (c) 2019-2024 Ruben Perez Hidalgo (rubenperez038 at gmail dot com)
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//

#ifndef BOOST_MYSQL_IMPL_INTERNAL_ERROR_SERVER_ERROR_TO_STRING_IPP
#define BOOST_MYSQL_IMPL_INTERNAL_ERROR_SERVER_ERROR_TO_STRING_IPP

// This file was generated by server_errors.py - do not edit directly.

#include <boost/mysql/detail/config.hpp>
#include <boost/mysql/impl/internal/error/server_error_to_string.hpp>

namespace boost {
namespace mysql {
namespace detail {

BOOST_MYSQL_STATIC_IF_COMPILED
constexpr const char* common_error_messages[] = {
    "er_hashchk",
    "er_nisamchk",
    "er_no",
    "er_yes",
    "er_cant_create_file",
    "er_cant_create_table",
    "er_cant_create_db",
    "er_db_create_exists",
    "er_db_drop_exists",
    "er_db_drop_delete",
    "er_db_drop_rmdir",
    "er_cant_delete_file",
    "er_cant_find_system_rec",
    "er_cant_get_stat",
    "er_cant_get_wd",
    "er_cant_lock",
    "er_cant_open_file",
    "er_file_not_found",
    "er_cant_read_dir",
    "er_cant_set_wd",
    "er_checkread",
    "er_disk_full",
    "er_dup_key",
    "er_error_on_close",
    "er_error_on_read",
    "er_error_on_rename",
    "er_error_on_write",
    "er_file_used",
    "er_filsort_abort",
    "er_form_not_found",
    "er_get_errno",
    "er_illegal_ha",
    "er_key_not_found",
    "er_not_form_file",
    "er_not_keyfile",
    "er_old_keyfile",
    "er_open_as_readonly",
    "er_outofmemory",
    "er_out_of_sortmemory",
    "er_unexpected_eof",
    "er_con_count_error",
    "er_out_of_resources",
    "er_bad_host_error",
    "er_handshake_error",
    "er_dbaccess_denied_error",
    "er_access_denied_error",
    "er_no_db_error",
    "er_unknown_com_error",
    "er_bad_null_error",
    "er_bad_db_error",
    "er_table_exists_error",
    "er_bad_table_error",
    "er_non_uniq_error",
    "er_server_shutdown",
    "er_bad_field_error",
    "er_wrong_field_with_group",
    "er_wrong_group_field",
    "er_wrong_sum_select",
    "er_wrong_value_count",
    "er_too_long_ident",
    "er_dup_fieldname",
    "er_dup_keyname",
    "er_dup_entry",
    "er_wrong_field_spec",
    "er_parse_error",
    "er_empty_query",
    "er_nonuniq_table",
    "er_invalid_default",
    "er_multiple_pri_key",
    "er_too_many_keys",
    "er_too_many_key_parts",
    "er_too_long_key",
    "er_key_column_does_not_exits",
    "er_blob_used_as_key",
    "er_too_big_fieldlength",
    "er_wrong_auto_key",
    nullptr,
    "er_normal_shutdown",
    "er_got_signal",
    "er_shutdown_complete",
    "er_forcing_close",
    "er_ipsock_error",
    "er_no_such_index",
    "er_wrong_field_terminators",
    "er_blobs_and_no_terminated",
    "er_textfile_not_readable",
    "er_file_exists_error",
    "er_load_info",
    "er_alter_info",
    "er_wrong_sub_key",
    "er_cant_remove_all_fields",
    "er_cant_drop_field_or_key",
    "er_insert_info",
    "er_update_table_used",
    "er_no_such_thread",
    "er_kill_denied_error",
    "er_no_tables_used",
    "er_too_big_set",
    "er_no_unique_logfile",
    "er_table_not_locked_for_write",
    "er_table_not_locked",
    nullptr,
    "er_wrong_db_name",
    "er_wrong_table_name",
    "er_too_big_select",
    "er_unknown_error",
    "er_unknown_procedure",
    "er_wrong_paramcount_to_procedure",
    "er_wrong_parameters_to_procedure",
    "er_unknown_table",
    "er_field_specified_twice",
    "er_invalid_group_func_use",
    "er_unsupported_extension",
    "er_table_must_have_columns",
    "er_record_file_full",
    "er_unknown_character_set",
    "er_too_many_tables",
    "er_too_many_fields",
    "er_too_big_rowsize",
    "er_stack_overrun",
    nullptr,
    "er_null_column_in_index",
    "er_cant_find_udf",
    "er_cant_initialize_udf",
    "er_udf_no_paths",
    "er_udf_exists",
    "er_cant_open_library",
    "er_cant_find_dl_entry",
    "er_function_not_defined",
    "er_host_is_blocked",
    "er_host_not_privileged",
    "er_password_anonymous_user",
    "er_password_not_allowed",
    "er_password_no_match",
    "er_update_info",
    "er_cant_create_thread",
    "er_wrong_value_count_on_row",
    "er_cant_reopen_table",
    "er_invalid_use_of_null",
    "er_regexp_error",
    "er_mix_of_group_func_and_fields",
    "er_nonexisting_grant",
    "er_tableaccess_denied_error",
    "er_columnaccess_denied_error",
    "er_illegal_grant_for_table",
    "er_grant_wrong_host_or_user",
    "er_no_such_table",
    "er_nonexisting_table_grant",
    "er_not_allowed_command",
    "er_syntax_error",
    nullptr,
    nullptr,
    "er_aborting_connection",
    "er_net_packet_too_large",
    "er_net_read_error_from_pipe",
    "er_net_fcntl_error",
    "er_net_packets_out_of_order",
    "er_net_uncompress_error",
    "er_net_read_error",
    "er_net_read_interrupted",
    "er_net_error_on_write",
    "er_net_write_interrupted",
    "er_too_long_string",
    "er_table_cant_handle_blob",
    "er_table_cant_handle_auto_increment",
    nullptr,
    "er_wrong_column_name",
    "er_wrong_key_column",
    "er_wrong_mrg_table",
    "er_dup_unique",
    "er_blob_key_without_length",
    "er_primary_cant_have_null",
    "er_too_many_rows",
    "er_requires_primary_key",
    "er_no_raid_compiled",
    "er_update_without_key_in_safe_mode",
    nullptr,
    "er_check_no_such_table",
    "er_check_not_implemented",
    "er_cant_do_this_during_an_transaction",
    "er_error_during_commit",
    "er_error_during_rollback",
    "er_error_during_flush_logs",
    "er_error_during_checkpoint",
    "er_new_aborting_connection",
    nullptr,
    "er_flush_master_binlog_closed",
    "er_index_rebuild",
    "er_master",
    "er_master_net_read",
    "er_master_net_write",
    "er_ft_matching_key_not_found",
    "er_lock_or_active_transaction",
    "er_unknown_system_variable",
    "er_crashed_on_usage",
    "er_crashed_on_repair",
    "er_warning_not_complete_rollback",
    "er_trans_cache_full",
    "er_slave_must_stop",
    "er_slave_not_running",
    "er_bad_slave",
    "er_master_info",
    "er_slave_thread",
    "er_too_many_user_connections",
    "er_set_constants_only",
    "er_lock_wait_timeout",
    "er_lock_table_full",
    "er_read_only_transaction",
    "er_drop_db_with_read_lock",
    "er_create_db_with_read_lock",
    "er_wrong_arguments",
    "er_no_permission_to_create_user",
    "er_union_tables_in_different_dir",
    "er_lock_deadlock",
    "er_table_cant_handle_ft",
    "er_cannot_add_foreign",
    "er_no_referenced_row",
    "er_row_is_referenced",
    "er_connect_to_master",
    "er_query_on_master",
    "er_error_when_executing_command",
    "er_wrong_usage",
    "er_wrong_number_of_columns_in_select",
    "er_cant_update_with_readlock",
    "er_mixing_not_allowed",
    "er_dup_argument",
    "er_user_limit_reached",
    "er_specific_access_denied_error",
    "er_local_variable",
    "er_global_variable",
    "er_no_default",
    "er_wrong_value_for_var",
    "er_wrong_type_for_var",
    "er_var_cant_be_read",
    "er_cant_use_option_here",
    "er_not_supported_yet",
    "er_master_fatal_error_reading_binlog",
    "er_slave_ignored_table",
    "er_incorrect_global_local_var",
    "er_wrong_fk_def",
    "er_key_ref_do_not_match_table_ref",
    "er_operand_columns",
    "er_subquery_no_1_row",
    "er_unknown_stmt_handler",
    "er_corrupt_help_db",
    "er_cyclic_reference",
    "er_auto_convert",
    "er_illegal_reference",
    "er_derived_must_have_alias",
    "er_select_reduced",
    "er_tablename_not_allowed_here",
    "er_not_supported_auth_mode",
    "er_spatial_cant_have_null",
    "er_collation_charset_mismatch",
    "er_slave_was_running",
    "er_slave_was_not_running",
    "er_too_big_for_uncompress",
    "er_zlib_z_mem_error",
    "er_zlib_z_buf_error",
    "er_zlib_z_data_error",
    "er_cut_value_group_concat",
    "er_warn_too_few_records",
    "er_warn_too_many_records",
    "er_warn_null_to_notnull",
    "er_warn_data_out_of_range",
    "warn_data_truncated",
    "er_warn_using_other_handler",
    "er_cant_aggregate_2collations",
    "er_drop_user",
    "er_revoke_grants",
    "er_cant_aggregate_3collations",
    "er_cant_aggregate_ncollations",
    "er_variable_is_not_struct",
    "er_unknown_collation",
    "er_slave_ignored_ssl_params",
    "er_server_is_in_secure_auth_mode",
    "er_warn_field_resolved",
    "er_bad_slave_until_cond",
    "er_missing_skip_slave",
    "er_until_cond_ignored",
    "er_wrong_name_for_index",
    "er_wrong_name_for_catalog",
    "er_warn_qc_resize",
    "er_bad_ft_column",
    "er_unknown_key_cache",
    "er_warn_hostname_wont_work",
    "er_unknown_storage_engine",
    "er_warn_deprecated_syntax",
    "er_non_updatable_table",
    "er_feature_disabled",
    "er_option_prevents_statement",
    "er_duplicated_value_in_type",
    "er_truncated_wrong_value",
    "er_too_much_auto_timestamp_cols",
    "er_invalid_on_update",
    "er_unsupported_ps",
    "er_get_errmsg",
    "er_get_temporary_errmsg",
    "er_unknown_time_zone",
    "er_warn_invalid_timestamp",
    "er_invalid_character_string",
    "er_warn_allowed_packet_overflowed",
    "er_conflicting_declarations",
    "er_sp_no_recursive_create",
    "er_sp_already_exists",
    "er_sp_does_not_exist",
    "er_sp_drop_failed",
    "er_sp_store_failed",
    "er_sp_lilabel_mismatch",
    "er_sp_label_redefine",
    "er_sp_label_mismatch",
    "er_sp_uninit_var",
    "er_sp_badselect",
    "er_sp_badreturn",
    "er_sp_badstatement",
    "er_update_log_deprecated_ignored",
    "er_update_log_deprecated_translated",
    "er_query_interrupted",
    "er_sp_wrong_no_of_args",
    "er_sp_cond_mismatch",
    "er_sp_noreturn",
    "er_sp_noreturnend",
    "er_sp_bad_cursor_query",
    "er_sp_bad_cursor_select",
    "er_sp_cursor_mismatch",
    "er_sp_cursor_already_open",
    "er_sp_cursor_not_open",
    "er_sp_undeclared_var",
    "er_sp_wrong_no_of_fetch_args",
    "er_sp_fetch_no_data",
    "er_sp_dup_param",
    "er_sp_dup_var",
    "er_sp_dup_cond",
    "er_sp_dup_curs",
    "er_sp_cant_alter",
    "er_sp_subselect_nyi",
    "er_stmt_not_allowed_in_sf_or_trg",
    "er_sp_varcond_after_curshndlr",
    "er_sp_cursor_after_handler",
    "er_sp_case_not_found",
    "er_fparser_too_big_file",
    "er_fparser_bad_header",
    "er_fparser_eof_in_comment",
    "er_fparser_error_in_parameter",
    "er_fparser_eof_in_unknown_parameter",
    "er_view_no_explain",
    "er_frm_unknown_type",
    "er_wrong_object",
    "er_nonupdateable_column",
    nullptr,
    "er_view_select_clause",
    "er_view_select_variable",
    "er_view_select_tmptable",
    "er_view_wrong_list",
    "er_warn_view_merge",
    "er_warn_view_without_key",
    "er_view_invalid",
    "er_sp_no_drop_sp",
    "er_sp_goto_in_hndlr",
    "er_trg_already_exists",
    "er_trg_does_not_exist",
    "er_trg_on_view_or_temp_table",
    "er_trg_cant_change_row",
    "er_trg_no_such_row_in_trg",
    "er_no_default_for_field",
    "er_division_by_zero",
    "er_truncated_wrong_value_for_field",
    "er_illegal_value_for_type",
    "er_view_nonupd_check",
    "er_view_check_failed",
    "er_procaccess_denied_error",
    "er_relay_log_fail",
    "er_passwd_length",
    "er_unknown_target_binlog",
    "er_io_err_log_index_read",
    "er_binlog_purge_prohibited",
    "er_fseek_fail",
    "er_binlog_purge_fatal_err",
    "er_log_in_use",
    "er_log_purge_unknown_err",
    "er_relay_log_init",
    "er_no_binary_logging",
    "er_reserved_syntax",
    "er_wsas_failed",
    "er_diff_groups_proc",
    "er_no_group_for_proc",
    "er_order_with_proc",
    "er_logging_prohibit_changing_of",
    "er_no_file_mapping",
    "er_wrong_magic",
    "er_ps_many_param",
    "er_key_part_0",
    "er_view_checksum",
    "er_view_multiupdate",
    "er_view_no_insert_field_list",
    "er_view_delete_merge_view",
    "er_cannot_user",
    "er_xaer_nota",
    "er_xaer_inval",
    "er_xaer_rmfail",
    "er_xaer_outside",
    "er_xaer_rmerr",
    "er_xa_rbrollback",
    "er_nonexisting_proc_grant",
    "er_proc_auto_grant_fail",
    "er_proc_auto_revoke_fail",
    "er_data_too_long",
    "er_sp_bad_sqlstate",
    "er_startup",
    "er_load_from_fixed_size_rows_to_var",
    "er_cant_create_user_with_grant",
    "er_wrong_value_for_type",
    "er_table_def_changed",
    "er_sp_dup_handler",
    "er_sp_not_var_arg",
    "er_sp_no_retset",
    "er_cant_create_geometry_object",
    "er_failed_routine_break_binlog",
    "er_binlog_unsafe_routine",
    "er_binlog_create_routine_need_super",
    "er_exec_stmt_with_open_cursor",
    "er_stmt_has_no_open_cursor",
    "er_commit_not_allowed_in_sf_or_trg",
    "er_no_default_for_view_field",
    "er_sp_no_recursion",
    "er_too_big_scale",
    "er_too_big_precision",
    "er_m_bigger_than_d",
    "er_wrong_lock_of_system_table",
    "er_connect_to_foreign_data_source",
    "er_query_on_foreign_data_source",
    "er_foreign_data_source_doesnt_exist",
    "er_foreign_data_string_invalid_cant_create",
    "er_foreign_data_string_invalid",
    "er_cant_create_federated_table",
    "er_trg_in_wrong_schema",
    "er_stack_overrun_need_more",
    "er_too_long_body",
    "er_warn_cant_drop_default_keycache",
    "er_too_big_displaywidth",
    "er_xaer_dupid",
    "er_datetime_function_overflow",
    "er_cant_update_used_table_in_sf_or_trg",
    "er_view_prevent_update",
    "er_ps_no_recursion",
    "er_sp_cant_set_autocommit",
    "er_malformed_definer",
    "er_view_frm_no_user",
    "er_view_other_user",
    "er_no_such_user",
    "er_forbid_schema_change",
    "er_row_is_referenced_2",
    "er_no_referenced_row_2",
    "er_sp_bad_var_shadow",
    "er_trg_no_definer",
    "er_old_file_format",
    "er_sp_recursion_limit",
    "er_sp_proc_table_corrupt",
    "er_sp_wrong_name",
    "er_table_needs_upgrade",
    "er_sp_no_aggregate",
    "er_max_prepared_stmt_count_reached",
    "er_view_recursive",
    "er_non_grouping_field_used",
    "er_table_cant_handle_spkeys",
    "er_no_triggers_on_system_schema",
    "er_removed_spaces",
    "er_autoinc_read_failed",
    "er_username",
    "er_hostname",
    "er_wrong_string_length",
    "er_non_insertable_table",
    "er_admin_wrong_mrg_table",
    "er_too_high_level_of_nesting_for_select",
    "er_name_becomes_empty",
    "er_ambiguous_field_term",
    "er_foreign_server_exists",
    "er_foreign_server_doesnt_exist",
    "er_illegal_ha_create_option",
    "er_partition_requires_values_error",
    "er_partition_wrong_values_error",
    "er_partition_maxvalue_error",
    "er_partition_subpartition_error",
    "er_partition_subpart_mix_error",
    "er_partition_wrong_no_part_error",
    "er_partition_wrong_no_subpart_error",
    "er_wrong_expr_in_partition_func_error",
    nullptr,
    "er_field_not_found_part_error",
    "er_list_of_fields_only_in_hash_error",
    "er_inconsistent_partition_info_error",
    "er_partition_func_not_allowed_error",
    "er_partitions_must_be_defined_error",
    "er_range_not_increasing_error",
    "er_inconsistent_type_of_functions_error",
    "er_multiple_def_const_in_list_part_error",
    "er_partition_entry_error",
    "er_mix_handler_error",
    "er_partition_not_defined_error",
    "er_too_many_partitions_error",
    "er_subpartition_error",
    "er_cant_create_handler_file",
    "er_blob_field_in_part_func_error",
    "er_unique_key_need_all_fields_in_pf",
    "er_no_parts_error",
    "er_partition_mgmt_on_nonpartitioned",
    nullptr,
    "er_drop_partition_non_existent",
    "er_drop_last_partition",
    "er_coalesce_only_on_hash_partition",
    "er_reorg_hash_only_on_same_no",
    "er_reorg_no_param_error",
    "er_only_on_range_list_partition",
    "er_add_partition_subpart_error",
    "er_add_partition_no_new_partition",
    "er_coalesce_partition_no_partition",
    "er_reorg_partition_not_exist",
    "er_same_name_partition",
    "er_no_binlog_error",
    "er_consecutive_reorg_partitions",
    "er_reorg_outside_range",
    "er_partition_function_failure",
    "er_part_state_error",
    "er_limited_part_range",
    "er_plugin_is_not_loaded",
    "er_wrong_value",
    "er_no_partition_for_given_value",
    "er_filegroup_option_only_once",
    "er_create_filegroup_failed",
    "er_drop_filegroup_failed",
    "er_tablespace_auto_extend_error",
    "er_wrong_size_number",
    "er_size_overflow_error",
    "er_alter_filegroup_failed",
    "er_binlog_row_logging_failed",
    "er_binlog_row_wrong_table_def",
    "er_binlog_row_rbr_to_sbr",
    "er_event_already_exists",
    "er_event_store_failed",
    "er_event_does_not_exist",
    "er_event_cant_alter",
    "er_event_drop_failed",
    "er_event_interval_not_positive_or_too_big",
    "er_event_ends_before_starts",
    "er_event_exec_time_in_the_past",
    "er_event_open_table_failed",
    "er_event_neither_m_expr_nor_m_at",
    nullptr,
    nullptr,
    "er_event_cannot_delete",
    "er_event_compile_error",
    "er_event_same_name",
    "er_event_data_too_long",
    "er_drop_index_fk",
    "er_warn_deprecated_syntax_with_ver",
    "er_cant_write_lock_log_table",
    "er_cant_lock_log_table",
    nullptr,
    "er_col_count_doesnt_match_please_update",
    "er_temp_table_prevents_switch_out_of_rbr",
    "er_stored_function_prevents_switch_binlog_format",
    nullptr,
    "er_partition_no_temporary",
    "er_partition_const_domain_error",
    "er_partition_function_is_not_allowed",
    "er_ddl_log_error",
    "er_null_in_values_less_than",
    "er_wrong_partition_name",
    "er_cant_change_tx_characteristics",
    "er_dup_entry_autoincrement_case",
    "er_event_modify_queue_error",
    "er_event_set_var_error",
    "er_partition_merge_error",
    "er_cant_activate_log",
    "er_rbr_not_available",
    "er_base64_decode_error",
    "er_event_recursion_forbidden",
    "er_events_db_error",
    "er_only_integers_allowed",
    "er_unsuported_log_engine",
    "er_bad_log_statement",
    "er_cant_rename_log_table",
    "er_wrong_paramcount_to_native_fct",
    "er_wrong_parameters_to_native_fct",
    "er_wrong_parameters_to_stored_fct",
    "er_native_fct_name_collision",
    "er_dup_entry_with_key_name",
    "er_binlog_purge_emfile",
    "er_event_cannot_create_in_the_past",
    "er_event_cannot_alter_in_the_past",
    "er_slave_incident",
    "er_no_partition_for_given_value_silent",
    "er_binlog_unsafe_statement",
    nullptr,
    "er_slave_relay_log_read_failure",
    "er_slave_relay_log_write_failure",
    "er_slave_create_event_failure",
    "er_slave_master_com_failure",
    "er_binlog_logging_impossible",
    "er_view_no_creation_ctx",
    "er_view_invalid_creation_ctx",
    "er_sr_invalid_creation_ctx",
    "er_trg_corrupted_file",
    "er_trg_no_creation_ctx",
    "er_trg_invalid_creation_ctx",
    "er_event_invalid_creation_ctx",
    "er_trg_cant_open_table",
    "er_cant_create_sroutine",
    nullptr,
    "er_no_format_description_event_before_binlog_statement",
    "er_slave_corrupt_event",
    nullptr,
    "er_log_purge_no_file",
    "er_xa_rbtimeout",
    "er_xa_rbdeadlock",
    "er_need_reprepare",
    "er_delayed_not_supported",
    "warn_no_master_info",
    "warn_option_ignored",
    "er_plugin_delete_builtin",
    "warn_plugin_busy",
    "er_variable_is_readonly",
    "er_warn_engine_transaction_rollback",
    "er_slave_heartbeat_failure",
    "er_slave_heartbeat_value_out_of_range",
    nullptr,
    "er_conflict_fn_parse_error",
    "er_exceptions_write_error",
    "er_too_long_table_comment",
    "er_too_long_field_comment",
    "er_func_inexistent_name_collision",
    "er_database_name",
    "er_table_name",
    "er_partition_name",
    "er_subpartition_name",
    "er_temporary_name",
    "er_renamed_name",
    "er_too_many_concurrent_trxs",
    "warn_non_ascii_separator_not_implemented",
    "er_debug_sync_timeout",
    "er_debug_sync_hit_limit",
    "er_dup_signal_set",
    "er_signal_warn",
    "er_signal_not_found",
    "er_signal_exception",
    "er_resignal_without_active_handler",
    "er_signal_bad_condition_type",
    "warn_cond_item_truncated",
    "er_cond_item_too_long",
    "er_unknown_locale",
    "er_slave_ignore_server_ids",
    "er_query_cache_disabled",
    "er_same_name_partition_field",
    "er_partition_column_list_error",
    "er_wrong_type_column_value_error",
    "er_too_many_partition_func_fields_error",
    "er_maxvalue_in_values_in",
    "er_too_many_values_error",
    "er_row_single_partition_field_error",
    "er_field_type_not_allowed_as_partition_field",
    "er_partition_fields_too_long",
    "er_binlog_row_engine_and_stmt_engine",
    "er_binlog_row_mode_and_stmt_engine",
    "er_binlog_unsafe_and_stmt_engine",
    "er_binlog_row_injection_and_stmt_engine",
    "er_binlog_stmt_mode_and_row_engine",
    "er_binlog_row_injection_and_stmt_mode",
    "er_binlog_multiple_engines_and_self_logging_engine",
    "er_binlog_unsafe_limit",
    nullptr,
    "er_binlog_unsafe_system_table",
    "er_binlog_unsafe_autoinc_columns",
    "er_binlog_unsafe_udf",
    "er_binlog_unsafe_system_variable",
    "er_binlog_unsafe_system_function",
    "er_binlog_unsafe_nontrans_after_trans",
    "er_message_and_statement",
    "er_slave_conversion_failed",
    "er_slave_cant_create_conversion",
    "er_inside_transaction_prevents_switch_binlog_format",
    "er_path_length",
    "er_warn_deprecated_syntax_no_replacement",
    "er_wrong_native_table_structure",
    "er_wrong_perfschema_usage",
    "er_warn_i_s_skipped_table",
    "er_inside_transaction_prevents_switch_binlog_direct",
    "er_stored_function_prevents_switch_binlog_direct",
    "er_spatial_must_have_geom_col",
    "er_too_long_index_comment",
    "er_lock_aborted",
    "er_data_out_of_range",
    "er_wrong_spvar_type_in_limit",
    "er_binlog_unsafe_multiple_engines_and_self_logging_engine",
    "er_binlog_unsafe_mixed_statement",
    "er_inside_transaction_prevents_switch_sql_log_bin",
    "er_stored_function_prevents_switch_sql_log_bin",
    "er_failed_read_from_par_file",
    "er_values_is_not_int_type_error",
    "er_access_denied_no_password_error",
    "er_set_password_auth_plugin",
    "er_grant_plugin_user_exists",
    "er_truncate_illegal_fk",
    "er_plugin_is_permanent",
    "er_slave_heartbeat_value_out_of_range_min",
    "er_slave_heartbeat_value_out_of_range_max",
    "er_stmt_cache_full",
    "er_multi_update_key_conflict",
    "er_table_needs_rebuild",
    "warn_option_below_limit",
    "er_index_column_too_long",
    "er_error_in_trigger_body",
    "er_error_in_unknown_trigger_body",
    "er_index_corrupt",
    "er_undo_record_too_big",
    "er_binlog_unsafe_insert_ignore_select",
    "er_binlog_unsafe_insert_select_update",
    "er_binlog_unsafe_replace_select",
    "er_binlog_unsafe_create_ignore_select",
    "er_binlog_unsafe_create_replace_select",
    "er_binlog_unsafe_update_ignore",
    nullptr,
    nullptr,
    "er_binlog_unsafe_write_autoinc_select",
    "er_binlog_unsafe_create_select_autoinc",
    "er_binlog_unsafe_insert_two_keys",
    nullptr,
    nullptr,
    "er_binlog_unsafe_autoinc_not_first",
    "er_cannot_load_from_table_v2",
    "er_master_delay_value_out_of_range",
    "er_only_fd_and_rbr_events_allowed_in_binlog_statement",
    "er_partition_exchange_different_option",
    "er_partition_exchange_part_table",
    "er_partition_exchange_temp_table",
    "er_partition_instead_of_subpartition",
    "er_unknown_partition",
    "er_tables_different_metadata",
    "er_row_does_not_match_partition",
    "er_binlog_cache_size_greater_than_max",
    "er_warn_index_not_applicable",
    "er_partition_exchange_foreign_key",
    "er_no_such_key_value",
    nullptr,
    "er_network_read_event_checksum_failure",
    "er_binlog_read_event_checksum_failure",
    "er_binlog_stmt_cache_size_greater_than_max",
    "er_cant_update_table_in_create_table_select",
    "er_partition_clause_on_nonpartitioned",
    "er_row_does_not_match_given_partition_set",
    nullptr,
    "er_change_rpl_info_repository_failure",
    "er_warning_not_complete_rollback_with_created_temp_table",
    "er_warning_not_complete_rollback_with_dropped_temp_table",
    "er_mts_feature_is_not_supported",
    "er_mts_updated_dbs_greater_max",
    "er_mts_cant_parallel",
    "er_mts_inconsistent_data",
    "er_fulltext_not_supported_with_partitioning",
    "er_da_invalid_condition_number",
    "er_insecure_plain_text",
    "er_insecure_change_master",
    "er_foreign_duplicate_key_with_child_info",
    "er_foreign_duplicate_key_without_child_info",
    "er_sqlthread_with_secure_slave",
    "er_table_has_no_ft",
    "er_variable_not_settable_in_sf_or_trigger",
    "er_variable_not_settable_in_transaction",
    "er_gtid_next_is_not_in_gtid_next_list",
    nullptr,
    "er_set_statement_cannot_invoke_function",
    "er_gtid_next_cant_be_automatic_if_gtid_next_list_is_non_null",
    "er_skipping_logged_transaction",
    "er_malformed_gtid_set_specification",
    "er_malformed_gtid_set_encoding",
    "er_malformed_gtid_specification",
    "er_gno_exhausted",
    "er_bad_slave_auto_position",
    nullptr,
    "er_cant_do_implicit_commit_in_trx_when_gtid_next_is_set",
    nullptr,
    "er_gtid_mode_requires_binlog",
    "er_cant_set_gtid_next_to_gtid_when_gtid_mode_is_off",
    "er_cant_set_gtid_next_to_anonymous_when_gtid_mode_is_on",
    "er_cant_set_gtid_next_list_to_non_null_when_gtid_mode_is_off",
    nullptr,
    "er_gtid_unsafe_non_transactional_table",
    "er_gtid_unsafe_create_select",
    "er_gtid_unsafe_create_drop_temporary_table_in_transaction",
    "er_gtid_mode_can_only_change_one_step_at_a_time",
    "er_master_has_purged_required_gtids",
    "er_cant_set_gtid_next_when_owning_gtid",
    "er_unknown_explain_format",
    "er_cant_execute_in_read_only_transaction",
    "er_too_long_table_partition_comment",
    "er_slave_configuration",
    "er_innodb_ft_limit",
    "er_innodb_no_ft_temp_table",
    "er_innodb_ft_wrong_docid_column",
    "er_innodb_ft_wrong_docid_index",
    "er_innodb_online_log_too_big",
    "er_unknown_alter_algorithm",
    "er_unknown_alter_lock",
    "er_mts_change_master_cant_run_with_gaps",
    "er_mts_recovery_failure",
    "er_mts_reset_workers",
    "er_col_count_doesnt_match_corrupted_v2",
    "er_slave_silent_retry_transaction",
    nullptr,
    "er_table_schema_mismatch",
    "er_table_in_system_tablespace",
    "er_io_read_error",
    "er_io_write_error",
    "er_tablespace_missing",
    "er_tablespace_exists",
    "er_tablespace_discarded",
    "er_internal_error",
    "er_innodb_import_error",
    "er_innodb_index_corrupt",
    "er_invalid_year_column_length",
    "er_not_valid_password",
    "er_must_change_password",
    "er_fk_no_index_child",
    "er_fk_no_index_parent",
    "er_fk_fail_add_system",
    "er_fk_cannot_open_parent",
    "er_fk_incorrect_option",
    nullptr,
    "er_password_format",
    "er_fk_column_cannot_drop",
    "er_fk_column_cannot_drop_child",
    "er_fk_column_not_null",
    "er_dup_index",
    "er_fk_column_cannot_change",
    "er_fk_column_cannot_change_child",
    nullptr,
    "er_malformed_packet",
    "er_read_only_mode",
    nullptr,
    "er_variable_not_settable_in_sp",
    "er_cant_set_gtid_purged_when_gtid_mode_is_off",
    "er_cant_set_gtid_purged_when_gtid_executed_is_not_empty",
    "er_cant_set_gtid_purged_when_owned_gtids_is_not_empty",
    "er_gtid_purged_was_changed",
    "er_gtid_executed_was_changed",
    "er_binlog_stmt_mode_and_no_repl_tables",
    "er_alter_operation_not_supported",
    "er_alter_operation_not_supported_reason",
    "er_alter_operation_not_supported_reason_copy",
    "er_alter_operation_not_supported_reason_partition",
    "er_alter_operation_not_supported_reason_fk_rename",
    "er_alter_operation_not_supported_reason_column_type",
    "er_alter_operation_not_supported_reason_fk_check",
    nullptr,
    "er_alter_operation_not_supported_reason_nopk",
    "er_alter_operation_not_supported_reason_autoinc",
    "er_alter_operation_not_supported_reason_hidden_fts",
    "er_alter_operation_not_supported_reason_change_fts",
    "er_alter_operation_not_supported_reason_fts",
    "er_sql_slave_skip_counter_not_settable_in_gtid_mode",
    "er_dup_unknown_in_index",
    "er_ident_causes_too_long_path",
    "er_alter_operation_not_supported_reason_not_null",
    "er_must_change_password_login",
    "er_row_in_wrong_partition",
    "er_mts_event_bigger_pending_jobs_size_max",
    "er_innodb_no_ft_uses_parser",
    "er_binlog_logical_corruption",
    "er_warn_purge_log_in_use",
    "er_warn_purge_log_is_active",
    "er_auto_increment_conflict",
    "warn_on_blockhole_in_rbr",
    "er_slave_mi_init_repository",
    "er_slave_rli_init_repository",
    "er_access_denied_change_user_error",
    "er_innodb_read_only",
    "er_stop_slave_sql_thread_timeout",
    "er_stop_slave_io_thread_timeout",
    "er_table_corrupt",
    "er_temp_file_write_failure",
    "er_innodb_ft_aux_not_hex_id",

};

} // namespace detail
} // namespace mysql
} // namespace boost

const char* boost::mysql::detail::common_error_to_string(int v) noexcept
{
    constexpr int first = 1000;
    constexpr int last = first + sizeof(common_error_messages) / sizeof(const char*);
    return (v >= first && v < last) ? common_error_messages[v - first] : nullptr;
}

const char* boost::mysql::detail::mysql_error_to_string(int v) noexcept
{
    switch (v)
    {
    case 1076: return "er_ready";
    case 1101: return "er_blob_cant_have_default";
    case 1120: return "er_wrong_outer_join_unused";
    case 1176: return "er_key_does_not_exits";
    case 1185: return "er_dump_not_implemented";
    case 1349: return "er_view_select_derived_unused";
    case 1487: return "er_no_const_expr_in_range_or_list_error";
    case 1506: return "er_foreign_key_on_partitioned";
    case 1547: return "er_obsolete_col_count_doesnt_match_corrupted";
    case 1548: return "er_obsolete_cannot_load_from_table";
    case 1557: return "er_foreign_duplicate_key_old_unused";
    case 1561: return "er_ndb_cant_switch_binlog_format";
    case 1593: return "er_binlog_fatal_error";
    case 1608: return "er_never_used";
    case 1611: return "er_load_data_invalid_column_unused";
    case 1625: return "er_ndb_replication_schema_error";
    case 1720: return "er_plugin_no_uninstall";
    case 1721: return "er_plugin_no_install";
    case 1725: return "er_table_in_fk_check";
    case 1726: return "er_unsupported_engine";
    case 1742: return "er_rpl_info_data_too_long";
    case 1768: return "er_cant_change_gtid_next_in_transaction";
    case 1777: return "er_auto_position_requires_gtid_mode_not_off";
    case 1779: return "er_gtid_mode_on_requires_enforce_gtid_consistency_on";
    case 1807: return "er_discard_fk_checks_running";
    case 1826: return "er_fk_dup_name";
    case 1837: return "er_gtid_next_type_undefined_gtid";
    case 1880: return "er_old_temporals_upgraded";
    case 1881: return "er_innodb_forced_recovery";
    case 1882: return "er_aes_invalid_iv";
    case 1883: return "er_plugin_cannot_be_uninstalled";
    case 1884: return "er_gtid_unsafe_binlog_splittable_statement_and_assigned_gtid";
    case 1885: return "er_slave_has_more_gtids_than_master";
    case 1886: return "er_missing_key";
    case 1887: return "warn_named_pipe_access_everyone";
    case 1888: return "er_found_missing_gtids";
    case 3000: return "er_file_corrupt";
    case 3001: return "er_error_on_master";
    case 3002: return "er_inconsistent_error";
    case 3003: return "er_storage_engine_not_loaded";
    case 3004: return "er_get_stacked_da_without_active_handler";
    case 3005: return "er_warn_legacy_syntax_converted";
    case 3006: return "er_binlog_unsafe_fulltext_plugin";
    case 3007: return "er_cannot_discard_temporary_table";
    case 3008: return "er_fk_depth_exceeded";
    case 3009: return "er_col_count_doesnt_match_please_update_v2";
    case 3010: return "er_warn_trigger_doesnt_have_created";
    case 3011: return "er_referenced_trg_does_not_exist";
    case 3012: return "er_explain_not_supported";
    case 3013: return "er_invalid_field_size";
    case 3014: return "er_missing_ha_create_option";
    case 3015: return "er_engine_out_of_memory";
    case 3016: return "er_password_expire_anonymous_user";
    case 3017: return "er_slave_sql_thread_must_stop";
    case 3018: return "er_no_ft_materialized_subquery";
    case 3019: return "er_innodb_undo_log_full";
    case 3020: return "er_invalid_argument_for_logarithm";
    case 3021: return "er_slave_channel_io_thread_must_stop";
    case 3022: return "er_warn_open_temp_tables_must_be_zero";
    case 3023: return "er_warn_only_master_log_file_no_pos";
    case 3024: return "er_query_timeout";
    case 3025: return "er_non_ro_select_disable_timer";
    case 3026: return "er_dup_list_entry";
    case 3027: return "er_sql_mode_no_effect";
    case 3028: return "er_aggregate_order_for_union";
    case 3029: return "er_aggregate_order_non_agg_query";
    case 3030: return "er_slave_worker_stopped_previous_thd_error";
    case 3031: return "er_dont_support_slave_preserve_commit_order";
    case 3032: return "er_server_offline_mode";
    case 3033: return "er_gis_different_srids";
    case 3034: return "er_gis_unsupported_argument";
    case 3035: return "er_gis_unknown_error";
    case 3036: return "er_gis_unknown_exception";
    case 3037: return "er_gis_invalid_data";
    case 3038: return "er_boost_geometry_empty_input_exception";
    case 3039: return "er_boost_geometry_centroid_exception";
    case 3040: return "er_boost_geometry_overlay_invalid_input_exception";
    case 3041: return "er_boost_geometry_turn_info_exception";
    case 3042: return "er_boost_geometry_self_intersection_point_exception";
    case 3043: return "er_boost_geometry_unknown_exception";
    case 3044: return "er_std_bad_alloc_error";
    case 3045: return "er_std_domain_error";
    case 3046: return "er_std_length_error";
    case 3047: return "er_std_invalid_argument";
    case 3048: return "er_std_out_of_range_error";
    case 3049: return "er_std_overflow_error";
    case 3050: return "er_std_range_error";
    case 3051: return "er_std_underflow_error";
    case 3052: return "er_std_logic_error";
    case 3053: return "er_std_runtime_error";
    case 3054: return "er_std_unknown_exception";
    case 3055: return "er_gis_data_wrong_endianess";
    case 3056: return "er_change_master_password_length";
    case 3057: return "er_user_lock_wrong_name";
    case 3058: return "er_user_lock_deadlock";
    case 3059: return "er_replace_inaccessible_rows";
    case 3060: return "er_alter_operation_not_supported_reason_gis";
    case 3061: return "er_illegal_user_var";
    case 3062: return "er_gtid_mode_off";
    case 3063: return "er_unsupported_by_replication_thread";
    case 3064: return "er_incorrect_type";
    case 3065: return "er_field_in_order_not_select";
    case 3066: return "er_aggregate_in_order_not_select";
    case 3067: return "er_invalid_rpl_wild_table_filter_pattern";
    case 3068: return "er_net_ok_packet_too_large";
    case 3069: return "er_invalid_json_data";
    case 3070: return "er_invalid_geojson_missing_member";
    case 3071: return "er_invalid_geojson_wrong_type";
    case 3072: return "er_invalid_geojson_unspecified";
    case 3073: return "er_dimension_unsupported";
    case 3074: return "er_slave_channel_does_not_exist";
    case 3075: return "er_slave_multiple_channels_host_port";
    case 3076: return "er_slave_channel_name_invalid_or_too_long";
    case 3077: return "er_slave_new_channel_wrong_repository";
    case 3078: return "er_slave_channel_delete";
    case 3079: return "er_slave_multiple_channels_cmd";
    case 3080: return "er_slave_max_channels_exceeded";
    case 3081: return "er_slave_channel_must_stop";
    case 3082: return "er_slave_channel_not_running";
    case 3083: return "er_slave_channel_was_running";
    case 3084: return "er_slave_channel_was_not_running";
    case 3085: return "er_slave_channel_sql_thread_must_stop";
    case 3086: return "er_slave_channel_sql_skip_counter";
    case 3087: return "er_wrong_field_with_group_v2";
    case 3088: return "er_mix_of_group_func_and_fields_v2";
    case 3089: return "er_warn_deprecated_sysvar_update";
    case 3090: return "er_warn_deprecated_sqlmode";
    case 3091: return "er_cannot_log_partial_drop_database_with_gtid";
    case 3092: return "er_group_replication_configuration";
    case 3093: return "er_group_replication_running";
    case 3094: return "er_group_replication_applier_init_error";
    case 3095: return "er_group_replication_stop_applier_thread_timeout";
    case 3096: return "er_group_replication_communication_layer_session_error";
    case 3097: return "er_group_replication_communication_layer_join_error";
    case 3098: return "er_before_dml_validation_error";
    case 3099: return "er_prevents_variable_without_rbr";
    case 3100: return "er_run_hook_error";
    case 3101: return "er_transaction_rollback_during_commit";
    case 3102: return "er_generated_column_function_is_not_allowed";
    case 3103: return "er_unsupported_alter_inplace_on_virtual_column";
    case 3104: return "er_wrong_fk_option_for_generated_column";
    case 3105: return "er_non_default_value_for_generated_column";
    case 3106: return "er_unsupported_action_on_generated_column";
    case 3107: return "er_generated_column_non_prior";
    case 3108: return "er_dependent_by_generated_column";
    case 3109: return "er_generated_column_ref_auto_inc";
    case 3110: return "er_feature_not_available";
    case 3111: return "er_cant_set_gtid_mode";
    case 3112: return "er_cant_use_auto_position_with_gtid_mode_off";
    case 3113: return "er_cant_replicate_anonymous_with_auto_position";
    case 3114: return "er_cant_replicate_anonymous_with_gtid_mode_on";
    case 3115: return "er_cant_replicate_gtid_with_gtid_mode_off";
    case 3116: return "er_cant_enforce_gtid_consistency_with_ongoing_gtid_violating_tx";
    case 3117: return "er_enforce_gtid_consistency_warn_with_ongoing_gtid_violating_tx";
    case 3118: return "er_account_has_been_locked";
    case 3119: return "er_wrong_tablespace_name";
    case 3120: return "er_tablespace_is_not_empty";
    case 3121: return "er_wrong_file_name";
    case 3122: return "er_boost_geometry_inconsistent_turns_exception";
    case 3123: return "er_warn_optimizer_hint_syntax_error";
    case 3124: return "er_warn_bad_max_execution_time";
    case 3125: return "er_warn_unsupported_max_execution_time";
    case 3126: return "er_warn_conflicting_hint";
    case 3127: return "er_warn_unknown_qb_name";
    case 3128: return "er_unresolved_hint_name";
    case 3129: return "er_warn_on_modifying_gtid_executed_table";
    case 3130: return "er_pluggable_protocol_command_not_supported";
    case 3131: return "er_locking_service_wrong_name";
    case 3132: return "er_locking_service_deadlock";
    case 3133: return "er_locking_service_timeout";
    case 3134: return "er_gis_max_points_in_geometry_overflowed";
    case 3135: return "er_sql_mode_merged";
    case 3136: return "er_vtoken_plugin_token_mismatch";
    case 3137: return "er_vtoken_plugin_token_not_found";
    case 3138: return "er_cant_set_variable_when_owning_gtid";
    case 3139: return "er_slave_channel_operation_not_allowed";
    case 3140: return "er_invalid_json_text";
    case 3141: return "er_invalid_json_text_in_param";
    case 3142: return "er_invalid_json_binary_data";
    case 3143: return "er_invalid_json_path";
    case 3144: return "er_invalid_json_charset";
    case 3145: return "er_invalid_json_charset_in_function";
    case 3146: return "er_invalid_type_for_json";
    case 3147: return "er_invalid_cast_to_json";
    case 3148: return "er_invalid_json_path_charset";
    case 3149: return "er_invalid_json_path_wildcard";
    case 3150: return "er_json_value_too_big";
    case 3151: return "er_json_key_too_big";
    case 3152: return "er_json_used_as_key";
    case 3153: return "er_json_vacuous_path";
    case 3154: return "er_json_bad_one_or_all_arg";
    case 3155: return "er_numeric_json_value_out_of_range";
    case 3156: return "er_invalid_json_value_for_cast";
    case 3157: return "er_json_document_too_deep";
    case 3158: return "er_json_document_null_key";
    case 3159: return "er_secure_transport_required";
    case 3160: return "er_no_secure_transports_configured";
    case 3161: return "er_disabled_storage_engine";
    case 3162: return "er_user_does_not_exist";
    case 3163: return "er_user_already_exists";
    case 3164: return "er_audit_api_abort";
    case 3165: return "er_invalid_json_path_array_cell";
    case 3166: return "er_bufpool_resize_inprogress";
    case 3167: return "er_feature_disabled_see_doc";
    case 3168: return "er_server_isnt_available";
    case 3169: return "er_session_was_killed";
    case 3170: return "er_capacity_exceeded";
    case 3171: return "er_capacity_exceeded_in_range_optimizer";
    case 3172: return "er_table_needs_upg_part";
    case 3173: return "er_cant_wait_for_executed_gtid_set_while_owning_a_gtid";
    case 3174: return "er_cannot_add_foreign_base_col_virtual";
    case 3175: return "er_cannot_create_virtual_index_constraint";
    case 3176: return "er_error_on_modifying_gtid_executed_table";
    case 3177: return "er_lock_refused_by_engine";
    case 3178: return "er_unsupported_alter_online_on_virtual_column";
    case 3179: return "er_master_key_rotation_not_supported_by_se";
    case 3180: return "er_master_key_rotation_error_by_se";
    case 3181: return "er_master_key_rotation_binlog_failed";
    case 3182: return "er_master_key_rotation_se_unavailable";
    case 3183: return "er_tablespace_cannot_encrypt";
    case 3184: return "er_invalid_encryption_option";
    case 3185: return "er_cannot_find_key_in_keyring";
    case 3186: return "er_capacity_exceeded_in_parser";
    case 3187: return "er_unsupported_alter_encryption_inplace";
    case 3188: return "er_keyring_udf_keyring_service_error";
    case 3189: return "er_user_column_old_length";
    case 3190: return "er_cant_reset_master";
    case 3191: return "er_group_replication_max_group_size";
    case 3192: return "er_cannot_add_foreign_base_col_stored";
    case 3193: return "er_table_referenced";
    case 3194: return "er_partition_engine_deprecated_for_table";
    case 3195: return "er_warn_using_geomfromwkb_to_set_srid_zero";
    case 3196: return "er_warn_using_geomfromwkb_to_set_srid";
    case 3197: return "er_xa_retry";
    case 3198: return "er_keyring_aws_udf_aws_kms_error";
    case 3199: return "er_binlog_unsafe_xa";
    case 3200: return "er_udf_error";
    case 3201: return "er_keyring_migration_failure";
    case 3202: return "er_keyring_access_denied_error";
    case 3203: return "er_keyring_migration_status";
    case 3204: return "er_plugin_failed_to_open_tables";
    case 3205: return "er_plugin_failed_to_open_table";
    case 3206: return "er_audit_log_no_keyring_plugin_installed";
    case 3207: return "er_audit_log_encryption_password_has_not_been_set";
    case 3208: return "er_audit_log_could_not_create_aes_key";
    case 3209: return "er_audit_log_encryption_password_cannot_be_fetched";
    case 3210: return "er_audit_log_json_filtering_not_enabled";
    case 3211: return "er_audit_log_udf_insufficient_privilege";
    case 3212: return "er_audit_log_super_privilege_required";
    case 3213: return "er_could_not_reinitialize_audit_log_filters";
    case 3214: return "er_audit_log_udf_invalid_argument_type";
    case 3215: return "er_audit_log_udf_invalid_argument_count";
    case 3216: return "er_audit_log_has_not_been_installed";
    case 3217: return "er_audit_log_udf_read_invalid_max_array_length_arg_type";
    case 3218: return "er_audit_log_udf_read_invalid_max_array_length_arg_value";
    case 3219: return "er_audit_log_json_filter_parsing_error";
    case 3220: return "er_audit_log_json_filter_name_cannot_be_empty";
    case 3221: return "er_audit_log_json_user_name_cannot_be_empty";
    case 3222: return "er_audit_log_json_filter_does_not_exists";
    case 3223: return "er_audit_log_user_first_character_must_be_alphanumeric";
    case 3224: return "er_audit_log_user_name_invalid_character";
    case 3225: return "er_audit_log_host_name_invalid_character";
    case 3226: return "obsolete_warn_deprecated_maxdb_sql_mode_for_timestamp";
    case 3228: return "er_cant_open_error_log";
    case 3230: return "er_cant_start_server_named_pipe";
    case 3231: return "er_write_set_exceeds_limit";
    case 3232: return "er_deprecated_tls_version_session";
    case 3233: return "er_warn_deprecated_tls_version";
    case 3234: return "er_warn_wrong_native_table_structure";
    case 3235: return "er_aes_invalid_kdf_name";
    case 3236: return "er_aes_invalid_kdf_iterations";
    case 3237: return "warn_aes_key_size";
    case 3238: return "er_aes_invalid_kdf_option_size";
    case 3500: return "er_unsupport_compressed_temporary_table";
    case 3501: return "er_acl_operation_failed";
    case 3502: return "er_unsupported_index_algorithm";
    case 3503: return "er_no_such_db";
    case 3504: return "er_too_big_enum";
    case 3505: return "er_too_long_set_enum_value";
    case 3506: return "er_invalid_dd_object";
    case 3507: return "er_updating_dd_table";
    case 3508: return "er_invalid_dd_object_id";
    case 3509: return "er_invalid_dd_object_name";
    case 3510: return "er_tablespace_missing_with_name";
    case 3511: return "er_too_long_routine_comment";
    case 3512: return "er_sp_load_failed";
    case 3513: return "er_invalid_bitwise_operands_size";
    case 3514: return "er_invalid_bitwise_aggregate_operands_size";
    case 3515: return "er_warn_unsupported_hint";
    case 3516: return "er_unexpected_geometry_type";
    case 3517: return "er_srs_parse_error";
    case 3518: return "er_srs_proj_parameter_missing";
    case 3519: return "er_warn_srs_not_found";
    case 3520: return "er_srs_not_cartesian";
    case 3521: return "er_srs_not_cartesian_undefined";
    case 3522: return "er_pk_index_cant_be_invisible";
    case 3523: return "er_unknown_authid";
    case 3524: return "er_failed_role_grant";
    case 3525: return "er_open_role_tables";
    case 3526: return "er_failed_default_roles";
    case 3527: return "er_components_no_scheme";
    case 3528: return "er_components_no_scheme_service";
    case 3529: return "er_components_cant_load";
    case 3530: return "er_role_not_granted";
    case 3531: return "er_failed_revoke_role";
    case 3532: return "er_rename_role";
    case 3533: return "er_components_cant_acquire_service_implementation";
    case 3534: return "er_components_cant_satisfy_dependency";
    case 3535: return "er_components_load_cant_register_service_implementation";
    case 3536: return "er_components_load_cant_initialize";
    case 3537: return "er_components_unload_not_loaded";
    case 3538: return "er_components_unload_cant_deinitialize";
    case 3539: return "er_components_cant_release_service";
    case 3540: return "er_components_unload_cant_unregister_service";
    case 3541: return "er_components_cant_unload";
    case 3542: return "er_warn_unload_the_not_persisted";
    case 3543: return "er_component_table_incorrect";
    case 3544: return "er_component_manipulate_row_failed";
    case 3545: return "er_components_unload_duplicate_in_group";
    case 3546: return "er_cant_set_gtid_purged_due_sets_constraints";
    case 3547: return "er_cannot_lock_user_management_caches";
    case 3548: return "er_srs_not_found";
    case 3549: return "er_variable_not_persisted";
    case 3550: return "er_is_query_invalid_clause";
    case 3551: return "er_unable_to_store_statistics";
    case 3552: return "er_no_system_schema_access";
    case 3553: return "er_no_system_tablespace_access";
    case 3554: return "er_no_system_table_access";
    case 3555: return "er_no_system_table_access_for_dictionary_table";
    case 3556: return "er_no_system_table_access_for_system_table";
    case 3557: return "er_no_system_table_access_for_table";
    case 3558: return "er_invalid_option_key";
    case 3559: return "er_invalid_option_value";
    case 3560: return "er_invalid_option_key_value_pair";
    case 3561: return "er_invalid_option_start_character";
    case 3562: return "er_invalid_option_end_character";
    case 3563: return "er_invalid_option_characters";
    case 3564: return "er_duplicate_option_key";
    case 3565: return "er_warn_srs_not_found_axis_order";
    case 3566: return "er_no_access_to_native_fct";
    case 3567: return "er_reset_master_to_value_out_of_range";
    case 3568: return "er_unresolved_table_lock";
    case 3569: return "er_duplicate_table_lock";
    case 3570: return "er_binlog_unsafe_skip_locked";
    case 3571: return "er_binlog_unsafe_nowait";
    case 3572: return "er_lock_nowait";
    case 3573: return "er_cte_recursive_requires_union";
    case 3574: return "er_cte_recursive_requires_nonrecursive_first";
    case 3575: return "er_cte_recursive_forbids_aggregation";
    case 3576: return "er_cte_recursive_forbidden_join_order";
    case 3577: return "er_cte_recursive_requires_single_reference";
    case 3578: return "er_switch_tmp_engine";
    case 3579: return "er_window_no_such_window";
    case 3580: return "er_window_circularity_in_window_graph";
    case 3581: return "er_window_no_child_partitioning";
    case 3582: return "er_window_no_inherit_frame";
    case 3583: return "er_window_no_redefine_order_by";
    case 3584: return "er_window_frame_start_illegal";
    case 3585: return "er_window_frame_end_illegal";
    case 3586: return "er_window_frame_illegal";
    case 3587: return "er_window_range_frame_order_type";
    case 3588: return "er_window_range_frame_temporal_type";
    case 3589: return "er_window_range_frame_numeric_type";
    case 3590: return "er_window_range_bound_not_constant";
    case 3591: return "er_window_duplicate_name";
    case 3592: return "er_window_illegal_order_by";
    case 3593: return "er_window_invalid_window_func_use";
    case 3594: return "er_window_invalid_window_func_alias_use";
    case 3595: return "er_window_nested_window_func_use_in_window_spec";
    case 3596: return "er_window_rows_interval_use";
    case 3597: return "er_window_no_group_order_unused";
    case 3598: return "er_window_explain_json";
    case 3599: return "er_window_function_ignores_frame";
    case 3600: return "er_wl9236_now_unused";
    case 3601: return "er_invalid_no_of_args";
    case 3602: return "er_field_in_grouping_not_group_by";
    case 3603: return "er_too_long_tablespace_comment";
    case 3604: return "er_engine_cant_drop_table";
    case 3605: return "er_engine_cant_drop_missing_table";
    case 3606: return "er_tablespace_dup_filename";
    case 3607: return "er_db_drop_rmdir2";
    case 3608: return "er_imp_no_files_matched";
    case 3609: return "er_imp_schema_does_not_exist";
    case 3610: return "er_imp_table_already_exists";
    case 3611: return "er_imp_incompatible_mysqld_version";
    case 3612: return "er_imp_incompatible_dd_version";
    case 3613: return "er_imp_incompatible_sdi_version";
    case 3614: return "er_warn_invalid_hint";
    case 3615: return "er_var_does_not_exist";
    case 3616: return "er_longitude_out_of_range";
    case 3617: return "er_latitude_out_of_range";
    case 3618: return "er_not_implemented_for_geographic_srs";
    case 3619: return "er_illegal_privilege_level";
    case 3620: return "er_no_system_view_access";
    case 3621: return "er_component_filter_flabbergasted";
    case 3622: return "er_part_expr_too_long";
    case 3623: return "er_udf_drop_dynamically_registered";
    case 3624: return "er_unable_to_store_column_statistics";
    case 3625: return "er_unable_to_update_column_statistics";
    case 3626: return "er_unable_to_drop_column_statistics";
    case 3627: return "er_unable_to_build_histogram";
    case 3628: return "er_mandatory_role";
    case 3629: return "er_missing_tablespace_file";
    case 3630: return "er_persist_only_access_denied_error";
    case 3631: return "er_cmd_need_super";
    case 3632: return "er_path_in_datadir";
    case 3633: return "er_clone_ddl_in_progress";
    case 3634: return "er_clone_too_many_concurrent_clones";
    case 3635: return "er_applier_log_event_validation_error";
    case 3636: return "er_cte_max_recursion_depth";
    case 3637: return "er_not_hint_updatable_variable";
    case 3638: return "er_credentials_contradict_to_history";
    case 3639: return "er_warning_password_history_clauses_void";
    case 3640: return "er_client_does_not_support";
    case 3641: return "er_i_s_skipped_tablespace";
    case 3642: return "er_tablespace_engine_mismatch";
    case 3643: return "er_wrong_srid_for_column";
    case 3644: return "er_cannot_alter_srid_due_to_index";
    case 3645: return "er_warn_binlog_partial_updates_disabled";
    case 3646: return "er_warn_binlog_v1_row_events_disabled";
    case 3647: return "er_warn_binlog_partial_updates_suggests_partial_images";
    case 3648: return "er_could_not_apply_json_diff";
    case 3649: return "er_corrupted_json_diff";
    case 3650: return "er_resource_group_exists";
    case 3651: return "er_resource_group_not_exists";
    case 3652: return "er_invalid_vcpu_id";
    case 3653: return "er_invalid_vcpu_range";
    case 3654: return "er_invalid_thread_priority";
    case 3655: return "er_disallowed_operation";
    case 3656: return "er_resource_group_busy";
    case 3657: return "er_resource_group_disabled";
    case 3658: return "er_feature_unsupported";
    case 3659: return "er_attribute_ignored";
    case 3660: return "er_invalid_thread_id";
    case 3661: return "er_resource_group_bind_failed";
    case 3662: return "er_invalid_use_of_force_option";
    case 3663: return "er_group_replication_command_failure";
    case 3664: return "er_sdi_operation_failed";
    case 3665: return "er_missing_json_table_value";
    case 3666: return "er_wrong_json_table_value";
    case 3667: return "er_tf_must_have_alias";
    case 3668: return "er_tf_forbidden_join_type";
    case 3669: return "er_jt_value_out_of_range";
    case 3670: return "er_jt_max_nested_path";
    case 3671: return "er_password_expiration_not_supported_by_auth_method";
    case 3672: return "er_invalid_geojson_crs_not_top_level";
    case 3673: return "er_bad_null_error_not_ignored";
    case 3674: return "warn_useless_spatial_index";
    case 3675: return "er_disk_full_nowait";
    case 3676: return "er_parse_error_in_digest_fn";
    case 3677: return "er_undisclosed_parse_error_in_digest_fn";
    case 3678: return "er_schema_dir_exists";
    case 3679: return "er_schema_dir_missing";
    case 3680: return "er_schema_dir_create_failed";
    case 3681: return "er_schema_dir_unknown";
    case 3682: return "er_only_implemented_for_srid_0_and_4326";
    case 3683: return "er_binlog_expire_log_days_and_secs_used_together";
    case 3684: return "er_regexp_buffer_overflow";
    case 3685: return "er_regexp_illegal_argument";
    case 3686: return "er_regexp_index_outofbounds_error";
    case 3687: return "er_regexp_internal_error";
    case 3688: return "er_regexp_rule_syntax";
    case 3689: return "er_regexp_bad_escape_sequence";
    case 3690: return "er_regexp_unimplemented";
    case 3691: return "er_regexp_mismatched_paren";
    case 3692: return "er_regexp_bad_interval";
    case 3693: return "er_regexp_max_lt_min";
    case 3694: return "er_regexp_invalid_back_ref";
    case 3695: return "er_regexp_look_behind_limit";
    case 3696: return "er_regexp_missing_close_bracket";
    case 3697: return "er_regexp_invalid_range";
    case 3698: return "er_regexp_stack_overflow";
    case 3699: return "er_regexp_time_out";
    case 3700: return "er_regexp_pattern_too_big";
    case 3701: return "er_cant_set_error_log_service";
    case 3702: return "er_empty_pipeline_for_error_log_service";
    case 3703: return "er_component_filter_diagnostics";
    case 3704: return "er_not_implemented_for_cartesian_srs";
    case 3705: return "er_not_implemented_for_projected_srs";
    case 3706: return "er_nonpositive_radius";
    case 3707: return "er_restart_server_failed";
    case 3708: return "er_srs_missing_mandatory_attribute";
    case 3709: return "er_srs_multiple_attribute_definitions";
    case 3710: return "er_srs_name_cant_be_empty_or_whitespace";
    case 3711: return "er_srs_organization_cant_be_empty_or_whitespace";
    case 3712: return "er_srs_id_already_exists";
    case 3713: return "er_warn_srs_id_already_exists";
    case 3714: return "er_cant_modify_srid_0";
    case 3715: return "er_warn_reserved_srid_range";
    case 3716: return "er_cant_modify_srs_used_by_column";
    case 3717: return "er_srs_invalid_character_in_attribute";
    case 3718: return "er_srs_attribute_string_too_long";
    case 3719: return "er_deprecated_utf8_alias";
    case 3720: return "er_deprecated_national";
    case 3721: return "er_invalid_default_utf8mb4_collation";
    case 3722: return "er_unable_to_collect_log_status";
    case 3723: return "er_reserved_tablespace_name";
    case 3724: return "er_unable_to_set_option";
    case 3725: return "er_slave_possibly_diverged_after_ddl";
    case 3726: return "er_srs_not_geographic";
    case 3727: return "er_polygon_too_large";
    case 3728: return "er_spatial_unique_index";
    case 3729: return "er_index_type_not_supported_for_spatial_index";
    case 3730: return "er_fk_cannot_drop_parent";
    case 3731: return "er_geometry_param_longitude_out_of_range";
    case 3732: return "er_geometry_param_latitude_out_of_range";
    case 3733: return "er_fk_cannot_use_virtual_column";
    case 3734: return "er_fk_no_column_parent";
    case 3735: return "er_cant_set_error_suppression_list";
    case 3736: return "er_srs_geogcs_invalid_axes";
    case 3737: return "er_srs_invalid_semi_major_axis";
    case 3738: return "er_srs_invalid_inverse_flattening";
    case 3739: return "er_srs_invalid_angular_unit";
    case 3740: return "er_srs_invalid_prime_meridian";
    case 3741: return "er_transform_source_srs_not_supported";
    case 3742: return "er_transform_target_srs_not_supported";
    case 3743: return "er_transform_source_srs_missing_towgs84";
    case 3744: return "er_transform_target_srs_missing_towgs84";
    case 3745: return "er_temp_table_prevents_switch_session_binlog_format";
    case 3746: return "er_temp_table_prevents_switch_global_binlog_format";
    case 3747: return "er_running_applier_prevents_switch_global_binlog_format";
    case 3748: return "er_client_gtid_unsafe_create_drop_temp_table_in_trx_in_sbr";
    case 3750: return "er_table_without_pk";
    case 3751: return "er_warn_data_truncated_functional_index";
    case 3752: return "er_warn_data_out_of_range_functional_index";
    case 3753: return "er_functional_index_on_json_or_geometry_function";
    case 3754: return "er_functional_index_ref_auto_increment";
    case 3755: return "er_cannot_drop_column_functional_index";
    case 3756: return "er_functional_index_primary_key";
    case 3757: return "er_functional_index_on_lob";
    case 3758: return "er_functional_index_function_is_not_allowed";
    case 3759: return "er_fulltext_functional_index";
    case 3760: return "er_spatial_functional_index";
    case 3761: return "er_wrong_key_column_functional_index";
    case 3762: return "er_functional_index_on_field";
    case 3763: return "er_generated_column_named_function_is_not_allowed";
    case 3764: return "er_generated_column_row_value";
    case 3765: return "er_generated_column_variables";
    case 3766: return "er_dependent_by_default_generated_value";
    case 3767: return "er_default_val_generated_non_prior";
    case 3768: return "er_default_val_generated_ref_auto_inc";
    case 3769: return "er_default_val_generated_function_is_not_allowed";
    case 3770: return "er_default_val_generated_named_function_is_not_allowed";
    case 3771: return "er_default_val_generated_row_value";
    case 3772: return "er_default_val_generated_variables";
    case 3773: return "er_default_as_val_generated";
    case 3774: return "er_unsupported_action_on_default_val_generated";
    case 3775: return "er_gtid_unsafe_alter_add_col_with_default_expression";
    case 3776: return "er_fk_cannot_change_engine";
    case 3777: return "er_warn_deprecated_user_set_expr";
    case 3778: return "er_warn_deprecated_utf8mb3_collation";
    case 3779: return "er_warn_deprecated_nested_comment_syntax";
    case 3780: return "er_fk_incompatible_columns";
    case 3781: return "er_gr_hold_wait_timeout";
    case 3782: return "er_gr_hold_killed";
    case 3783: return "er_gr_hold_member_status_error";
    case 3784: return "er_rpl_encryption_failed_to_fetch_key";
    case 3785: return "er_rpl_encryption_key_not_found";
    case 3786: return "er_rpl_encryption_keyring_invalid_key";
    case 3787: return "er_rpl_encryption_header_error";
    case 3788: return "er_rpl_encryption_failed_to_rotate_logs";
    case 3789: return "er_rpl_encryption_key_exists_unexpected";
    case 3790: return "er_rpl_encryption_failed_to_generate_key";
    case 3791: return "er_rpl_encryption_failed_to_store_key";
    case 3792: return "er_rpl_encryption_failed_to_remove_key";
    case 3793: return "er_rpl_encryption_unable_to_change_option";
    case 3794: return "er_rpl_encryption_master_key_recovery_failed";
    case 3795: return "er_slow_log_mode_ignored_when_not_logging_to_file";
    case 3796: return "er_grp_trx_consistency_not_allowed";
    case 3797: return "er_grp_trx_consistency_before";
    case 3798: return "er_grp_trx_consistency_after_on_trx_begin";
    case 3799: return "er_grp_trx_consistency_begin_not_allowed";
    case 3800: return "er_functional_index_row_value_is_not_allowed";
    case 3801: return "er_rpl_encryption_failed_to_encrypt";
    case 3802: return "er_page_tracking_not_started";
    case 3803: return "er_page_tracking_range_not_tracked";
    case 3804: return "er_page_tracking_cannot_purge";
    case 3805: return "er_rpl_encryption_cannot_rotate_binlog_master_key";
    case 3806: return "er_binlog_master_key_recovery_out_of_combination";
    case 3807: return "er_binlog_master_key_rotation_fail_to_operate_key";
    case 3808: return "er_binlog_master_key_rotation_fail_to_rotate_logs";
    case 3809: return "er_binlog_master_key_rotation_fail_to_reencrypt_log";
    case 3810: return "er_binlog_master_key_rotation_fail_to_cleanup_unused_keys";
    case 3811: return "er_binlog_master_key_rotation_fail_to_cleanup_aux_key";
    case 3812: return "er_non_boolean_expr_for_check_constraint";
    case 3813: return "er_column_check_constraint_references_other_column";
    case 3814: return "er_check_constraint_named_function_is_not_allowed";
    case 3815: return "er_check_constraint_function_is_not_allowed";
    case 3816: return "er_check_constraint_variables";
    case 3817: return "er_check_constraint_row_value";
    case 3818: return "er_check_constraint_refers_auto_increment_column";
    case 3819: return "er_check_constraint_violated";
    case 3820: return "er_check_constraint_refers_unknown_column";
    case 3821: return "er_check_constraint_not_found";
    case 3822: return "er_check_constraint_dup_name";
    case 3823: return "er_check_constraint_clause_using_fk_refer_action_column";
    case 3824: return "warn_unencrypted_table_in_encrypted_db";
    case 3825: return "er_invalid_encryption_request";
    case 3826: return "er_cannot_set_table_encryption";
    case 3827: return "er_cannot_set_database_encryption";
    case 3828: return "er_cannot_set_tablespace_encryption";
    case 3829: return "er_tablespace_cannot_be_encrypted";
    case 3830: return "er_tablespace_cannot_be_decrypted";
    case 3831: return "er_tablespace_type_unknown";
    case 3832: return "er_target_tablespace_unencrypted";
    case 3833: return "er_cannot_use_encryption_clause";
    case 3834: return "er_invalid_multiple_clauses";
    case 3835: return "er_unsupported_use_of_grant_as";
    case 3836: return "er_uknown_auth_id_or_access_denied_for_grant_as";
    case 3837: return "er_dependent_by_functional_index";
    case 3838: return "er_plugin_not_early";
    case 3839: return "er_innodb_redo_log_archive_start_subdir_path";
    case 3840: return "er_innodb_redo_log_archive_start_timeout";
    case 3841: return "er_innodb_redo_log_archive_dirs_invalid";
    case 3842: return "er_innodb_redo_log_archive_label_not_found";
    case 3843: return "er_innodb_redo_log_archive_dir_empty";
    case 3844: return "er_innodb_redo_log_archive_no_such_dir";
    case 3845: return "er_innodb_redo_log_archive_dir_clash";
    case 3846: return "er_innodb_redo_log_archive_dir_permissions";
    case 3847: return "er_innodb_redo_log_archive_file_create";
    case 3848: return "er_innodb_redo_log_archive_active";
    case 3849: return "er_innodb_redo_log_archive_inactive";
    case 3850: return "er_innodb_redo_log_archive_failed";
    case 3851: return "er_innodb_redo_log_archive_session";
    case 3852: return "er_std_regex_error";
    case 3853: return "er_invalid_json_type";
    case 3854: return "er_cannot_convert_string";
    case 3855: return "er_dependent_by_partition_func";
    case 3856: return "er_warn_deprecated_float_auto_increment";
    case 3857: return "er_rpl_cant_stop_slave_while_locked_backup";
    case 3858: return "er_warn_deprecated_float_digits";
    case 3859: return "er_warn_deprecated_float_unsigned";
    case 3860: return "er_warn_deprecated_integer_display_width";
    case 3861: return "er_warn_deprecated_zerofill";
    case 3862: return "er_clone_donor";
    case 3863: return "er_clone_protocol";
    case 3864: return "er_clone_donor_version";
    case 3865: return "er_clone_os";
    case 3866: return "er_clone_platform";
    case 3867: return "er_clone_charset";
    case 3868: return "er_clone_config";
    case 3869: return "er_clone_sys_config";
    case 3870: return "er_clone_plugin_match";
    case 3871: return "er_clone_loopback";
    case 3872: return "er_clone_encryption";
    case 3873: return "er_clone_disk_space";
    case 3874: return "er_clone_in_progress";
    case 3875: return "er_clone_disallowed";
    case 3876: return "er_cannot_grant_roles_to_anonymous_user";
    case 3877: return "er_secondary_engine_plugin";
    case 3878: return "er_second_password_cannot_be_empty";
    case 3879: return "er_db_access_denied";
    case 3880: return "er_da_auth_id_with_system_user_priv_in_mandatory_roles";
    case 3881: return "er_da_rpl_gtid_table_cannot_open";
    case 3882: return "er_geometry_in_unknown_length_unit";
    case 3883: return "er_da_plugin_install_error";
    case 3884: return "er_no_session_temp";
    case 3885: return "er_da_unknown_error_number";
    case 3886: return "er_column_change_size";
    case 3887: return "er_regexp_invalid_capture_group_name";
    case 3888: return "er_da_ssl_library_error";
    case 3889: return "er_secondary_engine";
    case 3890: return "er_secondary_engine_ddl";
    case 3891: return "er_incorrect_current_password";
    case 3892: return "er_missing_current_password";
    case 3893: return "er_current_password_not_required";
    case 3894: return "er_password_cannot_be_retained_on_plugin_change";
    case 3895: return "er_current_password_cannot_be_retained";
    case 3896: return "er_partial_revokes_exist";
    case 3897: return "er_cannot_grant_system_priv_to_mandatory_role";
    case 3898: return "er_xa_replication_filters";
    case 3899: return "er_unsupported_sql_mode";
    case 3900: return "er_regexp_invalid_flag";
    case 3901: return "er_partial_revoke_and_db_grant_both_exists";
    case 3902: return "er_unit_not_found";
    case 3903: return "er_invalid_json_value_for_func_index";
    case 3904: return "er_json_value_out_of_range_for_func_index";
    case 3905: return "er_exceeded_mv_keys_num";
    case 3906: return "er_exceeded_mv_keys_space";
    case 3907: return "er_functional_index_data_is_too_long";
    case 3908: return "er_wrong_mvi_value";
    case 3909: return "er_warn_func_index_not_applicable";
    case 3910: return "er_grp_rpl_udf_error";
    case 3911: return "er_update_gtid_purged_with_gr";
    case 3912: return "er_grouping_on_timestamp_in_dst";
    case 3913: return "er_table_name_causes_too_long_path";
    case 3914: return "er_audit_log_insufficient_privilege";
    case 3916: return "er_da_grp_rpl_started_auto_rejoin";
    case 3917: return "er_sysvar_change_during_query";
    case 3918: return "er_globstat_change_during_query";
    case 3919: return "er_grp_rpl_message_service_init_failure";
    case 3920: return "er_change_master_wrong_compression_algorithm_client";
    case 3921: return "er_change_master_wrong_compression_level_client";
    case 3922: return "er_wrong_compression_algorithm_client";
    case 3923: return "er_wrong_compression_level_client";
    case 3924: return "er_change_master_wrong_compression_algorithm_list_client";
    case 3925: return "er_client_privilege_checks_user_cannot_be_anonymous";
    case 3926: return "er_client_privilege_checks_user_does_not_exist";
    case 3927: return "er_client_privilege_checks_user_corrupt";
    case 3928: return "er_client_privilege_checks_user_needs_rpl_applier_priv";
    case 3929: return "er_warn_da_privilege_not_registered";
    case 3930: return "er_client_keyring_udf_key_invalid";
    case 3931: return "er_client_keyring_udf_key_type_invalid";
    case 3932: return "er_client_keyring_udf_key_too_long";
    case 3933: return "er_client_keyring_udf_key_type_too_long";
    case 3934: return "er_json_schema_validation_error_with_detailed_report";
    case 3935: return "er_da_udf_invalid_charset_specified";
    case 3936: return "er_da_udf_invalid_charset";
    case 3937: return "er_da_udf_invalid_collation";
    case 3938: return "er_da_udf_invalid_extension_argument_type";
    case 3939: return "er_multiple_constraints_with_same_name";
    case 3940: return "er_constraint_not_found";
    case 3941: return "er_alter_constraint_enforcement_not_supported";
    case 3942: return "er_table_value_constructor_must_have_columns";
    case 3943: return "er_table_value_constructor_cannot_have_default";
    case 3944: return "er_client_query_failure_invalid_non_row_format";
    case 3945: return "er_require_row_format_invalid_value";
    case 3946: return "er_failed_to_determine_if_role_is_mandatory";
    case 3947: return "er_failed_to_fetch_mandatory_role_list";
    case 3948: return "er_client_local_files_disabled";
    case 3949: return "er_imp_incompatible_cfg_version";
    case 3950: return "er_da_oom";
    case 3951: return "er_da_udf_invalid_argument_to_set_charset";
    case 3952: return "er_da_udf_invalid_return_type_to_set_charset";
    case 3953: return "er_multiple_into_clauses";
    case 3954: return "er_misplaced_into";
    case 3955: return "er_user_access_denied_for_user_account_blocked_by_password_lock";
    case 3956: return "er_warn_deprecated_year_unsigned";
    case 3957: return "er_clone_network_packet";
    case 3958: return "er_sdi_operation_failed_missing_record";
    case 3959: return "er_dependent_by_check_constraint";
    case 3960: return "er_grp_operation_not_allowed_gr_must_stop";
    case 3961: return "er_warn_deprecated_json_table_on_error_on_empty";
    case 3962: return "er_warn_deprecated_inner_into";
    case 3963: return "er_warn_deprecated_values_function_always_null";
    case 3964: return "er_warn_deprecated_sql_calc_found_rows";
    case 3965: return "er_warn_deprecated_found_rows";
    case 3966: return "er_missing_json_value";
    case 3967: return "er_multiple_json_values";
    case 3968: return "er_hostname_too_long";
    case 3969: return "er_warn_client_deprecated_partition_prefix_key";
    case 3970: return "er_group_replication_user_empty_msg";
    case 3971: return "er_group_replication_user_mandatory_msg";
    case 3972: return "er_group_replication_password_length";
    case 3973: return "er_subquery_transform_rejected";
    case 3974: return "er_da_grp_rpl_recovery_endpoint_format";
    case 3975: return "er_da_grp_rpl_recovery_endpoint_invalid";
    case 3976: return "er_wrong_value_for_var_plus_actionable_part";
    case 3977: return "er_statement_not_allowed_after_start_transaction";
    case 3978: return "er_foreign_key_with_atomic_create_select";
    case 3979: return "er_not_allowed_with_start_transaction";
    case 3980: return "er_invalid_json_attribute";
    case 3981: return "er_engine_attribute_not_supported";
    case 3982: return "er_invalid_user_attribute_json";
    case 3983: return "er_innodb_redo_disabled";
    case 3984: return "er_innodb_redo_archiving_enabled";
    case 3985: return "er_mdl_out_of_resources";
    case 3986: return "er_implicit_comparison_for_json";
    case 3987: return "er_function_does_not_support_character_set";
    case 3988: return "er_impossible_string_conversion";
    case 3989: return "er_schema_read_only";
    case 3990: return "er_rpl_async_reconnect_gtid_mode_off";
    case 3991: return "er_rpl_async_reconnect_auto_position_off";
    case 3992: return "er_disable_gtid_mode_requires_async_reconnect_off";
    case 3993: return "er_disable_auto_position_requires_async_reconnect_off";
    case 3994: return "er_invalid_parameter_use";
    case 3995: return "er_character_set_mismatch";
    case 3996: return "er_warn_var_value_change_not_supported";
    case 3997: return "er_invalid_time_zone_interval";
    case 3998: return "er_invalid_cast";
    case 3999: return "er_hypergraph_not_supported_yet";
    case 4000: return "er_warn_hypergraph_experimental";
    case 4001: return "er_da_no_error_log_parser_configured";
    case 4002: return "er_da_error_log_table_disabled";
    case 4003: return "er_da_error_log_multiple_filters";
    case 4004: return "er_da_cant_open_error_log";
    case 4005: return "er_user_referenced_as_definer";
    case 4006: return "er_cannot_user_referenced_as_definer";
    case 4007: return "er_regex_number_too_big";
    case 4008: return "er_spvar_noninteger_type";
    case 4009: return "warn_unsupported_acl_tables_read";
    case 4010: return "er_binlog_unsafe_acl_table_read_in_dml_ddl";
    case 4011: return "er_stop_replica_monitor_io_thread_timeout";
    case 4012: return "er_starting_replica_monitor_io_thread";
    case 4013: return "er_cant_use_anonymous_to_gtid_with_gtid_mode_not_on";
    case 4014: return "er_cant_combine_anonymous_to_gtid_and_autoposition";
    case 4015: return "er_assign_gtids_to_anonymous_transactions_requires_gtid_mode_on";
    case 4016: return "er_sql_slave_skip_counter_used_with_gtid_mode_on";
    case 4017: return "er_using_assign_gtids_to_anonymous_transactions_as_local_or_uuid";
    case 4018: return "er_cant_set_anonymous_to_gtid_and_wait_until_sql_thd_after_gtids";
    case 4019: return "er_cant_set_sql_after_or_before_gtids_with_anonymous_to_gtid";
    case 4020: return "er_anonymous_to_gtid_uuid_same_as_group_name";
    case 4021: return "er_cant_use_same_uuid_as_group_name";
    case 4022: return "er_grp_rpl_recovery_channel_still_running";
    case 4023: return "er_innodb_invalid_autoextend_size_value";
    case 4024: return "er_innodb_incompatible_with_tablespace";
    case 4025: return "er_innodb_autoextend_size_out_of_range";
    case 4026: return "er_cannot_use_autoextend_size_clause";
    case 4027: return "er_role_granted_to_itself";
    case 4028: return "er_table_must_have_a_visible_column";
    case 4029: return "er_innodb_compression_failure";
    case 4030: return "er_warn_async_conn_failover_network_namespace";
    case 4031: return "er_client_interaction_timeout";
    case 4032: return "er_invalid_cast_to_geometry";
    case 4033: return "er_invalid_cast_polygon_ring_direction";
    case 4034: return "er_gis_different_srids_aggregation";
    case 4035: return "er_reload_keyring_failure";
    case 4036: return "er_sdi_get_keys_invalid_tablespace";
    case 4037: return "er_change_rpl_src_wrong_compression_algorithm_size";
    case 4039: return "er_cant_use_same_uuid_as_view_change_uuid";
    case 4040: return "er_anonymous_to_gtid_uuid_same_as_view_change_uuid";
    case 4041: return "er_grp_rpl_view_change_uuid_fail_get_variable";
    case 4042: return "er_warn_aduit_log_max_size_and_prune_seconds";
    case 4043: return "er_warn_aduit_log_max_size_close_to_rotate_on_size";
    case 4044: return "er_kerberos_create_user";
    case 4045: return "er_install_plugin_conflict_client";
    case 4046: return "er_da_error_log_component_flush_failed";
    case 4047: return "er_warn_sql_after_mts_gaps_gap_not_calculated";
    case 4048: return "er_invalid_assignment_target";
    case 4049: return "er_operation_not_allowed_on_gr_secondary";
    case 4050: return "er_grp_rpl_failover_channel_status_propagation";
    case 4051: return "er_warn_audit_log_format_unix_timestamp_only_when_json";
    case 4052: return "er_invalid_mfa_plugin_specified";
    case 4053: return "er_identified_by_unsupported";
    case 4054: return "er_invalid_plugin_for_registration";
    case 4055: return "er_plugin_requires_registration";
    case 4056: return "er_mfa_method_exists";
    case 4057: return "er_mfa_method_not_exists";
    case 4058: return "er_authentication_policy_mismatch";
    case 4059: return "er_plugin_registration_done";
    case 4060: return "er_invalid_user_for_registration";
    case 4061: return "er_user_registration_failed";
    case 4062: return "er_mfa_methods_invalid_order";
    case 4063: return "er_mfa_methods_identical";
    case 4064: return "er_invalid_mfa_operations_for_passwordless_user";
    case 4065: return "er_change_replication_source_no_options_for_gtid_only";
    case 4066: return "er_change_rep_source_cant_disable_req_row_format_with_gtid_only";
    case 4067: return "er_change_rep_source_cant_disable_auto_position_with_gtid_only";
    case 4068: return "er_change_rep_source_cant_disable_gtid_only_without_positions";
    case 4069: return "er_change_rep_source_cant_disable_auto_pos_without_positions";
    case 4070: return "er_change_rep_source_gr_channel_with_gtid_mode_not_on";
    case 4071: return "er_cant_use_gtid_only_with_gtid_mode_not_on";
    case 4072: return "er_warn_c_disable_gtid_only_with_source_auto_pos_invalid_pos";
    case 4073: return "er_da_ssl_fips_mode_error";
    case 4074: return "er_value_out_of_range";
    case 4075: return "er_fulltext_with_rollup";
    case 4076: return "er_regexp_missing_resource";
    case 4077: return "er_warn_regexp_using_default";
    case 4078: return "er_regexp_missing_file";
    case 4079: return "er_warn_deprecated_collation";
    case 4080: return "er_concurrent_procedure_usage";
    case 4081: return "er_da_global_conn_limit";
    case 4082: return "er_da_conn_limit";
    case 4083: return "er_alter_operation_not_supported_reason_column_type_instant";
    case 4084: return "er_warn_sf_udf_name_collision";
    case 4085: return "er_cannot_purge_binlog_with_backup_lock";
    case 4086: return "er_too_many_windows";
    case 4087: return "er_mysqlbackup_client_msg";
    case 4088: return "er_comment_contains_invalid_string";
    case 4089: return "er_definition_contains_invalid_string";
    case 4090: return "er_cant_execute_command_with_assigned_gtid_next";
    case 4091: return "er_xa_temp_table";
    case 4092: return "er_innodb_max_row_version";
    case 4094: return "er_operation_not_allowed_while_primary_change_is_running";
    case 4095: return "er_warn_deprecated_datetime_delimiter";
    case 4096: return "er_warn_deprecated_superfluous_delimiter";
    case 4097: return "er_cannot_persist_sensitive_variables";
    case 4098: return "er_warn_cannot_securely_persist_sensitive_variables";
    case 4099: return "er_warn_trg_already_exists";
    case 4100: return "er_if_not_exists_unsupported_trg_exists_on_different_table";
    case 4101: return "er_if_not_exists_unsupported_udf_native_fct_name_collision";
    case 4102: return "er_set_password_auth_plugin_error";
    case 4105: return "er_srs_invalid_latitude_of_origin";
    case 4106: return "er_srs_invalid_longitude_of_origin";
    case 4107: return "er_srs_unused_proj_parameter_present";
    case 4108: return "er_gipk_column_exists";
    case 4109: return "er_gipk_failed_autoinc_column_exists";
    case 4110: return "er_gipk_column_alter_not_allowed";
    case 4111: return "er_drop_pk_column_to_drop_gipk";
    case 4112: return "er_create_select_with_gipk_disallowed_in_sbr";
    case 4113: return "er_da_expire_logs_days_ignored";
    case 4114: return "er_cte_recursive_not_union";
    case 4115: return "er_command_backend_failed_to_fetch_security_ctx";
    case 4116: return "er_command_service_backend_failed";
    case 4117: return "er_client_file_privilege_for_replication_checks";
    case 4118: return "er_group_replication_force_members_command_failure";
    case 4119: return "er_warn_deprecated_ident";
    case 4120: return "er_intersect_all_max_duplicates_exceeded";
    case 4121: return "er_tp_query_thrs_per_grp_exceeds_txn_thr_limit";
    case 4122: return "er_bad_timestamp_format";
    case 4123: return "er_shape_pridiction_udf";
    case 4124: return "er_srs_invalid_height";
    case 4125: return "er_srs_invalid_scaling";
    case 4126: return "er_srs_invalid_zone_width";
    case 4127: return "er_srs_invalid_latitude_polar_stere_var_a";
    case 4128: return "er_warn_deprecated_client_no_schema_option";
    case 4129: return "er_table_not_empty";
    case 4130: return "er_table_no_primary_key";
    case 4131: return "er_table_in_shared_tablespace";
    case 4132: return "er_index_other_than_pk";
    case 4133: return "er_load_bulk_data_unsorted";
    case 4134: return "er_bulk_executor_error";
    case 4135: return "er_bulk_reader_libcurl_init_failed";
    case 4136: return "er_bulk_reader_libcurl_error";
    case 4137: return "er_bulk_reader_server_error";
    case 4138: return "er_bulk_reader_communication_error";
    case 4139: return "er_bulk_load_data_failed";
    case 4140: return "er_bulk_loader_column_too_big_for_leftover_buffer";
    case 4141: return "er_bulk_loader_component_error";
    case 4142: return "er_bulk_loader_file_contains_less_lines_than_ignore_clause";
    case 4143: return "er_bulk_parser_missing_enclosed_by";
    case 4144: return "er_bulk_parser_row_buffer_max_total_cols_exceeded";
    case 4145: return "er_bulk_parser_copy_buffer_size_exceeded";
    case 4146: return "er_bulk_parser_unexpected_end_of_input";
    case 4147: return "er_bulk_parser_unexpected_row_terminator";
    case 4148: return "er_bulk_parser_unexpected_char_after_ending_enclosed_by";
    case 4149: return "er_bulk_parser_unexpected_char_after_null_escape";
    case 4150: return "er_bulk_parser_unexpected_char_after_column_terminator";
    case 4151: return "er_bulk_parser_incomplete_escape_sequence";
    case 4152: return "er_load_bulk_data_failed";
    case 4153: return "er_load_bulk_data_wrong_value_for_field";
    case 4154: return "er_load_bulk_data_warn_null_to_notnull";
    case 4155: return "er_require_table_primary_key_check_generate_with_gr";
    case 4156: return "er_cant_change_sys_var_in_read_only_mode";
    case 4157: return "er_innodb_instant_add_drop_not_supported_max_size";
    case 4158: return "er_innodb_instant_add_not_supported_max_fields";
    case 4159: return "er_cant_set_persisted";
    case 4160: return "er_install_component_set_null_value";
    case 4161: return "er_install_component_set_unused_value";
    case 4162: return "er_warn_deprecated_user_defined_collations";
    case 4163: return "er_user_lock_overlong_name";
    case 4164: return "er_warn_no_space_version_comment";
    case 4165: return "er_validate_password_insufficient_changed_characters";

    default: return "<unknown MySQL-specific server error>";
    }
}

const char* boost::mysql::detail::mariadb_error_to_string(int v) noexcept
{
    switch (v)
    {
    case 1076: return "er_binlog_cant_delete_gtid_domain";
    case 1120: return "er_wrong_outer_join";
    case 1150: return "er_delayed_cant_change_lock";
    case 1151: return "er_too_many_delayed_threads";
    case 1165: return "er_delayed_insert_table_locked";
    case 1176: return "er_key_does_not_exists";
    case 1349: return "er_view_select_derived";
    case 1487: return "er_not_constant_expression";
    case 1506: return "er_feature_not_supported_with_partitioning";
    case 1593: return "er_slave_fatal_error";
    case 1611: return "er_load_data_invalid_column";
    case 1669: return "er_binlog_unsafe_insert_delayed";
    case 1726: return "er_vers_not_allowed";
    case 1742: return "er_value_too_long";
    case 1768: return "er_cant_change_gtid_next_in_transaction_when_gtid_next_list_is_null";
    case 1777: return "er_auto_position_requires_gtid_mode_on";
    case 1779: return "er_gtid_mode_2_or_3_requires_enforce_gtid_consistency_on";
    case 1784: return "er_found_gtid_event_when_gtid_mode_is_off";
    case 1826: return "er_dup_constraint_name";
    case 1834: return "er_fk_cannot_delete_parent";
    case 1837: return "er_gtid_next_type_undefined_group";
    case 1852: return "er_alter_operation_not_supported_reason_ignore";
    case 1901: return "er_generated_column_function_is_not_allowed";
    case 1903: return "er_primary_key_based_on_generated_column";
    case 1904: return "er_key_based_on_generated_virtual_column";
    case 1905: return "er_wrong_fk_option_for_generated_column";
    case 1906: return "er_warning_non_default_value_for_generated_column";
    case 1907: return "er_unsupported_action_on_generated_column";
    case 1910: return "er_unsupported_engine_for_generated_columns";
    case 1911: return "er_unknown_option";
    case 1912: return "er_bad_option_value";
    case 1916: return "er_data_overflow";
    case 1917: return "er_data_truncated";
    case 1918: return "er_bad_data";
    case 1919: return "er_dyn_col_wrong_format";
    case 1920: return "er_dyn_col_implementation_limit";
    case 1921: return "er_dyn_col_data";
    case 1922: return "er_dyn_col_wrong_charset";
    case 1923: return "er_illegal_subquery_optimizer_switches";
    case 1924: return "er_query_cache_is_disabled";
    case 1925: return "er_query_cache_is_globaly_disabled";
    case 1926: return "er_view_orderby_ignored";
    case 1927: return "er_connection_killed";
    case 1929: return "er_inside_transaction_prevents_switch_skip_replication";
    case 1930: return "er_stored_function_prevents_switch_skip_replication";
    case 1931: return "er_query_exceeded_rows_examined_limit";
    case 1932: return "er_no_such_table_in_engine";
    case 1933: return "er_target_not_explainable";
    case 1934: return "er_connection_already_exists";
    case 1935: return "er_master_log_prefix";
    case 1936: return "er_cant_start_stop_slave";
    case 1937: return "er_slave_started";
    case 1938: return "er_slave_stopped";
    case 1939: return "er_sql_discover_error";
    case 1940: return "er_failed_gtid_state_init";
    case 1941: return "er_incorrect_gtid_state";
    case 1942: return "er_cannot_update_gtid_state";
    case 1943: return "er_duplicate_gtid_domain";
    case 1944: return "er_gtid_open_table_failed";
    case 1945: return "er_gtid_position_not_found_in_binlog";
    case 1946: return "er_cannot_load_slave_gtid_state";
    case 1947: return "er_master_gtid_pos_conflicts_with_binlog";
    case 1948: return "er_master_gtid_pos_missing_domain";
    case 1949: return "er_until_requires_using_gtid";
    case 1950: return "er_gtid_strict_out_of_order";
    case 1951: return "er_gtid_start_from_binlog_hole";
    case 1952: return "er_slave_unexpected_master_switch";
    case 1953: return "er_inside_transaction_prevents_switch_gtid_domain_id_seq_no";
    case 1954: return "er_stored_function_prevents_switch_gtid_domain_id_seq_no";
    case 1955: return "er_gtid_position_not_found_in_binlog2";
    case 1956: return "er_binlog_must_be_empty";
    case 1957: return "er_no_such_query";
    case 1958: return "er_bad_base64_data";
    case 1959: return "er_invalid_role";
    case 1960: return "er_invalid_current_user";
    case 1961: return "er_cannot_grant_role";
    case 1962: return "er_cannot_revoke_role";
    case 1963: return "er_change_slave_parallel_threads_active";
    case 1964: return "er_prior_commit_failed";
    case 1965: return "er_it_is_a_view";
    case 1966: return "er_slave_skip_not_in_gtid";
    case 1967: return "er_table_definition_too_big";
    case 1968: return "er_plugin_installed";
    case 1969: return "er_statement_timeout";
    case 1970: return "er_subqueries_not_supported";
    case 1971: return "er_set_statement_not_supported";
    case 1973: return "er_user_create_exists";
    case 1974: return "er_user_drop_exists";
    case 1975: return "er_role_create_exists";
    case 1976: return "er_role_drop_exists";
    case 1977: return "er_cannot_convert_character";
    case 1978: return "er_invalid_default_value_for_field";
    case 1979: return "er_kill_query_denied_error";
    case 1980: return "er_no_eis_for_field";
    case 1981: return "er_warn_aggfunc_dependence";
    case 1982: return "warn_innodb_partition_option_ignored";
    case 3000: return "er_file_corrupt";
    case 3001: return "er_error_on_master";
    case 3002: return "er_inconsistent_error";
    case 3003: return "er_storage_engine_not_loaded";
    case 3004: return "er_get_stacked_da_without_active_handler";
    case 3005: return "er_warn_legacy_syntax_converted";
    case 3006: return "er_binlog_unsafe_fulltext_plugin";
    case 3007: return "er_cannot_discard_temporary_table";
    case 3008: return "er_fk_depth_exceeded";
    case 3009: return "er_col_count_doesnt_match_please_update_v2";
    case 3010: return "er_warn_trigger_doesnt_have_created";
    case 3011: return "er_referenced_trg_does_not_exist_mysql";
    case 3012: return "er_explain_not_supported";
    case 3013: return "er_invalid_field_size";
    case 3014: return "er_missing_ha_create_option";
    case 3015: return "er_engine_out_of_memory";
    case 3016: return "er_password_expire_anonymous_user";
    case 3017: return "er_slave_sql_thread_must_stop";
    case 3018: return "er_no_ft_materialized_subquery";
    case 3019: return "er_innodb_undo_log_full";
    case 3020: return "er_invalid_argument_for_logarithm";
    case 3021: return "er_slave_channel_io_thread_must_stop";
    case 3022: return "er_warn_open_temp_tables_must_be_zero";
    case 3023: return "er_warn_only_master_log_file_no_pos";
    case 3024: return "er_query_timeout";
    case 3025: return "er_non_ro_select_disable_timer";
    case 3026: return "er_dup_list_entry";
    case 3027: return "er_sql_mode_no_effect";
    case 3028: return "er_aggregate_order_for_union";
    case 3029: return "er_aggregate_order_non_agg_query";
    case 3030: return "er_slave_worker_stopped_previous_thd_error";
    case 3031: return "er_dont_support_slave_preserve_commit_order";
    case 3032: return "er_server_offline_mode";
    case 3033: return "er_gis_different_srids";
    case 3034: return "er_gis_unsupported_argument";
    case 3035: return "er_gis_unknown_error";
    case 3036: return "er_gis_unknown_exception";
    case 3037: return "er_gis_invalid_data";
    case 3038: return "er_boost_geometry_empty_input_exception";
    case 3039: return "er_boost_geometry_centroid_exception";
    case 3040: return "er_boost_geometry_overlay_invalid_input_exception";
    case 3041: return "er_boost_geometry_turn_info_exception";
    case 3042: return "er_boost_geometry_self_intersection_point_exception";
    case 3043: return "er_boost_geometry_unknown_exception";
    case 3044: return "er_std_bad_alloc_error";
    case 3045: return "er_std_domain_error";
    case 3046: return "er_std_length_error";
    case 3047: return "er_std_invalid_argument";
    case 3048: return "er_std_out_of_range_error";
    case 3049: return "er_std_overflow_error";
    case 3050: return "er_std_range_error";
    case 3051: return "er_std_underflow_error";
    case 3052: return "er_std_logic_error";
    case 3053: return "er_std_runtime_error";
    case 3054: return "er_std_unknown_exception";
    case 3055: return "er_gis_data_wrong_endianess";
    case 3056: return "er_change_master_password_length";
    case 3057: return "er_user_lock_wrong_name";
    case 3058: return "er_user_lock_deadlock";
    case 3059: return "er_replace_inaccessible_rows";
    case 3060: return "er_alter_operation_not_supported_reason_gis";
    case 4002: return "er_with_col_wrong_list";
    case 4003: return "er_too_many_definitions_in_with_clause";
    case 4004: return "er_dup_query_name";
    case 4005: return "er_recursive_without_anchors";
    case 4006: return "er_unacceptable_mutual_recursion";
    case 4007: return "er_ref_to_recursive_with_table_in_derived";
    case 4008: return "er_not_standard_compliant_recursive";
    case 4009: return "er_wrong_window_spec_name";
    case 4010: return "er_dup_window_name";
    case 4011: return "er_partition_list_in_referencing_window_spec";
    case 4012: return "er_order_list_in_referencing_window_spec";
    case 4013: return "er_window_frame_in_referenced_window_spec";
    case 4014: return "er_bad_combination_of_window_frame_bound_specs";
    case 4015: return "er_wrong_placement_of_window_function";
    case 4016: return "er_window_function_in_window_spec";
    case 4017: return "er_not_allowed_window_frame";
    case 4018: return "er_no_order_list_in_window_spec";
    case 4019: return "er_range_frame_needs_simple_orderby";
    case 4020: return "er_wrong_type_for_rows_frame";
    case 4021: return "er_wrong_type_for_range_frame";
    case 4022: return "er_frame_exclusion_not_supported";
    case 4023: return "er_window_function_dont_have_frame";
    case 4024: return "er_invalid_ntile_argument";
    case 4025: return "er_constraint_failed";
    case 4026: return "er_expression_is_too_big";
    case 4027: return "er_error_evaluating_expression";
    case 4028: return "er_calculating_default_value";
    case 4029: return "er_expression_refers_to_uninit_field";
    case 4030: return "er_partition_default_error";
    case 4031: return "er_referenced_trg_does_not_exist";
    case 4032: return "er_invalid_default_param";
    case 4033: return "er_binlog_non_supported_bulk";
    case 4034: return "er_binlog_uncompress_error";
    case 4035: return "er_json_bad_chr";
    case 4036: return "er_json_not_json_chr";
    case 4037: return "er_json_eos";
    case 4038: return "er_json_syntax";
    case 4039: return "er_json_escaping";
    case 4040: return "er_json_depth";
    case 4041: return "er_json_path_eos";
    case 4042: return "er_json_path_syntax";
    case 4043: return "er_json_path_depth";
    case 4044: return "er_json_path_no_wildcard";
    case 4045: return "er_json_path_array";
    case 4046: return "er_json_one_or_all";
    case 4047: return "er_unsupported_compressed_table";
    case 4048: return "er_geojson_incorrect";
    case 4049: return "er_geojson_too_few_points";
    case 4050: return "er_geojson_not_closed";
    case 4051: return "er_json_path_empty";
    case 4052: return "er_slave_same_id";
    case 4053: return "er_flashback_not_supported";
    case 4054: return "er_keys_out_of_order";
    case 4055: return "er_overlapping_keys";
    case 4056: return "er_require_row_binlog_format";
    case 4057: return "er_isolation_mode_not_supported";
    case 4058: return "er_on_duplicate_disabled";
    case 4059: return "er_updates_with_consistent_snapshot";
    case 4060: return "er_rollback_only";
    case 4061: return "er_rollback_to_savepoint";
    case 4062: return "er_isolation_level_with_consistent_snapshot";
    case 4063: return "er_unsupported_collation";
    case 4064: return "er_metadata_inconsistency";
    case 4065: return "er_cf_different";
    case 4066: return "er_rdb_ttl_duration_format";
    case 4067: return "er_rdb_status_general";
    case 4068: return "er_rdb_status_msg";
    case 4069: return "er_rdb_ttl_unsupported";
    case 4070: return "er_rdb_ttl_col_format";
    case 4071: return "er_per_index_cf_deprecated";
    case 4072: return "er_key_create_during_alter";
    case 4073: return "er_sk_populate_during_alter";
    case 4074: return "er_sum_func_with_window_func_as_arg";
    case 4075: return "er_net_ok_packet_too_large";
    case 4076: return "er_geojson_empty_coordinates";
    case 4077: return "er_myrocks_cant_nopad_collation";
    case 4078: return "er_illegal_parameter_data_types2_for_operation";
    case 4079: return "er_illegal_parameter_data_type_for_operation";
    case 4080: return "er_wrong_paramcount_to_cursor";
    case 4081: return "er_unknown_structured_variable";
    case 4082: return "er_row_variable_does_not_have_field";
    case 4083: return "er_end_identifier_does_not_match";
    case 4084: return "er_sequence_run_out";
    case 4085: return "er_sequence_invalid_data";
    case 4086: return "er_sequence_invalid_table_structure";
    case 4087: return "er_sequence_access_error";
    case 4088: return "er_sequence_binlog_format";
    case 4089: return "er_not_sequence";
    case 4090: return "er_not_sequence2";
    case 4091: return "er_unknown_sequences";
    case 4092: return "er_unknown_view";
    case 4093: return "er_wrong_insert_into_sequence";
    case 4094: return "er_sp_stack_trace";
    case 4095: return "er_package_routine_in_spec_not_defined_in_body";
    case 4096: return "er_package_routine_forward_declaration_not_defined";
    case 4097: return "er_compressed_column_used_as_key";
    case 4098: return "er_unknown_compression_method";
    case 4099: return "er_wrong_number_of_values_in_tvc";
    case 4100: return "er_field_reference_in_tvc";
    case 4101: return "er_wrong_type_for_percentile_func";
    case 4102: return "er_argument_not_constant";
    case 4103: return "er_argument_out_of_range";
    case 4104: return "er_wrong_type_of_argument";
    case 4105: return "er_not_aggregate_function";
    case 4106: return "er_invalid_aggregate_function";
    case 4107: return "er_invalid_value_to_limit";
    case 4108: return "er_invisible_not_null_without_default";
    case 4109: return "er_update_info_with_system_versioning";
    case 4110: return "er_vers_field_wrong_type";
    case 4111: return "er_vers_engine_unsupported";
    case 4113: return "er_partition_wrong_type";
    case 4114: return "warn_vers_part_full";
    case 4115: return "warn_vers_parameters";
    case 4116: return "er_vers_drop_partition_interval";
    case 4118: return "warn_vers_part_non_historical";
    case 4119: return "er_vers_alter_not_allowed";
    case 4120: return "er_vers_alter_engine_prohibited";
    case 4121: return "er_vers_range_prohibited";
    case 4122: return "er_conflicting_for_system_time";
    case 4123: return "er_vers_table_must_have_columns";
    case 4124: return "er_vers_not_versioned";
    case 4125: return "er_missing";
    case 4126: return "er_vers_period_columns";
    case 4127: return "er_part_wrong_value";
    case 4128: return "er_vers_wrong_parts";
    case 4129: return "er_vers_no_trx_id";
    case 4130: return "er_vers_alter_system_field";
    case 4131: return "er_drop_versioning_system_time_partition";
    case 4132: return "er_vers_db_not_supported";
    case 4133: return "er_vers_trt_is_disabled";
    case 4134: return "er_vers_duplicate_row_start_end";
    case 4135: return "er_vers_already_versioned";
    case 4137: return "er_vers_not_supported";
    case 4138: return "er_vers_trx_part_historic_row_not_supported";
    case 4139: return "er_index_file_full";
    case 4140: return "er_updated_column_only_once";
    case 4141: return "er_empty_row_in_tvc";
    case 4142: return "er_vers_query_in_partition";
    case 4143: return "er_key_doesnt_support";
    case 4144: return "er_alter_operation_table_options_need_rebuild";
    case 4145: return "er_backup_lock_is_active";
    case 4146: return "er_backup_not_running";
    case 4147: return "er_backup_wrong_stage";
    case 4148: return "er_backup_stage_failed";
    case 4149: return "er_backup_unknown_stage";
    case 4150: return "er_user_is_blocked";
    case 4151: return "er_account_has_been_locked";
    case 4152: return "er_period_temporary_not_allowed";
    case 4153: return "er_period_types_mismatch";
    case 4154: return "er_more_than_one_period";
    case 4155: return "er_period_field_wrong_attributes";
    case 4156: return "er_period_not_found";
    case 4157: return "er_period_columns_updated";
    case 4158: return "er_period_constraint_drop";
    case 4159: return "er_too_long_keypart";
    case 4160: return "er_too_long_database_comment";
    case 4161: return "er_unknown_data_type";
    case 4162: return "er_unknown_operator";
    case 4163: return "er_warn_history_row_start_time";
    case 4164: return "er_part_starts_beyond_interval";
    case 4165: return "er_galera_replication_not_supported";
    case 4166: return "er_load_infile_capability_disabled";
    case 4167: return "er_no_secure_transports_configured";
    case 4168: return "er_slave_ignored_shared_table";
    case 4169: return "er_no_autoincrement_with_unique";
    case 4170: return "er_key_contains_period_fields";
    case 4171: return "er_key_cant_have_without_overlaps";
    case 4172: return "er_not_allowed_in_this_context";
    case 4173: return "er_data_was_commited_under_rollback";
    case 4174: return "er_pk_index_cant_be_ignored";
    case 4175: return "er_binlog_unsafe_skip_locked";
    case 4176: return "er_json_table_error_on_field";
    case 4177: return "er_json_table_alias_required";
    case 4178: return "er_json_table_scalar_expected";
    case 4179: return "er_json_table_multiple_matches";
    case 4180: return "er_with_ties_needs_order";
    case 4181: return "er_removed_orphan_trigger";
    case 4182: return "er_storage_engine_disabled";
    case 4183: return "warn_sformat_error";
    case 4184: return "er_partition_convert_subpartitioned";
    case 4185: return "er_provider_not_loaded";
    case 4186: return "er_json_histogram_parse_failed";
    case 4187: return "er_sf_out_inout_arg_not_allowed";
    case 4188: return "er_inconsistent_slave_temp_table";
    case 4189: return "er_vers_hist_part_failed";
    case 4190: return "warn_option_changing";
    case 4191: return "er_cm_option_missing_requirement";
    case 4192: return "er_slave_statement_timeout";
    case 4193: return "er_json_invalid_value_for_keyword";
    case 4194: return "er_json_schema_keyword_unsupported";

    default: return "<unknown MariaDB-specific server error>";
    }
}

#endif

