#ifndef _CEGOCHECKPOINTDUMP_H_INCLUDED_
#define _CEGOCHECKPOINTDUMP_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCheckpointDump.h
// --------------------
// Cego Checkpoint dump handler class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDumpHandler
// 
// Description: bufferpool checkpoint dump handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/File.h>

// CEGO INCLUDES
#include "CegoDefs.h"

class CegoCheckpointDump {
    
public:

    CegoCheckpointDump(Chain& tableSet, Chain& tsRoot, int pageSize);
    
    void startWrite();
    void dumpPage(PageIdType pageId, unsigned fixStat, char* pageData);
    void finish();
    
    void commitDump();

    void startRead();
    bool readDump(PageIdType& pageId, unsigned& fixStat, char* pageData);
    void remove();

    bool readyDumpExists();

    void cleanUp();

private:

    Chain _tableSet;
    Chain _tsRoot;
    int _pageSize;
    
    File* _pDumpFile;
};

#endif
