/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageViewer
extends JPanel {
    private ImageManager imgmanager;
    private int vw;
    private int vh;
    private int iw;
    private int ih;
    private int selected = 0;
    private Image img;
    private String cmdline = new String();
    private boolean fullRefresh = false;
    private Point offset = new Point(0, 0);
    private Rectangle rect = new Rectangle();
    private Rectangle[] roirect = null;
    private String[] roiname = null;

    public ImageViewer(String string, ImageManager imageManager, boolean bl, boolean bl2, int n) {
        this.setSize(170, 170);
        Dimension dimension = this.getSize();
        this.vw = dimension.width;
        this.vh = dimension.height;
        this.setBackground(Color.black);
        MML mML = new MML(this);
        this.imgmanager = imageManager;
        this.img = this.imgmanager.getImage(string, this.vw, this.vh, bl, n, bl2, !bl2);
        this.addMouseListener(mML);
        this.addMouseMotionListener(mML);
        this.addComponentListener(new ResizeListener(this));
    }

    public Image getImage() {
        return this.img;
    }

    public void zoomIn() {
        this.roirect = null;
        this.roiname = null;
        double d = (double)this.vw / (double)this.rect.width;
        double d2 = (double)this.vh / (double)this.rect.height;
        int n = (int)((double)this.imgmanager.getFw() * d);
        int n2 = (int)((double)this.imgmanager.getFh() * d2);
        int n3 = (int)((double)(this.imgmanager.getRx() + this.rect.x) * d);
        int n4 = (int)((double)(this.imgmanager.getRy() + this.rect.y) * d2);
        this.img = this.imgmanager.getImage(n, n2, n3, n4, this.vw, this.vh);
        this.rect.height = 0;
        this.rect.width = 0;
        this.rect.y = 0;
        this.rect.x = 0;
        this.selected = 0;
        this.fullRefresh = true;
        this.repaint();
    }

    public void enlarge() {
        this.roirect = null;
        this.roiname = null;
        Dimension dimension = this.getSize();
        this.vw = dimension.width;
        this.vh = dimension.height;
        double d = (double)this.vw / (double)this.imgmanager.getRw();
        double d2 = (double)this.vh / (double)this.imgmanager.getRh();
        int n = (int)((double)this.imgmanager.getFw() * d);
        int n2 = (int)((double)this.imgmanager.getFh() * d2);
        int n3 = (int)((double)this.imgmanager.getRx() * d);
        int n4 = (int)((double)this.imgmanager.getRy() * d2);
        this.img = this.imgmanager.getImage(n, n2, n3, n4, this.vw, this.vh);
        this.fullRefresh = true;
        this.repaint();
    }

    public void setSelected(int n) {
        this.roirect = null;
        this.roiname = null;
        if (n != this.selected) {
            this.selected = n;
            this.repaint();
        }
    }

    public boolean isInsideRect(int n, int n2) {
        return this.rect.contains(n - this.offset.x, n2 - this.offset.y);
    }

    public void setRGeom(int n, int n2, int n3, int n4) {
        this.rect.x = Math.min(n, n3) - this.offset.x;
        this.rect.y = Math.min(n2, n4) - this.offset.y;
        this.rect.width = Math.abs(n3 - n);
        this.rect.height = Math.abs(n4 - n2);
    }

    public boolean hasAnnotation() {
        return this.roirect != null;
    }

    public boolean isInsideROIRect(int n, int n2) {
        for (int i = 0; i < this.roirect.length; ++i) {
            if (this.roirect[i] == null || !this.roirect[i].contains(n - this.offset.x, n2 - this.offset.y)) continue;
            this.rect = this.roirect[i];
            return true;
        }
        return false;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.fullRefresh) {
            graphics2D.clearRect(0, 0, this.vw, this.vh);
            this.fullRefresh = false;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.offset.x = 0;
        this.offset.y = 0;
        this.iw = this.img.getWidth(this);
        this.ih = this.img.getHeight(this);
        BufferedImage bufferedImage = new BufferedImage(this.iw, this.ih, 1);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.drawImage(this.img, 0, 0, this);
        graphics2D2.setPaint(Color.red);
        if (this.rect.width > 0 && this.rect.height > 0) {
            graphics2D2.draw(this.rect);
        }
        if (this.roirect != null) {
            for (int i = 0; i < this.roirect.length; ++i) {
                if (this.roirect[i] == null) continue;
                graphics2D2.draw(this.roirect[i]);
                graphics2D2.drawString(this.roiname[i], this.roirect[i].x + 3, this.roirect[i].y + this.roirect[i].height * 2 / 3);
            }
        }
        if (this.selected == 1) {
            this.shadeExt(graphics2D2, 0, 0, 0, 64);
        } else if (this.selected == 2) {
            this.shadeExt(graphics2D2, 0, 0, 0, 255);
            this.selected = 1;
        }
        graphics2D.drawImage((Image)bufferedImage, this.offset.x, this.offset.y, this);
    }

    private void shadeRect(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setPaint(new Color(n, n2, n3, n4));
        graphics2D.fillRect(this.rect.x + 1, this.rect.y + 1, this.rect.width - 1, this.rect.height - 1);
    }

    private void shadeExt(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setPaint(new Color(n, n2, n3, n4));
        graphics2D.fillRect(0, 0, this.iw, this.rect.y);
        graphics2D.fillRect(this.rect.x + this.rect.width + 1, this.rect.y, this.iw - this.rect.x - this.rect.width - 1, this.rect.height + 1);
        graphics2D.fillRect(0, this.rect.y, this.rect.x, this.rect.height + 1);
        graphics2D.fillRect(0, this.rect.y + this.rect.height + 1, this.iw, this.ih - this.rect.y - this.rect.height - 1);
    }
}

