%feature("docstring") OT::Frechet
"Frechet distribution.

Parameters
----------
beta : float, :math:`\\beta > 0`
    Scale parameter
alpha : float, :math:`\\alpha > 0`
    Shape parameter
gamma : float, optional
    Location parameter

Notes
-----
Its cumulative and probability density functions are defined as:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        F_X(x) & = & \\exp\\left(-\\left(\\frac{x-\\gamma}{\\beta}\\right)^{-\\alpha}\\right), \\quad x \\in [ \\gamma; +\\infty) \\\\
        f_X(x) & = & \\frac{\\alpha}{\\beta}\\left(\\frac{x-\\gamma}{\\beta}\\right)^{-1-\\alpha}\\exp\\left(-\\left(\\frac{x-\\gamma}{\\beta}\\right)^{-\\alpha}\\right),
             \\quad x \\in [ \\gamma; +\\infty)
    \\end{eqnarray*}

with :math:`\\beta > 0` and :math:`\\alpha > 0`.


Its first moments are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = & \\gamma + \\beta \\,\\Gamma\\left(1 - \\frac{1}{\\alpha}\\right)
                        \\quad \\text{ if } \\alpha > 1\\\\
                   & = & +\\infty  \\quad\\text{ if } \\alpha \\leq 1\\\\
        \\Var{X} & = & \\beta^2 \\left( \\Gamma \\left( 1 - \\frac{2}{\\alpha} \\right) -
                     \\Gamma^2 \\left( 1 - \\frac{1}{\\alpha} \\right) \\right) \\quad \\text{ if } \\alpha > 2\\\\
                   & = & +\\infty  \\quad \\text{ if } \\alpha \\leq 2\\\\
    \\end{eqnarray*}

where :math:`\\Gamma` denotes Euler's Gamma function
:meth:`~openturns.SpecFunc.Gamma`.

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> distribution = ot.Frechet(1.0, 3.0, 0.0)

Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::Frechet::getAlpha
"Accessor to the shape parameter.

Returns
-------
alpha : float
    Shape parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::Frechet::setAlpha
"Accessor to the shape parameter.

Parameters
----------
alpha : float, :math:`\\alpha > 0`
    Shape parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::Frechet::getBeta
"Accessor to the scale parameter.

Returns
-------
beta : float
    Scale parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::Frechet::setBeta
"Accessor to the scale parameter.

Parameters
----------
beta : float, :math:`\\beta > 0`
    Scale parameter."
// ---------------------------------------------------------------------

%feature("docstring") OT::Frechet::getGamma
"Accessor to the location parameter.

Returns
-------
gamma : float
    Location parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::Frechet::setGamma
"Accessor to the location parameter.

Parameters
----------
gamma : float, :math:`\\gamma > 0`
    Location parameter."
    
