%feature("docstring") OT::GumbelMuSigma
"Gumbel distribution parameters.

Parameters
----------
mu : float
    Mean.
sigma : float
    Standard deviation :math:`\\sigma > 0`.

Notes
-----
The native parameters  :math:`(\\beta, \\gamma)` are defined as follows:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\mu & = & \\gamma + \\gamma_e \\beta \\\\
        \\sigma^2 & = & \\frac{1}{6} \\pi^2 \\beta^2
    \\end{eqnarray*}

where :math:`\\gamma_e` is the Euler-Mascheroni constant.

See also
--------
Gumbel

Examples
--------
Create the parameters :math:`(\\mu, \\sigma)` of the Gumbel distribution:

>>> import openturns as ot
>>> parameters = ot.GumbelMuSigma(1.5, 1.3)

Convert parameters into the native parameters :math:`(\\beta, \\gamma)`:

>>> print(parameters.evaluate())
[1.01361,0.914931]"
