%feature("docstring") OT::InverseNormalFactory
"Inverse Normal factory.

Available constructor:
    InverseNormalFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{\\mu}_n =  \\bar{x}_n\\\\
      \\displaystyle\\Hat{\\lambda}_n = \\left(  \\frac{1}{n} \\sum_{i=1}^n \\frac{1}{x_i} - \\frac{1}{\\bar{x}_n} \\right)^{-1}
    \\end{eqnarray*}

See also
--------
DistributionFactory, InverseNormal"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsInverseNormal_doc
"Build the InverseNormal distribution.

**Available usages**:

    buildAsInverseNormal(*sample*)

    buildAsInverseNormal(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.InverseNormal`
    The built distribution."
%enddef
%feature("docstring") OT::InverseNormalFactory::buildAsInverseNormal
OT_DistributionFactory_buildAsInverseNormal_doc

