%feature("docstring") OT::LogNormalMuSigma
"LogNormal distribution parameters.

Parameters
----------
mu : float
    The mean of the log-normal random variable.
sigma : float
    The standard deviation of the log-normal random variable, with :math:`\\sigma > 0`.
gamma : float, optional
    Location parameter.

Notes
-----
The :math:`\\mu` (resp. :math:`\\sigma`) parameter is 
the mean (resp. the standard deviation) of the log-normal 
random variable, i.e. 

.. math::

    \\Expect{X} &= \\mu \\\\
    \\Var{X} &= \\sigma^2

where :math:`X` is the log-normal random variable. 

The native parameters are :math:`\\mu_\\ell` 
and :math:`\\sigma_\\ell`, which are the mean and 
standard deviation of the logarithm of the log-normal variable, 
i.e. the parameters of the associated normal variable.
They are defined as follows:

.. math::

    \\sigma_\\ell &= \\sqrt{\\log{ \\left( 1+\\frac{\\sigma^2}{(\\mu-\\gamma)^2} \\right) }} \\\\
    \\mu_\\ell &= \\log{(\\mu-\\gamma)} - \\frac{\\sigma_\\ell^2}{2}

See also
--------
LogNormal

Examples
--------
Create the parameters of the LogNormal distribution:

>>> import openturns as ot
>>> parameters = ot.LogNormalMuSigma(0.63, 3.3, -0.5)

Convert parameters into the native parameters:

>>> print(parameters.evaluate())
[-1.00492,1.50143,-0.5]

The gradient of the transformation of the native parameters into the new
parameters:

>>> print(parameters.gradient())
[[  1.67704  -0.527552  0        ]
 [ -0.271228  0.180647  0        ]
 [ -1.67704   0.527552  1        ]]"
