%feature("docstring") OT::ParametricFunction
"Parametric function.

Available constructor:
    ParametricFunction(*function, indices, referencePoint, parametersSet*)

It defines a parametric function from *function* by freezing the variables
marked by the *indices* set to the values of *referencePoint*.

Parameters
----------
function : :class:`~openturns.Function`
    Function with full parameters from which the parametric function is built.
indices : sequence of int
    Indices of the frozen variables.
referencePoint : sequence of float
    Values of the frozen variables.
    Must be of size of *indices* if *parametersSet* is *True* (default),
    else its size should be the complementary size of *indices*.
parametersSet : bool
    If *True* (default), the frozen variables are the ones referenced
    in *indices*.
    Otherwise, the set variables are the ones referenced in the complementary
    set of *indices*.

Examples
--------
>>> import openturns as ot
>>> f = ot.SymbolicFunction(['x', 'y', 'z'], ['x+y', 'x*z+y'])
>>> print(f)
[x,y,z]->[x+y,x*z+y]

Then create another function by setting x=2 and y=3:

>>> g=ot.ParametricFunction(f, [0,1], [2,3])
>>> print(g)
ParametricEvaluation([x,y,z]->[x+y,x*z+y], parameters positions=[0,1], parameters=[x : 2, y : 3], input positions=[2])

Or by setting z=4 using the complementary set flag:

>>> g = ot.ParametricFunction(f, [0,1], [4], False)
>>> print(g.getInputDescription())
[x,y]
>>> print(g)
ParametricEvaluation([x,y,z]->[x+y,x*z+y], parameters positions=[2], parameters=[z : 4], input positions=[0,1])"
