%feature("docstring") OT::QRMethod
"Least squares solver using the QR decomposition.

Available constructors:
    QRMethod(*proxy, weight, indices*)

    QRMethod(*proxy, indices*)

    QRMethod(*design*)

Parameters
----------
proxy : :class:`~openturns.DesignProxy`
    Input sample
weight : sequence of float
    Output weights
indices : sequence of int
    Indices allowed in the basis
design : 2-d sequence of float
    A priori known design matrix

See also
--------
LeastSquaresMethod, CholeskyMethod, SVDMethod


Examples
--------
Solves a linear least squares problem with SVD method:

>>> import openturns as ot
>>> A = ot.Matrix([[1,1],[1,2],[1,3],[1,4]])
>>> y = [6, 5, 7, 10]
>>> method = ot.QRMethod(A)
>>> x = method.solve(y)
>>> print(x)
[3.5,1.4]"


