%feature("docstring") OT::TriangularFactory
"Triangular factory.

Available constructor:
    TriangularFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{a}_n=(1-\\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\\\
      \\displaystyle\\Hat{b}_n=(1+\\mathrm{sign}(x_{(n,n)})/(2+n))x_{(n,n)}\\\\
      \\displaystyle\\Hat{m}_n=3\\bar{x}_n-\\Hat{a}_n-\\Hat{b}_n
    \\end{eqnarray*}

See also
--------
DistributionFactory, Triangular"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsTriangular_doc
"Build the Triangular distribution.

**Available usages**:

    buildAsTriangular(*sample*)

    buildAsTriangular(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Triangular`
    The built distribution."
%enddef
%feature("docstring") OT::TriangularFactory::buildAsTriangular
OT_DistributionFactory_buildAsTriangular_doc

