// Copyright 2021-2025 The Khronos Group
// SPDX-License-Identifier: Apache-2.0

#pragma once

// glm
#include "glm/mat2x2.hpp"
#include "glm/mat3x2.hpp"
#include "glm/mat3x3.hpp"
#include "glm/mat4x3.hpp"
#include "glm/vec2.hpp"
#include "glm/vec3.hpp"
#include "glm/vec4.hpp"
// anari_cpp
#include "../Traits.h"

namespace anari {

ANARI_TYPEFOR_SPECIALIZATION(glm::vec2, ANARI_FLOAT32_VEC2);
ANARI_TYPEFOR_SPECIALIZATION(glm::vec3, ANARI_FLOAT32_VEC3);
ANARI_TYPEFOR_SPECIALIZATION(glm::vec4, ANARI_FLOAT32_VEC4);
ANARI_TYPEFOR_SPECIALIZATION(glm::ivec2, ANARI_INT32_VEC2);
ANARI_TYPEFOR_SPECIALIZATION(glm::ivec3, ANARI_INT32_VEC3);
ANARI_TYPEFOR_SPECIALIZATION(glm::ivec4, ANARI_INT32_VEC4);
ANARI_TYPEFOR_SPECIALIZATION(glm::uvec2, ANARI_UINT32_VEC2);
ANARI_TYPEFOR_SPECIALIZATION(glm::uvec3, ANARI_UINT32_VEC3);
ANARI_TYPEFOR_SPECIALIZATION(glm::uvec4, ANARI_UINT32_VEC4);
ANARI_TYPEFOR_SPECIALIZATION(glm::mat2x2, ANARI_FLOAT32_MAT2);
ANARI_TYPEFOR_SPECIALIZATION(glm::mat3x3, ANARI_FLOAT32_MAT3);
ANARI_TYPEFOR_SPECIALIZATION(glm::mat3x2, ANARI_FLOAT32_MAT2x3);
ANARI_TYPEFOR_SPECIALIZATION(glm::mat4x3, ANARI_FLOAT32_MAT3x4);
ANARI_TYPEFOR_SPECIALIZATION(glm::mat4, ANARI_FLOAT32_MAT4);

#ifdef ANARI_GLM_DEFINITIONS
ANARI_TYPEFOR_DEFINITION(glm::vec2);
ANARI_TYPEFOR_DEFINITION(glm::vec3);
ANARI_TYPEFOR_DEFINITION(glm::vec4);
ANARI_TYPEFOR_DEFINITION(glm::ivec2);
ANARI_TYPEFOR_DEFINITION(glm::ivec3);
ANARI_TYPEFOR_DEFINITION(glm::ivec4);
ANARI_TYPEFOR_DEFINITION(glm::uvec2);
ANARI_TYPEFOR_DEFINITION(glm::uvec3);
ANARI_TYPEFOR_DEFINITION(glm::uvec4);
ANARI_TYPEFOR_DEFINITION(glm::mat2x2);
ANARI_TYPEFOR_DEFINITION(glm::mat3x3);
ANARI_TYPEFOR_DEFINITION(glm::mat3x2);
ANARI_TYPEFOR_DEFINITION(glm::mat4x3);
ANARI_TYPEFOR_DEFINITION(glm::mat4);
#endif

} // namespace anari
