# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was AdbcDriverFlightSQLConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../clang64" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(ADBC_BUILD_SHARED ON)
set(ADBC_BUILD_STATIC ON)
set(ADBC_FULL_SO_VERSION "110.0.0")
set(ADBC_INSTALL_LIBDIR "lib")
set(ADBC_SO_VERSION "110")
set(ADBC_VERSION "1.10.0")

get_filename_component(_IMPORT_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
if(_IMPORT_PREFIX STREQUAL "/")
  set(_IMPORT_PREFIX "")
endif()

function(adbc_add_shared_library target_name base_name)
  set(shared_base_name
    "${CMAKE_SHARED_LIBRARY_PREFIX}${base_name}${CMAKE_SHARED_LIBRARY_SUFFIX}")
  set(prefix "${_IMPORT_PREFIX}/${ADBC_INSTALL_LIBDIR}")
  add_library(${target_name} SHARED IMPORTED)
  if(WINDOWS)
    set(import_base_name
      "${CMAKE_IMPORT_LIBRARY_PREFIX}${base_name}${CMAKE_IMPORT_LIBRARY_SUFFIX}")
    set_target_properties(${target_name}
      PROPERTIES
      IMPORTED_IMPLIB "${prefix}/${import_base_name}"
      IMPORTED_LOCATION "${_IMPORT_PREFIX}/bin/${shared_base_name}")
  else()
    set_target_properties(${target_name}
      PROPERTIES
      IMPORTED_LOCATION "${prefix}/${shared_base_name}.${ADBC_FULL_SO_VERSION}"
      IMPORTED_SONAME "${prefix}/${shared_base_name}.${ADBC_SO_VERSION}")
  endif()
endfunction()

function(adbc_add_static_library target_name base_name)
  set(static_base_name
    "${CMAKE_STATIC_LIBRARY_PREFIX}${base_name}${CMAKE_STATIC_LIBRARY_SUFFIX}")
  add_library(${target_name} STATIC IMPORTED)
  if(WINDOWS)
    set_target_properties(${target_name}
      PROPERTIES
      IMPORTED_LOCATION "${_IMPORT_PREFIX}/bin/${static_base_name}")
  else()
    set(prefix "${_IMPORT_PREFIX}/${ADBC_INSTALL_LIBDIR}")
    set_target_properties(${target_name}
      PROPERTIES
      IMPORTED_LOCATION "${prefix}/${static_base_name}")
  endif()
endfunction()


if(ADBC_BUILD_SHARED)
  adbc_add_shared_library(
    AdbcDriverFlightSQL::adbc_driver_flightsql_shared
    adbc_driver_flightsql)
endif()

if(ADBC_BUILD_STATIC)
  adbc_add_static_library(
    AdbcDriverFlightSQL::adbc_driver_flightsql_static
    adbc_driver_flightsql)
endif()

check_required_components(AdbcDriverFlightSQL)
