#ifndef _CEGODBTHREAD_H_INCLUDED_
#define _CEGODBTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDbThread.h  
// --------------
// Cego db thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDbThread
// 
// Description: This class implements the functions of a single database thread.
//              It serves a database session dispatched from the database thread pool
//              and handles subsequent requests for this session.
//              Database requests can be request from a native client but also distributed
//              requests from a different cego database node.
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/Thread.h>
#include <lfcbase/NetHandler.h>
#include <lfcbase/NanoTimer.h>

// CEGO INCLUDES
#include "CegoDistDbHandler.h"
#include "CegoDatabaseManager.h"
#include "CegoDistManager.h"
#include "CegoAction.h"

class CegoDbThreadPool;

class CegoDbThread : public Thread {
    
public:
    
    CegoDbThread();
    CegoDbThread(CegoDbThreadPool *pPool, CegoDatabaseManager *pDBMng, CegoDbHandler::ProtocolType protType);
    ~CegoDbThread();

    const Chain& lastAction() const;
    unsigned long long allocatedSortArea() const;
    void* job(void* arg);

    bool isTerminated();

    void abortSession();

    void loadObjects(int tabSetId);
    void unloadObjects(int tabSetId);
    void invalidateObject(int tabSetId, const Chain& objName, CegoObject::ObjectType type);
    // void loadObject(int tabSetId, const Chain& objName, CegoObject::ObjectType type);

    void addReloadRequest(int tabSetId);
    void checkReloadRequest();

    int getErrorCode() const;
    
private:

    unsigned long long _idx;

    CegoDbHandler::ProtocolType _protType;

    void serveSession(CegoDistDbHandler *pSH);
    bool serveRequest(CegoDistDbHandler *pSH, CegoDbHandler::RequestType reqType);

    CegoDbThreadPool* _pPool;
    CegoDatabaseManager* _pDBMng;
    
    CegoDistManager* _pTabMng;
    CegoAction* _pPA;

    NetHandler* _pRequest;

    Chain _lastAction;

    ListT<int> _loadList;

    int _errorCode;

    NanoTimer* _pTim;

    unsigned long _modId;

};

#endif
