#ifndef _CEGOPROCWHILESTMT_H_INCLUDED_
#define _CEGOPROCWHILESTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcWhileStmt.h  
// -------------------
// Cego procedure while loop statement block class definition
//              
// Design and Implementation by Bjoern Lemke
//                                                         
// (C)opyright 2000-2019 Bjoern Lemke   
//
// INTERFACE MODULE
//
// Class: CegoProcWhileStmt
// 
// Description: This class implements the while statement for cego stored procedures.
//              The condition and block information is stored stored for later execution  
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcStmt.h"
#include "CegoProcCond.h"

class CegoProcWhileStmt : public CegoProcStmt {
    
public:
    
    CegoProcWhileStmt(CegoTableManager *pTabMng,
		      CegoProcCond  *pCond,
		      CegoProcBlock *pBlock,
		      CegoProcBlock *pParentBlock);

    ~CegoProcWhileStmt();

    void setBlock(CegoProcBlock* pBlock);
    
    CegoException execute();
  
    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
private:

    CegoTableManager *_pTabMng;
    CegoProcCond *_pCond;
    CegoProcBlock* _pBlock;
    CegoProcBlock* _pParentBlock;
};

#endif
